/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.grass;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import dangeon.util.R;
import dangeon.view.anime.GrassWaveEffect;
import dangeon.view.detail.MainMap;
import java.awt.Point;
import java.util.Random;
import main.res.Image_Artifact;

public abstract class Base_Grass
extends Base_Item {
    private static final long serialVersionUID = 1L;

    protected Base_Grass(Point p, String item_name) {
        super(p, item_name, 0, Base_Artifact.ITEM_CASE.GRASS);
        this.IM = Image_Artifact.GLASS;
    }

    @Override
    protected void action() {
    }

    private void aroundHit(Base_Creature c) {
        this.effect_pre(c);
        for (Base_Creature _c : MapInSelect.getListAroundInCreature(c.getMassPoint())) {
            if (_c.isResistantToGrassWave()) {
                if (!_c.isSkillActive()) continue;
                Message.set(_c.getColoredName(), "\u306f\u8349\u306e\u6ce2\u7d0b\u52b9\u679c\u3092\u7121\u52b9\u5316\u3057\u305f");
                continue;
            }
            this.effect_pre(_c);
        }
    }

    protected abstract void effect(Base_Creature var1);

    private void effect_pre(Base_Creature c) {
        this.hitCheck(c);
        this.effect(c);
    }

    protected int enchantAttack(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    protected int enchantDefence(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    public void firstMsgAtUsingThis() {
        Message.set(this.getColoredName().concat("\u3092\u98f2\u3093\u3060"));
    }

    @Override
    public String getClassName() {
        return "\u8349\uff1a";
    }

    @Override
    public String getLastPackage() {
        return "grass";
    }

    @Override
    protected String getSecondExplain_ByCategory() {
        return "\u4f7f\u7528\u3057\u3066\u3082\u6295\u3052\u3066\u3082\u52b9\u679c\u304c\u767a\u751f\u3059\u308b\u3002\u4f7f\u7528\u3059\u308b\u3068\u98f2\u307f\u3053\u3093\u3067\u52b9\u679c\u3092\u5f97\u308b\u306e\u3067\u6e80\u8179\u5ea6\u304c\u5c11\u3057\u3060\u3051\u5f97\u3089\u308c\u308b\u3002\u30c1\u30eb\u30ce\u306f\u51cd\u3063\u305f\u8349\u3082\u304a\u306b\u304e\u308a\u3082\u5e73\u6c17\u3067\u3082\u3050\u3082\u3050\u3067\u304d\u307e\u3059\u3002";
    }

    protected abstract boolean grassUse();

    public void haretsu(Base_Creature c) {
        this.effect_pre(c);
    }

    private void hitCheck(Base_Creature c) {
        if (this.isAbleToBeHittedChecked(c)) {
            this.staticCheck();
        } else {
            Message.set(c.getColoredName(), "\u306b\u306f\u52b9\u679c\u304c\u306a\u304b\u3063\u305f");
            if (!this.isStaticCheked()) {
                Checker.write(this, Checker.KeyWord.\u6295\u64f2);
            }
        }
    }

    protected boolean isAbleToBeHittedChecked(Base_Creature c) {
        return true;
    }

    public void itemEffect(Base_Creature c) {
        this.effect_pre(c);
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    public void itemHit() {
        R ran = new R();
        int damage = ((Random)ran).nextInt(2) + 1;
        Message.set(MapList.getEnemy(this.getMassPoint()).getColoredName().concat("\u306b"), this.getColoredName().concat("\u3092\u3076\u3064\u3051\u305f"));
        Message.set(MapList.getEnemy(this.getMassPoint()).getColoredName().concat("\u306b"), String.valueOf(damage) + "\u30dd\u30a4\u30f3\u30c8\u3092\u4e0e\u3048\u305f");
    }

    @Override
    public void itemHit(final Base_Creature c, Base_Creature c2) {
        Message.set(this.getColoredName(), "\u306e\u52b9\u679c\u304c\u5e83\u304c\u3063\u305f");
        MainMap.addEffect(new GrassWaveEffect(c, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Base_Grass.this.aroundHit(c);
            }
        }), true);
    }

    @Override
    public boolean itemUse() {
        Player.me.chengeSatiety(5);
        if (this.isEnchantedNow()) {
            Enchant.forceToRemove(this);
        }
        Belongings.remove(this);
        return this.grassUse();
    }
}

