/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.check;

import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.check.Checker_ClassName;
import dangeon.model.object.artifact.item.check.Checker_ClassName_Enum;
import dangeon.model.object.artifact.item.grass.Base_Grass;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.ring.Ring;
import dangeon.model.object.artifact.item.scrool.Scrool;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.creature.player.Belongings;
import dangeon.view.util.StringFilter;
import java.io.Serializable;
import java.util.ArrayList;
import main.res.Image_Artifact;
import main.util.Show;

public class Checker
implements Serializable {
    public static Checker_ClassName<Checker> CARD;
    public static Checker_ClassName<Checker> GRASS;
    public static Checker_ClassName<Checker> RING;
    public static Checker_ClassName<Checker> SCROLL;
    public static Checker_ClassName<Checker> STAFF;
    public static Checker_ClassName<Checker> POT;
    private static final long serialVersionUID = 1L;
    protected Class<? extends Base_Artifact> clazz;
    public String checked_name;
    public final Checker_ClassName_Enum NAME;
    private boolean static_checked = false;
    private boolean selection = false;
    private boolean thrown = false;
    private boolean usage = false;
    private int atk_count = -1;
    private int def_count = -1;
    private String name;

    public static void addAtkCount(Base_Artifact a) {
        Checker.getChecker(a).addAtkCount();
    }

    public static void addDefCount(Base_Artifact a) {
        Checker.getChecker(a).addDefCount();
    }

    public static void checkStatic(Base_Artifact a) {
        Checker.getChecker(a).check(a);
    }

    public static void enchant(Base_Artifact a) {
        Checker.getChecker(a).enchant();
    }

    public static boolean enchanted(Base_Artifact a) {
        return Checker.getChecker(a).enchanted();
    }

    private static Checker_ClassName<Checker> get(ArrayList<Checker_ClassName_Enum> initList) {
        Checker_ClassName<Checker> list = new Checker_ClassName<Checker>();
        for (Checker_ClassName_Enum enm : initList) {
            list.add(new Checker(enm));
        }
        return list;
    }

    private static Checker_ClassName<Checker> get(Base_Artifact a) {
        if (a instanceof SpellCard) {
            return CARD;
        }
        if (a instanceof Base_Grass) {
            return GRASS;
        }
        if (a instanceof Ring) {
            return RING;
        }
        if (a instanceof Scrool && !a.getImage_Artifact().equals((Object)Image_Artifact.BOOK2)) {
            return SCROLL;
        }
        if (a instanceof Staff) {
            return STAFF;
        }
        if (a instanceof Base_Pot) {
            return POT;
        }
        return Checker_ClassName.NULL;
    }

    public static Checker_ClassName<Checker> get(int i) {
        switch (i) {
            case 0: {
                return CARD;
            }
            case 1: {
                return GRASS;
            }
            case 2: {
                return RING;
            }
            case 3: {
                return SCROLL;
            }
            case 4: {
                return STAFF;
            }
            case 5: {
                return POT;
            }
        }
        return null;
    }

    private static Checker getChecker(Base_Artifact a) {
        return Checker.get(a).get(a);
    }

    public static String getUnCheckedName(Base_Artifact a) {
        return Checker.getChecker(a).toString();
    }

    public static String getWritenName(Base_Artifact a) {
        return Checker.getChecker((Base_Artifact)a).name;
    }

    public static void init(int unchecked_level) {
        if (unchecked_level == 0) {
            CARD = new Checker_ClassName();
            GRASS = new Checker_ClassName();
            RING = new Checker_ClassName();
            SCROLL = new Checker_ClassName();
            STAFF = new Checker_ClassName();
            POT = new Checker_ClassName();
        } else {
            SCROLL = Checker.get(Checker_ClassName.SCROLL.initList());
            STAFF = Checker.get(Checker_ClassName.STAFF.initList());
            CARD = Checker.get(Checker_ClassName.CARD.initList());
            if (unchecked_level == 2) {
                RING = Checker.get(Checker_ClassName.RING.initList());
                GRASS = Checker.get(Checker_ClassName.Grass.initList());
            } else {
                RING.clear();
                GRASS.clear();
            }
            POT = Checker.get(Checker_ClassName.POT.initList());
            for (Base_Artifact a : Belongings.getListItems()) {
                Checker.checkStatic(a);
            }
        }
    }

    public static boolean isStaticChecked(Base_Artifact a) {
        return Checker.getChecker(a).isStaticChecked();
    }

    public static void load(Checker_ClassName<Checker> list) {
        CARD = new Checker_ClassName();
        GRASS = new Checker_ClassName();
        RING = new Checker_ClassName();
        SCROLL = new Checker_ClassName();
        STAFF = new Checker_ClassName();
        POT = new Checker_ClassName();
        int i = 0;
        for (Checker c : list) {
            if (c == null) {
                ++i;
                continue;
            }
            Checker.get(i).add(c);
        }
    }

    public static Checker_ClassName<Checker> saveHash() {
        Checker_ClassName<Checker> list = new Checker_ClassName<Checker>();
        int i = 0;
        while (i < 6) {
            for (Checker c : Checker.get(i)) {
                list.add(c);
            }
            list.add(null);
            ++i;
        }
        return list;
    }

    public static void select(Base_Artifact a) {
        Checker.write(a, KeyWord.\u9078\u629e);
    }

    public static void write(Base_Artifact a, KeyWord key_word) {
        Checker.getChecker(a).setKeyWord(key_word);
    }

    public static void writeName(Base_Artifact a, String name) {
        Checker.getChecker(a).setName(name);
    }

    public Checker() {
        this.NAME = null;
        this.check(null);
    }

    public Checker(Checker_ClassName_Enum enm) {
        this.NAME = enm;
    }

    private void addAtkCount() {
        if (++this.atk_count > 99) {
            this.atk_count = 99;
        }
    }

    private void addDefCount() {
        if (++this.def_count > 99) {
            this.def_count = 99;
        }
    }

    private void check(Base_Artifact a) {
        if (!this.static_checked) {
            this.static_checked = true;
        }
        this.checked_name = a != null ? StringFilter.getPlainString(a.getName()) : "";
    }

    private String createName() {
        if (this.name == null || this.name.isEmpty()) {
            return this.NAME.toString();
        }
        String header = this.NAME instanceof Checker_ClassName.STAFF ? "\u6756\uff1a" : (this.NAME instanceof Checker_ClassName.POT ? "\u74f6\uff1a" : (this.NAME instanceof Checker_ClassName.CARD ? "\u672d\uff1a" : (this.NAME instanceof Checker_ClassName.Grass ? "\u8349\uff1a" : (this.NAME instanceof Checker_ClassName.RING ? "\u98fe\uff1a" : (this.NAME instanceof Checker_ClassName.SCROLL ? "\u66f8\uff1a" : "\uff1f\uff1a")))));
        return Base_Item.CL_NAMED.concat(header).concat(this.name);
    }

    private String createString() {
        String s = this.createName();
        if (this.NAME instanceof Checker_ClassName.STAFF) {
            return s;
        }
        if (this.NAME instanceof Checker_ClassName.POT) {
            return s;
        }
        if (this.selection || this.enchanted() || this.thrown) {
            StringBuilder sb = new StringBuilder(s);
            sb.append(Base_Item.CL_NAMED);
            sb.append("\u300a");
            if (this.usage) {
                sb.append("\u4f7f\u7528\u578b");
            } else if (!this.enchanted()) {
                if (this.selection && this.thrown) {
                    sb.append("\u9078\u629e\u5f0f\u30fb\u6295\u64f2\u6e08");
                } else if (this.selection) {
                    sb.append("\u9078\u629e\u5f0f");
                } else if (this.thrown) {
                    sb.append("\u6295\u64f2\u6e08");
                }
            } else {
                if (this.selection) {
                    sb.append("\u9078\u629e\u30fb");
                }
                if (this.thrown) {
                    sb.append("\u6295\u64f2\u30fb");
                }
                this.toName(sb);
            }
            sb.append("\u300b");
            s = sb.toString();
        }
        return s;
    }

    private void enchant() {
        if (this.atk_count == -1) {
            this.atk_count = 0;
        }
        if (this.def_count == -1) {
            this.def_count = 0;
        }
    }

    private boolean enchanted() {
        return this.def_count != -1;
    }

    public String getCheckedName() {
        return this.checked_name;
    }

    public boolean isExist() {
        return this.clazz != null;
    }

    public boolean isStaticChecked() {
        return this.static_checked;
    }

    public Checker set(Base_Artifact a) {
        this.clazz = a.getClass();
        return this;
    }

    public Checker set(boolean b) {
        this.static_checked = b;
        return this;
    }

    private void setKeyWord(KeyWord key_word) {
        switch (key_word) {
            case \u9078\u629e: {
                this.selection = true;
                return;
            }
            case \u6295\u64f2: {
                this.thrown = true;
                return;
            }
            case \u4f7f\u7528: {
                this.usage = true;
                return;
            }
        }
        Show.showErrorMessageDialog("No_Such_KeyWord_Error @ Checker.setKeyWord");
    }

    private void setName(String name) {
        this.name = name;
    }

    private void toName(StringBuilder sb) {
        if (this.def_count == 0) {
            sb.append("\u88c5\u5099\u6e08");
        } else {
            sb.append("\u653b");
            if (this.atk_count < 10) {
                sb.append(" ");
            }
            sb.append(this.atk_count);
            sb.append("\uff1a\u9632");
            if (this.def_count < 10) {
                sb.append(" ");
            }
            sb.append(this.def_count);
        }
    }

    public String toString() {
        if (this.NAME == null) {
            return "(null)";
        }
        return this.createString();
    }

    public static enum KeyWord {
        \u9078\u629e,
        \u6295\u64f2,
        \u4f7f\u7528;

    }
}

