/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.ThrowingItem;
import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.itemlist.Book_Item;
import dangeon.latest.scene.action.itemlist.Item_List;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.system.KeyHolder;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.Config;
import dangeon.model.config.table.ItemTable;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.SelectItem;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.food.Food;
import dangeon.model.object.artifact.item.grass.Base_Grass;
import dangeon.model.object.artifact.item.grass.\u8d85\u4e0d\u5e78\u306e\u8349;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.ring.Ring;
import dangeon.model.object.artifact.item.scrool.Scrool;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.util.Damage;
import dangeon.util.R;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import main.res.Image_Artifact;
import main.res.Image_Player;
import main.res.SE;

public abstract class Base_Item
extends Base_Artifact {
    private static final long serialVersionUID = 1L;
    private static HashMap<Class<? extends Base_Item>, Boolean> map = new HashMap();
    protected int staff_use_count = 0;
    protected final int base_merchant_value;
    public static final String CL_PUNISH = new Color(225, 225, 255).toString();
    public static final String CL_NOT_USABLE = new Color(190, 230, 220).toString();
    public static final String CL_CUSTOMIZED = new Color(255, 255, 180).toString();
    public static final String CL_NAMED = new Color(0, 225, 70).toString();
    public static final String CL_CURSED = new Color(200, 50, 150).toString();
    public static final String CL_NORMAL = new Color(255, 195, 175).toString();
    public static final String CL_LIMITTED = new Color(255, 255, 255).toString();
    public boolean flag_gousei = false;
    protected boolean flag_open_cursed = false;
    protected boolean flag_open_numbers = false;
    protected Base_Artifact A;
    public final int MAX_STAFF_REST = 10;
    public boolean flag_pick_checked;

    protected Base_Item(Point p, String item_name, int composition_number, Base_Artifact.ITEM_CASE item_case) {
        super(p, item_name, composition_number == 0 ? 1 : composition_number, item_case, true);
        this.visible = true;
        this.base_merchant_value = ItemTable.getMerchantValue(this);
    }

    protected void action() {
    }

    public final Base_Item addStaffRest(int delt) {
        this.staff_rest = this.staff_rest + delt >= 10 ? 10 : (this.staff_rest += delt);
        return this;
    }

    protected void before_walkOnAction() {
        this.flag_pick_checked = true;
    }

    protected boolean checkedCheck(Class<? extends Base_Item> c) {
        return map.containsKey(c);
    }

    public void firstMsgAtUsingThis() {
        Message.set(this.getColoredName(), "\u3092\u4f7f\u3063\u305f");
    }

    @Override
    public final String getColoredName() {
        return this.getColoredName(true);
    }

    @Override
    public String getColoredName(boolean icon) {
        if (this.flag_sample) {
            if (this.flag_unknown) {
                return Color.YELLOW.toString().concat("\uff1f\uff1f\uff1f\uff1f");
            }
            return this.getTrueName();
        }
        StringBuilder sb = new StringBuilder();
        if (icon) {
            sb.append("#");
            sb.append(Integer.toString(Image_Artifact.getIdentifier(this), 36));
            sb.append(this.getFreeseStep());
        }
        if (this.isPunishment()) {
            sb.append(CL_PUNISH);
        } else if (this.isForgedMax()) {
            sb.append(CL_LIMITTED);
        } else if (this.flag_gousei || !this.getListComposition().isEmpty()) {
            sb.append(CL_CUSTOMIZED);
        } else if (!this.isPerfectCheked()) {
            if (this.isCurse() && !(this instanceof SpellCard)) {
                sb.append(CL_CURSED);
            } else {
                sb.append(Color.YELLOW.toString());
            }
        } else if (Enchant.isEnchanted(this)) {
            sb.append(Enchant.getEnchantedPlace(this).getColor().toString());
        } else if (this.isCurse()) {
            sb.append(CL_CURSED);
        } else if (this instanceof SpellCard && !((SpellCard)this).isAbleToUse()) {
            sb.append(CL_NOT_USABLE);
        } else {
            sb.append(CL_NORMAL);
        }
        sb = this.getName(sb);
        sb.append(Color.WHITE);
        return sb.toString();
    }

    @Override
    public int getMerchantSoldValue() {
        int beta;
        int alpha;
        if (this.isStaticCheked()) {
            alpha = 0;
            alpha += this.getListComposition().size();
            if (this.isCold()) {
                ++alpha;
            }
            if (this.isFrozen()) {
                ++alpha;
            }
            if (this.isCurse_And_isItViewed()) {
                --alpha;
            }
        } else {
            return 1;
        }
        if (this.isPerfectCheked()) {
            beta = 0;
            if (this instanceof Staff) {
                beta = this.staff_rest;
            } else if (this instanceof SpellCard) {
                beta = ((SpellCard)this).getBomCount() + this.getForgeValue();
            }
        } else {
            beta = 0;
        }
        boolean flag = this instanceof Base_Pot || this instanceof SpellCard || this instanceof Scrool;
        float gumma = flag ? 1.5f : 1.0f;
        int pages = Math.round((float)(this.base_merchant_value + alpha) * gumma * (1.0f + 0.1f * (float)beta));
        if (pages > 100) {
            pages = 100;
        }
        return pages;
    }

    @Override
    public String getName() {
        if (this.isStaticCheked()) {
            return this.name;
        }
        return Checker.getUnCheckedName(this);
    }

    public StringBuilder getName(StringBuilder sb) {
        sb.append(this.getName());
        return sb;
    }

    @Override
    public int getShadow() {
        return 6;
    }

    public final int getStaffRest() {
        return this.staff_rest;
    }

    protected boolean isForgedMax() {
        return this.staff_rest >= 10;
    }

    protected boolean isItemUseThisAvailable() {
        boolean flag_mouse = this.isUsingMouse();
        if ((Player.me.getConditionList().contains((Object)CONDITION.\u5c01\u5370) || Player.me.getConditionList().contains((Object)CONDITION.\u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b)) && flag_mouse) {
            SE.STATUS_SEAL.play();
            Message.set("\u53e3\u304c\u4f7f\u3048\u306a\u3044");
            return false;
        }
        if (this.isCurse()) {
            this.flag_open_cursed = true;
            Message.set("\u546a\u308f\u308c\u3066\u3044\u308b\u305f\u3081\u4f7f\u7528\u3067\u304d\u306a\u3044\uff01");
            return false;
        }
        return true;
    }

    public boolean isPickCheked() {
        return this.flag_pick_checked && !this.flag_punishment && !this.flag_merchant;
    }

    public boolean isUsingMouse() {
        return this instanceof Food || this instanceof Base_Grass || this instanceof SpellCard;
    }

    @Override
    public void itemHit(Base_Creature c, Base_Creature c2) {
        R ran = new R();
        int damage = ((Random)ran).nextInt(2) + 1;
        Message.set(c.getColoredName().concat("\u306b"), this.getColoredName().concat("\u3092\u3076\u3064\u3051\u305f"));
        String deathMsg = String.valueOf(this.getColoredName()) + "\u304c\u3076\u3064\u304b\u3063\u3066\u5012\u308c\u305f";
        ThrowingItem ti = TaskOnMapObject.getThrow();
        deathMsg = ti != null && ti.A == this && ti.isReflected() ? "\u8df3\u306d\u8fd4\u3063\u305f" + deathMsg : "\u98db\u3093\u3067\u304d\u305f" + deathMsg;
        Damage.damage(this, null, deathMsg, c2, c, damage);
    }

    @Override
    public final void itemUseThis() {
        if (this.isItemUseThisAvailable()) {
            this.firstMsgAtUsingThis();
            if (!(this instanceof Staff || this instanceof Base_Pot || this.isStaticCheked())) {
                String name = this.getColoredName();
                this.check();
                Message.set(name, "\u306f", this.getColoredName(), "\u3060\u3063\u305f");
                if (this instanceof Ring) {
                    if (ItemTable.getRank(this) == 5) {
                        Medal.\u672a\u8b58\u5225\u30ea\u30dc\u30f3\u3092\u4f7f\u7528\u3057\u305f\u3089\u30ec\u30a2\u3082\u306e\u3060\u3063\u305f.addCount();
                    }
                } else if (\u8d85\u4e0d\u5e78\u306e\u8349.class.isInstance(this)) {
                    Medal.\u672a\u8b58\u5225\u306e\u8349\u3092\u98f2\u3093\u3060\u3089\u8d85\u4e0d\u5e78\u306e\u7a2e\u3060\u3063\u305f.addCount();
                }
            }
            Config.saveItemData(this);
            Image_Player.set(this);
        }
    }

    @Override
    public void itemUseThis_fromMenu(KeyHolder KH, Base_View view) {
        if (this instanceof SelectItem) {
            this.selectItem(view);
        } else {
            super.itemUseThis_fromMenu(KH, view);
        }
    }

    protected void selectItem(Base_View view) {
        SelectItem ME = (SelectItem)((Object)this);
        ArrayList<Base_Artifact> list = null;
        if (this.isStaticCheked()) {
            list = Belongings.getDeepCopy(Belongings.getListItems_includingFoot());
            list = ME.getEscape(list);
        }
        if (list == null) {
            list = new ArrayList();
        }
        list.add(this);
        final Base_Item me = this;
        new Item_List(new Book_Item(){

            @Override
            public void work(Base_Artifact a) {
                Base_Item.this.A = a;
                Base_Item.this.itemUseThis();
            }
        }, list, true){

            @Override
            protected void action_cancel() {
                super.action_cancel();
                Checker.select(me);
            }
        };
    }

    @Override
    public final boolean walkOnAction() {
        if (this.flag_merchant) {
            this.check();
            TaskOnMapObject.setTaskStairs(this);
            return false;
        }
        this.before_walkOnAction();
        return this.itemPickUp();
    }

    @Override
    public final boolean walkOnAction(boolean b) {
        if (this.flag_merchant) {
            this.check();
        } else {
            this.before_walkOnAction();
        }
        Message.set(this.getColoredName(), "\u306e\u4e0a\u306b\u4e57\u3063\u305f");
        return false;
    }
}

