/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map.field.special.map;

import dangeon.controller.TurnSystemController;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.map.field.special.FixedMap;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.\u968e\u6bb5\u623b\u308a;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import java.awt.Point;
import java.util.AbstractList;
import java.util.ArrayList;
import main.res.BGM;
import main.res.Image_Dungeon_Name;
import main.res.Image_MapTip;
import main.res.SE;
import main.util.DIRECTION;
import main.util.FrameShaker;

public abstract class BossMap
extends FixedMap {
    protected Base_Enemy boss;
    private static final long serialVersionUID = 1L;
    public final Base_Map_Random BMR;
    public final Point entrance;

    public BossMap(Base_Map_Random bmr, int index, Point entrance) {
        super("battle" + index);
        this.BMR = bmr;
        this.entrance = entrance;
    }

    public void appearStair() {
        ItemFall.itemFall(this.getStair());
    }

    @Override
    public int defaultItemNumber() {
        return 3;
    }

    public void end() {
        this.message();
        Message.setTask_AfterReleaseDemandToPushEnter(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Message.set("\u3069\u3053\u304b\u306b\u968e\u6bb5\u304c\u73fe\u308c\u305f\u3088\u3046\u3060\u2026");
                BossMap.this.appearStair();
            }
        });
    }

    @Override
    public abstract BGM getBGM();

    protected abstract Base_Enemy getBoss();

    @Override
    public String getClassName() {
        return "";
    }

    @Override
    public Point getEntrancePoint() {
        return this.entrance;
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    protected Image_Dungeon_Name getImageDungeonName() {
        return Image_Dungeon_Name.danjon_no_sukima;
    }

    @Override
    public String getMapName() {
        return "\u6c7a\u6226\u306e\u5834";
    }

    @Override
    public Image_MapTip getMapTip() {
        return this.BMR.getMapTip();
    }

    @Override
    protected AbstractList<Base_MapObject> getObjectList() {
        return super.getObjectList();
    }

    @Override
    public Base_Map_Random getParentRandomMap() {
        return this.BMR;
    }

    protected Base_Artifact getStair() {
        return new \u968e\u6bb5\u623b\u308a(MassCreater.getStairsIP(), Player.me.flag_no_item ? "\u6301\u3061\u8fbc\u307f\u306a\u3057\u3067\u6700\u6df1\u5c64\u307e\u3067\u8fbf\u308a\u7740\u304d\u5e30\u9084\u3057\u305f" : "\u6700\u6df1\u5c64\u304b\u3089\u5e30\u9084\u3057\u305f", this.BMR);
    }

    @Override
    public int getTrapDefaultValue() {
        return 5;
    }

    public void initBossMap(MassCreater massCreater) {
        Player.me.direction = DIRECTION.UP;
        this.boss = this.getBoss().setFlagWarning();
        TurnSystemController.setBoss(new BOSS(this.boss, null, this));
        MapList.nextFloor();
        massCreater.initBossMap(this.getDefaultEnemyNumber(), this.BMR);
        SE.GOGOGO.play();
        FrameShaker.doneNormaly();
        Message.set("\u6ce8\u610f\u305b\u3088\uff01\u3000\u3053\u306e\u968e\u5c64\u306f", this.boss.getColoredName(), "\u306b\u3088\u3063\u3066\u5b88\u3089\u308c\u3066\u3044\u308b\uff01");
    }

    public int getDefaultEnemyNumber() {
        return new R().nextInt(4) + 8;
    }

    @Override
    protected boolean isBGMDemandedToPlay() {
        return true;
    }

    @Override
    public boolean isDiggable() {
        return false;
    }

    @Override
    public final boolean isDungeon() {
        return true;
    }

    @Override
    public final boolean isHaraheru() {
        return true;
    }

    @Override
    public boolean isMiniMapAvaible() {
        return true;
    }

    protected abstract void message();

    public class BOSS {
        public final Base_Enemy creature;
        public final ArrayList<String[]> conv;
        public final BossMap map;

        public BOSS(Base_Enemy creature, ArrayList<String[]> conv, BossMap map) {
            this.creature = creature;
            this.conv = conv;
            this.map = map;
        }
    }
}

