/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map;

import dangeon.controller.DangeonScene;
import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.condition.Nap;
import dangeon.model.config.Config;
import dangeon.model.config.table.EnemyTable;
import dangeon.model.config.table.ItemTable;
import dangeon.model.config.table.TrapTable;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.PresentField;
import dangeon.model.map.SpecialRoom;
import dangeon.model.map.StairScene;
import dangeon.model.map.field.Base_Map;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.map.field.special.map.BossMap;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.FakeStairs;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.trap.\u843d\u3068\u3057\u7a74\u306e\u7f60;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.MiniMap;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import main.Second_Firster;
import main.util.DIRECTION;
import main.util.FileReadSupporter;
import main.util.Show;

public class MassCreater
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static MassCreater ME;
    private static boolean spot;
    public final Point NEXT_INI_POINT;
    public static final int WIDTH = 40;
    public static final int HEIGHT = 30;
    private static Mass[][] mass;
    private static InitialPlacement ip;
    private static int dangeon_width;
    private static int dangeon_height;
    private static String hack_name;
    public boolean MOVE_BY_STEP;
    public static boolean flag_neglect_bgm;
    public static final int X_MIN = 0;
    public static final int Y_MIN = 0;

    static {
        hack_name = null;
    }

    public static void breakIntoLargeRoom() {
        Mass[][] massArray = mass;
        int n = mass.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] ms;
            Mass[] massArray2 = ms = massArray[n2];
            int n3 = ms.length;
            int n4 = 0;
            while (n4 < n3) {
                Mass m = massArray2[n4];
                if (m.X != 0 && m.X != 39 && m.Y != 0 && m.Y != 29) {
                    if (!m.ROOM) {
                        m.setChecked(true);
                        m.ROOM = true;
                    }
                    m.ROAD = false;
                    m.WATER = false;
                    m.WATER_LEEF = false;
                    m.WALKABLE = true;
                    m.setVisible(false);
                    m.tellBroken();
                }
                ++n4;
            }
            ++n2;
        }
        for (InitialPlacement.Room r : ip.getRoomList()) {
            if (!r.flag_monster_house) continue;
            MapList.performMonsterHosue();
        }
        ip = new InitialPlacement();
        MassCreater.retakeMassSet();
    }

    public static boolean dig(Point p) {
        Mass mass = MassCreater.getMass(p);
        if (mass.DIGGABLE) {
            mass.setDigged(true);
            return true;
        }
        Message.set("\u3053\u3053\u306f\u6398\u308c\u306a\u3044");
        return false;
    }

    public static void frozenWater() {
        MassCreater.frozenWater(false);
    }

    public static void frozenWater(boolean not_frozen_deep_water) {
        Mass[] massArray = MassCreater.getMasses();
        int n = massArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mass mass = massArray[n2];
            if (!mass.WATER_NOT_FROZEN || !not_frozen_deep_water) {
                mass.setFrozen(true);
            }
            ++n2;
        }
        MassCreater.retakeMassSet();
    }

    public static void frozenWater(InitialPlacement.Room r) {
        if (r == null) {
            return;
        }
        Mass[] massArray = MassCreater.getMass(r);
        int n = massArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mass mass = massArray[n2];
            mass.setFrozen(true);
            ++n2;
        }
        MassCreater.retakeMassSet();
    }

    public static String getHackName() {
        return hack_name;
    }

    public static InitialPlacement getIP() {
        return ip;
    }

    public static Point getItemIP() {
        return ip.getItemPoint();
    }

    public static Mass[][] getMass() {
        return mass;
    }

    public static Mass getMass(int x, int y) {
        try {
            return mass[x][y];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Mass.nullpo;
        }
    }

    public static Mass getMass(Point p) {
        try {
            return mass[p.x][p.y];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return Mass.nullpo;
    }

    public static Mass getMass(Point point, DIRECTION d) {
        return MassCreater.getMass(point.x + d.X, point.y + d.Y);
    }

    public static Mass[] getMass(InitialPlacement.Room r) {
        ArrayList<Mass> list = new ArrayList<Mass>(r.getSize());
        int x = r.X;
        while (x < r.X + r.W) {
            int y = r.Y;
            while (y < r.Y + r.H) {
                list.add(MassCreater.getMass(x, y));
                ++y;
            }
            ++x;
        }
        return list.toArray(new Mass[0]);
    }

    private static Mass[] getMasses() {
        Mass[] masses = new Mass[mass.length * mass[0].length];
        int k = 0;
        int i = 0;
        while (i < mass.length) {
            int j = 0;
            while (j < mass[0].length) {
                masses[k++] = mass[i][j];
                ++j;
            }
            ++i;
        }
        return masses;
    }

    public static ArrayList<Mass> getMasses_NotSpotValid(int x, int y) {
        ArrayList<Mass> list = new ArrayList<Mass>();
        int i = -4;
        while (i <= 4) {
            int j = -3;
            while (j <= 3) {
                list.add(MassCreater.getMass(x + i, y + j));
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static Mass getPlayerMass() {
        return MassCreater.getMass(Player.me.getMassPoint());
    }

    public static InitialPlacement.Room getPlayerRoom() {
        return ip.getRoom(Player.me.getMassPoint());
    }

    public static InitialPlacement.Room getRoom(int x, int y) {
        if (ip == null) {
            ip = new InitialPlacement();
        }
        return ip.getRoom(x, y);
    }

    public static InitialPlacement.Room getRoom(Point p) {
        return MassCreater.getRoom(p.x, p.y);
    }

    public static Point getStairsIP() {
        return ip.getStairsPoint();
    }

    public static Point getTrapIP() {
        return ip.getTrapPoint();
    }

    public static Point getTrapIP(InitialPlacement.Room r) {
        return ip.getTrapPoint(r);
    }

    public static Point getWarpPoint(Base_Enemy em) {
        if (em != null) {
            em.RoomInRootClear();
        }
        return MassCreater.getIP().getCreaturePoint();
    }

    public static boolean is1InTheSightFrom2(int x1, int y1, int x2, int y2, int range) {
        InitialPlacement.Room r = ip.getRoom(x2, y2);
        if (r != null && r.isThePointInExtentdedThis(x1, y1)) {
            return true;
        }
        return Math.abs(x2 - x1) <= range && Math.abs(y2 - y1) <= range;
    }

    public static boolean is1InTheSightFrom2(int x1, int y1, int x2, int y2, int r1, int r2) {
        InitialPlacement.Room r = ip.getRoom(x2, y2);
        if (r != null && r.isThePointInExtentdedThis(x1, y1)) {
            return true;
        }
        return Math.abs(x2 - x1) <= r1 && Math.abs(y2 - y1) <= r2;
    }

    public static boolean isEntrance(int x, int y) {
        InitialPlacement.Room r = MassCreater.getRoom(x, y);
        return r != null && ip.getRoom(Player.me.getMassPoint()).equals(r) && r.isEntrance(x, y);
    }

    public static boolean isMovedWithStep() {
        return MassCreater.ME.MOVE_BY_STEP;
    }

    public static boolean isPlayerInRoom() {
        return ip.getRoom(Player.me.getMassPoint()) != null;
    }

    public static boolean isPlayerInTheSameRoom(int x, int y) {
        try {
            return ip.getRoom(Player.me.getMassPoint()).equals(ip.getRoom(x, y));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean isPlayerInTheSameRoom(Point p) {
        try {
            return ip.getRoom(Player.me.getMassPoint()).equals(ip.getRoom(p));
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean isPlayerInTheSightFromThePoint(int x, int y, int range) {
        return MassCreater.is1InTheSightFrom2(Player.me.getMassPoint().x, Player.me.getMassPoint().y, x, y, range);
    }

    public static boolean isPlayerInTheSightFromThePoint(Point p, int range) {
        return MassCreater.isPlayerInTheSightFromThePoint(p.x, p.y, range);
    }

    public static boolean isPointInTheSameRoom(Point source, Point target) {
        return MassCreater.isPointInTheSameRoomInEntrance(source, target);
    }

    public static boolean isPointInTheSameRoomInEntrance(Point source, Point target) {
        try {
            if (ip.getRoomInEntrance(target).equals(ip.getRoom(source))) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (target.equals(d.getFrontPoint(source.getLocation()))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isPointOutOfDangeon(int x, int y) {
        return x < 1 || x >= dangeon_width - 1 || y < 1 || y >= dangeon_height - 1;
    }

    public static boolean isPointOutOfDangeon(Point p) {
        return MassCreater.isPointOutOfDangeon(p.x, p.y);
    }

    public static boolean isSpotValid() {
        return spot && !Player.me.conditionCheck(CONDITION.\u86cd);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isStandMass(Point p) {
        try {
            Base_Creature c;
            if (!MassCreater.mass[p.x][p.y].ROOM && !MassCreater.mass[p.x][p.y].ROAD) {
                return false;
            }
            Iterator<Base_Creature> iterator = MapList.getListCreature().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (!(c = iterator.next()).getMassPoint().equals(p));
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    public static boolean isTheObjectInsideOfScreen(Base_MapObject o) {
        int dif_x = Player.me.getMassPoint().x - o.getMassPoint().x;
        int dif_y = Player.me.getMassPoint().y - o.getMassPoint().y;
        dif_x = Math.abs(dif_x);
        dif_y = Math.abs(dif_y);
        return dif_x > 4 || dif_y > 4;
    }

    public static boolean isThePointInThePlayerSight(int x, int y, int range) {
        return MassCreater.is1InTheSightFrom2(x, y, Player.me.getMassPoint().x, Player.me.getMassPoint().y, range);
    }

    public static boolean isThePointInThePlayerSight(Point p, int range) {
        return MassCreater.isThePointInThePlayerSight(p.x, p.y, range);
    }

    public static boolean isThePointInThePlayerSight(Point p, int r1, int r2) {
        return MassCreater.is1InTheSightFrom2(p.x, p.y, Player.me.getMassPoint().x, Player.me.getMassPoint().y, r1, r2);
    }

    public static boolean isWalk(Point p) {
        return (MassCreater.getMass((Point)p).ROOM || MassCreater.getMass((Point)p).ROAD) && MapList.getCreature(p) == null;
    }

    public static boolean isWalkableFor(Base_Creature c, Point point) {
        if (MapList.isCreature(point)) {
            return false;
        }
        Mass mass = MassCreater.getMass(point);
        if (!mass.WALKABLE) {
            return false;
        }
        return c.isWatering() || !mass.WATER;
    }

    public static void load(MassCreater me) {
        ME = me;
        ME.createMapByDoor();
    }

    public static void retakeMassSet() {
        ip.extendRoom();
        Mass[][] massArray = mass;
        int n = mass.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] m2;
            Mass[] massArray2 = m2 = massArray[n2];
            int n3 = m2.length;
            int n4 = 0;
            while (n4 < n3) {
                Mass m = massArray2[n4];
                m.setWallTileNo();
                ++n4;
            }
            ++n2;
        }
        MainMap.requestForUpdate();
    }

    public static void saveFuckinMap() {
        if (Show.showConfirmDialog("\u73fe\u5728\u306e\u30de\u30c3\u30d7\u3092fuckin\u3057\u307e\u3059\u304b\uff1f") != 0) {
            return;
        }
        try {
            File file = new File("fukin_map.txt");
            FileWriter filewriter = new FileWriter(file, true);
            filewriter.write("\u3010");
            filewriter.write(new Date().toString());
            filewriter.write("\u3011\t");
            filewriter.write(Second_Firster.ME.getTitle());
            filewriter.write("\r\n");
            filewriter.close();
            Show.showInformationMessageDialog("fuckin_map\u306b\u73fe\u5728\u306e\u30de\u30c3\u30d7\u3092\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setAllMassOnMiniMap() {
        Mass[][] massArray = mass;
        int n = mass.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] m2;
            Mass[] massArray2 = m2 = massArray[n2];
            int n3 = m2.length;
            int n4 = 0;
            while (n4 < n3) {
                Mass m = massArray2[n4];
                if (m.WALKABLE) {
                    MiniMap.addPicture(m);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static void setExplotionMass(Point p) {
        MassCreater.setExsetExplotionMass_private(p);
        MassCreater.retakeMassSet();
    }

    public static void setExplotionMass(Point ... ps) {
        Point[] pointArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            MassCreater.setExsetExplotionMass_private(p);
            ++n2;
        }
        MassCreater.retakeMassSet();
    }

    private static void setExsetExplotionMass_private(Point p) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                MassCreater.getMass(p.x + i, p.y + j).setDigged(true);
                ++j;
            }
            ++i;
        }
    }

    public static void setFallTrap(int value) {
        int i = 0;
        while (i <= value) {
            TaskOnMapObject.addTrapSetTask(new \u843d\u3068\u3057\u7a74\u306e\u7f60(ip.getTrapPoint()));
            ++i;
        }
    }

    public static void setHackName(String name) {
        hack_name = name;
    }

    public static void setLight() {
        MassCreater.setAllMassOnMiniMap();
        spot = false;
    }

    public static boolean setSpot(boolean b) {
        spot = b;
        return spot;
    }

    public static void stepEnd() {
        Mass[][] massArray = MassCreater.getMass();
        int n = massArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] m2;
            Mass[] massArray2 = m2 = massArray[n2];
            int n3 = m2.length;
            int n4 = 0;
            while (n4 < n3) {
                Mass m = massArray2[n4];
                m.stepEnd();
                ++n4;
            }
            ++n2;
        }
    }

    public static void turnCount() {
        if (MassCreater.isPlayerInRoom()) {
            MassCreater.getPlayerRoom().addCount();
        }
    }

    public static Point getCreatureIp() {
        return ip.getCreaturePoint();
    }

    public static Point getMonsterPoint(InitialPlacement.Room r) {
        return ip.getMonsterPoint(r);
    }

    public MassCreater() {
        this.NEXT_INI_POINT = null;
        this.MOVE_BY_STEP = true;
        ME = this;
    }

    public MassCreater(Base_Map pf, boolean step) {
        this(pf, pf.getEntrancePoint(), step);
    }

    public MassCreater(Base_Map pf, Point p, boolean step) {
        PresentField.setPresentField(pf);
        this.NEXT_INI_POINT = p;
        this.MOVE_BY_STEP = step;
        ME = this;
    }

    public void createFirstMap(int unchecked_level) {
        Config.setReimuChecked(false);
        Player.me.resetPlayingMilliTime();
        this.createItemTable();
        Checker.init(unchecked_level);
        MapList.setFloor(0);
        R.next();
        this.createMap();
        Message.clearRecord();
    }

    public void createItemTable() {
        ItemTable.testCreate(this.getTable(1, hack_name));
    }

    public void createItemTableNoDungeon() {
        ItemTable.testCreate();
    }

    public void createMap() {
        if (this.MOVE_BY_STEP) {
            new StairScene(this);
        } else {
            this.createMapByDoor();
        }
    }

    private void createMapByDoor() {
        DangeonScene.setScene(DangeonScene.STAIRS);
        this.setNewMap();
        DangeonScene.setScene(DangeonScene.DANGEON);
    }

    private BufferedReader getTable(Base_Map base_Map) {
        try {
            String name = base_Map.getCSVName();
            URL url = this.getClass().getResource(name);
            return new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BufferedReader getTable(int index_0_enemy__1_item__2_trap, String ... hack) {
        return this.getTable(PresentField.get());
    }

    public void initBossMap(int enemy_number, Base_Map_Random bmr) {
        EnemyTable.tableCreate(this.getTable(bmr));
        TrapTable.createTrapTable(this.getTable(bmr));
        TrapTable.setOnMap();
        ItemTable.setOnMapInNormalFirst();
        EnemyTable.enemyTable(enemy_number, !PresentField.get().isForcedToMakeEnemy());
        EnchantSpecial.setBake();
    }

    private void initialPlacement_FixedField() {
        if (this.NEXT_INI_POINT != null) {
            Player.me.setMassPoint(this.NEXT_INI_POINT);
        } else if (PresentField.get().getEntrancePoint() != null) {
            Player.me.setMassPoint(PresentField.get().getEntrancePoint());
        } else {
            Show.showErrorMessageDialog("\u56fa\u5b9a\u30d5\u30a3\u30fc\u30eb\u30c9\u306fgetEntrancePoint\u3092\u6307\u5b9a\u3057\u3066\u4e0b\u3055\u3044");
            Player.me.setMassPoint(ip.getPlayerPoint());
        }
        ListIterator<Base_MapObject> i = PresentField.get().getIterator_ObjectList();
        while (i.hasNext()) {
            Base_MapObject o = i.next();
            if (o instanceof Base_Artifact) {
                MapList.addArtifact((Base_Artifact)o);
            } else if (o instanceof Base_NPC) {
                MapList.addEnemy((Base_NPC)o);
            } else if (o instanceof Base_Enemy) {
                MapList.addEnemy((Base_Enemy)o);
            }
            i.remove();
        }
        if (PresentField.get() instanceof BossMap) {
            ((BossMap)PresentField.get()).initBossMap(this);
        }
    }

    private void initialPlacement_RandomField() {
        Player.me.setMassPoint(new Point(Mass.nullpo.X, Mass.nullpo.Y));
        EnemyTable.tableCreate(this.getTable(0, hack_name));
        TrapTable.createTrapTable(this.getTable(2, hack_name));
        SpecialRoom.set();
        MapList.addArtifact(new Stairs(MassCreater.getStairsIP()));
        if (PresentField.get().isInsane()) {
            MapList.addArtifact(new FakeStairs(MassCreater.getStairsIP()));
        }
        TrapTable.setOnMap();
        ItemTable.setOnMapInNormalFirst();
        EnemyTable.enemyTable(0);
        Player.me.setMassPoint(ip.getPlayerPoint());
        if (MapList.checkSpecialRoom(Player.me.getMassPoint())) {
            Nap.\u958b\u5e55();
        }
        EnchantSpecial.setBake();
    }

    private void selectInitialPlacement() {
        ip = new InitialPlacement();
        flag_neglect_bgm = false;
        if (PresentField.isRandomField()) {
            this.initialPlacement_RandomField();
        } else {
            this.initialPlacement_FixedField();
        }
        if (!flag_neglect_bgm) {
            PresentField.get().playBGM();
        }
    }

    void setNewMap() {
        MapList.clear();
        MapList.setFlagSheef(false);
        if (Player.me.saisen != null) {
            Player.me.saisen.release();
            Player.me.saisen = null;
        }
        if (Player.me.shop != null) {
            Player.me.shop.release();
            Player.me.shop = null;
        }
        MapList.resetHutoChan();
        CONDITION.conditionAllClear(Player.me);
        try {
            String FIRST_LINE;
            BufferedReader bf = new BufferedReader(FileReadSupporter.readUTF8Map());
            int y = 0;
            String line = FIRST_LINE = bf.readLine();
            int x = FIRST_LINE.length();
            while (line != null) {
                if (line.length() != x) {
                    Show.showCriticalErrorMessageDialog("\u30de\u30c3\u30d7\u306e\u5217\u304c\u884c\u3068\u884c\u3067\u5909\u5316\u3057\u3066\u3044\u307e\u3059\n\u6587\u5b57\u5316\u3051\u3057\u3066\u3044\u306a\u3044\u304b\u78ba\u8a8d\u4e0b\u3055\u3044", String.valueOf(x).concat(FIRST_LINE), String.valueOf(line.length()).concat(line));
                }
                ++y;
                line = bf.readLine();
            }
            bf.close();
            dangeon_width = x;
            dangeon_height = y;
            bf = new BufferedReader(FileReadSupporter.readUTF8Map());
            mass = new Mass[x][y];
            int i = 0;
            while (i < y) {
                line = bf.readLine();
                int j = 0;
                while (j < x) {
                    MassCreater.mass[j][i] = new Mass(j, i, line.charAt(j));
                    ++j;
                }
                ++i;
            }
            bf.close();
            Mass[][] massArray = mass;
            int n = mass.length;
            int n2 = 0;
            while (n2 < n) {
                Mass[] m2;
                Mass[] massArray2 = m2 = massArray[n2];
                int n3 = m2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Mass m = massArray2[n4];
                    m.setWallTileNo();
                    ++n4;
                }
                ++n2;
            }
            spot = !PresentField.get().isLightful();
            this.selectInitialPlacement();
            MainMap.requestForUpdate();
            if (PresentField.isRandomField()) {
                Player.me.performNewMap();
            }
        }
        catch (IOException e) {
            Show.showCriticalErrorMessageDialog(e);
        }
    }
}

