/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import java.awt.Point;

public class ItemFall {
    public static boolean flag_trap_check;

    private static boolean isAbleToFall(Point p) {
        return MassCreater.getMass((Point)p).WALKABLE && !MassCreater.getMass((Point)p).WATER && MapList.getArtifact(p) == null;
    }

    public static boolean isAbleToFall_AroundPlayer() {
        Point _p = Player.me.getMassPoint();
        if (MassCreater.getMass((Point)_p).WATER && MapList.getArtifact(_p) == null) {
            return true;
        }
        int i = -2;
        while (i <= 2) {
            int j = -2;
            while (j <= 2) {
                Point p = _p.getLocation();
                p.translate(i, j);
                if (ItemFall.isAbleToFall(p)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean isArtifact_exceptMe(Point p, Base_Artifact a) {
        if (flag_trap_check) {
            return MapList.getArtiface_exceptME_Trap(p, a) != null;
        }
        return MapList.getArtiface_exceptME(p, a) != null;
    }

    public static void itemFall(Base_Artifact a) {
        if (a == null) {
            return;
        }
        ItemFall.itemFall(a.getMassPoint(), a);
    }

    public static void itemFall(Point p, Base_Artifact a) {
        ItemFall.itemFall(p, p, a);
    }

    public static void itemFall(Point from_p, Point to_p, Base_Artifact a) {
        if (a == null || to_p == null || from_p == null) {
            return;
        }
        boolean flag_sucess = ItemFall.setItemFallPoint_NoMessage(from_p, to_p = to_p.getLocation(), a);
        if (flag_sucess) {
            if (a instanceof Base_Trap && MassCreater.getMass(a.getMassPoint()).isTrapChecked()) {
                a.setVisible(true);
            }
            MapList.addArtifact(a);
        } else {
            Message.set(a.getColoredName().concat("\u306f"), "\u6d88\u3048\u3066\u3057\u307e\u3063\u305f\uff65\uff65\uff65");
        }
    }

    public static void itemFall_TrapCheck(Point p, Base_Artifact a) {
        flag_trap_check = true;
        ItemFall.itemFall(p, a);
    }

    private static boolean setItemFallPoint(Point p, Base_Artifact a) {
        if (MassCreater.getMass(p).isAbleToExistArtifact() && MapList.getArtiface_exceptME(p, a) == null) {
            a.setMassPoint_ParabolaJump_NoAttack(p);
            return true;
        }
        return false;
    }

    public static boolean setItemFallPoint_NoMessage(Point p, Base_Artifact a) {
        return ItemFall.setItemFallPoint_NoMessage(p, p, a);
    }

    public static boolean setItemFallPoint_NoMessage(Point from, Point p, Base_Artifact a) {
        a.setMassPoint(from);
        if (ItemFall.isArtifact_exceptMe(p, a)) {
            int j;
            int i = -1;
            while (i <= 1) {
                j = -1;
                while (j <= 1) {
                    if (ItemFall.setItemFallPoint(new Point(p.x + i, p.y + j), a)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            i = -2;
            while (i <= 2) {
                j = -2;
                while (j <= 2) {
                    if (ItemFall.setItemFallPoint(new Point(p.x + i, p.y + j), a)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
            return false;
        }
        if (flag_trap_check && ItemFall.trapCheck(p, a)) {
            return true;
        }
        ItemFall.setItemFallPoint(p, a);
        return true;
    }

    private static boolean trapCheck(Point p, Base_Artifact a) {
        if (MassCreater.getMass(p).isAbleToExistArtifact() && MapList.getArtiface_exceptME_Trap(p, a) == null) {
            return ItemFall.trapCheck_setMassPoint(p, a);
        }
        return false;
    }

    private static boolean trapCheck_setMassPoint(final Point p, final Base_Artifact a) {
        Base_Artifact _a = MapList.getArtiface_exceptME(p, a);
        if (_a != null && _a instanceof Base_Trap) {
            final Base_Trap trap = (Base_Trap)_a;
            if (!trap.isAbleToWork()) {
                return false;
            }
            a.setMassPoint_ParabolaJump_NoAttack(p, new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    Message.set(trap.getColoredName(), "\u304c\u53cd\u5fdc\u3057\u305f");
                    Base_Creature c = MapList.getCreature(p);
                    if (c != null) {
                        new Task(){
                            private static final long serialVersionUID = 1L;
                            private boolean flag_end;

                            @Override
                            public boolean isDemandToContinue() {
                                return !this.flag_end;
                            }

                            @Override
                            public void work() {
                                if (TaskOnMapObject.isThrowTaskEmpty()) {
                                    for (Base_Artifact a2 : MapList.getListArtifact()) {
                                        if (!a2.isAnimating()) continue;
                                        return;
                                    }
                                    this.flag_end = true;
                                    MapList.removeArtifact(a);
                                    flag_trap_check = false;
                                    ItemFall.itemFall(a);
                                }
                            }
                        }.work_appointment();
                        trap.trapEffect(c);
                        flag_trap_check = false;
                    } else {
                        trap.trapEffect(a);
                    }
                }
            });
        } else {
            a.setMassPoint_ParabolaJump_NoAttack(p);
        }
        flag_trap_check = false;
        return true;
    }
}

