/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.map;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u7f60\u5e2b;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import dangeon.view.anime.DoronEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.MiniMap;
import java.awt.Point;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import main.res.SE;
import main.util.DIRECTION;
import main.util.Show;

public class InitialPlacement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean[][] unchecked_mass;
    private final int SUM;
    private List<Room> room_list = new ArrayList<Room>();

    InitialPlacement() {
        int y;
        Mass[][] mass = MassCreater.getMass();
        this.unchecked_mass = new boolean[mass.length][mass[0].length];
        int x = 0;
        while (x < mass.length) {
            y = 0;
            while (y < mass[x].length) {
                this.unchecked_mass[x][y] = true;
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < mass.length) {
            y = 0;
            while (y < mass[x].length) {
                if (mass[x][y].ROOM && this.unchecked_mass[x][y]) {
                    this.room_list.add(new Room(x, y));
                }
                ++y;
            }
            ++x;
        }
        int sum = 0;
        for (Room r : this.room_list) {
            sum += r.getWeight();
        }
        this.SUM = sum;
    }

    void extendRoom() {
        while (this.extendRoom1Mass()) {
        }
    }

    private boolean extendRoom1Mass() {
        ArrayList<Room> list = new ArrayList<Room>();
        for (Room r : this.room_list) {
            if (!r.isAbleToExtend()) continue;
            list.add(r);
        }
        if (list.size() > 0) {
            HashMap<Room, Room> map = new HashMap<Room, Room>(list.size());
            for (Room r : list) {
                map.put(r, new Room(r));
            }
            for (Room r : list) {
                this.room_list.remove(r);
                this.room_list.add((Room)map.get(r));
            }
            for (Room r : this.room_list) {
                for (Room _r : this.room_list) {
                    r.isLappedOver(_r);
                }
            }
        }
        return list.size() > 0;
    }

    Point getCreaturePoint() {
        int i = 10000;
        Point p = null;
        while (i-- > 0) {
            p = this.getRoomPoint();
            if (!MassCreater.getMass((Point)p).WALKABLE || MassCreater.getMass((Point)p).WATER || MapList.getCreature(p) != null || MassCreater.isPlayerInRoom() && MassCreater.isPlayerInTheSameRoom(p) && this.room_list.size() > 1) continue;
            if (Math.abs(p.x - Player.me.getMassPoint().x) > 4 || Math.abs(p.y - Player.me.getMassPoint().y) > 3) {
                return p;
            }
            if (this.room_list.size() != 1 || this.room_list.get(0).getSize() >= 100) continue;
            return p;
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getCreaturePoint()");
        return p;
    }

    Point getItemPoint() {
        Point p = null;
        for (int i = 10000; i > 0; --i) {
            p = this.getRoomPoint();
            if (!MassCreater.getMass((Point)p).WALKABLE || MassCreater.getMass((Point)p).WATER || MapList.isArtifact(p.x, p.y) || MassCreater.getMass(p).isShop()) continue;
            return p;
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getArtifactPoint() ");
        return p;
    }

    public ArrayList<Point> getListRoomPoint(Room r) {
        ArrayList<Point> list = new ArrayList<Point>();
        int x = 0;
        while (x <= r.W - 1) {
            int y = 0;
            while (y <= r.H - 1) {
                list.add(new Point(r.X + x, r.Y + y));
                ++y;
            }
            ++x;
        }
        return list;
    }

    Point getMonsterHouseArtifactPoint(Room r) {
        Point p = null;
        for (int i = 10000; i > 0; --i) {
            p = this.getRandomRoomPoint(r);
            if (MapList.getArtifact(p) != null || !MassCreater.getMass((Point)p).WALKABLE) continue;
            return p;
        }
        return new Point(Mass.nullpo.X, Mass.nullpo.Y);
    }

    Point getMonsterHouseTrapPoint(Room r) {
        int i = 1000;
        DIRECTION[] ds = new DIRECTION[]{DIRECTION.UP, DIRECTION.DOWN, DIRECTION.LEFT, DIRECTION.RIGHT};
        Point p = null;
        block0: while (i > 0) {
            --i;
            p = this.getRandomRoomPoint(r);
            DIRECTION[] dIRECTIONArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                if (MassCreater.getMass((int)(p.x + d.X), (int)(p.y + d.Y)).ROAD) continue block0;
                ++n2;
            }
            if (MapList.getArtifact(p) != null || !MassCreater.getMass((Point)p).WALKABLE) continue;
            return p;
        }
        return new Point(Mass.nullpo.X, Mass.nullpo.Y);
    }

    public Point getMonsterPoint(Room r) {
        ArrayList<Point> list = new ArrayList<Point>();
        for (Point p : this.getListRoomPoint(r)) {
            if (!MassCreater.isWalk(p)) continue;
            list.add(p);
        }
        if (list.isEmpty()) {
            return Mass.nullpo.null_point;
        }
        return (Point)list.get(R.ran(list.size()));
    }

    Point getMonsterPoint_MonsterHouse(Room r) {
        Point p = null;
        for (int i = 10000; i > 0; --i) {
            p = this.getRandomRoomPoint(r);
            if (MapList.getCreature(p) != null && MassCreater.getMass((Point)p).WALKABLE) continue;
            return p;
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getMonsterPoint_MonsterHouse");
        return p;
    }

    Point getPlayerPoint() {
        int x = 0;
        int y = 0;
        R ran = new R();
        for (int i = 10000; i > 0; --i) {
            int rnd = ((Random)ran).nextInt(this.room_list.size());
            Room r = this.room_list.get(rnd);
            x = ((Random)ran).nextInt(r.W) + r.X;
            y = ((Random)ran).nextInt(r.H) + r.Y;
            Mass m = MassCreater.getMass(x, y);
            if (MapList.getCreature(x, y) != null || !m.WALKABLE || m.WATER || m.isShop() || m.isHoly() || m.isIsLand()) continue;
            return new Point(x, y);
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f\n\u4e3b\u4eba\u516c\u306e\u521d\u671f\u4f4d\u7f6e\u304c\u6c7a\u3081\u3089\u308c\u307e\u305b\u3093\n\u8003\u3048\u3089\u308c\u308b\u539f\u56e0\uff1a\u90e8\u5c4b\u304c\u5c0f\u3055\u3059\u304e\u305f");
        return new Point(x, y);
    }

    Point getRandomRoomPoint(Room r) {
        int x = 0;
        int y = 0;
        x = new R().nextInt(r.W) + r.X;
        y = new R().nextInt(r.H) + r.Y;
        return new Point(x, y);
    }

    Room getRoom() {
        int rnd = new R().nextInt(this.SUM);
        int sum = 0;
        for (Room r : this.room_list) {
            if (rnd >= (sum += r.getWeight())) continue;
            return r;
        }
        Show.showErrorMessageDialog("\u306c\u308b\u307d@InitialPoint.getRoom()");
        return null;
    }

    Room getRoom(int x, int y) {
        for (Room r : this.room_list) {
            if (r.X > x || x >= r.X + r.W || r.Y > y || y >= r.Y + r.H) continue;
            return r;
        }
        return null;
    }

    Room getRoom(Point p) {
        return this.getRoom(p.x, p.y);
    }

    Room getRoomInEntrance(Point p) {
        for (Room r : this.room_list) {
            if (r.X - 1 > p.x || p.x >= r.X + r.W + 1 || r.Y - 1 > p.y || p.y >= r.Y + r.H + 1) continue;
            return r;
        }
        return null;
    }

    public List<Room> getRoomList() {
        return this.room_list;
    }

    private Point getRoomPoint() {
        int x = 0;
        int y = 0;
        Room r = this.getRoom();
        x = new R().nextInt(r.W) + r.X;
        y = new R().nextInt(r.H) + r.Y;
        return new Point(x, y);
    }

    private Point getRoomPoint_WithoutEntrance() {
        return this.getRoomPoint_WithoutEntrance(null);
    }

    private Point getRoomPoint_WithoutEntrance(Room r) {
        boolean rnd = r == null;
        int i = 10000;
        int x = 0;
        int y = 0;
        DIRECTION[] ds = new DIRECTION[]{DIRECTION.UP, DIRECTION.DOWN, DIRECTION.LEFT, DIRECTION.RIGHT};
        block0: while (i > 0) {
            --i;
            if (rnd) {
                r = this.getRoom();
            }
            x = new R().nextInt(r.W) + r.X;
            y = new R().nextInt(r.H) + r.Y;
            DIRECTION[] dIRECTIONArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                if (MassCreater.getMass((int)(x + d.X), (int)(y + d.Y)).ROAD) continue block0;
                ++n2;
            }
            return new Point(x, y);
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getPlayerPoint");
        return new Point(x, y);
    }

    public Point getStairsPoint() {
        int i = 10000;
        while (i-- > 0) {
            Point p = MassCreater.getItemIP();
            Mass mass = MassCreater.getMass(p);
            if (mass.isHoly() || mass.isShop() || mass.isIsLand() || !mass.WALKABLE || mass.WATER_NOT_FROZEN || mass.WATER || mass.WATER_LEEF) continue;
            return p;
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getTrapPoint() ");
        return this.getItemPoint();
    }

    public Point getTrapPoint() {
        return this.getTrapPoint(null);
    }

    public Point getTrapPoint(Room r) {
        Point p = null;
        for (int i = 10000; i > 0; --i) {
            Base_Artifact a;
            p = this.getRoomPoint_WithoutEntrance(r);
            if (!MassCreater.getMass((Point)p).WALKABLE || MassCreater.getMass((Point)p).WATER || (a = MapList.getArtifact(p)) != null) continue;
            return p;
        }
        Show.showErrorMessageDialog("while\u6587\u304b\u3089\u629c\u3051\u3089\u308c\u307e\u305b\u3093\u3067\u3057\u305f@InitialPlacement.getTrapPoint(r) ");
        return p;
    }

    public class Room
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int X;
        public final int Y;
        public final int W;
        public final int H;
        boolean flag_monster_house = false;
        boolean flag_water_room;
        private boolean flag_drawed = false;
        private int stay = 0;
        public final RoundRectangle2D.Double LIGHT;
        public boolean HOLY;
        public boolean SHOP;

        Room(int x, int y) {
            ArrayList<Mass> list = new ArrayList<Mass>();
            this.checkRoom(x, y, list, new DIRECTION[]{DIRECTION.DOWN, DIRECTION.UP, DIRECTION.LEFT, DIRECTION.RIGHT});
            int max_y = 0;
            int max_x = 0;
            int min_x = 40;
            int min_y = 30;
            for (Mass m : list) {
                if (max_x < m.X) {
                    max_x = m.X;
                }
                if (min_x > m.X) {
                    min_x = m.X;
                }
                if (max_y < m.Y) {
                    max_y = m.Y;
                }
                if (min_y <= m.Y) continue;
                min_y = m.Y;
            }
            this.X = min_x;
            this.Y = min_y;
            this.W = max_x - min_x + 1;
            this.H = max_y - min_y + 1;
            this.LIGHT = new RoundRectangle2D.Double(0.0, 0.0, 50 * (this.W + 2) - 25, 50 * (this.H + 2) - 25, 50.0, 50.0);
            x = this.X;
            while (x < this.X + this.W) {
                y = this.Y;
                while (y < this.Y + this.H) {
                    ((InitialPlacement)InitialPlacement.this).unchecked_mass[x][y] = false;
                    ++y;
                }
                ++x;
            }
        }

        Room(Room r) {
            int dx = 0;
            int dy = 0;
            int dw = 0;
            int dh = 0;
            boolean flag = true;
            int i = 0;
            while (i < r.W) {
                if (!MassCreater.getMass((int)(r.X + i), (int)(r.Y - 1)).WALKABLE) {
                    flag = false;
                    break;
                }
                ++i;
            }
            if (flag) {
                dy = -1;
                dh = 1;
            } else {
                flag = true;
                i = 0;
                while (i < r.W) {
                    if (!MassCreater.getMass((int)(r.X + i), (int)(r.Y + r.H)).WALKABLE) {
                        flag = false;
                        break;
                    }
                    ++i;
                }
                if (flag) {
                    dh = 1;
                } else {
                    flag = true;
                    i = 0;
                    while (i < r.H) {
                        if (!MassCreater.getMass((int)(r.X - 1), (int)(r.Y + i)).WALKABLE) {
                            flag = false;
                            break;
                        }
                        ++i;
                    }
                    if (flag) {
                        dx = -1;
                        dw = 1;
                    } else {
                        flag = true;
                        i = 0;
                        while (i < r.H) {
                            if (!MassCreater.getMass((int)(r.X + r.W), (int)(r.Y + i)).WALKABLE) {
                                flag = false;
                                break;
                            }
                            ++i;
                        }
                        if (flag) {
                            dw = 1;
                        }
                    }
                }
            }
            this.X = r.X + dx;
            this.Y = r.Y + dy;
            this.W = r.W + dw;
            this.H = r.H + dh;
            this.flag_drawed = false;
            this.flag_monster_house = r.flag_monster_house;
            this.LIGHT = new RoundRectangle2D.Double(25.0, 25.0, 50 * (this.W + 1), 50 * (this.H + 1), 50.0, 50.0);
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    Mass mass = MassCreater.getMass(x, y);
                    mass.ROOM = true;
                    mass.ROAD = false;
                    ++y;
                }
                ++x;
            }
        }

        public void addCount() {
            if (PresentField.get().isDungeon()) {
                int MAX = 40;
                if (this.stay != MAX) {
                    if (this.stay < MAX) {
                        ++this.stay;
                    }
                    return;
                }
                ++this.stay;
                SE.LIGHT_ON.play();
                int x = this.X;
                while (x < this.X + this.W) {
                    int y = this.Y;
                    while (y < this.Y + this.H) {
                        MassCreater.getMass(x, y).setChecked(true);
                        Base_Artifact a = MapList.getArtiface(x, y);
                        if (a != null) {
                            this.trap(a);
                        }
                        ++y;
                    }
                    ++x;
                }
                MiniMap.reset();
            }
        }

        private void checkRoom(int x, int y, ArrayList<Mass> list, DIRECTION[] ds) {
            Mass m = MassCreater.getMass(x, y);
            if (!list.contains(m) && m.ROOM) {
                list.add(m);
                DIRECTION[] dIRECTIONArray = ds;
                int n = ds.length;
                int n2 = 0;
                while (n2 < n) {
                    DIRECTION d = dIRECTIONArray[n2];
                    this.checkRoom(x + d.X, y + d.Y, list, ds);
                    ++n2;
                }
            }
        }

        public void draw() {
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    MiniMap.addPicture(MassCreater.getMass(x, y));
                    ++y;
                }
                ++x;
            }
            this.flag_drawed = true;
        }

        public Point getEntrance() {
            ArrayList<Point> list = new ArrayList<Point>();
            int x = this.X + 1;
            while (x < this.X + this.W - 1) {
                if (MassCreater.getMass((int)x, (int)(this.Y - 1)).WALKABLE) {
                    list.add(new Point(x, this.Y - 1));
                }
                if (MassCreater.getMass((int)x, (int)(this.Y + this.H)).WALKABLE) {
                    list.add(new Point(x, this.Y + this.H));
                }
                ++x;
            }
            int y = this.Y + 1;
            while (y < this.Y + this.H - 1) {
                if (MassCreater.getMass((int)(this.X - 1), (int)y).WALKABLE) {
                    list.add(new Point(this.X - 1, y));
                }
                if (MassCreater.getMass((int)(this.X + this.W), (int)y).WALKABLE) {
                    list.add(new Point(this.X + this.W, y));
                }
                ++y;
            }
            if (list.size() == 0) {
                return null;
            }
            return (Point)list.get((int)Math.floor(new R().nextDouble() * (double)list.size()));
        }

        public int getEntranceNumber() {
            int i = 0;
            int x = this.X + 1;
            while (x < this.X + this.W - 1) {
                if (MassCreater.getMass((int)x, (int)(this.Y - 1)).WALKABLE) {
                    ++i;
                }
                if (MassCreater.getMass((int)x, (int)(this.Y + this.H)).WALKABLE) {
                    ++i;
                }
                ++x;
            }
            int y = this.Y + 1;
            while (y < this.Y + this.H - 1) {
                if (MassCreater.getMass((int)(this.X - 1), (int)y).WALKABLE) {
                    ++i;
                }
                if (MassCreater.getMass((int)(this.X + this.W), (int)y).WALKABLE) {
                    ++i;
                }
                ++y;
            }
            return i;
        }

        public ArrayList<Point> getListAllMassPointInRoom() {
            ArrayList<Point> list = new ArrayList<Point>();
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    if (MassCreater.getMass((int)x, (int)y).ROOM) {
                        list.add(new Point(x, y));
                    }
                    ++y;
                }
                ++x;
            }
            if (list.size() == 0) {
                return null;
            }
            return list;
        }

        public List<Point> getListEntrance() {
            ArrayList<Point> list = new ArrayList<Point>();
            int x = this.X;
            while (x < this.X + this.W) {
                if (MassCreater.getMass((int)x, (int)(this.Y - 1)).WALKABLE) {
                    list.add(new Point(x, this.Y - 1));
                }
                if (MassCreater.getMass((int)x, (int)(this.Y + this.H)).WALKABLE) {
                    list.add(new Point(x, this.Y + this.H));
                }
                ++x;
            }
            int y = this.Y;
            while (y < this.Y + this.H) {
                if (MassCreater.getMass((int)(this.X - 1), (int)y).WALKABLE) {
                    list.add(new Point(this.X - 1, y));
                }
                if (MassCreater.getMass((int)(this.X + this.W), (int)y).WALKABLE) {
                    list.add(new Point(this.X + this.W, y));
                }
                ++y;
            }
            return list;
        }

        public List<Point> getListEntrance_Huto() {
            ArrayList<Point> list = new ArrayList<Point>();
            int x = this.X - 1;
            while (x < this.X + this.W + 1) {
                if (MassCreater.getMass((int)x, (int)(this.Y - 1)).WALKABLE) {
                    list.add(new Point(x, this.Y - 1));
                }
                if (MassCreater.getMass((int)x, (int)(this.Y + this.H)).WALKABLE) {
                    list.add(new Point(x, this.Y + this.H));
                }
                ++x;
            }
            int y = this.Y - 1;
            while (y < this.Y + this.H + 1) {
                if (MassCreater.getMass((int)(this.X - 1), (int)y).WALKABLE) {
                    list.add(new Point(this.X - 1, y));
                }
                if (MassCreater.getMass((int)(this.X + this.W), (int)y).WALKABLE) {
                    list.add(new Point(this.X + this.W, y));
                }
                ++y;
            }
            return list;
        }

        public ArrayList<Point> getListNoCreatureMassPointInRoom() {
            ArrayList<Point> list = new ArrayList<Point>();
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    if (MassCreater.getMass((int)x, (int)y).ROOM && MapList.getCreature(x, y) == null) {
                        list.add(new Point(x, y));
                    }
                    ++y;
                }
                ++x;
            }
            return list;
        }

        public int getSize() {
            return this.W * this.H;
        }

        private int getWeight() {
            return (int)Math.round(Math.sqrt(this.getSize()));
        }

        private boolean isAbleToExtend() {
            boolean flag = true;
            int i = 0;
            while (i < this.W) {
                if (!MassCreater.getMass((int)(this.X + i), (int)(this.Y - 1)).WALKABLE) {
                    flag = false;
                    break;
                }
                ++i;
            }
            if (flag) {
                return true;
            }
            flag = true;
            i = 0;
            while (i < this.W) {
                if (!MassCreater.getMass((int)(this.X + i), (int)(this.Y + this.H)).WALKABLE) {
                    flag = false;
                    break;
                }
                ++i;
            }
            if (flag) {
                return true;
            }
            flag = true;
            i = 0;
            while (i < this.H) {
                if (!MassCreater.getMass((int)(this.X - 1), (int)(this.Y + i)).WALKABLE) {
                    flag = false;
                    break;
                }
                ++i;
            }
            if (flag) {
                return true;
            }
            flag = true;
            i = 0;
            while (i < this.H) {
                if (!MassCreater.getMass((int)(this.X + this.W), (int)(this.Y + i)).WALKABLE) {
                    flag = false;
                    break;
                }
                ++i;
            }
            return flag;
        }

        public boolean isDrawed() {
            return this.flag_drawed;
        }

        public boolean isEntrance(int x, int y) {
            boolean b = false;
            int signal = 0;
            if (x == this.X || x == this.X + this.W - 1) {
                signal = x == this.X ? -1 : 1;
                b = MassCreater.getMass((int)(x + signal), (int)y).WALKABLE;
            }
            if (y == this.Y || y == this.Y + this.H - 1) {
                signal = y == this.Y ? -1 : 1;
                b = b || MassCreater.getMass((int)x, (int)(y + signal)).WALKABLE;
            }
            return b;
        }

        private boolean isLappedOver(Room r) {
            if (this.equals(r)) {
                return false;
            }
            if (this.X < r.X && r.X < this.X + this.W) {
                if (this.Y < r.Y && r.Y < this.Y + this.H) {
                    return true;
                }
                if (this.Y < r.Y + r.H && r.Y + r.H < this.Y + this.H) {
                    return true;
                }
            }
            if (this.X < r.X + r.W && r.X + r.W < this.X + this.W) {
                if (this.Y < r.Y && r.Y < this.Y + this.H) {
                    return true;
                }
                if (this.Y < r.Y + r.H && r.Y + r.H < this.Y + this.H) {
                    return true;
                }
            }
            if (this.X < r.X && r.X + r.W < this.X + this.W && r.Y < this.Y && this.Y + this.H < r.Y + r.H) {
                return true;
            }
            return r.X < this.X && this.X + this.W < r.X + r.W && this.Y < r.Y && r.Y + r.H < this.Y + this.H;
        }

        public boolean isNewThePointInExtentdedThis(int x, int y) {
            return this.X <= x && x < this.X + this.W && this.Y <= y && y < this.Y + this.H;
        }

        public boolean isThePointInExtentdedThis(int x, int y) {
            return this.X - 1 <= x && x < this.X + this.W + 1 && this.Y - 1 <= y && y < this.Y + this.H + 1;
        }

        public boolean isThePointInExtentdedThis(Point p) {
            return this.isThePointInExtentdedThis(p.x, p.y);
        }

        public boolean isThePointInThis(int x, int y) {
            return this.X <= x && x < this.X + this.W && this.Y <= y && y < this.Y + this.H;
        }

        public boolean isThePointInThis(Point p) {
            return this.isThePointInThis(p.x, p.y);
        }

        public void setHoly(boolean b) {
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    MassCreater.getMass(x, y).setHoly(b);
                    ++y;
                }
                ++x;
            }
        }

        public ArrayList<Mass> setHuto(int lv) {
            Base_Artifact a;
            ArrayList<Mass> list = new ArrayList<Mass>();
            if (lv == 4) {
                int i = this.X;
                while (i < this.X + this.W) {
                    int j = this.Y;
                    while (j < this.Y + this.H) {
                        a = MapList.getArtiface(i, j);
                        if (!(a != null && (a.isMerchant() || a.isPunishment()) || MapList.isCreature(i, j))) {
                            list.add(MassCreater.getMass(i, j));
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                for (Point p : this.getListEntrance_Huto()) {
                    a = MapList.getArtifact(p);
                    if (a != null && (a.isMerchant() || a.isPunishment())) continue;
                    list.add(MassCreater.getMass(p));
                }
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((Mass)iterator.next()).setWaterWithAnimation(true, !iterator.hasNext());
            }
            if (!list.isEmpty()) {
                Message.set("\u79d8\u8853\u306b\u3088\u3063\u3066\u9589\u3058\u8fbc\u3081\u3089\u308c\u305f");
            }
            return list;
        }

        public void setShop(boolean b) {
            int x = this.X;
            while (x < this.X + this.W) {
                int y = this.Y;
                while (y < this.Y + this.H) {
                    MassCreater.getMass(x, y).setShop(b);
                    ++y;
                }
                ++x;
            }
        }

        private void trap(final Base_Artifact a) {
            if (a instanceof Base_Trap && !a.isVisible()) {
                if (!Player.me.conditionCheck(CONDITION.\u76ee\u85ac) && !\u5370\u7f60\u5e2b.effect()) {
                    MainMap.addEffect(new DoronEffect(a.getMassPoint(), new Task(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public void work() {
                            a.setVisible(true);
                        }

                        @Override
                        protected void work(int frame) {
                            if (frame == 4) {
                                a.setVisible(true);
                            }
                        }
                    }, false, true), true);
                } else {
                    a.setVisible(true);
                }
            }
        }
    }
}

