/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.config.table;

import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.creature.player.class_job.bonus.bonus_switch.BonusConductor;
import dangeon.util.R;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import main.util.DIRECTION;
import main.util.FileReadSupporter;
import main.util.Show;

public class TrapTable {
    private static HashMap<Class<?>, Integer> trap_map = new HashMap();
    private static List<Class<?>> list_trap_table = new ArrayList();
    private static int total_value = 0;

    public static void addMapList(int value, Base_Artifact a) {
        if (BonusConductor.\u5192\u967a\u5bb6()) {
            if (a == null) {
                TrapTable.dangerousStair();
                value *= 2;
            }
            int i = 0;
            while (i < value) {
                if (a == null) {
                    TrapTable.trapSelect();
                } else {
                    MapList.setTrapOnMap(a.getMassPoint(), a);
                }
                ++i;
            }
        } else if (a == null) {
            int i = 0;
            while (i < value) {
                TrapTable.setWarningPoint(MassCreater.getTrapIP());
                ++i;
            }
            TrapTable.dangerousStair();
        } else {
            int i = 0;
            while (i < value) {
                MapList.setTrapOnMap(a.getMassPoint(), a);
                ++i;
            }
        }
    }

    public static void createMonsterHouse(InitialPlacement.Room r, int number) {
        if (BonusConductor.\u5192\u967a\u5bb6()) {
            int i = 0;
            while (i < number * 2) {
                TrapTable.trapSelect();
                ++i;
            }
        } else {
            int i = 0;
            while (i < number) {
                TrapTable.setWarningPoint(MassCreater.getTrapIP(r));
                ++i;
            }
        }
    }

    private static Base_Artifact createObject(Point p, Class<?> c) {
        try {
            Constructor<?> con = c.getConstructor(Point.class);
            Object obj = con.newInstance(p);
            if (obj instanceof Base_Artifact) {
                return (Base_Artifact)obj;
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void createTrapTable(BufferedReader bf) {
        trap_map.clear();
        list_trap_table.clear();
        total_value = 0;
        try {
            String str;
            boolean roop = true;
            while ((str = bf.readLine()) != null) {
                if (roop) {
                    if (!str.startsWith("TRAP")) continue;
                    roop = false;
                    continue;
                }
                String[] detail = str.split("\t");
                String trap_name = detail[0];
                Integer parcent = Integer.valueOf(detail[1]);
                Class<?> c = TrapTable.returnClass(trap_name);
                total_value += parcent.intValue();
                trap_map.put(c, parcent);
                list_trap_table.add(c);
            }
            bf.close();
        }
        catch (FileNotFoundException e) {
            Show.showCriticalErrorMessageDialog("ItemTable\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093@FileReader-ItemTable");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dangerousStair() {
        if (PresentField.get().isDangerous()) {
            ArrayList<Stairs> array = new ArrayList<Stairs>(5);
            for (Base_Artifact base_Artifact : MapList.getListArtifact()) {
                if (!(base_Artifact instanceof Stairs)) continue;
                array.add((Stairs)base_Artifact);
            }
            for (Base_Artifact base_Artifact : array) {
                Point p = base_Artifact.getMassPoint();
                TrapTable.setWarningPoint(p);
            }
        }
    }

    private static boolean isTrapUnableToExist_Apparently(Point p) {
        Mass m = MassCreater.getMass(p);
        if (m.equals(Mass.nullpo) || !m.WALKABLE) {
            return true;
        }
        if (m.WATER || m.WATER_LEEF) {
            return true;
        }
        Base_Artifact a = MapList.getArtifact(p);
        return a != null && a.isVisible();
    }

    public static StringBuffer randomTableCreate() {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader read = FileReadSupporter.readUTF8("res/table/table.csv");
            sb = TrapTable.randomTableCreate(new BufferedReader(read));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static StringBuffer randomTableCreate(BufferedReader br) {
        boolean _flag = false;
        StringBuffer sb = new StringBuffer("TRAP\n");
        try {
            String str;
            while ((str = br.readLine()) != null) {
                if ((str = str.trim()).isEmpty()) continue;
                if (str.startsWith("ENEMY") || str.startsWith("ITEM")) {
                    _flag = false;
                    continue;
                }
                if (str.startsWith("TRAP")) {
                    _flag = true;
                    continue;
                }
                if (!_flag) continue;
                String[] cut = str.split("\t");
                sb.append(cut[0].trim());
                sb.append("\t");
                sb.append(R.ran(100) + 1);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static Class<?> returnClass(String str) {
        try {
            Class<?> clazz = Class.forName("dangeon.model.object.artifact.trap.".concat(str));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setOnMap() {
        TrapTable.addMapList(PresentField.get().getTrapDefaultValue(), null);
    }

    public static void setOnMap(Point p) {
        TrapTable.trapSelect(p);
    }

    private static void setWarningPoint(Point p) {
        boolean small = new R().is(80);
        int parcent = small ? 40 : 20;
        boolean flag_less_one = true;
        if (small) {
            DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                Point target = d.getFrontPoint(p.getLocation());
                Mass m = MassCreater.getMass(target);
                if (m.ROOM && !TrapTable.isTrapUnableToExist_Apparently(target)) {
                    flag_less_one = false;
                    m.setWarningSmall(false);
                    if (new R().is(parcent)) {
                        TrapTable.trapSelect(target);
                        m.setWarningSmall(false);
                    }
                }
                ++n2;
            }
        } else {
            DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyBasic4();
            int n = dIRECTIONArray.length;
            int n3 = 0;
            while (n3 < n) {
                DIRECTION d = dIRECTIONArray[n3];
                Point target = p.getLocation();
                while (true) {
                    Mass m = MassCreater.getMass(d.getFrontPoint(target));
                    if (!m.ROOM) break;
                    if (TrapTable.isTrapUnableToExist_Apparently(target)) continue;
                    flag_less_one = false;
                    m.setWarningLarge(false);
                    if (!new R().is(parcent)) continue;
                    TrapTable.trapSelect(target);
                    m.setWarningLarge(false);
                }
                ++n3;
            }
        }
        if (!flag_less_one) {
            if (small) {
                MassCreater.getMass(p).setWarningSmall(true);
            } else {
                MassCreater.getMass(p).setWarningLarge(true);
            }
        }
    }

    private static void trapSelect() {
        int i = 0;
        if (total_value == 0) {
            return;
        }
        int select = new R().nextInt(total_value) + 1;
        for (Class<?> clazz : list_trap_table) {
            if (select > (i += trap_map.get(clazz).intValue())) continue;
            Point p = MassCreater.getTrapIP();
            if (!MapList.isTrapOrWaterPermitted(p)) break;
            MapList.addArtifact(TrapTable.createObject(p, clazz));
            break;
        }
    }

    public static boolean trapSelect(Point p) {
        if (TrapTable.isTrapUnableToExist_Apparently(p)) {
            return false;
        }
        int i = 0;
        int select = new R().nextInt(total_value) + 1;
        for (Class<?> clazz : list_trap_table) {
            if (select > (i += trap_map.get(clazz).intValue())) continue;
            if (MapList.isTrapOrWaterPermitted(p)) {
                MapList.addArtifact(TrapTable.createObject(p, clazz));
            }
            return true;
        }
        return true;
    }
}

