/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.config.table;

import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.arrow.Arrow;
import dangeon.model.object.artifact.item.disc.Disc;
import dangeon.model.object.artifact.item.food.Food;
import dangeon.model.object.artifact.item.grass.Base_Grass;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.ring.Ring;
import dangeon.model.object.artifact.item.scrool.Scrool;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.util.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public enum ItemDetail {
    CARD("spellcard", SpellCard.class),
    RING("ring", Ring.class),
    FOOD("food", Food.class),
    ARROW("arrow", Arrow.class),
    SCROOL("scrool", Scrool.class),
    GRASS("grass", Base_Grass.class),
    STAFF("staff", Staff.class),
    DISC("disc", Disc.class),
    POT("pot", Base_Pot.class);

    public int parcent_value;
    private Class<? extends Base_Artifact> category_class;
    private String category;
    int category_parcent;
    private static int category_parcent_sum;
    List<Class<?>> category_list = new ArrayList();
    HashMap<Class<?>, RANK> rank_map = new HashMap();
    public HashMap<RANK, List<Class<?>>> map = new HashMap();
    private static ArrayList<ItemDetail> category_values;

    static {
        category_values = new ArrayList();
    }

    static Class<?> getItem(boolean rare) {
        if (rare) {
            ArrayList list = new ArrayList();
            ItemDetail[] itemDetailArray = ItemDetail.values();
            int n = itemDetailArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemDetail id = itemDetailArray[n2];
                id.setRareIntoList(list);
                ++n2;
            }
            if (list.isEmpty()) {
                return null;
            }
            return list.get(new R().nextInt(list.size()));
        }
        if (category_parcent_sum > 0) {
            int value = 0;
            int category_select = new R().nextInt(category_parcent_sum) + 1;
            for (ItemDetail id : category_values) {
                if ((value += id.category_parcent) < category_select) continue;
                return id.itemPerfectedllyRandom();
            }
            return null;
        }
        return null;
    }

    static Class<?> getItem(ItemDetail ID) {
        int value = 0;
        if (category_parcent_sum == 0) {
            return null;
        }
        int category_select = new R().nextInt(category_parcent_sum) + 1;
        for (ItemDetail id : category_values) {
            if (ID != null) {
                if (!ID.equals((Object)id)) continue;
                return id.item();
            }
            if ((value += id.category_parcent) < category_select) continue;
            return id.item();
        }
        return null;
    }

    private static void setCategoryParcentValue() {
        category_parcent_sum = 0;
        for (ItemDetail id : category_values) {
            category_parcent_sum += id.category_parcent;
        }
    }

    private static void setCategoryValues() {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            if (!id.category_list.isEmpty()) {
                category_values.add(id);
            }
            ++n2;
        }
    }

    static void setList(String category, String rank, Class<?> c) {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            if (category.matches(id.category)) {
                id.set(rank, c);
                return;
            }
            ++n2;
        }
    }

    public static void setPercent(String category, int percent) {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            if (id.category.matches(category)) {
                id.category_parcent = percent;
                return;
            }
            ++n2;
        }
    }

    static void start() {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            id.setParcentValue();
            ++n2;
        }
        ItemDetail.setCategoryValues();
        ItemDetail.setCategoryParcentValue();
    }

    public static ItemDetail getCategory(Base_Artifact a) {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            if (id.category_class.isInstance(a)) {
                return id;
            }
            ++n2;
        }
        return null;
    }

    static RANK getRank(Base_Artifact a) {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            for (Class<?> c : id.category_list) {
                if (!c.isInstance(a)) continue;
                return id.rank_map.get(c);
            }
            ++n2;
        }
        return RANK.N;
    }

    public static void resetDate() {
        ItemDetail[] itemDetailArray = ItemDetail.values();
        int n = itemDetailArray.length;
        int n2 = 0;
        while (n2 < n) {
            ItemDetail id = itemDetailArray[n2];
            id.parcent_value = 0;
            id.category_list.clear();
            id.rank_map.clear();
            id.map.clear();
            ++n2;
        }
        category_parcent_sum = 0;
        category_values.clear();
    }

    private ItemDetail(String str, Class<? extends Base_Artifact> c) {
        this.category = str;
        this.category_class = c;
    }

    private Class<?> item() {
        int c_value = 0;
        int select = new R().nextInt(this.parcent_value) + 1;
        for (Class<?> c : this.category_list) {
            if ((c_value += this.rank_map.get(c).PARCENT) < select) continue;
            return c;
        }
        return null;
    }

    private Class<?> itemPerfectedllyRandom() {
        ArrayList category_list = new ArrayList();
        for (Class<?> class1 : this.category_list) {
            if (this.rank_map.get(class1).PARCENT <= 0) continue;
            category_list.add(class1);
        }
        if (category_list.isEmpty()) {
            return null;
        }
        return (Class)category_list.get(new R().nextInt(category_list.size()));
    }

    private void set(String str, Class<?> c) {
        this.category_list.add(c);
        if (str.matches("S")) {
            this.rank_map.put(c, RANK.S);
        } else if (str.matches("A")) {
            this.rank_map.put(c, RANK.A);
        } else if (str.matches("B")) {
            this.rank_map.put(c, RANK.B);
        } else if (str.matches("C")) {
            this.rank_map.put(c, RANK.C);
        } else if (str.matches("D")) {
            this.rank_map.put(c, RANK.D);
        } else {
            this.rank_map.put(c, RANK.N);
        }
    }

    private void setParcentValue() {
        this.parcent_value = 0;
        for (Class<?> c : this.category_list) {
            this.parcent_value += this.rank_map.get(c).PARCENT;
        }
    }

    private void setRareIntoList(ArrayList<Class<?>> list) {
        for (Class<?> c : this.category_list) {
            switch (this.rank_map.get(c)) {
                case A: {
                    list.add(c);
                    list.add(c);
                    list.add(c);
                }
                case S: {
                    list.add(c);
                    list.add(c);
                }
            }
        }
    }

    static enum RANK {
        S(2),
        A(5),
        B(30),
        C(60),
        D(100),
        N(0);

        int PARCENT;

        private RANK(int i) {
            this.PARCENT = i;
        }
    }
}

