/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.condition;

import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import java.awt.Point;
import main.util.DIRECTION;

public class Panic {
    private static int MP = 60;
    static Mass[][] mass = MassCreater.getMass();
    private static boolean[][] check_room = new boolean[MP][MP];
    private static boolean player_watched = false;

    private static void check_clear() {
        int i = 0;
        while (i < MP) {
            int j = 0;
            while (j < MP) {
                Panic.check_room[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    public static void conditionEffect(Base_Creature creature) {
        if (creature == Player.me) {
            return;
        }
        if (Panic.mass[creature.getMassPoint().x][creature.getMassPoint().y].ROOM) {
            Panic.check_clear();
            player_watched = false;
            Panic.whereIsPlayerInRoom(creature, creature.getMassPoint().x, creature.getMassPoint().y);
            if (!player_watched) {
                return;
            }
            Panic.escapeFromPlayer(creature);
            creature.convertEnemyFromCreature((Base_Creature)creature).enemy_condition_actioned = true;
            return;
        }
        if (Panic.mass[creature.getMassPoint().x][creature.getMassPoint().y].ROAD) {
            if (!Panic.whereIsPlayerInRoad(creature)) {
                return;
            }
            Panic.escapeFromPlayer(creature);
            creature.convertEnemyFromCreature((Base_Creature)creature).enemy_condition_actioned = true;
            return;
        }
    }

    private static DIRECTION directionOfPlayer(Base_Creature creature) {
        if (Player.me.getMassPoint().x > creature.getMassPoint().x) {
            if (Player.me.getMassPoint().y > creature.getMassPoint().y) {
                return DIRECTION.DOWN_RIGHT;
            }
            if (Player.me.getMassPoint().y < creature.getMassPoint().y) {
                return DIRECTION.UP_RIGHT;
            }
            return DIRECTION.RIGHT;
        }
        if (Player.me.getMassPoint().x < creature.getMassPoint().x) {
            if (Player.me.getMassPoint().y > creature.getMassPoint().y) {
                return DIRECTION.DOWN_LEFT;
            }
            if (Player.me.getMassPoint().y < creature.getMassPoint().x) {
                return DIRECTION.UP_LEFT;
            }
            return DIRECTION.RIGHT;
        }
        if (Player.me.getMassPoint().y < creature.getMassPoint().y) {
            return DIRECTION.UP;
        }
        return DIRECTION.DOWN;
    }

    private static void escapeFromPlayer(Base_Creature creature) {
        Point p = creature.getMassPoint();
        switch (Panic.directionOfPlayer(creature)) {
            case UP: {
                if (!Panic.mass[p.x][p.y + 1].WALKABLE || MapList.getEnemy(p.x, p.y + 1) != null) {
                    if (Panic.mass[p.x - 1][p.y + 1].WALKABLE && MapList.getEnemy(p.x - 1, p.y + 1) == null && Panic.mass[p.x - 1][p.y].WALKABLE && Panic.mass[p.x][p.y + 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 1, DIRECTION.DOWN_LEFT);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y + 1].WALKABLE && MapList.getEnemy(p.x + 1, p.y + 1) == null && Panic.mass[p.x + 1][p.y].WALKABLE && Panic.mass[p.x][p.y + 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, 1, DIRECTION.DOWN_RIGHT);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y].WALKABLE && MapList.getEnemy(p.x - 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y].WALKABLE && MapList.getEnemy(p.x + 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, 0, DIRECTION.RIGHT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(0, 1, DIRECTION.DOWN);
                break;
            }
            case DOWN: {
                if (!Panic.mass[p.x][p.y - 1].WALKABLE || MapList.getEnemy(p.x, p.y - 1) != null) {
                    if (Panic.mass[p.x - 1][p.y - 1].WALKABLE && MapList.getEnemy(p.x - 1, p.y - 1) == null && Panic.mass[p.x - 1][p.y].WALKABLE && Panic.mass[p.x][p.y - 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, -1, DIRECTION.UP_LEFT);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y - 1].WALKABLE && MapList.getEnemy(p.x + 1, p.y - 1) == null && Panic.mass[p.x + 1][p.y].WALKABLE && Panic.mass[p.x][p.y - 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, -1, DIRECTION.UP_RIGHT);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y].WALKABLE && MapList.getEnemy(p.x - 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y].WALKABLE && MapList.getEnemy(p.x + 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, 0, DIRECTION.RIGHT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(0, -1, DIRECTION.UP);
                break;
            }
            case LEFT: {
                if (!Panic.mass[p.x + 1][p.y].WALKABLE || MapList.getEnemy(p.x + 1, p.y) != null) {
                    if (Panic.mass[p.x + 1][p.y + 1].WALKABLE && MapList.getEnemy(p.x + 1, p.y + 1) == null && Panic.mass[p.x + 1][p.y].WALKABLE && Panic.mass[p.x][p.y + 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, 1, DIRECTION.DOWN_RIGHT);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y - 1].WALKABLE && MapList.getEnemy(p.x + 1, p.y - 1) == null && Panic.mass[p.x + 1][p.y].WALKABLE && Panic.mass[p.x][p.y - 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, -1, DIRECTION.UP_RIGHT);
                        break;
                    }
                    if (Panic.mass[p.x][p.y + 1].WALKABLE && MapList.getEnemy(p.x, p.y + 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, 1, DIRECTION.DOWN);
                        break;
                    }
                    if (Panic.mass[p.x][p.y - 1].WALKABLE && MapList.getEnemy(p.x, p.y - 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, -1, DIRECTION.UP);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(1, 0, DIRECTION.RIGHT);
                break;
            }
            case RIGHT: {
                if (!Panic.mass[p.x - 1][p.y].WALKABLE || MapList.getEnemy(p.x - 1, p.y) != null) {
                    if (Panic.mass[p.x - 1][p.y + 1].WALKABLE && MapList.getEnemy(p.x - 1, p.y + 1) == null && Panic.mass[p.x - 1][p.y].WALKABLE && Panic.mass[p.x][p.y + 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 1, DIRECTION.DOWN_LEFT);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y - 1].WALKABLE && MapList.getEnemy(p.x - 1, p.y - 1) == null && Panic.mass[p.x - 1][p.y].WALKABLE && Panic.mass[p.x][p.y - 1].WALKABLE) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, -1, DIRECTION.UP_LEFT);
                        break;
                    }
                    if (Panic.mass[p.x][p.y + 1].WALKABLE && MapList.getEnemy(p.x, p.y + 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, 1, DIRECTION.DOWN);
                        break;
                    }
                    if (Panic.mass[p.x][p.y - 1].WALKABLE && MapList.getEnemy(p.x, p.y - 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                break;
            }
            case DOWN_RIGHT: {
                if (!Panic.mass[p.x - 1][p.y - 1].WALKABLE || MapList.getEnemy(p.x - 1, p.y - 1) != null) {
                    if (Panic.mass[p.x][p.y - 1].WALKABLE && MapList.getEnemy(p.x, p.y - 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, -1, DIRECTION.UP);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y].WALKABLE && MapList.getEnemy(p.x - 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(-1, -1, DIRECTION.UP_LEFT);
                break;
            }
            case DOWN_LEFT: {
                if (!Panic.mass[p.x + 1][p.y - 1].WALKABLE || MapList.getEnemy(p.x + 1, p.y - 1) != null) {
                    if (Panic.mass[p.x][p.y - 1].WALKABLE && MapList.getEnemy(p.x, p.y - 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, -1, DIRECTION.UP);
                        break;
                    }
                    if (Panic.mass[p.x + 1][p.y].WALKABLE && MapList.getEnemy(p.x + 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(1, 0, DIRECTION.RIGHT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(1, -1, DIRECTION.UP_RIGHT);
                break;
            }
            case UP_RIGHT: {
                if (!Panic.mass[p.x - 1][p.y + 1].WALKABLE || MapList.getEnemy(p.x - 1, p.y + 1) != null) {
                    if (Panic.mass[p.x][p.y + 1].WALKABLE && MapList.getEnemy(p.x, p.y + 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, 1, DIRECTION.DOWN);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y].WALKABLE && MapList.getEnemy(p.x - 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(-1, 1, DIRECTION.DOWN_LEFT);
                break;
            }
            case UP_LEFT: {
                if (!Panic.mass[p.x + 1][p.y + 1].WALKABLE || MapList.getEnemy(p.x + 1, p.y + 1) != null) {
                    if (Panic.mass[p.x][p.y + 1].WALKABLE && MapList.getEnemy(p.x, p.y + 1) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(0, 1, DIRECTION.DOWN);
                        break;
                    }
                    if (Panic.mass[p.x - 1][p.y].WALKABLE && MapList.getEnemy(p.x - 1, p.y) == null) {
                        creature.convertEnemyFromCreature(creature).enemy_move(-1, 0, DIRECTION.LEFT);
                        break;
                    }
                    return;
                }
                creature.convertEnemyFromCreature(creature).enemy_move(1, 1, DIRECTION.DOWN_RIGHT);
            }
        }
    }

    private static boolean whereIsPlayerInRoad(Base_Creature creature) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (Player.me.getMassPoint().x == creature.getMassPoint().x + i && Player.me.getMassPoint().y == creature.getMassPoint().y + j) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static void whereIsPlayerInRoom(Base_Creature creature, int x, int y) {
        int i = -1;
        while (i <= 1) {
            int j = -1;
            while (j <= 1) {
                if (!check_room[x + i][y + j]) {
                    if (Player.me.getMassPoint().x == x + i && Player.me.getMassPoint().y == y + j) {
                        Panic.check_room[x + i][y + j] = true;
                        player_watched = true;
                    }
                    if (!Panic.mass[x + i][y + j].WALKABLE) {
                        Panic.check_room[x + i][y + j] = true;
                    } else if (Panic.mass[x + i][y + j].ROAD) {
                        Panic.check_room[x + i][y + j] = true;
                    } else if (Panic.mass[x + i][y + j].ROOM) {
                        Panic.check_room[x + i][y + j] = true;
                        Panic.whereIsPlayerInRoom(creature, x + i, y + j);
                    }
                }
                ++j;
            }
            ++i;
        }
    }
}

