/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.condition;

import dangeon.controller.TurnSystemController;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.Confusion;
import dangeon.model.condition.Death;
import dangeon.model.condition.Paralyze;
import dangeon.model.condition.Sleep;
import dangeon.model.map.MapList;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import java.util.ArrayList;
import java.util.List;
import main.res.Image_Condition;
import main.util.CSVLoadSupporter;

public enum CONDITION {
    \u500d\u901f,
    \u4e09\u500d\u901f,
    \u3084\u308a\u3059\u3054\u3057,
    \u900f\u660e,
    \u53cd\u5c04,
    \u76ee\u85ac,
    \u900f\u8996,
    \u30d1\u30ef\u30fc\u30a2\u30c3\u30d7,
    \u86cd,
    \u7761\u7720,
    \u9ebb\u75fa,
    \u6df7\u4e71,
    \u920d\u8db3,
    \u5c01\u5370,
    \u5f71\u7e2b\u3044,
    \u6b7b,
    \u90aa\u6cd5,
    \u4eee\u7720,
    \u7279\u6b8a\u4eee\u7720,
    \u708e\u4e0a,
    \u30a4\u30ab\u30ea,
    \u3048\u3048\u3093\u3058\u3083\u306a\u3044\u304b,
    \u5b89\u5fc3,
    \u5929\u90aa\u9b3c,
    \u56de\u5fa9,
    \u8d85\u4f1a\u5fc3,
    \u5fc5\u4e2d\u4f1a\u5fc3,
    \u7d76\u5bfe\u56de\u907f,
    \u30a4\u30ea\u30e5\u30fc\u30b8\u30e7\u30f3,
    \u5fa9\u6d3b,
    \u304a\u306b\u304e\u308a,
    \u7d76\u5bfe\u5fc5\u4e2d,
    \u6697\u95c7,
    \u7206\u5f3e;

    public final int p_time;
    public final int e_time;
    public final Image_Condition IMA;
    public final boolean is_good;
    public final boolean is_bad;
    public final String NAME;
    public final String ORIGIN;
    public final String[] TEXTS;
    public final Boolean ONLY_FOR;

    public static boolean check(Base_Creature c, CONDITION con) {
        for (CONDITION condition : c.getConditionList()) {
            if (con != condition) continue;
            return true;
        }
        return false;
    }

    public static void conditionAllClear(Base_Creature creature) {
        creature.getConditionList().clear();
        creature.condition_map.clear();
    }

    public static void conditionCheck(Base_Creature creature) {
        CONDITION.conditionTurnCount(creature);
        for (CONDITION condition : creature.getConditionRemoveTask()) {
            creature.getConditionList().remove((Object)condition);
        }
        creature.getConditionRemoveTask().clear();
        CONDITION.conditionEffect(creature);
    }

    public static boolean conditionEffect(Base_Creature creature) {
        block5: for (CONDITION condition : creature.getConditionList()) {
            switch (condition) {
                case \u7761\u7720: 
                case \u4eee\u7720: 
                case \u7279\u6b8a\u4eee\u7720: 
                case \u6697\u95c7: {
                    if (creature == Player.me) {
                        TurnSystemController.setPlayerConditionSleep();
                    }
                }
                case \u9ebb\u75fa: {
                    if (creature == Player.me) {
                        TurnSystemController.callMeToStartEnemyTurn();
                    } else {
                        ((Base_Enemy)creature).enemy_actioned = true;
                    }
                    return true;
                }
                case \u3084\u308a\u3059\u3054\u3057: {
                    if (creature != Player.me || EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u98df)) continue block5;
                    TurnSystemController.setPlayerConditionSleep();
                    TurnSystemController.callMeToStartEnemyTurn(true);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean conditionEffectCase(Base_Creature creature, CONDITION condition) {
        for (CONDITION con : creature.getConditionList()) {
            if (con != condition) continue;
            switch (condition) {
                case \u7761\u7720: {
                    Sleep.conditionEffect(creature);
                    return true;
                }
                case \u6697\u95c7: {
                    Sleep.\u6697\u95c7(creature);
                    return true;
                }
                case \u6df7\u4e71: {
                    Confusion.conditionEffect(creature);
                    return true;
                }
                case \u9ebb\u75fa: 
                case \u4eee\u7720: 
                case \u7279\u6b8a\u4eee\u7720: 
                case \u5b89\u5fc3: {
                    creature.condition_map.remove((Object)con);
                    creature.setConditionRemoveTask(con);
                    return true;
                }
                case \u3084\u308a\u3059\u3054\u3057: {
                    creature.condition_map.remove((Object)con);
                    creature.getConditionList().remove((Object)con);
                    return true;
                }
            }
        }
        for (CONDITION con : creature.getConditionRemoveTask()) {
            creature.getConditionList().remove((Object)con);
        }
        creature.getConditionRemoveTask().clear();
        return false;
    }

    public static void conditionEnemyContinue() {
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            CONDITION.conditionCheck(enemy);
        }
    }

    public static void conditionOneEnemyContinue(Base_Creature creature) {
        CONDITION.conditionCheck(creature);
    }

    public static void conditionPlayerContinue() {
        CONDITION.conditionCheck(Player.me);
    }

    public static void conditionRecovery(Base_Creature creature, CONDITION ... con) {
        CONDITION[] cONDITIONArray = con;
        int n = con.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION condition = cONDITIONArray[n2];
            if (!creature.getConditionList().contains((Object)condition)) {
                return;
            }
            creature.condition_map.remove((Object)condition);
            creature.setConditionRemoveTask(condition);
            ++n2;
        }
    }

    public static void conditionRemove() {
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            for (CONDITION condition : enemy.getConditionRemoveTask()) {
                enemy.getConditionList().remove((Object)condition);
            }
            enemy.getConditionRemoveTask().clear();
        }
    }

    public static CONDITION conditionSelect(CONDITION c) {
        if (c == null) {
            List<CONDITION> list = CONDITION.getBadConditionList();
            int select = new R().nextInt(list.size());
            return list.get(select);
        }
        return c;
    }

    public static void conditionTurnCount(Base_Creature creature) {
        int i = 0;
        int j = 0;
        while (j <= i) {
            for (CONDITION c : creature.getConditionListNow()) {
                Integer count;
                if (c.equals((Object)\u5fc5\u4e2d\u4f1a\u5fc3) || (count = creature.condition_map.get((Object)c)) == null || count <= 0) continue;
                creature.condition_map.put(c, count - 1);
                if (count - 1 > 0) continue;
                if (c == \u6b7b) {
                    Death.effect(creature);
                }
                CONDITION.conditionRecovery(creature, c);
                return;
            }
            ++j;
        }
    }

    public static boolean enemyDontMove(Base_Creature creature) {
        for (CONDITION condition : creature.getConditionList()) {
            switch (condition) {
                case \u6697\u95c7: {
                    return true;
                }
                case \u7761\u7720: {
                    return true;
                }
                case \u9ebb\u75fa: {
                    Paralyze.conditionEffect(creature);
                    return true;
                }
                case \u4eee\u7720: 
                case \u7279\u6b8a\u4eee\u7720: {
                    return true;
                }
            }
        }
        return false;
    }

    private static List<CONDITION> getBadConditionList() {
        ArrayList<CONDITION> list = new ArrayList<CONDITION>();
        CONDITION[] cONDITIONArray = CONDITION.values();
        int n = cONDITIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION c = cONDITIONArray[n2];
            if (c.is_bad) {
                list.add(c);
            }
            ++n2;
        }
        return list;
    }

    public static boolean isMovable(Base_Creature c) {
        CONDITION[] cs;
        CONDITION[] cONDITIONArray = cs = new CONDITION[]{\u4eee\u7720, \u7279\u6b8a\u4eee\u7720, \u7761\u7720, \u9ebb\u75fa};
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION condition = cONDITIONArray[n2];
            if (c.conditionCheck(condition)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isSetCondition(Player p, CONDITION c) {
        switch (c) {
            case \u6df7\u4e71: {
                if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u6625)) {
                    Message.set("\u3057\u304b\u3057\u982d\u304c\u6674\u308c\u3084\u304b\u3067\u6df7\u4e71\u306f\u3059\u3050\u6cbb\u3063\u305f");
                    return true;
                }
                if (!EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u77b3)) break;
                Message.set("\u3057\u304b\u3057\u6ce2\u9577\u3092\u64cd\u308b\u3053\u3068\u3067\u6df7\u4e71\u304b\u3089\u7acb\u3061\u76f4\u3063\u305f");
                return true;
            }
            case \u7761\u7720: {
                if (!EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u899a\u9192) && !EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u6625)) break;
                Message.set("\u3057\u304b\u3057\u5143\u6c17\u3044\u3063\u3071\u3044\u3067\u3059\u3050\u8d77\u304d\u3066\u3057\u307e\u3063\u305f");
                return true;
            }
            case \u920d\u8db3: {
                if (!EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u6625)) break;
                Message.set("\u3057\u304b\u3057\u5143\u6c17\u3044\u3063\u3071\u3044\u3067\u920d\u8db3\u306f\u3059\u3050\u6cbb\u3063\u305f");
                return true;
            }
        }
        return false;
    }

    public static int powerUp(Base_Creature creature, int damage, boolean attack) {
        for (CONDITION con : creature.getConditionList()) {
            if (con != \u30d1\u30ef\u30fc\u30a2\u30c3\u30d7) continue;
            if (attack) {
                return damage * 150 / 100;
            }
            return damage * 75 / 100;
        }
        return damage;
    }

    public static void quickRemoveCondition(CONDITION con, Base_Creature c) {
        if (!c.getConditionList().contains((Object)con)) {
            return;
        }
        c.condition_map.remove((Object)con);
        c.getConditionList().remove((Object)con);
    }

    public static void setConditionTime(Base_Creature creature, CONDITION condition, int timer) {
        if (timer == 0) {
            timer = creature instanceof Player ? condition.p_time : condition.e_time;
        } else if (timer == -1) {
            timer = creature instanceof Player ? condition.p_time / 2 : condition.e_time / 2;
        } else if (timer == -2) {
            timer = 0;
        }
        creature.condition_map.put(condition, timer);
    }

    public static void setEnemyNormalSpeed(Base_Creature creature) {
        for (CONDITION con : creature.getConditionList()) {
            if (con == \u920d\u8db3) {
                CONDITION.conditionRecovery(creature, con);
            }
            if (con == \u500d\u901f) {
                CONDITION.conditionRecovery(creature, con);
            }
            if (con != \u4e09\u500d\u901f) continue;
            CONDITION.conditionRecovery(creature, con);
        }
        for (CONDITION con : creature.getConditionRemoveTask()) {
            creature.getConditionList().remove((Object)con);
        }
        creature.getConditionRemoveTask().clear();
    }

    public static ArrayList<CONDITION> values_bad() {
        ArrayList<CONDITION> list = new ArrayList<CONDITION>();
        CONDITION[] cONDITIONArray = CONDITION.values();
        int n = cONDITIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            CONDITION con = cONDITIONArray[n2];
            if (!con.is_good) {
                list.add(con);
            }
            ++n2;
        }
        return list;
    }

    public static void wakeUp(Base_Creature c) {
        CONDITION.conditionRecovery(c, \u4eee\u7720);
        CONDITION.conditionRecovery(c, \u7279\u6b8a\u4eee\u7720);
        CONDITION.conditionRecovery(c, \u5b89\u5fc3);
    }

    public static void \u90aa\u6cd5(Base_Creature c) {
        if (c.getConditionList().contains((Object)\u90aa\u6cd5)) {
            if (c.getGhost() != 1) {
                return;
            }
            int i = c instanceof Player ? 50 : 30;
            int damage = c.getMAX_HP() / i;
            if (damage < 1) {
                damage = 1;
            }
            if (c instanceof Player) {
                if (c.getHP() < damage) {
                    damage = c.getHP() - 1;
                }
                if (damage < 1) {
                    return;
                }
            }
            EnchantSpecial.setFlagNeglectHeal(true);
            c.chengeHP(null, "\u90aa\u6cd5\u306b\u3088\u3063\u3066\u8755\u307e\u308c\u305f", -damage);
        }
    }

    private CONDITION() {
        CSVLoadSupporter<String> list = CSVLoadSupporter.loadCSV(this.name(), CONDITION.class, "\t");
        this.NAME = list.get();
        this.is_good = ((String)list.get(1)).matches("TRUE");
        this.is_bad = list.get().matches("FALSE");
        this.p_time = list.toI();
        this.e_time = list.toI();
        this.IMA = Image_Condition.get(list.get());
        this.ONLY_FOR = list.is();
        this.ORIGIN = list.get();
        this.TEXTS = list.get().split("\n");
    }

    public boolean isBad() {
        return this.is_bad;
    }

    public boolean isGood() {
        return this.is_good;
    }
}

