/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.util.view_window;

import dangeon.model.config.Config;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.Footer;
import dangeon.view.util.StringFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import main.util.BeautifulView;

public class WindowFrame {
    public final Font FONT;
    public final Insets INSETS;
    protected final int MARGINE = 5;
    public BufferedImage WINDOW;
    public final Integer X;
    public Integer Y;
    public static final int BG_NORMAL = 0;
    public static final int BG_RED = 1;
    public static final int BG_NORMAL_UNCLEARLY = 2;
    private final Color B_COLOR = new Color(0, 0, 0, 150);
    public static final String CENTERIZE = "&c";
    public static final String HORIZON = "&-";
    public static final String TAIL = "&t";
    private int frame_rotation = 0;

    protected WindowFrame(Integer x, Integer y) {
        this(x, y, NormalFont.NORMALFONT);
    }

    protected WindowFrame(Integer x, Integer y, Font font) {
        this.X = x;
        this.Y = y;
        this.FONT = font;
        int top = 5;
        int left = 5;
        this.INSETS = new Insets(top, left, top, left);
    }

    public WindowFrame(Integer x, Integer y, Integer w_inside, int cols) {
        this(x, y, w_inside, cols, NormalFont.NORMALFONT);
    }

    public WindowFrame(Integer x, Integer y, Integer w_inside, int cols, Font font) {
        this(x, y, font);
        if (w_inside == null) {
            w_inside = 400 - this.getWidth(0) - this.X * 2;
        }
        this.WINDOW = this.createWindow(this.getWidth(w_inside), this.getHeight(cols));
    }

    public WindowFrame createDoubleSizeClearCopy() {
        final WindowFrame ME = this;
        WindowFrame wf = new WindowFrame((Integer)0, (Integer)0, this.FONT){

            @Override
            public void drawWindow(Graphics2D g) {
                g.drawImage(this.WINDOW, ME.getViewX(), ME.getViewY() + this.INSETS.top, this.getWidth() / 2, this.getHeight() / 2, null);
            }

            @Override
            protected int getViewY() {
                return super.getViewY() - this.INSETS.top;
            }
        };
        wf.WINDOW = new BufferedImage((this.getWidth() - this.INSETS.left - this.INSETS.right) * 2, (this.getHeight() - this.INSETS.top - this.INSETS.bottom) * 2, this.WINDOW.getType());
        return wf;
    }

    protected BufferedImage createWindow(int w, int h) {
        BufferedImage bi = Config.isLightVer() ? new BufferedImage(w, h, 2) : new BufferedImage(w, h, 3);
        Graphics2D g = bi.createGraphics();
        if (Config.isLightVer()) {
            switch (this.getBG()) {
                case 0: {
                    g.setColor(new Color(0, 50, 0));
                    break;
                }
                case 1: {
                    g.setColor(new Color(50, 0, 0));
                    break;
                }
                case 2: {
                    g.setColor(new Color(0, 50, 0));
                }
            }
        } else {
            switch (this.getBG()) {
                case 0: {
                    BeautifulView.setAlphaOnImg(g, Float.valueOf(0.4f));
                    g.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLUE, 0.0f, h, Color.CYAN));
                    break;
                }
                case 1: {
                    BeautifulView.setAlphaOnImg(g, Float.valueOf(0.4f));
                    g.setPaint(new GradientPaint(0.0f, 0.0f, Color.RED, 0.0f, h, Color.YELLOW));
                    break;
                }
                case 2: {
                    BeautifulView.setAlphaOnImg(g, Float.valueOf(0.8f));
                    g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(0, 0, 200), 0.0f, h, new Color(0, 200, 200)));
                }
            }
        }
        int x1 = 5;
        int y1 = 5;
        g.fillRect(x1, y1, w -= x1 * 2, h -= y1 * 2);
        g.setColor(Color.BLACK);
        int a = 2;
        g.drawRect(x1 + a, y1 + a, w - a * 2, h - a * 2);
        Color c = Color.WHITE;
        g.setPaint(new GradientPaint(0.0f, 0.0f, c, 0.0f, h, new Color(c.getRed() / 2, c.getGreen() / 2, c.getBlue() / 2)));
        BeautifulView.setAlphaOnImg(g, Float.valueOf(0.8f));
        g.setStroke(new BasicStroke(3.0f));
        g.drawRect(x1, y1, w, h);
        g.setStroke(new BasicStroke());
        a = -3;
        g.drawRect(x1 + a, y1 + a, w - a * 2, h - a * 2);
        return bi;
    }

    public void drawArrow(Graphics2D g, boolean writing) {
        this.frame_rotation += writing ? -3 : 1;
        g.setColor(writing ? new Color(10, 10, 150) : new Color(200, 255, 255));
        Footer.draw9(g, this.getViewX() + this.getWidth_CenterArea() - 5, this.getViewY() + this.getHeight_MiddleArea(), 16.0f, this.frame_rotation * 5, 2, 2.0f);
    }

    public void drawEdgedString(Graphics2D g, String str, int cols) {
        g.setFont(this.FONT);
        StringFilter.drawEdgedString(g, str, this.getViewX() + this.INSETS.left + 5, this.getViewY() + this.INSETS.top + this.getContentHeight() * cols);
    }

    public void drawLine(Graphics2D g, int cols, boolean middle_under) {
        this.drawLine(g, cols, this.getWidth_CenterArea() - 1, middle_under);
    }

    public void drawLine(Graphics2D g, int cols, int w, boolean middle_under) {
        int x = this.getX();
        int y = this.getY(g, this.getViewY(), cols);
        FontMetrics fm = g.getFontMetrics(this.FONT);
        y += fm.getDescent();
        if (middle_under) {
            y += this.getContentHeight() / 2;
        }
        g.setColor(Color.BLACK);
        g.fillRect(x, ++y, w, 3);
        g.setColor(Color.WHITE);
        int delt = 0;
        g.setPaint(new GradientPaint(x + delt, y, Color.WHITE, x + delt + w, y, Color.LIGHT_GRAY, false));
        g.fillRect(x + 1, y + 1, w - 2, 1);
        g.setColor(Color.WHITE);
    }

    public void drawString(Graphics2D g, String str, int cols) {
        g.setFont(this.FONT);
        StringFilter.drawString(g, str, this.getViewX() + this.INSETS.left + 5, this.getViewY() + this.INSETS.top + this.getContentHeight() * cols);
    }

    public void drawString(Graphics2D g, String str, int cols, int y_diff) {
        g.setColor(Color.WHITE);
        StringFilter.drawString(g, str, this.getViewX() + this.INSETS.left + 5, this.getViewY() + this.INSETS.top + this.getContentHeight() * cols + y_diff);
    }

    public void drawString(Graphics2D g, String str, int cols, int x_diff, int y_diff) {
        StringFilter.drawString(g, str, this.getViewX() + this.INSETS.left + 5 + x_diff, this.getViewY() + this.INSETS.top + this.getContentHeight() * cols + y_diff);
    }

    public void drawWindow(Graphics2D g) {
        g.setColor(Color.WHITE);
        g.drawImage((Image)this.WINDOW, this.getViewX(), this.getViewY(), null);
    }

    protected int getBG() {
        return 0;
    }

    protected final int getBG(boolean red) {
        return red ? 1 : 0;
    }

    public int getContentHeight() {
        return this.FONT.getSize() + 5;
    }

    public int getHeight() {
        return this.WINDOW.getHeight();
    }

    protected int getHeight(int cols) {
        int chosei = 5;
        int h = 5 + chosei + this.getContentHeight() * cols;
        return h += this.INSETS.top + this.INSETS.bottom;
    }

    public int getHeight_MiddleArea() {
        return this.getHeight() - this.getHeight(0);
    }

    public int getViewX() {
        if (this.X == null) {
            return (400 - this.WINDOW.getWidth()) / 2;
        }
        if (this.X < 0) {
            return 400 + this.X - this.getWidth();
        }
        return this.X;
    }

    protected int getViewY() {
        if (this.Y == null) {
            return (340 - this.WINDOW.getHeight()) / 2;
        }
        return this.Y;
    }

    public int getWidth() {
        return this.WINDOW.getWidth();
    }

    protected int getWidth(int w_inside) {
        int chosei = 3;
        w_inside += 5 + chosei;
        return w_inside += this.INSETS.left + this.INSETS.right;
    }

    public int getWidth_CenterArea() {
        return this.getWidth() - this.getWidth(0);
    }

    public int getX() {
        return this.getViewX() + this.INSETS.left + 5;
    }

    protected int getX(int x) {
        return x + this.INSETS.left + 5;
    }

    protected int getY(Graphics2D g, int y, int col) {
        return y + this.INSETS.top + this.getContentHeight() * (col + 1);
    }

    public Graphics2D initGraphics2Scaled() {
        Graphics2D g = this.WINDOW.createGraphics();
        g.setColor(Color.WHITE);
        g.setFont(this.FONT);
        int y = 5;
        g.setClip(0, y, this.WINDOW.getWidth(), this.WINDOW.getHeight() - y * 2 + 1);
        g.scale(2.0, 2.0);
        BeautifulView.setAntiAliasing(g, true);
        return g;
    }

    public void setY(int y) {
        this.Y = y;
    }
}

