/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.util.view_window;

import dangeon.latest.scene.action.menu.scrool.Scrool;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.util.view_window.Scrool_Bar;
import dangeon.latest.util.view_window.StringOnlyWindow;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class ScroolWindow
extends StringOnlyWindow {
    public Scrool_Bar SCROOL_BAR;
    public final String[] WHOLE_CONTENTS;
    public final int COLS;
    public final Scrool SCR;

    public ScroolWindow(Scrool scr, Font font, String ... contents) {
        this(scr, Message.W * 14 / 18, font, contents);
    }

    private ScroolWindow(Scrool scr, int w, Font font, String ... contents) {
        super((Integer)25, (Integer)null, w, (int)scr.COL, font);
        this.SCR = scr;
        this.WHOLE_CONTENTS = contents;
        this.COLS = scr.COL;
        this.SCROOL_BAR = new Scrool_Bar(this.getViewX() + this.getWidth() + 5, null, this.COLS, this.FONT, contents.length, this.SCR);
    }

    public ScroolWindow(Scrool scr, int w, String ... contents) {
        this(scr, w, NormalFont.NORMALFONT.deriveFont(14.0f), contents);
    }

    public ScroolWindow(Scrool scr, String ... contents) {
        this(scr, NormalFont.NORMALFONT.deriveFont(14.0f), contents);
    }

    @Override
    protected void drawHorizon(Graphics2D g, int i) {
        this.drawLine(g, i - 1, true);
    }

    @Override
    protected void drawString(Graphics2D g, int X, int Y) {
        StringFilter.setColor(g, this.CONTENTS[0]);
        int i = 0;
        while (i < this.CONTENTS.length - 1) {
            if (this.CONTENTS[i + 1].matches("&--")) {
                this.drawHorizon(g, i);
            } else {
                this.drawString(g, this.CONTENTS[i + 1], i + 1);
            }
            ++i;
        }
    }

    @Override
    public void drawWindow(Graphics2D g) {
        super.drawWindow(g);
        this.SCROOL_BAR.drawWindow(g);
    }

    public void drawWindow(Graphics2D g, boolean current) {
        super.drawWindow(g);
        if (current) {
            this.SCROOL_BAR.drawWindow(g);
        }
    }

    public boolean isExist(int index) {
        return index + this.COLS < this.WHOLE_CONTENTS.length;
    }

    @Override
    public void setY(int index) {
        this.SCROOL_BAR.setY(index);
        if (index >= 0) {
            ArrayList<String> list = new ArrayList<String>(this.COLS + 1);
            int i = 0;
            while (i < this.COLS) {
                int j = index + i;
                if (j >= this.WHOLE_CONTENTS.length) break;
                list.add(this.WHOLE_CONTENTS[j]);
                ++i;
            }
            list.add(0, index - 1 > 0 ? this.WHOLE_CONTENTS[index - 1] : "");
            this.setString(list.toArray(new String[0]));
        }
    }
}

