/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.util.view_window;

import dangeon.latest.scene.action.menu.Base_Scene_Menu;
import dangeon.latest.scene.action.menu.Base_Scene_Menu_View;
import dangeon.latest.util.view_window.Base_Window;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import main.res.Image_Object;
import main.res.Image_Window_Frame;
import main.util.BeautifulView;
import main.util.DIRECTION;

public class MenuWindow
extends Base_Window {
    protected final Color COLOR_MAIN = new Color(0, 150, 255, 50);
    protected final Color COLOR_SUB = new Color(100, 200, 100, 50);
    protected final Color COLOR_MAIN_LINE = new Color(0, 200, 255);
    protected final Color COLOR_MAIN_LINE_CLEAR = new Color(this.COLOR_MAIN_LINE.getRed(), this.COLOR_MAIN_LINE.getGreen(), this.COLOR_MAIN_LINE.getBlue(), 0);
    protected final Color COLOR_SUB_LINE = new Color(100, 255, 100);
    protected final Color COLOR_SUB_LINE_CLEAR = new Color(this.COLOR_SUB_LINE.getRed(), this.COLOR_SUB_LINE.getGreen(), this.COLOR_SUB_LINE.getBlue(), 0);
    protected final Base_Scene_Menu SCENE;
    protected final Base_Scene_Menu_View VIEW;
    protected final int W;
    private boolean red = false;

    protected MenuWindow(Base_Scene_Menu_View view) {
        this(view, NormalFont.NORMALFONT);
    }

    protected MenuWindow(Base_Scene_Menu_View view, Font font) {
        this(view, 0, font);
    }

    public MenuWindow(Base_Scene_Menu_View view, int w) {
        this(view, w, NormalFont.NORMALFONT);
    }

    public MenuWindow(Base_Scene_Menu_View view, int w, Font font) {
        super(view.X, view.Y, font);
        this.VIEW = view;
        this.W = w;
        this.SCENE = (Base_Scene_Menu)view.PARENT_SCENE;
        this.WINDOW = this.createWindow(this.getWidth(this.getW_Inside()), this.getHeight(this.SCENE.COL));
    }

    public void change(int cols, boolean red) {
        this.red = red;
        this.WINDOW = this.createWindow(this.getWidth(this.getW_Inside()), this.getHeight(cols));
    }

    private void drawBackLight(Graphics2D g, boolean current) {
        this.drawBackLight(g, current, this.SCENE.getIndex());
    }

    protected void drawBackLight(Graphics2D g, boolean current, int index) {
        FontMetrics fm = g.getFontMetrics(this.FONT);
        int w = this.getW(index) * 70 / 100;
        int h = fm.getHeight();
        int x = this.getX(this.getViewX(), index);
        int y = this.getY(g, this.getViewY(), index);
        y += fm.getDescent();
        y -= h;
        Color c = g.getColor();
        Paint p = g.getPaint();
        if (current) {
            g.setPaint(new GradientPaint(x, y, this.COLOR_MAIN_LINE, x + w, y, this.COLOR_MAIN_LINE_CLEAR));
        } else {
            g.setPaint(new GradientPaint(x, y, this.COLOR_SUB_LINE, x + w, y, this.COLOR_SUB_LINE_CLEAR));
        }
        g.fillRect(x, y, w, h);
        g.setPaint(p);
        g.setColor(c);
    }

    protected void drawGlowString(Graphics2D g, int x, int y, boolean current) {
        int index = this.SCENE.getIndex();
        if (this.SCENE.isContentDeprecated(index)) {
            return;
        }
        Color origine = g.getColor();
        g.setColor(current ? this.COLOR_MAIN : this.COLOR_SUB);
        String plain = StringFilter.getPlainString(this.SCENE.getContentName(index));
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION direction = dIRECTIONArray[n2];
            this.drawGlowString(g, x, y, direction, index, plain);
            ++n2;
        }
        g.setColor(Color.WHITE);
        g.drawString(plain, this.getX(x, index), this.getY(g, y, index));
        g.setColor(origine);
    }

    protected void drawGlowString(Graphics2D g, int x, int y, DIRECTION direction, int index, String plain) {
        int range = 2;
        int _x = this.getX(x, index) + direction.X * range;
        int _y = this.getY(g, y, index) + direction.Y * range;
        g.drawString(plain, _x, _y);
    }

    @Override
    protected void drawString(Graphics2D g, int x, int y) {
        g.setFont(this.FONT);
        int selected = this.SCENE.getIndex();
        int i = 0;
        while (i < this.SCENE.getContentSize()) {
            Color c = g.getColor();
            if (!this.isSelectedGlow() || this.SCENE.isContentDeprecated(i) || i != selected) {
                if (this.SCENE.isContentDeprecated(i)) {
                    g.setColor(Color.GRAY);
                }
                this.drawStringFilter(g, i, x, y);
                g.setColor(c);
            }
            ++i;
        }
    }

    protected void drawStringFilter(Graphics2D g, int i, int x, int y) {
        String s = this.SCENE.getContentName(i);
        if (s.matches("&-")) {
            this.drawLine(g, i - 1, true);
        } else {
            StringFilter.drawString(g, s, this.getX(x, i), this.getY(g, y, i));
        }
    }

    protected void drawSuikaIcon(Graphics2D g, boolean current) {
        BufferedImage im = Image_Object.suika.getImage();
        int hosei = 2;
        if (!current) {
            BeautifulView.setAlphaOnImg(g, Float.valueOf(0.6f));
        }
        g.drawImage((Image)im, this.getX(this.getViewX(), this.SCENE.getIndex()) - ((Image)im).getWidth(null) + hosei, this.getY(g, this.getViewY(), this.SCENE.getIndex()) - ((Image)im).getHeight(null), null);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
    }

    public void drawWindow(Graphics2D g, boolean current) {
        if (this.isSelectedLine()) {
            g.setColor(Color.WHITE);
        } else {
            g.setColor(current ? Color.WHITE : Color.GRAY);
        }
        g.drawImage((Image)this.WINDOW, this.getViewX(), this.getViewY(), null);
        if (this.isSelectedLine()) {
            this.drawBackLight(g, current);
        }
        this.drawString(g, this.getViewX(), this.getViewY());
        this.drawSuikaIcon(g, current);
        if (this.isSelectedGlow()) {
            this.drawGlowString(g, this.getViewX(), this.getViewY(), current);
        }
    }

    @Override
    protected int getBG() {
        return this.getBG(this.red);
    }

    @Override
    public int getViewX() {
        Integer X = this.VIEW.X;
        if (X == null) {
            return (400 - this.WINDOW.getWidth()) / 2;
        }
        if (X < 0) {
            return 400 + X - this.getWidth();
        }
        return X;
    }

    @Override
    protected int getViewY() {
        Integer Y = this.VIEW.Y;
        if (Y == null) {
            return (340 - this.WINDOW.getHeight()) / 2;
        }
        return Y;
    }

    public int getW(int index) {
        return this.W;
    }

    protected int getW_Inside() {
        return this.W;
    }

    protected int getX(int x, int index) {
        return x + this.INSETS.left + 5;
    }

    @Override
    protected int getY(Graphics2D g, int y, int index) {
        int dy = 0;
        if (this.isSelectedLine() && !this.SCENE.isContentDeprecated(index) && index == this.SCENE.getIndex()) {
            ++dy;
        }
        int col = index / this.SCENE.ROW;
        return y + this.INSETS.top + this.getContentHeight() * (col + 1) + dy;
    }

    protected boolean isSelectedGlow() {
        return this.VIEW.TYPE.equals((Object)Image_Window_Frame.GLOW);
    }

    protected boolean isSelectedLine() {
        return this.VIEW.TYPE.equals((Object)Image_Window_Frame.LINE);
    }
}

