/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.util.view_window;

import dangeon.latest.scene.action.itemlist.Item_List;
import dangeon.latest.scene.action.menu.Base_Scene_Menu;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.util.view_window.WindowFrame;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.view.constant.NormalFont;
import java.awt.Graphics2D;

public class ItemExplainWindow
extends WindowFrame {
    private final Item_List PARENT_ITEM_LIST;
    private Base_Scene_Menu next_scene;

    public ItemExplainWindow(Item_List scene) {
        super(Message.X, Message.Y, Message.W, 4, NormalFont.NORMALFONT.deriveFont(14.0f));
        this.PARENT_ITEM_LIST = scene;
    }

    protected void drawString(Graphics2D g, int X, int Y) {
        String[] arr;
        if (this.PARENT_ITEM_LIST.getSelectedContent() == null) {
            return;
        }
        Base_Artifact a = (Base_Artifact)this.PARENT_ITEM_LIST.getSelectedContent().OBJECT;
        if (this.next_scene == null) {
            arr = a.firstPageExplain();
            if (a instanceof SpellCard && a.isStaticCheked()) {
                int y_diff = 0;
                int i = 0;
                while (i < 4 && i < arr.length) {
                    if (i == 2) {
                        this.drawLine(g, 1, false);
                        y_diff += 5;
                    }
                    this.drawString(g, arr[i], i + 1, y_diff);
                    ++i;
                }
                return;
            }
        } else {
            arr = this.next_scene.getSelectedContent().EXPLAIN;
        }
        int i = 0;
        while (i < 4 && i < arr.length) {
            this.drawString(g, arr[i], i + 1, 0, 3);
            ++i;
        }
    }

    @Override
    public void drawWindow(Graphics2D g) {
        super.drawWindow(g);
        this.drawString(g, this.getViewX(), this.getViewY());
    }

    @Override
    protected int getBG() {
        return this.getBG(this.next_scene != null);
    }

    @Override
    public int getContentHeight() {
        return super.getContentHeight() - 3;
    }

    public void setNextScene(Base_Scene_Menu base_scene_maenu) {
        this.next_scene = base_scene_maenu;
    }
}

