/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.system;

import dangeon.controller.DangeonScene;
import dangeon.controller.TaskOnMapObject;
import dangeon.controller.TurnSystemController;
import dangeon.controller.listener.KeyAccepter;
import dangeon.latest.scene.Base_Scene;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.system.KeyHolder;
import dangeon.model.map.MapList;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import main.Base_KeyAccepter;
import main.Listener;
import main.util.BlackOut;
import main.util.DIRECTION;
import title.Title;

public class SceneHolder_KeyAccepter
extends Base_KeyAccepter {
    public final Scene_Action SCENE_ACTION;
    private Base_Scene base_scene;
    public final KeyHolder kh = new KeyHolder(this);

    public SceneHolder_KeyAccepter() {
        this.SCENE_ACTION = new Scene_Action(this.kh);
        this.base_scene = new Title(this.kh);
    }

    boolean action(Listener.ACTION a) {
        return this.base_scene.action_pre(a);
    }

    boolean arrow(DIRECTION direction) {
        return this.base_scene.arrow(direction);
    }

    public void clearTaskKeyActions() {
        this.kh.clearTaskKeyActions();
    }

    @Override
    public void draw(Graphics2D g) {
        Base_Scene bs;
        do {
            bs = this.base_scene;
            bs.draw(g);
        } while (bs != this.base_scene);
    }

    public boolean isCurrentScene(Base_Scene base_scene2) {
        return this.base_scene.equals(base_scene2);
    }

    public boolean isScene(Class<? extends Base_Scene> clazz) {
        return this.base_scene.getClass() == clazz;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!BlackOut.isEmpty()) {
            return;
        }
        DIRECTION d = Listener.getAllow_map().get(e.getKeyCode());
        Listener.ACTION a = Listener.getKey().get(e.getKeyCode());
        if (d != null) {
            this.kh.setTaskKeyArrow(d);
        }
        if (a != null) {
            this.kh.setTaskKeyAction(a);
        }
        this.kh.set(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        DIRECTION d = Listener.getAllow_map().get(e.getKeyCode());
        Listener.ACTION a = Listener.getKey().get(e.getKeyCode());
        if (a != null || d != null) {
            this.base_scene.keyReleased(a, d);
        }
    }

    private void objectUpdate() {
        if (!(this.base_scene instanceof Scene_Action)) {
            return;
        }
        if (TaskOnMapObject.isThrowTaskEmpty()) {
            TaskOnMapObject.work();
            KeyAccepter.upDate();
            if (TaskOnMapObject.isThrowTaskEmpty()) {
                TurnSystemController.upDate();
            }
        } else {
            TaskOnMapObject.getThrow().upDate();
        }
        if (!DangeonScene.RESULT.isPresentScene()) {
            this.objectUpDate();
        }
    }

    private void objectUpDate() {
        int player = 1;
        List<Base_Enemy> enemies = MapList.getListEnemy();
        List<Base_Artifact> items = MapList.getListArtifact();
        ArrayList<Base_MapObject> list = new ArrayList<Base_MapObject>(player + enemies.size());
        list.add(Player.me);
        for (Base_Enemy enemy : enemies) {
            list.add(enemy);
        }
        for (Base_Artifact a : items) {
            list.add(a);
        }
        for (Base_MapObject creature : list) {
            creature.upDate();
        }
    }

    public void set(KeyEvent ev) {
        this.base_scene.upDate(ev);
    }

    void setKeyAccepter(Base_Scene base_scene) {
        this.base_scene = base_scene;
    }

    @Override
    public final void up_date() {
        this.kh.upDate();
        this.base_scene.upDate();
        this.objectUpdate();
    }
}

