/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.otog.value;

import dangeon.latest.scene.action.otog.value.HitChecker;
import dangeon.latest.scene.action.otog.value.ValueHolder;

public class Calculater {
    private void add(ValueHolder vh, HitChecker.TEXT tex) {
        vh.hash_save_tex_count.put(tex, vh.hash_save_tex_count.get((Object)tex) + 1);
    }

    public void calc(ValueHolder vh, HitChecker.TEXT tex) {
        if (tex != null) {
            this.add(vh, tex);
            long n = 1000000000999L / vh.node_sum;
            vh.score_milli += n * this.getScoreRate(tex) / 100L;
            if (vh.score_milli > 999999999999L) {
                vh.score_milli = 999999999999L;
            }
            vh.LIFE_100 += this.getHeal(vh, tex);
            if (vh.LIFE_100 < 0L) {
                vh.LIFE_100 = 0L;
                vh.MAIN_PANEL.PARENT.interrput();
                return;
            }
            if (vh.LIFE_100 > 10000L) {
                vh.LIFE_100 = 10000L;
            }
        }
    }

    private long getError(ValueHolder vh, HitChecker.TEXT tex) {
        switch (vh.difficulty) {
            case 2: {
                return 160L;
            }
            case 3: {
                return 300L;
            }
            case 4: {
                return 500L;
            }
            case 5: {
                return 1000L;
            }
            case 6: {
                if (tex == HitChecker.TEXT.NOODLE) {
                    return 1000L;
                }
                return 10000L;
            }
        }
        return 0L;
    }

    private long getHeal(ValueHolder vh, HitChecker.TEXT tex) {
        switch (tex) {
            case PERFECT: 
            case COLD: {
                return 100L * vh.HEAL_MILLI_RATE / 1000L;
            }
            case COOL: {
                return 20L * vh.HEAL_MILLI_RATE / 1000L;
            }
            case CHILLY: 
            case NOODLE: {
                return -this.getError(vh, tex) / 2L;
            }
            case MISS: 
            case ERROR: {
                return -this.getMiss(vh) / 2;
            }
        }
        return 0L;
    }

    private int getMiss(ValueHolder vh) {
        switch (vh.difficulty) {
            case 2: {
                return 250;
            }
            case 3: {
                return 750;
            }
            case 4: {
                return 900;
            }
            case 5: {
                return 1800;
            }
            case 6: {
                return 10000;
            }
        }
        return 0;
    }

    private long getScoreRate(HitChecker.TEXT tex) {
        switch (tex) {
            case PERFECT: {
                return 100L;
            }
            case COLD: {
                return 50L;
            }
            case COOL: {
                return 10L;
            }
        }
        return 0L;
    }
}

