/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.otog.ready.select.select;

import dangeon.latest.scene.action.message.Message;
import dangeon.latest.scene.action.otog.ready.select.select.Otog_Select_Content_Left;
import dangeon.latest.scene.action.otog.value.HitChecker;
import dangeon.latest.scene.action.otog.value.ValueHolder;
import dangeon.model.config.Config;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import main.constant.PropertySupporter;
import main.res.BGM;
import main.res.Image_LargeCharacter;
import main.thread.MainThread;
import main.util.Show;

public class Otog_Select_Content_Selection
extends Otog_Select_Content_Left
implements Comparable<Otog_Select_Content_Selection> {
    public final File FILE;
    public final String AUTHOR;
    public final long OFFSET;
    public final BGM BGM;
    public final ValueHolder VH;
    private Image_LargeCharacter IMLC;
    public long SCORE;
    public int COMBO;
    public int RANK;
    public String MISS;
    public int PLAY_COUNT;
    public int FLAG_CLEARED;
    public final PropertySupporter PROP;
    public boolean flag;

    protected Otog_Select_Content_Selection() {
        super(1, 1);
        this.AUTHOR = null;
        this.OFFSET = 0L;
        this.BGM = null;
        this.VH = null;
        this.SCORE = 0L;
        this.COMBO = 0;
        this.RANK = 0;
        this.MISS = null;
        this.PROP = null;
        this.PLAY_COUNT = 0;
        this.FILE = null;
    }

    public Otog_Select_Content_Selection(String author, int level, int version, long offset, String bgm, File file, String prop_pass, ValueHolder vh) {
        super(version, level);
        this.AUTHOR = author;
        this.OFFSET = offset;
        this.BGM = main.res.BGM.get(bgm);
        this.FILE = file;
        this.VH = vh;
        PropertySupporter p = null;
        try {
            p = new PropertySupporter(prop_pass, true);
        }
        catch (IOException e) {
            try {
                if (!new File(prop_pass).createNewFile()) {
                    Show.showErrorMessageDialog("\u65b0\u8b5c\u9762\u30d5\u30a1\u30a4\u30eb\u306e\u521d\u671f\u60c5\u5831\u306e\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                }
                p = new PropertySupporter(prop_pass, true);
                p.saveProperty("SCORE", 0);
                p.saveProperty("COMBO", 0);
                p.saveProperty("RANK", 0);
                p.saveProperty("MISS", "-");
                p.saveProperty("PLAY_COUNT", 0);
                boolean flag_demand_to_gacha = true;
                if (this.LEVEL <= 2) {
                    flag_demand_to_gacha = false;
                } else {
                    File f = new File("./otog/editor");
                    if (f.exists() && this.AUTHOR.equals(new PropertySupporter(f).getProperty("author"))) {
                        flag_demand_to_gacha = false;
                    }
                }
                p.saveProperty("FLAG_CLEARED", flag_demand_to_gacha ? -1 : 0);
            }
            catch (IOException e1) {
                Show.showErrorMessageDialog("\u65b0\u8b5c\u9762\u30d5\u30a1\u30a4\u30eb\u306e\u521d\u671f\u60c5\u5831\u306e\u66f8\u304d\u51fa\u3057\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                Show.showErrorMessageDialog(e1);
            }
        }
        this.PROP = p;
        this.SCORE = Long.valueOf(p.getProperty_Nature("SCORE").toString());
        this.COMBO = p.getProperty("COMBO");
        this.RANK = p.getProperty("RANK");
        this.MISS = p.getProperty_Nature("MISS").toString();
        this.PLAY_COUNT = p.getProperty("PLAY_COUNT");
        this.FLAG_CLEARED = p.getProperty("FLAG_CLEARED");
    }

    @Override
    public int compareTo(Otog_Select_Content_Selection o) {
        if (this.VH.select_sort == 0) {
            return this.LEVEL - o.LEVEL;
        }
        if (this.VH.select_sort == 1) {
            return this.BGM.TITLE.compareTo(o.BGM.TITLE);
        }
        if (this.VH.select_sort == 2) {
            return this.AUTHOR.compareTo(o.AUTHOR);
        }
        return 0;
    }

    protected boolean drawLevel(Graphics2D g, int x, int y, int w, int h) {
        StringBuilder sb = new StringBuilder();
        if (this.LEVEL < 10) {
            sb.append(" ");
        }
        sb.append(this.LEVEL);
        StringFilter.drawString(g, sb.toString(), x + 2, y + g.getFontMetrics().getHeight() / 2 - 1);
        return true;
    }

    public void drawMe(Graphics2D g, int x, int cols) {
        int title_head;
        x += this.dx;
        if (cols == 0) {
            this.drawStatus(g);
        } else {
            this.IMLC = null;
        }
        this.flag = cols == 0;
        int x1 = x;
        int x2 = x + 12;
        int x3 = x + this.getW() - 12;
        int x4 = x + this.getW();
        int y = (cols + 3) * 26 + this.dy;
        int y_m = y - 12;
        int y_p = y + 12;
        int[] xs = new int[]{x1, x2, x3, x4, x3, x2};
        int[] ys = new int[]{y, y_m, y_m, y, y_p, y_p};
        g.drawImage(this.FRAME, x1, y_m, this.FRAME.getWidth() / 2, this.FRAME.getHeight() / 2, null);
        int size = 12;
        int margine = 2;
        boolean b = this.drawMedal(g, x2, y, size);
        if (b) {
            size += margine * 2;
        }
        if (b = this.drawLevel(g, title_head = x2 + size, y, x3 - margine - title_head, 24 - margine * 2)) {
            title_head += 23;
        }
        this.drawTitle(g, title_head, y, x3 - margine - title_head, 24 - margine * 2);
    }

    protected boolean drawMedal(Graphics2D g, int x2, int y, int size) {
        if (this.FLAG_CLEARED != 0) {
            Color c = this.VH.getDifficultyColors(this.FLAG_CLEARED);
            if (MainThread.getFrame() / 2 % 2 == 0) {
                c = c.darker();
            }
            g.setPaint(new RadialGradientPaint(x2 + size / 2, (float)y, size / 2, new float[]{0.3f, 1.0f}, new Color[]{c, c.darker().darker()}, MultipleGradientPaint.CycleMethod.NO_CYCLE));
            g.fillRect(x2, y - size / 2, size, size);
            g.setPaint(null);
            g.setColor(Color.BLUE);
            g.drawRect(x2, y - size / 2, size, size);
        }
        return true;
    }

    protected void drawStatus(Graphics2D g) {
        int font_h = g.getFontMetrics().getHeight() + 1;
        int h = font_h * 5;
        int w = Message.W;
        int x = (400 - w) / 2;
        int y = 340 - h - x / 2;
        g.setColor(new Color(0, 0, 0, 200));
        g.fillRect(x, y, w, h);
        g.setColor(Color.BLUE);
        g.drawRect(x, y, w, h);
        g.setColor(Color.WHITE);
        g.setClip(x, y, w, h - 1);
        int x1 = x + 5;
        int x2 = x + w / 2 - 10;
        int x3 = x + w / 2;
        int x4 = x + w - 10;
        this.drawStatusL(g, Color.YELLOW, "SCORE", x1, y, font_h, 0);
        this.drawStatusL(g, Color.ORANGE, "COMBO", x1, y, font_h, 1);
        this.drawStatusL(g, Color.PINK, "RANK", x1, y, font_h, 2);
        this.drawStatusL(g, Color.CYAN, "BAD COUNT", x1, y, font_h, 3);
        this.drawStatusL(g, Color.MAGENTA, "PLAY COUNT", x1, y, font_h, 4);
        NumberFormat nf = NumberFormat.getNumberInstance();
        this.drawStatusR(g, StringFilter.NUMBERS, nf.format(this.SCORE), x2, y, font_h, 0);
        this.drawStatusR(g, StringFilter.NUMBERS, nf.format(this.COMBO), x2, y, font_h, 1);
        this.drawStatusR(g, null, this.VH.getRank(g, this.RANK), x2, y, font_h, 2);
        this.drawStatusR(g, StringFilter.NUMBERS, this.MISS, x2, y, font_h, 3);
        this.drawStatusR(g, StringFilter.NUMBERS, nf.format(this.PLAY_COUNT), x2, y, font_h, 4);
        this.drawStatusL(g, Color.WHITE, "ARRANGE by", x3, y, font_h, 3);
        this.drawStatusL(g, Color.LIGHT_GRAY, "OBJECT  by", x3, y, font_h, 4);
        this.drawStatusR(g, Color.WHITE, this.BGM.AUTHOR, x4, y, font_h, 3);
        this.drawStatusR(g, Color.LIGHT_GRAY, this.AUTHOR, x4, y, font_h, 4);
        if (this.IMLC == null && this.BGM.CLASS != null) {
            String card = this.BGM.CLASS.getSimpleName();
            card = card.substring(0, card.lastIndexOf("\u306e\u30ab\u30fc\u30c9"));
            this.IMLC = Image_LargeCharacter.get(card);
        }
        g.setClip(x3, y + 5, w / 2 - 10, font_h * 3 - 10);
        g.setColor(Color.WHITE);
        StringFilter.drawString(g, this.BGM.TITLE, x3, y + font_h * 2 - 1);
        if (this.IMLC != null) {
            this.IMLC.draw(g, x3 + 5, y + 5, w / 2 - 10, font_h * 3 - 10, true);
        }
        g.setClip(null);
    }

    protected void drawStatusL(Graphics2D g, Color c, String str, int x, int y, int font_h, int cols) {
        g.setColor(c);
        StringFilter.drawString_plain(g, str, x, y + font_h * ++cols - 2);
    }

    protected void drawStatusR(Graphics2D g, Color c, int i, int x, int y, int font_h, int cols) {
        this.drawStatusR(g, c, String.valueOf(i), x, y, font_h, cols);
    }

    protected void drawStatusR(Graphics2D g, Color c, String str, int x, int y, int font_h, int cols) {
        if (c != null) {
            g.setColor(c);
            StringFilter.drawString_plain(g, str, x - g.getFontMetrics().stringWidth(str), y + font_h * ++cols - 2);
        } else {
            StringFilter.drawString(g, str, x - g.getFontMetrics().stringWidth(str), y + font_h * ++cols - 2);
        }
    }

    @Override
    protected void drawTitle(Graphics2D g, int x, int y, int w, int h) {
        String str = this.VERSION.concat(" ").concat(Color.WHITE.toString()).concat(this.BGM.TITLE);
        String plan = StringFilter.getPlainString(str);
        if (this.flag && this.frame != -1) {
            double d = (double)MainThread.getFrame() / 16.0;
            g.setPaint(new GradientPaint((float)((double)w * Math.cos(d)) + (float)x + (float)(w / 2), (float)((double)(h * 2) * Math.sin(d)) + (float)y, Color.WHITE, x + w / 2, y, Color.ORANGE, true));
        } else {
            g.setColor(Color.BLUE);
        }
        g.drawRect(x, y - h / 2, w, h);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRect(x, y - h / 2, w, h);
        g.setClip(x + 1, y - h / 2, w - 1, h);
        g.setColor(Color.WHITE);
        if (this.flag && this.frame != -1) {
            int str_w = g.getFontMetrics().stringWidth(plan) + 10;
            ++this.frame;
            if (this.frame > (str_w += 10)) {
                this.frame -= str_w;
            }
            StringFilter.drawString(g, str, x + 2 - this.frame + str_w, y + g.getFontMetrics().getHeight() / 2 - 1);
            StringFilter.drawString(g, str, x + 2 - this.frame + str_w * 2, y + g.getFontMetrics().getHeight() / 2 - 1);
            StringFilter.drawString(g, str, x + 2 - this.frame, y + g.getFontMetrics().getHeight() / 2 - 1);
        } else {
            StringFilter.drawString(g, str, x + 3, y + g.getFontMetrics().getHeight() / 2 - 1);
        }
        g.setClip(null);
    }

    @Override
    public void init() {
        this.dx += 20;
    }

    public void saveProp() {
        if (this.VH.score_milli / 1000L > this.SCORE) {
            this.SCORE = this.VH.score_milli / 1000L;
            this.PROP.saveProperty("SCORE", this.VH.score_milli / 1000L);
            int sum = 0;
            for (HitChecker.TEXT t : this.VH.hash_save_tex_count.keySet()) {
                if (!t.isNoGood()) continue;
                sum += this.VH.hash_save_tex_count.get((Object)t).intValue();
            }
            String s = NumberFormat.getInstance().format(sum);
            this.PROP.saveProperty("MISS", s);
            this.MISS = s;
        }
        if (this.VH.MAX_COMBO > this.COMBO) {
            this.PROP.saveProperty("COMBO", this.VH.MAX_COMBO);
            this.COMBO = this.VH.MAX_COMBO;
        }
        if (this.VH.RANK > this.RANK) {
            this.PROP.saveProperty("RANK", this.VH.RANK);
            this.RANK = this.VH.RANK;
        }
        this.PROP.saveProperty("PLAY_COUNT", ++this.PLAY_COUNT);
        if (this.FLAG_CLEARED == 0) {
            this.FLAG_CLEARED = 1;
            this.PROP.saveProperty("FLAG_CLEARED", this.FLAG_CLEARED);
        }
        if (!this.VH.isFailed()) {
            boolean FULL_COMBO = true;
            for (HitChecker.TEXT text : this.VH.hash_save_tex_count.keySet()) {
                if (text.isCombo() || this.VH.hash_save_tex_count.get((Object)text) <= 0) continue;
                FULL_COMBO = false;
                break;
            }
            int flag = 0;
            if (FULL_COMBO) {
                flag = 6;
            } else if (this.VH.difficulty > this.FLAG_CLEARED) {
                flag = this.VH.difficulty;
            }
            if (this.FLAG_CLEARED < flag) {
                Config.changeGachaPoints((flag - this.FLAG_CLEARED) * 5);
                this.FLAG_CLEARED = flag;
                this.PROP.saveProperty("FLAG_CLEARED", flag);
            }
        }
    }

    public void saveProp(boolean flag_get) {
        this.FLAG_CLEARED = flag_get ? 0 : -1;
        this.PROP.saveProperty("FLAG_CLEARED", this.FLAG_CLEARED);
    }
}

