/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.message;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.MessageBox;
import dangeon.view.util.StringFilter;
import java.util.ArrayList;
import main.constant.FR;
import main.res.Image_LargeCharacter;

public class MsgBlock {
    public static final int BLOCK_DURATION = 500;
    public static final int LAST_MESSAGE_DURATION = 1000;
    public int last_message_time = 0;
    public static final int SPEED = 5;
    public static int BOX_LINE = 3;
    private final ArrayList<String> LINE_LIST = new ArrayList();
    private int diff = -NormalFont.HEIGHT * BOX_LINE;
    private String[] string_arr;
    private boolean first_space_exist = true;
    public final Image_LargeCharacter ILC;
    boolean isSlept = false;
    int sleep = 0;
    boolean wait_for_pushing_any_key;
    private int y = 0;
    private boolean flag_rapid = false;
    ArrayList<Task> TASK_LIST = new ArrayList();

    MsgBlock(Image_LargeCharacter ilc, ArrayList<String> arr) {
        this.ILC = ilc.equals((Object)Image_LargeCharacter.ANY) ? null : ilc;
        this.string_arr = arr.toArray(new String[0]);
        this.init();
    }

    public MsgBlock(Image_LargeCharacter ilc, ArrayList<String> arr, int sleep) {
        this(ilc, arr);
        this.wait_for_pushing_any_key = true;
        this.sleep = sleep;
        this.isSlept = true;
    }

    public void concat(String[] array) {
        String[] arr = new String[this.string_arr.length + 1 + array.length];
        int i = 0;
        while (i < this.string_arr.length) {
            arr[i] = this.string_arr[i];
            ++i;
        }
        arr[this.string_arr.length] = "$";
        i = 0;
        while (i < array.length) {
            arr[this.string_arr.length + 1 + i] = array[i];
            ++i;
        }
        this.string_arr = arr;
        this.init();
    }

    public int getDif() {
        return this.diff;
    }

    private int getLeftLinesNumbers() {
        return this.LINE_LIST.size() - (BOX_LINE + this.y + 4);
    }

    public String getLine(int i) {
        try {
            return this.LINE_LIST.get(i + this.y);
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    public ArrayList<String> getMsg() {
        return this.LINE_LIST;
    }

    private void init() {
        StringFilter.setList(this.LINE_LIST, MessageBox.W_VALID, this.string_arr);
        this.last_message_time = 0;
    }

    public boolean isLast() {
        return !this.first_space_exist && !this.isNextLineExist() && this.sleep == 0;
    }

    private boolean isNext3LinesExist() {
        return this.LINE_LIST.size() > BOX_LINE + this.y + 4;
    }

    private boolean isNextLineExist() {
        return this.LINE_LIST.size() > BOX_LINE + this.y;
    }

    public boolean isOverDuration() {
        int duration;
        if (this.wait_for_pushing_any_key) {
            return false;
        }
        if (this.flag_rapid) {
            return true;
        }
        int n = duration = Message.isNextTaskEmpty() ? 1000 : 500;
        return this.last_message_time >= duration;
    }

    public void remove1stLine() {
        ++this.y;
    }

    public void setFlagRapid(boolean b) {
        this.flag_rapid = b;
    }

    public void setTask(Task task) {
        this.TASK_LIST.add(task);
    }

    public void upDate() {
        if (this.first_space_exist) {
            this.diff += 5 * Math.max(2, this.getLeftLinesNumbers());
            if (this.diff >= 0) {
                this.diff = 0;
                this.first_space_exist = false;
            }
        } else if (this.isNextLineExist()) {
            this.diff = this.isNext3LinesExist() ? (this.diff += 5 * this.getLeftLinesNumbers()) : (this.diff += 5);
            if (this.diff >= NormalFont.HEIGHT) {
                this.diff = 0;
                this.remove1stLine();
            }
        } else {
            if (this.sleep > 0) {
                --this.sleep;
                if (this.sleep < 0) {
                    this.sleep = 0;
                }
                return;
            }
            if (!this.TASK_LIST.isEmpty()) {
                ArrayList<Task> _TASK_LIST = new ArrayList<Task>();
                for (Task task : this.TASK_LIST) {
                    _TASK_LIST.add(task);
                }
                for (Task task : _TASK_LIST) {
                    task.work();
                }
                this.TASK_LIST.clear();
            }
            if (!this.wait_for_pushing_any_key) {
                if (this.isOverDuration()) {
                    this.diff += 10;
                    int DIFF = NormalFont.HEIGHT;
                    DIFF *= this.LINE_LIST.size() - this.y + 1;
                } else {
                    this.last_message_time += FR.THREAD_SLEEP;
                }
            }
        }
    }
}

