/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.message;

import dangeon.latest.util.view_window.WindowFrame;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class CopyOfMessage {
    public static final Integer X = null;
    public static final Integer Y = 255;
    public static final Integer W = 370;
    public static final Integer COLS = 3;
    public static final CopyOfMessage ME = new CopyOfMessage();
    private static final int HOLDING_INTERVAL = 60;
    private final ArrayList<String> task = new ArrayList();
    private final WindowFrame WINDOW_FRAME = new WindowFrame(X, Y, W, COLS);
    private int holding_time;
    private int diff;

    public static void set(String ... strings) {
        ME.set_non_statiic(strings);
    }

    private CopyOfMessage() {
        this.reset();
    }

    public void draw(Graphics2D g) {
        if (!this.task.isEmpty()) {
            if (this.holding_time < 60) {
                this.WINDOW_FRAME.drawWindow(g);
                this.drawStringField(g);
            } else {
                this.reset();
            }
        }
    }

    private void draw4Strings(Graphics2D g, WindowFrame wf) {
        if (this.diff < wf.getContentHeight()) {
            int i = 0;
            while (i < COLS + 1) {
                wf.drawString(g, this.task.get(i), i + 1, -this.diff);
                ++i;
            }
            this.diff += this.speed();
        } else {
            this.task.remove(0);
            this.diff -= wf.getContentHeight();
            this.drawString(g, wf);
        }
    }

    private void drawbelow4Strings(Graphics2D g, WindowFrame wf) {
        int i = 0;
        while (i < this.task.size()) {
            wf.drawString(g, this.task.get(i), i + 1, 0);
            ++i;
        }
    }

    private void drawString(Graphics2D g, WindowFrame wf) {
        if (this.task.size() <= COLS) {
            this.drawbelow4Strings(g, wf);
            ++this.holding_time;
        } else {
            this.draw4Strings(g, wf);
        }
    }

    private void drawStringField(Graphics2D g) {
        WindowFrame wf = this.WINDOW_FRAME.createDoubleSizeClearCopy();
        this.drawString(wf.initGraphics2Scaled(), wf);
        wf.drawWindow(g);
    }

    private void reset() {
        this.task.clear();
        this.holding_time = 0;
        this.diff = 0;
    }

    private void set_non_statiic(String[] strings) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s);
            ++n2;
        }
        this.task.add(sb.toString());
        this.holding_time = 0;
    }

    private int speed() {
        double device;
        switch (this.task.size() - COLS) {
            case 1: 
            case 2: {
                device = 5.0;
                break;
            }
            case 3: 
            case 4: {
                device = 4.0;
                break;
            }
            case 5: 
            case 6: {
                device = 3.0;
                break;
            }
            case 7: 
            case 8: {
                device = 2.0;
                break;
            }
            default: {
                device = 1.5;
            }
        }
        return (int)((double)this.WINDOW_FRAME.getContentHeight() / device);
    }
}

