/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.menu.first.adventure.wiki;

import dangeon.latest.scene.Base_Scene;
import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.menu.first.adventure.wiki.Wiki_Enemy_View;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.system.KeyHolder;
import dangeon.latest.util.view_window.StringOnlyWindow;
import dangeon.model.config.Config;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.util.STAGE;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import main.Listener;
import main.res.SE;
import main.util.CSVLoadSupporter;
import main.util.DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class Wiki_Enemy
extends Base_Scene {
    private final Base_Scene PREV;
    public final StringOnlyWindow WINDOW;
    public final Base_Enemy ENEMY;
    public int frame;
    private final boolean flag_detail;

    public Wiki_Enemy(KeyHolder kh, Base_View bv, Base_Enemy e, int index, int max, String title, int lv) {
        super(kh, new Wiki_Enemy_View());
        this.flag_detail = Config.isAccessableToDetail(e, lv);
        this.PREV = bv.PARENT_SCENE;
        this.ENEMY = e;
        while (this.ENEMY.isAnimating()) {
            this.ENEMY.upDate();
        }
        this.ENEMY.setDamaging(false);
        this.ENEMY.setDirection(DIRECTION.DOWN);
        ArrayList<String> list = new ArrayList<String>();
        if (index < 0 || max <= 0) {
            this.add(list, title);
        } else {
            String zero = index < 10 ? "0" : "";
            String zero_ = max < 10 ? "0" : "";
            StringBuilder sb = new StringBuilder("&t");
            for (STAGE stage : this.ENEMY.getCategory()) {
                sb.append(stage.ONE_NAME);
                sb.append("\uff06");
            }
            if (!this.ENEMY.getCategory().isEmpty()) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append(" ");
            this.add(list, title, "(", zero, index, "/", zero_, max, ")", sb.toString());
        }
        this.add(list, "");
        this.add(list, "");
        this.add(list, e.getColoredName(), "&t", \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(Config.getKONumber(e, lv)), "\u5012\u3057\u305f ");
        this.add(list, "&--");
        this.add(list, "\uff28\uff30\uff1a", this.getStars(this.ENEMY.getMAX_HP()), "\u3000\u653b\uff1a", this.getStars(this.ENEMY.getMAX_STR()), "\u3000\u9632\uff1a", this.getStars(this.ENEMY.getMAX_DEF()));
        this.add(list, "\u7279\u6280\u4f7f\u7528\u7387\uff1a", this.getSkillParcent(), "\u3000\u3000\u9053\u5177\u6240\u6301\u7387\uff1a", this.getItemDrop(), "\u3000\u7d4c\u9a13\u5024\uff1a", this.ENEMY.getENEMY_EXP());
        this.add(list, "&--");
        this.loadCsv(lv, list);
        this.WINDOW = new StringOnlyWindow((Integer)16, (Integer)5, (Integer)7, Message.W, NormalFont.NORMALFONT.deriveFont(14.0f), list.toArray(new String[0]));
    }

    @Override
    public boolean action(Listener.ACTION a) {
        switch (a) {
            case ENTER: {
                if (!this.ENEMY.isAnimating()) {
                    this.frame = 0;
                    this.ENEMY.setDamaging(false);
                    this.ENEMY.startAttack(null);
                }
                return true;
            }
            case CANCEL: 
            case MENU: {
                SE.SYSTEM_ENTER.play();
                this.setNextScene(this.getPreviousScene());
                return true;
            }
        }
        SE.SYSTEM_DAMEGED_ANIME.play();
        this.frame = 24;
        this.ENEMY.setDamaging(true);
        return true;
    }

    private void add(ArrayList<String> list, Object ... text) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            sb.append(object);
            ++n2;
        }
        list.add(sb.toString());
    }

    @Override
    public boolean arrow(DIRECTION d) {
        this.ENEMY.setDamaging(false);
        this.frame = -48;
        DIRECTION converted = DIRECTION.getSum(this.KH.getDirections());
        if (converted != null) {
            this.ENEMY.setDirection(converted);
        } else {
            this.ENEMY.setDirection(d);
        }
        return true;
    }

    private String getItemDrop() {
        int i = this.ENEMY.getItemDropParcent();
        int normal = 250;
        if (i == 0) {
            return Color.GRAY + "\u7121" + Color.WHITE;
        }
        if (i < normal) {
            return Color.CYAN + "\u4f4e" + Color.WHITE;
        }
        if (i == normal) {
            return StringFilter.NUMBERS + "\u4e26" + Color.WHITE;
        }
        if (i < 10000) {
            return Color.ORANGE + "\u9ad8" + Color.WHITE;
        }
        return Color.RED + "\u5fc5" + Color.WHITE;
    }

    @Override
    public Base_Scene getPreviousScene() {
        return this.PREV;
    }

    private String getSkillParcent() {
        int i = this.ENEMY.getSpecialParcent();
        if (i <= 0) {
            return Color.GRAY + "\u7121" + Color.WHITE;
        }
        if (i < 20) {
            return Color.LIGHT_GRAY + "\u7a00" + Color.WHITE;
        }
        if (i < 30) {
            return Color.CYAN + "\u4f4e" + Color.WHITE;
        }
        if (i < 50) {
            return StringFilter.NUMBERS + "\u4e26" + Color.WHITE;
        }
        if (i < 100) {
            return Color.ORANGE + "\u9ad8" + Color.WHITE;
        }
        return Color.RED + "\u5fc5" + Color.WHITE;
    }

    private String getStar(int i) {
        StringBuilder sb = new StringBuilder();
        Color[] cs = new Color[]{Color.MAGENTA, Color.CYAN, Color.GREEN, Color.ORANGE, Color.RED};
        if (i != 0) {
            sb.append(cs[i - 1]);
        }
        int j = 0;
        while (j < 5) {
            if (j < i) {
                sb.append("\u2605");
            } else {
                sb.append(Color.GRAY);
                sb.append("\u2606");
            }
            ++j;
        }
        sb.append(Color.WHITE);
        return sb.toString();
    }

    private String getStars(int max) {
        int i = max < 6 ? 0 : (max < 30 ? 1 : (max < 70 ? 2 : (max < 130 ? 3 : (max < 200 ? 4 : 5))));
        return this.getStar(i);
    }

    private void loadCsv(int lv, ArrayList<String> list) {
        HashMap<String, Object> map = CSVLoadSupporter.getWiki(this.ENEMY.getOriginalName());
        if (!this.flag_detail) {
            this.add(list, Color.gray, "\u30fb\uff1f\uff1f\uff1f\uff1f");
            this.add(list, "");
            this.add(list, "");
            this.add(list, "");
            this.add(list, "");
            this.add(list, "");
            this.add(list, "");
            this.add(list, "&t", "Dotted By ".concat((String)map.get("dot")));
        } else if (map == null) {
            this.add(list, "<NO_DATA>");
        } else {
            String[] s;
            String[] stringArray = s = (String[])map.get("LV" + lv);
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string != null && !string.isEmpty()) {
                    String c = Color.PINK.toString();
                    if (string.startsWith("\u300e")) {
                        this.add(list, "\u3000", c, string);
                    } else if (string.endsWith("\u300f") || string.startsWith("\uff0b")) {
                        if (string.startsWith("\u30fb") || string.startsWith("\uff0b")) {
                            this.add(list, "\u3000\u3000", c, string.substring(1));
                        } else {
                            this.add(list, "\u3000", c, string);
                        }
                    } else if (string.startsWith("\u30fb")) {
                        this.add(list, "\u3000".concat(string.substring(1)));
                    } else {
                        this.add(list, "\u30fb".concat(string));
                    }
                } else {
                    this.add(list, "");
                }
                ++n2;
            }
            this.add(list, "&t", "Dotted By ".concat((String)map.get("dot")));
        }
    }

    @Override
    public void upDate() {
        if (this.ENEMY.isAnimating()) {
            this.ENEMY.upDate();
        } else {
            ++this.frame;
            if (this.frame > 48) {
                this.ENEMY.setDamaging(false);
                this.frame = 0;
                this.ENEMY.setDirection(this.ENEMY.getDirection().getNeiboringDirection());
            }
        }
        super.upDate();
    }
}

