/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.menu;

import dangeon.latest.scene.Base_Scene;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.menu.Base_Scene_Menu_View;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.menu.first.Scene_Menu_First;
import dangeon.latest.system.KeyHolder;
import dangeon.latest.util.view_window.UnderMenuWindow;
import java.util.ArrayList;
import main.Listener;
import main.res.SE;
import main.util.DIRECTION;

public abstract class Base_Scene_Menu
extends Base_Scene {
    protected final ArrayList<MenuContent> CONTENTS = new ArrayList();
    public Integer ROW;
    public Integer COL;
    public final UnderMenuWindow SUB_WINDOW = this.initializeSubWindow();
    protected int x;
    protected int y;

    public Base_Scene_Menu(Integer cols, Integer row, KeyHolder kh, Base_Scene_Menu_View smv) {
        super(kh, smv);
        this.COL = cols;
        this.ROW = row;
    }

    public Base_Scene_Menu(Integer cols, KeyHolder kh, Base_Scene_Menu_View smv) {
        this(cols, null, kh, smv);
    }

    public Base_Scene_Menu(KeyHolder kh, Base_Scene_Menu_View smv) {
        this(null, kh, smv);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean action(Listener.ACTION a) {
        try {
            switch (a) {
                case ENTER: {
                    SE.SYSTEM_ENTER.play();
                    this.action_enter();
                    return true;
                }
                case CANCEL: 
                case MENU: {
                    this.action_cancel();
                    return true;
                }
            }
            this.action_else(a);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    protected void action_cancel() {
        SE.SYSTEM_CANCEL.play();
        if (this.getPreviousScene() instanceof Scene_Menu_First) {
            this.setNextScene(Scene_Action.getMe());
        } else {
            Base_Scene scene = this.getPreviousScene();
            this.setNextScene(scene);
            if (scene instanceof Base_Scene_Menu) {
                ((Base_Scene_Menu)scene).setExplain();
            }
        }
    }

    protected abstract void action_else();

    protected void action_else(Listener.ACTION a) {
        this.action_else();
    }

    protected void action_enter() {
        if (!this.CONTENTS.isEmpty()) {
            this.action_enter(this.getIndex());
        } else {
            this.setNextScene(this.getPreviousScene());
        }
    }

    protected void action_enter(int index) {
        if (this.isContentDeprecated(index)) {
            ((Book)this.CONTENTS.get((int)index).OBJECT).work();
        } else {
            this.CONTENTS.get((int)index).BOOK.work();
        }
    }

    @Override
    public boolean arrow(DIRECTION d) {
        SE.SYSTEM_CURSOR.play();
        if (this.CONTENTS.isEmpty()) {
            return true;
        }
        this.x += d.X;
        this.y += d.Y;
        if (this.x < 0) {
            this.x += this.getNumberOfRows();
            this.arrow_x_less_than_zero();
        } else if (this.x >= this.getNumberOfRows()) {
            this.x -= this.getNumberOfRows();
            this.arrow_x_more_than_max();
        }
        if (this.y < 0) {
            this.y += this.getNumberOfCols();
            this.arrow_y_less_than_zero();
        } else if (this.y >= this.getNumberOfCols()) {
            this.y -= this.getNumberOfCols();
            this.arrow_y_more_than_max();
        }
        int i = this.getIndex();
        if (this.isContentDeprecated_Perfectedly(i) || this.getContentName(i).isEmpty()) {
            if (this.isThisCurrentScene()) {
                this.arrow(d);
            }
        } else {
            this.setExplain();
        }
        return true;
    }

    protected void arrow_function_min_max() {
    }

    protected void arrow_x_less_than_zero() {
    }

    protected void arrow_x_more_than_max() {
    }

    protected void arrow_y_less_than_zero() {
    }

    protected void arrow_y_more_than_max() {
    }

    public void ascX() {
        ++this.x;
        if (this.x >= this.getNumberOfRows()) {
            this.x -= this.getNumberOfRows();
            this.arrow_x_more_than_max();
        }
    }

    public void decX() {
        --this.x;
        if (this.x < 0) {
            this.x += this.getNumberOfRows();
            this.arrow_x_less_than_zero();
        }
    }

    public MenuContent getContent(int index) {
        return this.CONTENTS.get(index);
    }

    public String getContentName(int index) {
        return this.CONTENTS.get((int)index).NAME;
    }

    public int getContentSize() {
        return this.CONTENTS.size();
    }

    public MenuContent getContentSize(int index) {
        return this.CONTENTS.get(index);
    }

    public int getIndex() {
        return this.y * this.ROW + this.x;
    }

    protected int getNumberOfCols() {
        return this.COL;
    }

    protected int getNumberOfRows() {
        return this.ROW;
    }

    public MenuContent getSelectedContent() {
        if (this.CONTENTS.isEmpty()) {
            return null;
        }
        if (this.getIndex() < 0) {
            return null;
        }
        return this.CONTENTS.get(this.getIndex());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected final void initializeContents() {
        this.initializeContents(this.CONTENTS);
        if (this.COL == null) {
            this.COL = this.CONTENTS.size();
        }
        if (this.ROW == null) {
            int row = (int)Math.ceil((double)this.CONTENTS.size() / (double)this.COL.intValue());
            this.ROW = row < 1 ? 1 : row;
        }
        this.y = 0;
        this.x = 0;
        this.sort();
        this.initialX_Y();
        this.setExplain();
    }

    protected abstract void initializeContents(ArrayList<MenuContent> var1);

    protected UnderMenuWindow initializeSubWindow() {
        Base_Scene parent_scene = this.CURRENT_VIEW.PREVIOUSE_VIEW.PARENT_SCENE;
        if (parent_scene == null) {
            return null;
        }
        if (parent_scene instanceof Base_Scene_Menu) {
            if (((Base_Scene_Menu)parent_scene).SUB_WINDOW == null) {
                return null;
            }
            return ((Base_Scene_Menu)parent_scene).SUB_WINDOW;
        }
        return null;
    }

    protected void initialX_Y() {
        int i = 0;
        while (i < this.CONTENTS.size()) {
            if (!this.isContentDeprecated_Perfectedly(i) && !this.getContentName(i).isEmpty()) {
                this.x = i % this.ROW;
                this.y = i / this.ROW;
                break;
            }
            ++i;
        }
    }

    public boolean isContentDeprecated(int index) {
        return this.CONTENTS.size() <= index || this.CONTENTS.get((int)index).BOOK == null;
    }

    public boolean isContentDeprecated_Perfectedly(int index) {
        if (index >= this.CONTENTS.size()) {
            return true;
        }
        return this.CONTENTS.get((int)index).BOOK == null && this.CONTENTS.get((int)index).OBJECT == null;
    }

    protected void setContents(Book book) {
        this.setContents(book.TITLE, "", book);
    }

    protected void setContents(String name) {
        this.CONTENTS.add(new MenuContent(name, new Book(){

            @Override
            protected void work() {
            }
        }));
    }

    protected void setContents(String name, Book book) {
        this.setContents(name, "", book);
    }

    protected void setContents(String name, String explain, Book book) {
        this.CONTENTS.add(new MenuContent(name, new String[]{explain}, book));
    }

    protected void setContents(String name, String[] explain, Book book) {
        this.CONTENTS.add(new MenuContent(name, explain, book));
    }

    protected void setContents(String name, String[] explain, Book book, Object obj) {
        this.CONTENTS.add(new MenuContent(name, explain, book, obj));
    }

    protected void setDeprecatedContents(String name, Book book) {
        this.CONTENTS.add(new MenuContent(name, null, null, book));
    }

    protected void setDeprecatedContents(String name, String explain) {
        this.CONTENTS.add(new MenuContent(name, new String[]{explain}, null));
    }

    protected void setDeprecatedContents(String name, String explain, Book book) {
        this.CONTENTS.add(new MenuContent(name, new String[]{explain}, null, book));
    }

    protected void setDeprecatedContents(String name, String[] explain, Book book) {
        this.CONTENTS.add(new MenuContent(name, explain, null, book));
    }

    protected void setDeprecatedContentsHorizon() {
        this.CONTENTS.add(new MenuContent("&-", null, null, null));
    }

    protected void setDeprecatedPerfetedlyContents() {
        this.CONTENTS.add(new MenuContent("", null, null, null));
    }

    protected void setDeprecatedPerfetedlyContents(int size) {
        int j = 0;
        while (j < size) {
            this.setDeprecatedPerfetedlyContents();
            ++j;
        }
    }

    protected void setDeprecatedPerfetedlyContents(String name) {
        this.CONTENTS.add(new MenuContent(name, null, null, null));
    }

    protected void setExplain() {
        if (this.SUB_WINDOW != null && this.getSelectedContent() != null) {
            this.SUB_WINDOW.setExplain(this.getSelectedContent().EXPLAIN);
        }
    }

    @Override
    protected void setNextScene(Base_Scene base_scene) {
        super.setNextScene(base_scene);
        if (base_scene instanceof Base_Scene_Menu) {
            ((Base_Scene_Menu)base_scene).triger();
        }
    }

    private void sort() {
        if (!this.vertical_sort()) {
            return;
        }
        int SIZE = this.CONTENTS.size();
        int remainder = SIZE % this.ROW;
        if (remainder == 0) {
            remainder = this.ROW;
        }
        int COL = (SIZE + this.ROW - 1) / this.ROW;
        int[] heads = new int[this.ROW.intValue()];
        int i = 0;
        while (i < heads.length) {
            if (i == 0) {
                heads[i] = 0;
            } else {
                heads[i] = heads[i - 1] + COL;
                if (--remainder < 0) {
                    int n = i;
                    heads[n] = heads[n] - 1;
                }
            }
            ++i;
        }
        ArrayList<MenuContent> list = new ArrayList<MenuContent>(SIZE);
        int i2 = 0;
        block1: while (i2 < COL) {
            int j = 0;
            while (j < this.ROW) {
                int index = heads[j] + i2;
                if (index >= this.CONTENTS.size()) break block1;
                list.add(this.CONTENTS.get(index));
                if (list.size() == SIZE) break block1;
                ++j;
            }
            ++i2;
        }
        this.CONTENTS.clear();
        for (MenuContent menuContent : list) {
            this.CONTENTS.add(menuContent);
        }
    }

    protected void triger() {
    }

    protected boolean vertical_sort() {
        return false;
    }

    public void work(Book book) {
        book.work();
    }

    public class MenuContent {
        public final Book BOOK;
        public final String[] EXPLAIN;
        public final String NAME;
        public final Object OBJECT;

        private MenuContent(String name, Book book) {
            this(name, null, book, (Object)null);
        }

        public MenuContent(String name, String explain, Book book) {
            this(name, new String[]{explain}, book, (Object)null);
        }

        private MenuContent(String name, String[] explain, Book book) {
            this(name, explain, book, (Object)null);
        }

        private MenuContent(String name, String[] explain, Book book, Object object) {
            String[] stringArray;
            String string = this.NAME = name == null ? "" : name;
            if (explain == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "NULL(\u672a\u5b9f\u88c5)";
            } else {
                stringArray = explain;
            }
            this.EXPLAIN = stringArray;
            this.BOOK = book;
            this.OBJECT = object;
        }
    }
}

