/*
 * Decompiled with CFR 0.152.
 */
package dangeon.latest.scene.action.ksg1.main.panel;

import dangeon.latest.scene.action.otog.main.panel.Base_Panel;
import dangeon.latest.system.KeyHolder;
import dangeon.util.R;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import main.Listener;
import main.res.BGM;
import main.res.CHARA_IMAGE;
import main.res.Image_Artifact;
import main.res.Image_Player;
import main.res.SE;
import main.util.DIRECTION;

public class Ksg_Panel_Main
extends Base_Panel {
    public final int NORMAL = 5;
    public final int LEFT = 4;
    public final int RIGHT = 6;
    public final int UP_DOWN = 8;
    public final int DEATH = -1;
    public int cirno_state = 5;
    public final ArrayList<Accepter> list_a = new ArrayList();
    public final ArrayList<Target> list_hit = new ArrayList();
    public final Target[] targets_left = new Target[3];
    public final Target[] targets_right = new Target[3];
    public KeyHolder KH;
    public int frame;
    public int limit;
    public final int LIMIT = 100;
    private boolean flag_missed;
    public long count;

    public Ksg_Panel_Main(int x, int w, int margine, KeyHolder kh) {
        super(x, margine, w, 340 - margine * 2, null);
        int i = 0;
        while (i < 3) {
            this.list_a.add(new Accepter(true, i));
            this.list_a.add(new Accepter(false, i));
            ++i;
        }
        this.init();
        this.KH = kh;
    }

    public boolean action(Listener.ACTION a) {
        this.frame = 5;
        boolean success = false;
        boolean b1 = this.targets_left[0].FOOD && !this.targets_left[0].ice;
        boolean b2 = this.targets_right[0].FOOD && !this.targets_right[0].ice;
        this.cirno_state = 8;
        boolean bl = success = !b1 && !b2;
        if (success) {
            this.success(SE.SYSTEM_ARRANGEMENT);
            return true;
        }
        this.death();
        return false;
    }

    public synchronized boolean arrow(DIRECTION d) {
        this.frame = 5;
        boolean success = false;
        SE se = SE.YOUMU_SP2;
        boolean b1 = this.targets_left[0].FOOD && !this.targets_left[0].ice;
        boolean b2 = this.targets_right[0].FOOD && !this.targets_right[0].ice;
        switch (d) {
            case LEFT: {
                this.cirno_state = 4;
                success = b1;
                this.list_hit.add(this.targets_left[0]);
                if (!b2) break;
                this.list_hit.add(this.targets_right[0]);
                break;
            }
            case RIGHT: {
                this.cirno_state = 6;
                success = b2;
                this.list_hit.add(this.targets_right[0]);
                if (!b1) break;
                this.list_hit.add(this.targets_left[0]);
                break;
            }
            case UP: 
            case DOWN: {
                this.cirno_state = 8;
                success = !b1 && !b2;
                se = SE.SYSTEM_ARRANGEMENT;
            }
        }
        if (success) {
            this.success(se);
            return true;
        }
        this.death();
        return false;
    }

    public void death() {
        SE.SYSTEM_CURSE.play();
        this.flag_missed = true;
        BGM.stop();
    }

    private int decLimit() {
        if (this.count > 1040L) {
            return 10;
        }
        if (this.count > 840L) {
            return 9;
        }
        if (this.count > 660L) {
            return 8;
        }
        if (this.count > 500L) {
            return 7;
        }
        if (this.count > 360L) {
            return 6;
        }
        if (this.count > 240L) {
            return 5;
        }
        if (this.count > 140L) {
            return 4;
        }
        if (this.count > 60L) {
            return 3;
        }
        if (this.count > 20L) {
            return 2;
        }
        return 1;
    }

    @Override
    public synchronized void drawME(Graphics2D g) {
        Image im = null;
        CHARA_IMAGE c = CHARA_IMAGE.\u30c1\u30eb\u30ce;
        switch (this.cirno_state) {
            case 5: {
                im = c.getWalkImage(0, DIRECTION.DOWN, 0.0f);
                break;
            }
            case 4: {
                im = c.getATKImage(0, DIRECTION.LEFT, 2);
                break;
            }
            case 6: {
                im = c.getATKImage(0, DIRECTION.RIGHT, 2);
                break;
            }
            case 8: {
                im = Image_Player.disc3.IM;
            }
        }
        g.drawImage(im, this.W / 2 - 25, this.H - 75, null);
        int s = this.getSize();
        int x = this.W / 2 - s / 2;
        int y = this.H - s;
        int angle = (int)(360.0 * (double)this.limit / 100.0);
        StringBuilder sb = new StringBuilder();
        sb.append("x");
        int dec = this.decLimit();
        if (dec == 10) {
            sb.append("9.9");
        } else {
            sb.append(this.decLimit());
            sb.append(".0");
        }
        int i = 0;
        while (i < 2) {
            this.getLimitColor(g);
            g.fillArc(x, y -= s * 2, s, s, 90, angle);
            g.setColor(Color.BLUE);
            g.drawOval(x, y, s, s);
            g.setColor(Color.LIGHT_GRAY);
            StringFilter.drawString(g, sb.toString(), x + s / 2 - 10, y + s / 2 + 4);
            ++i;
        }
        for (Accepter a : this.list_a) {
            a.draw(g);
        }
        Target[] targetArray = this.targets_left;
        int n = this.targets_left.length;
        int n2 = 0;
        while (n2 < n) {
            Target t = targetArray[n2];
            t.draw(g);
            ++n2;
        }
        targetArray = this.targets_right;
        n = this.targets_right.length;
        n2 = 0;
        while (n2 < n) {
            Target t = targetArray[n2];
            t.draw(g);
            ++n2;
        }
        for (Target t : this.list_hit) {
            t.draw(g);
        }
    }

    private void getLimitColor(Graphics2D g) {
        if (this.limit * 4 < 100) {
            g.setColor(Color.RED);
        } else if (this.limit * 2 < 100) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(Color.GREEN);
        }
    }

    private int getSize() {
        return 50;
    }

    public int getX(boolean left, int s) {
        int x = 20;
        if (!left) {
            x = this.W - x - s;
        }
        return x;
    }

    private int getY(int INDEX, int s) {
        return this.H - s * 2 - s * INDEX * 2;
    }

    public void init() {
        int r = R.ran(20);
        if (r == 0) {
            BGM.PetalChaser.play();
        } else if (r == 1) {
            BGM.RampageGhost.play();
        } else if (r == 2) {
            BGM.Rock_on_dream.play();
        } else if (r == 3) {
            BGM.Jiang_Shi_Dance.play();
        } else {
            BGM.BladeRunner.play();
        }
        int i = 0;
        while (i < 3) {
            this.targets_left[i] = new Target(true, i, R.ran(100));
            this.targets_right[i] = new Target(false, i, R.ran(100));
            ++i;
        }
        this.list_hit.clear();
        this.flag_missed = false;
        this.limit = 100;
        this.count = 0L;
    }

    private void success(SE se) {
        int speed = this.decLimit();
        ++this.count;
        if (speed != this.decLimit()) {
            SE.STATUS_SPEEDY.play();
        }
        this.limit = 100;
        if (se != null) {
            se.play();
        }
        int max = this.targets_left.length - 1;
        int i = 0;
        while (i < max) {
            this.targets_left[i] = this.targets_left[i + 1];
            this.targets_right[i] = this.targets_right[i + 1];
            this.targets_left[i].decIndex();
            this.targets_right[i].decIndex();
            ++i;
        }
        this.targets_left[max] = new Target(true, max, R.ran(100));
        this.targets_right[max] = new Target(false, max, R.ran(100));
    }

    @Override
    public void upDate() {
        Target t2;
        if (this.frame > 0 && --this.frame == 0) {
            this.cirno_state = 5;
        }
        Object[] objectArray = this.targets_left;
        int n = this.targets_left.length;
        int n2 = 0;
        while (n2 < n) {
            t2 = objectArray[n2];
            t2.upDate();
            ++n2;
        }
        objectArray = this.targets_right;
        n = this.targets_right.length;
        n2 = 0;
        while (n2 < n) {
            t2 = objectArray[n2];
            t2.upDate();
            ++n2;
        }
        for (Target t2 : this.list_hit) {
            t2.ascX();
        }
        this.list_a.get(0).setPushing(false);
        this.list_a.get(1).setPushing(false);
        objectArray = this.KH.getDirections();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Target d = objectArray[n3];
            if (d == DIRECTION.LEFT) {
                this.list_a.get(1).setPushing(true);
            } else if (d == DIRECTION.RIGHT) {
                this.list_a.get(0).setPushing(true);
            }
            ++n3;
        }
    }

    public boolean upDate_limit() {
        if (this.limit <= 0) {
            this.death();
            return false;
        }
        this.limit -= this.decLimit();
        if (this.limit <= 0) {
            this.limit = 0;
        }
        return true;
    }

    public class Accepter {
        public final int INDEX;
        public final boolean LEFT;
        public boolean pushing;

        public Accepter(boolean b, int i) {
            this.INDEX = i;
            this.LEFT = b;
        }

        public void draw(Graphics2D g) {
            if (Ksg_Panel_Main.this.flag_missed) {
                g.setColor(Color.RED);
            } else if (this.INDEX == 0) {
                if (this.pushing) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
            } else if (this.INDEX == 1) {
                g.setColor(Color.CYAN);
            } else if (this.INDEX == 2) {
                g.setColor(Color.BLUE);
            }
            int s = Ksg_Panel_Main.this.getSize();
            g.drawRect(Ksg_Panel_Main.this.getX(this.LEFT, s), Ksg_Panel_Main.this.getY(this.INDEX, s), s, s);
        }

        public void setPushing(boolean b) {
            this.pushing = b;
        }
    }

    public class Target {
        public int INDEX;
        public final boolean LEFT;
        public final boolean FOOD;
        public boolean ice;
        public final Image_Artifact IM;
        public int dy;
        private int dx;

        public Target(boolean b, int i, int seed) {
            this.INDEX = i;
            this.LEFT = b;
            this.IM = this.getImage(seed);
            this.ice = seed % 4 == 0;
            this.FOOD = seed < 60;
            this.decIndex();
            ++this.INDEX;
        }

        public void ascX() {
            this.dx += 10 * (this.LEFT ? -1 : 1);
        }

        public void changeIce() {
            this.ice = !this.ice;
        }

        public void decIndex() {
            --this.INDEX;
            this.dy -= Ksg_Panel_Main.this.getSize() * 2;
        }

        public void draw(Graphics2D g) {
            int s = Ksg_Panel_Main.this.getSize();
            g.drawImage(this.IM.getImage(this.ice ? 1 : 0), Ksg_Panel_Main.this.getX(this.LEFT, s) + this.dx, Ksg_Panel_Main.this.getY(this.INDEX, s) + this.dy, null);
        }

        private Image_Artifact getImage(int seed) {
            if (seed < 40) {
                return Image_Artifact.FOOD;
            }
            if (seed < 50) {
                return Image_Artifact.GOLDEN_FOOD;
            }
            if (seed < 60) {
                return Image_Artifact.GLASS;
            }
            if (seed < 65) {
                return Image_Artifact.BIN;
            }
            if (seed < 70) {
                return Image_Artifact.BOOK;
            }
            if (seed < 75) {
                return Image_Artifact.CARD;
            }
            if (seed < 80) {
                return Image_Artifact.DISC;
            }
            if (seed < 85) {
                return Image_Artifact.RIBBON;
            }
            if (seed < 88) {
                return Image_Artifact.HAKKE;
            }
            if (seed < 91) {
                return Image_Artifact.KNIFE;
            }
            if (seed < 94) {
                return Image_Artifact.P_KNIFE;
            }
            return Image_Artifact.STAFF;
        }

        public void upDate() {
            this.dy /= 2;
        }
    }
}

