/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller.listener.menu;

import dangeon.controller.DangeonScene;
import dangeon.controller.TurnSystemController;
import dangeon.controller.listener.menu.ITEM;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.creature.player.Enchant;
import main.Listener;
import main.res.SE;
import main.util.DIRECTION;

public class ENCHANT {
    private static Base_Artifact selected_artifact = null;
    private static int y;

    public static void actionKeyPressed(Listener.ACTION action) {
        switch (action) {
            case ENTER: {
                ENCHANT.pressEnter();
                break;
            }
            case CANCEL: {
                selected_artifact = null;
                DangeonScene.MENU.setPresentScene();
            }
        }
    }

    static void arrowKeyPressed(DIRECTION direction) {
        int _y = y;
        switch (direction) {
            case UP: {
                --_y;
                break;
            }
            case DOWN: {
                ++_y;
                break;
            }
            case RIGHT: 
            case LEFT: {
                return;
            }
        }
        if (ENCHANT.isSelectedArtifactSpellCard()) {
            if (_y < 0) {
                _y += Enchant.LENGTH;
            } else if (_y >= Enchant.LENGTH) {
                _y -= Enchant.LENGTH;
            }
        } else if (_y < 2) {
            _y += Enchant.ANY_LENGTH;
        } else if (_y >= Enchant.LENGTH) {
            _y -= Enchant.ANY_LENGTH;
        }
        y = _y;
    }

    public static String getEXP() {
        StringBuilder sb = new StringBuilder();
        Enchant e = Enchant.getEnchantedPlace(selected_artifact);
        Enchant old = Enchant.get(y);
        if (old.isAbleToExchange(old.getEnchant(), e)) {
            sb.append(selected_artifact.getColoredName());
            sb.append("\u3068");
            sb.append(old.getEnchant().getColoredName());
            sb.append("\u3092\u6301\u3061\u66ff\u3048\u307e\u3059");
        } else {
            sb.append(selected_artifact.getColoredName());
            sb.append("\u3092");
            sb.append(Enchant.get(y).toColoredString());
            if (ENCHANT.isSelectedArtifactEqualEnchant()) {
                sb.append("\u304b\u3089\u5916\u3057\u307e\u3059");
            } else {
                sb.append("\u88c5\u5099\u3057\u307e\u3059");
            }
        }
        return sb.toString();
    }

    public static int getY() {
        return y;
    }

    public static void initENCHANT(Base_Artifact a) {
        selected_artifact = a;
        y = a.isEnchantedNow() ? Enchant.getEnchantedPlace((Base_Artifact)a).y : (ENCHANT.isSelectedArtifactSpellCard() ? 0 : Enchant.ANY1.y);
        DangeonScene.ENCHANT.setPresentScene();
    }

    public static boolean isSelectedArtifactEqualEnchant() {
        return ENCHANT.isSelectedArtifactEqualEnchant(Enchant.get(y));
    }

    public static boolean isSelectedArtifactEqualEnchant(Enchant e) {
        return e.getEnchant() == selected_artifact;
    }

    public static boolean isSelectedArtifactSpellCard() {
        if (selected_artifact == null) {
            return true;
        }
        return selected_artifact instanceof SpellCard;
    }

    private static void pressEnter() {
        if (ENCHANT.isSelectedArtifactEqualEnchant()) {
            if (Enchant.tryToRemove(selected_artifact)) {
                SE.SYSTEM_ENCHANT_OFF.play();
                TurnSystemController.callMeToStartEnemyTurn();
            }
        } else {
            boolean success = Enchant.get(y).tryToSet(selected_artifact);
            if (success) {
                TurnSystemController.callMeToStartEnemyTurn();
            }
        }
        selected_artifact = null;
        ITEM.setMenuEnd();
    }
}

