/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller.listener.menu;

import dangeon.controller.DangeonScene;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.view.constant.NormalFont;
import dangeon.view.util.Window;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import main.Listener;
import main.Second_Firster;
import main.util.DIRECTION;
import main.util.Show;

public abstract class Base_MenuItem {
    private static Base_MenuItem now = null;
    protected int page;
    protected int y;
    public static final int Y_LENGTH = 10;
    private ArrayList<Base_Artifact> list = new ArrayList();
    public final BufferedImage TITLE_IMAGE;
    public final String TITLE;
    private DangeonScene DS;
    public final boolean IS_EMPTY;

    public static Base_MenuItem getNow() {
        return now;
    }

    public Base_MenuItem(String tit, Base_Artifact ... as) {
        if (now != null) {
            Show.showCriticalErrorMessageDialog("SeleceMenu\u8868\u793a\u4e2d\u306b\u65b0\u305f\u306aSelectMenu\u8868\u793a\u547d\u4ee4\u304c\u547c\u3070\u308c\u307e\u3057\u305f\u3002");
        }
        this.TITLE_IMAGE = this.initTitle(tit);
        this.TITLE = tit;
        this.IS_EMPTY = as.length == 0;
        Base_Artifact[] base_ArtifactArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            Base_Artifact a = base_ArtifactArray[n2];
            this.list.add(a);
            ++n2;
        }
        now = this;
    }

    public Base_MenuItem(String tit, Collection<Base_Artifact> as) {
        this.TITLE_IMAGE = this.initTitle(tit);
        this.TITLE = tit;
        this.IS_EMPTY = as.isEmpty();
        for (Base_Artifact a : as) {
            this.list.add(a);
        }
        now = this;
    }

    public Base_MenuItem(String tit, HashMap<Integer, Base_Artifact> as) {
        this.TITLE_IMAGE = this.initTitle(tit);
        this.TITLE = tit;
        this.IS_EMPTY = as.isEmpty();
        int i = 0;
        while (i < as.size()) {
            this.list.add(as.get(i));
            ++i;
        }
        now = this;
    }

    void actionKeyPressed(Listener.ACTION action) {
        switch (action) {
            case ENTER: {
                if (this.IS_EMPTY) {
                    this.pressedChancel();
                    break;
                }
                this.pressedEnter(this.get());
                break;
            }
            case CANCEL: {
                this.pressedChancel();
            }
        }
    }

    void arrowKeyPressed(DIRECTION direction) {
        if (this.list.size() > 10) {
            this.arrowKeyPressed_ExistPage(direction);
        } else {
            this.arrowKeyPressed_ExistNoPage(direction);
        }
    }

    private void arrowKeyPressed_ExistNoPage(DIRECTION direction) {
        int _y = this.y;
        switch (direction) {
            case UP: {
                --_y;
                break;
            }
            case DOWN: {
                ++_y;
                break;
            }
            case RIGHT: 
            case LEFT: {
                return;
            }
        }
        if (_y < 0) {
            _y = this.list.size() - 1;
        }
        if (_y > this.list.size() - 1) {
            _y = 0;
        }
        this.y = _y;
    }

    private void arrowKeyPressed_ExistPage(DIRECTION direction) {
        int MAX_Y;
        int _x = this.page;
        int _y = this.y;
        switch (direction) {
            case UP: {
                --_y;
                break;
            }
            case DOWN: {
                ++_y;
                break;
            }
            case LEFT: {
                --_x;
                break;
            }
            case RIGHT: {
                ++_x;
            }
        }
        while (true) {
            if (_x < 0 || _x > this.getMaxPage() - 1) {
                _x = _x < 0 ? this.getMaxPage() - 1 : 0;
            }
            if ((MAX_Y = this.list.size() - _x * 10) >= 1) break;
            --_x;
        }
        if (MAX_Y > 10) {
            MAX_Y = 10;
        }
        if (_y < 0) {
            _y = MAX_Y - 1;
        }
        if (_y > MAX_Y - 1) {
            _y = _x == this.page ? 0 : MAX_Y - 1;
        }
        this.page = _x;
        this.y = _y;
    }

    protected final void end() {
        DangeonScene.setScene(this.DS);
    }

    public Base_Artifact get() {
        return this.list.get(this.page * 10 + this.y);
    }

    public Base_Artifact get(int index) {
        return this.list.get(index);
    }

    public int getMaxPage() {
        return (this.list.size() - 1) / 10 + 1;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.list.size();
    }

    public int getY() {
        return this.y;
    }

    private BufferedImage initTitle(String tit) {
        if (tit == null) {
            return null;
        }
        int w = Second_Firster.ME.getFontMetrics(NormalFont.NORMALFONT).stringWidth(tit) + 20;
        int h = Window.getNarrowWindowH_SmallFont(1);
        BufferedImage im = Window.get(w, h);
        return im;
    }

    protected void pressedChancel() {
        this.end();
    }

    protected abstract void pressedEnter(Base_Artifact var1);

    public void work() {
        this.DS = DangeonScene.getPresentScene();
        DangeonScene.setScene(DangeonScene.SELECT_ITEM);
    }
}

