/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller.listener;

import dangeon.controller.DangeonScene;
import dangeon.controller.MainSystem;
import dangeon.controller.TurnSystemController;
import dangeon.controller.listener.KeyHolder;
import dangeon.controller.listener.menu.Conducter;
import dangeon.controller.listener.menu.FIRST;
import dangeon.controller.listener.menu.ITEM;
import dangeon.controller.listener.menu.Menu_Select;
import dangeon.controller.listener.menu.Menu_Volume;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.arrow.Arrow;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.EnchantArrow;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.hold_enemy.HoldEnemy;
import java.awt.Point;
import java.awt.event.KeyEvent;
import main.Base_KeyAccepter;
import main.Listener;
import main.constant.FR;
import main.res.SE;
import main.thread.MainThread;
import main.util.DIRECTION;

public class KeyAccepter
extends Base_KeyAccepter {
    private static int time = 0;
    private static final int INTERVAL = 50;
    private static boolean dash_button_pushing = false;
    private static boolean player_direction_pushing = false;
    private static boolean bias_button_pushing = false;
    private static boolean bias_button_push_twice_over = false;
    private static boolean leftKey_pushing = false;
    private static boolean downKey_pushing = false;
    private static boolean rightKey_pushing = false;
    private static boolean upKey_pushing = false;
    private static int direction_holding_frame = 0;
    private static boolean name_pushing = false;
    private static final int DIRECTION_HOLDING_FRAME = 5;
    private static boolean request_release_UPkey;
    private static boolean request_release_DOWNkey;
    private static boolean request_release_LEFTkey;
    private static boolean request_release_RIGHTkey;

    private static boolean isAnyReleaseRequest() {
        if (request_release_UPkey) {
            return true;
        }
        if (request_release_DOWNkey) {
            return true;
        }
        if (request_release_LEFTkey) {
            return true;
        }
        return request_release_RIGHTkey;
    }

    public static boolean isBiasButtonPushing() {
        return bias_button_pushing;
    }

    public static boolean isDirecting() {
        return player_direction_pushing;
    }

    public static boolean isDushing() {
        return dash_button_pushing;
    }

    public static boolean isNamePushing() {
        return name_pushing;
    }

    public static boolean playerAction(Listener.ACTION action) {
        switch (DangeonScene.getPresentScene()) {
            case DANGEON: {
                return KeyAccepter.playerAction_Dangeon(action);
            }
            case SELECT: {
                Menu_Select.actionKeyPressed(action);
                break;
            }
            case MENU: 
            case GOUSEI: 
            case ENCHANT: 
            case SELECT_ITEM: 
            case RESULT: {
                Conducter.actionKeyPressed(action);
                break;
            }
        }
        return true;
    }

    private static boolean playerAction_Dangeon(Listener.ACTION action) {
        if (!MainSystem.isKeyAccept()) {
            return true;
        }
        if (action != Listener.ACTION.BIAS) {
            KeyAccepter.setBias_button_push_twice_over(false);
        }
        block0 : switch (action) {
            case BIAS: {
                if (!bias_button_pushing) {
                    if (!bias_button_push_twice_over) {
                        KeyAccepter.setBias_button_push_twice_over(true);
                    } else {
                        DIRECTION d = Player.me.getDirection();
                        if (d.ROTATE % 2 == 0) {
                            Player.me.setDirection(d.getNeiboringDirection());
                        } else {
                            Player.me.setDirection(d.getNeiboringDirection().getNeiboringDirection());
                        }
                    }
                }
                bias_button_pushing = true;
                break;
            }
            case NAME: {
                name_pushing = true;
                break;
            }
            case TURN: {
                if (player_direction_pushing) break;
                player_direction_pushing = true;
                direction_holding_frame = 0;
                Point p = Player.me.getMassPoint();
                DIRECTION _d = Player.me.getDirection();
                Base_Enemy e = MapList.getEnemy(p.x + _d.X, p.y + _d.Y);
                if (e != null) {
                    int rotate = _d.ROTATE + 1;
                    int i = 0;
                    while (i < 8) {
                        DIRECTION d = DIRECTION.getDirectionFromRotate(rotate);
                        if (MapList.getEnemy(p.x + d.X, p.y + d.Y) != null) {
                            Player.me.setDirection(d);
                            break block0;
                        }
                        ++i;
                        ++rotate;
                    }
                } else {
                    DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
                    int n = dIRECTIONArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DIRECTION d = dIRECTIONArray[n2];
                        if (MapList.getEnemy(p.x + d.X, p.y + d.Y) != null) {
                            Player.me.setDirection(d);
                            break block0;
                        }
                        ++n2;
                    }
                }
                break;
            }
            case CANCEL: {
                dash_button_pushing = !KeyHolder.isContraining(Listener.ACTION.ENTER);
                return false;
            }
            case MAP: 
            case OWATTA: {
                return false;
            }
        }
        if (KeyHolder.isContraining(Listener.ACTION.MAP)) {
            return true;
        }
        switch (action) {
            case ENTER: {
                if (KeyHolder.isContraining(Listener.ACTION.CANCEL)) {
                    TurnSystemController.callMeToStartEnemyTurn();
                    return false;
                }
                if (!Player.me.normalAttack()) break;
                TurnSystemController.callMeToStartEnemyTurn();
                break;
            }
            case RECORD: {
                SE.SYSTEM_MENU.play();
                SE.mute(true);
                KeyAccepter.playerAction(Listener.ACTION.MENU);
                KeyAccepter.playerArrow(DIRECTION.DOWN);
                KeyAccepter.playerArrow(DIRECTION.RIGHT);
                KeyAccepter.playerAction(Listener.ACTION.ENTER);
                KeyAccepter.playerAction(Listener.ACTION.ENTER);
                SE.mute(false);
                break;
            }
            case INFO: {
                SE.SYSTEM_MENU.play();
                SE.mute(true);
                KeyAccepter.playerAction(Listener.ACTION.MENU);
                KeyAccepter.playerArrow(DIRECTION.DOWN);
                KeyAccepter.playerArrow(DIRECTION.RIGHT);
                KeyAccepter.playerAction(Listener.ACTION.ENTER);
                SE.mute(false);
                break;
            }
            case SYMBOL: {
                SE.SYSTEM_MENU.play();
                SE.mute(true);
                KeyAccepter.playerAction(Listener.ACTION.MENU);
                KeyAccepter.playerArrow(DIRECTION.DOWN);
                KeyAccepter.playerArrow(DIRECTION.RIGHT);
                KeyAccepter.playerAction(Listener.ACTION.ENTER);
                KeyAccepter.playerArrow(DIRECTION.DOWN);
                KeyAccepter.playerAction(Listener.ACTION.ENTER);
                SE.mute(false);
                break;
            }
            case BGM: {
                Config.switchBgm();
                if (Config.isFixBGM()) {
                    Message.set("BGM\u3092\u73fe\u5728\u306e\u66f2\u306b\u56fa\u5b9a\u3057\u307e\u3057\u305f$\u88c5\u5099\u3092\u5909\u66f4\u3057\u3066\u3082\uff22\uff27\uff2d\u3092\u7dad\u6301\u3057\u307e\u3059");
                    break;
                }
                Message.set("BGM\u306e\u56fa\u5b9a\u3092\u89e3\u9664\u3057\u307e\u3057\u305f$\u65b0\u3057\u304f\u88c5\u5099\u3092\u5909\u66f4\u3057\u3066\u304f\u3060\u3055\u3044");
                break;
            }
            case SOUND: {
                SE.SYSTEM_MENU.play();
                DangeonScene.MENU.setPresentScene();
                Menu_Volume.init();
                break;
            }
            case WINDOW: {
                MainThread.setSwitchFullScreenTask();
                break;
            }
            case GATHER: {
                Base_Artifact a = Belongings.get(-1);
                if (a != null) {
                    Arrow arr;
                    boolean flag_success;
                    if (!a.isMobile()) {
                        KeyAccepter.playerAction(Listener.ACTION.MENU);
                        KeyAccepter.playerArrow(DIRECTION.DOWN);
                        KeyAccepter.playerAction(Listener.ACTION.ENTER);
                        break;
                    }
                    boolean bl = flag_success = Belongings.getSize() < Belongings.getMax();
                    if (a instanceof Arrow && (arr = Belongings.getArrow(a.getClass())) != null) {
                        flag_success = true;
                    }
                    Belongings.get(-1).itemPickUp();
                    if (!flag_success) break;
                    TurnSystemController.callMeToStartEnemyTurn();
                    break;
                }
                Message.set("\u8db3\u5143\u306b\u306f\u7279\u306b\u4f55\u3082\u306a\u3044");
                break;
            }
            case ITEM: {
                if (Belongings.getSize() != 0) {
                    ITEM.setInit();
                    Conducter.phase = Conducter.PHASE.\u9053\u5177;
                    while (!Message.isTaskEmpty()) {
                        Message.getTask().upDate();
                    }
                    SE.SYSTEM_ENTER.play();
                    FIRST.x = 0;
                    FIRST.y = 0;
                    DangeonScene.setScene(DangeonScene.MENU);
                    break;
                }
                Message.set("\u7279\u306b\u4f55\u3082\u6301\u3063\u3066\u3044\u306a\u3044");
                break;
            }
            case MENU: {
                while (!Message.isTaskEmpty()) {
                    Message.getTask().upDate();
                }
                SE.SYSTEM_MENU.play();
                FIRST.x = 0;
                FIRST.y = 0;
                DangeonScene.setScene(DangeonScene.MENU);
                break;
            }
            case FIRE: {
                if (HoldEnemy.ME.specialAction()) break;
                if (EnchantArrow.getArrow() == null) {
                    Message.set("\u4f55\u3082\u30bb\u30c3\u30c8\u3057\u3066\u3044\u306a\u3044");
                    break;
                }
                Arrow arrow = Belongings.getArrow(EnchantArrow.getArrow().CLAZZ);
                if (arrow == null) {
                    Message.set(EnchantArrow.getArrow().name(), "\u3092\u6301\u3063\u3066\u3044\u306a\u3044");
                    break;
                }
                if (!arrow.itemUse()) break;
                TurnSystemController.callMeToStartEnemyTurn();
                break;
            }
            case TEST3: {
                HoldEnemy.ME.throwEnemy();
                break;
            }
            case TEST2: {
                HoldEnemy.ME.specialAction();
                break;
            }
            case TEST: {
                HoldEnemy.ME.hold();
                break;
            }
            case FUCKIN_MAP: {
                MassCreater.saveFuckinMap();
            }
        }
        return true;
    }

    private static void playerArrow(DIRECTION direction) {
        if (direction == null) {
            return;
        }
        if (!DangeonScene.SELECT.isPresentScene() && Message.isDemandToWaitPushingAnyKey()) {
            return;
        }
        if (KeyAccepter.isAnyReleaseRequest()) {
            return;
        }
        switch (DangeonScene.getPresentScene()) {
            case DANGEON: {
                switch (direction) {
                    case UP: {
                        upKey_pushing = true;
                        break;
                    }
                    case DOWN: {
                        downKey_pushing = true;
                        break;
                    }
                    case LEFT: {
                        leftKey_pushing = true;
                        break;
                    }
                    case RIGHT: {
                        rightKey_pushing = true;
                        break;
                    }
                    case DOWN_LEFT: {
                        downKey_pushing = true;
                        leftKey_pushing = true;
                        break;
                    }
                    case DOWN_RIGHT: {
                        downKey_pushing = true;
                        rightKey_pushing = true;
                        break;
                    }
                    case UP_LEFT: {
                        upKey_pushing = true;
                        leftKey_pushing = true;
                        break;
                    }
                    case UP_RIGHT: {
                        upKey_pushing = true;
                        rightKey_pushing = true;
                    }
                }
                break;
            }
            case SELECT: {
                Menu_Select.arrowKeyPressed(direction);
                break;
            }
            case MENU: 
            case GOUSEI: 
            case ENCHANT: 
            case SELECT_ITEM: 
            case RESULT: {
                if (!MainSystem.isKeyAccept()) {
                    return;
                }
                Conducter.arrowKeyPressed(direction);
                break;
            }
        }
    }

    public static void setBias_button_push_twice_over(boolean b) {
        bias_button_push_twice_over = b;
    }

    public static void setMovingKeyFalse() {
        upKey_pushing = false;
        downKey_pushing = false;
        leftKey_pushing = false;
        rightKey_pushing = false;
    }

    public static void setRequestReleasePushingKey() {
        request_release_UPkey = upKey_pushing;
        request_release_DOWNkey = downKey_pushing;
        request_release_LEFTkey = leftKey_pushing;
        request_release_RIGHTkey = rightKey_pushing;
        KeyAccepter.setMovingKeyFalse();
    }

    public static void setTimeZero() {
        time = 0;
    }

    public static void upDate() {
        if (!(upKey_pushing || downKey_pushing || rightKey_pushing || leftKey_pushing)) {
            time = 0;
            return;
        }
        time += FR.THREAD_SLEEP;
        if (!MainSystem.isKeyAccept()) {
            return;
        }
        if (player_direction_pushing || KeyHolder.isContraining(Listener.ACTION.MAP)) {
            if (leftKey_pushing && upKey_pushing) {
                Player.me.direction = DIRECTION.UP_LEFT;
                direction_holding_frame = 5;
            } else if (leftKey_pushing && downKey_pushing) {
                Player.me.direction = DIRECTION.DOWN_LEFT;
                direction_holding_frame = 5;
            } else if (rightKey_pushing && upKey_pushing) {
                Player.me.direction = DIRECTION.UP_RIGHT;
                direction_holding_frame = 5;
            } else if (rightKey_pushing && downKey_pushing) {
                Player.me.direction = DIRECTION.DOWN_RIGHT;
                direction_holding_frame = 5;
            } else {
                if (bias_button_pushing) {
                    return;
                }
                if (direction_holding_frame > 0) {
                    --direction_holding_frame;
                    return;
                }
                if (leftKey_pushing) {
                    Player.me.direction = DIRECTION.LEFT;
                } else if (rightKey_pushing) {
                    Player.me.direction = DIRECTION.RIGHT;
                } else if (upKey_pushing) {
                    Player.me.direction = DIRECTION.UP;
                } else if (downKey_pushing) {
                    Player.me.direction = DIRECTION.DOWN;
                }
            }
            return;
        }
        if (KeyHolder.isContraining(Listener.ACTION.MAP)) {
            return;
        }
        if (leftKey_pushing && upKey_pushing) {
            Player.me.move(DIRECTION.UP_LEFT);
            return;
        }
        if (leftKey_pushing && downKey_pushing) {
            Player.me.move(DIRECTION.DOWN_LEFT);
            return;
        }
        if (rightKey_pushing && upKey_pushing) {
            Player.me.move(DIRECTION.UP_RIGHT);
            return;
        }
        if (rightKey_pushing && downKey_pushing) {
            Player.me.move(DIRECTION.DOWN_RIGHT);
            return;
        }
        if (bias_button_pushing) {
            return;
        }
        if (time < 50) {
            return;
        }
        if (leftKey_pushing) {
            Player.me.move(DIRECTION.LEFT);
        } else if (rightKey_pushing) {
            Player.me.move(DIRECTION.RIGHT);
        } else if (upKey_pushing) {
            Player.me.move(DIRECTION.UP);
        } else if (downKey_pushing) {
            Player.me.move(DIRECTION.DOWN);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyAccepter.playerArrow(Listener.getAllow_map().get(e.getKeyCode()));
        KeyHolder.setTaskKeyAction(Listener.getKey().get(e.getKeyCode()));
    }

    @Override
    public void keyReleased(KeyEvent e) {
        DIRECTION allow = Listener.getAllow_map().get(e.getKeyCode());
        if (allow != null) {
            switch (allow) {
                case UP: {
                    upKey_pushing = false;
                    request_release_UPkey = false;
                    break;
                }
                case DOWN: {
                    downKey_pushing = false;
                    request_release_DOWNkey = false;
                    break;
                }
                case LEFT: {
                    leftKey_pushing = false;
                    request_release_LEFTkey = false;
                    break;
                }
                case RIGHT: {
                    rightKey_pushing = false;
                    request_release_RIGHTkey = false;
                    break;
                }
                case DOWN_LEFT: {
                    downKey_pushing = false;
                    request_release_DOWNkey = false;
                    leftKey_pushing = false;
                    request_release_LEFTkey = false;
                    break;
                }
                case DOWN_RIGHT: {
                    downKey_pushing = false;
                    request_release_DOWNkey = false;
                    rightKey_pushing = false;
                    request_release_RIGHTkey = false;
                    break;
                }
                case UP_LEFT: {
                    upKey_pushing = false;
                    request_release_UPkey = false;
                    leftKey_pushing = false;
                    request_release_LEFTkey = false;
                    break;
                }
                case UP_RIGHT: {
                    upKey_pushing = false;
                    request_release_UPkey = false;
                    rightKey_pushing = false;
                    request_release_RIGHTkey = false;
                }
            }
        } else {
            Listener.ACTION action = Listener.getKey().get(e.getKeyCode());
            if (action == null) {
                return;
            }
            KeyHolder.removeTaskKeyAction(action);
            switch (action) {
                case BIAS: {
                    bias_button_pushing = false;
                    break;
                }
                case CANCEL: {
                    dash_button_pushing = false;
                    break;
                }
                case TURN: {
                    player_direction_pushing = false;
                    break;
                }
                case NAME: {
                    name_pushing = false;
                }
            }
        }
    }
}

