/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller;

import connection.sv_cl.SocketHolder;
import dangeon.controller.DangeonScene;
import dangeon.controller.MainSystem;
import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.condition.Nap;
import dangeon.model.config.Config;
import dangeon.model.config.table.EnemyTable;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.special.map.BossMap;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.artifact.trap.\u843d\u3068\u3057\u7a74\u306e\u7f60;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.enemy.\u4e8c\u30c3\u5ca9\u30de\u30df\u30be\u30a6;
import dangeon.model.object.creature.enemy.\u9234\u4ed9\u30fb\u512a\u66c7\u83ef\u9662\u30fb\u30a4\u30ca\u30d0;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.I_Dush;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import dangeon.view.anime.CirnoIceEffect;
import dangeon.view.detail.MainMap;
import dangeon.view.detail.View_Sider;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import main.res.Image_Icon;
import main.res.SE;
import main.thread.MainThread;
import main.util.FrameShaker;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class TurnSystemController {
    private static int player_condition_sleep = 0;
    private static int turn_count = 0;
    private static boolean flag_turn_count_first = false;
    private static boolean flag_turn_count_second = false;
    private static boolean flag_turn_count_max = false;
    private static Phase phase = Phase.\u7b49\u901f;
    private static boolean slow_switch = false;
    private static EnemyTurnStep step = null;
    private static int non_actioned_count_hold = 0;
    public static boolean time_stop = false;
    public static int time_stop_count = 0;
    public static int time_stop_count2 = 0;
    private static boolean all_moved_and_start_to_wait = false;
    private static boolean flag_while_end = false;
    private static BossMap.BOSS boss;

    private static void bossCheck() {
        if (boss == null) {
            return;
        }
        if (!MapList.getListEnemy().contains(TurnSystemController.boss.creature)) {
            TurnSystemController.boss.map.end();
            boss = null;
        }
    }

    public static void callMeToStartEnemyTurn() {
        TurnSystemController.callMeToStartEnemyTurn(false);
    }

    public static void callMeToStartEnemyTurn(boolean only_walk_or_rest) {
        if (!only_walk_or_rest && Player.me.conditionCheck(CONDITION.\u3084\u308a\u3059\u3054\u3057)) {
            CONDITION.quickRemoveCondition(CONDITION.\u3084\u308a\u3059\u3054\u3057, Player.me);
        }
        Scene_Action.getMe().setBias_button_push_twice_over(false);
        step = EnemyTurnStep.\u4e3b\u4eba\u516c\u5f85\u3061;
    }

    private static void endEnemy() {
        if (!TaskOnMapObject.isMoveTaskEmpty()) {
            TaskOnMapObject.getEnemyMoveTask().clear();
        }
    }

    private static void endPlayer() {
        Player.me.selfHealing();
        Player.me.turnSatiety();
        Player.me.setBackPoint();
        CONDITION.\u90aa\u6cd5(Player.me);
        if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u5e78\u305b)) {
            if (!PresentField.get().isHaraheru()) {
                return;
            }
            Player.me.setExpCashNoMessage(1);
        }
        Player.me.playerLevelUp();
        EnchantSpecial.endPlayerTurn();
        Player.me.getClassJob().turnEndAction();
        for (Base_Artifact a : Belongings.getListItems()) {
            a.endPlayerTurn();
        }
        CONDITION.conditionEffect(Player.me);
        SocketHolder.submitFlagExchange();
    }

    private static boolean enemyAttack() {
        Base_Enemy non_actioned_enemy = MapList.getNonActionedEnemu();
        if (non_actioned_enemy != null) {
            if (!Player.me.isAnimeComletelyEnded()) {
                return true;
            }
            for (Base_Creature c : MapList.getListCreature()) {
                if (c.isAnimeComletelyEnded()) continue;
                return true;
            }
            non_actioned_enemy.attackOrSpecial();
            step = EnemyTurnStep.\u6575\u653b\u6483\u5f85\u6a5f;
        } else {
            step = EnemyTurnStep.\u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061;
        }
        return false;
    }

    private static void enemyMoveWaitAll(boolean turn_start) {
        Base_Enemy.enemy_move_wait = turn_start;
    }

    private static int get1stWarning() {
        return 5000;
    }

    private static int get2ndWarning() {
        return TurnSystemController.getMaxTurn() - 1500;
    }

    private static int getFinalWarning() {
        return TurnSystemController.getMaxTurn();
    }

    public static int getMaxTurn() {
        switch (Config.getFate()) {
            case 0: {
                return 9990;
            }
            case 1: {
                return 8000;
            }
            case 2: {
                return 7000;
            }
        }
        return 6600;
    }

    public static Image getPhaseImage() {
        switch (phase) {
            case \u4e09\u500d\u901f: {
                return Image_Icon.stt_icon_quick3.getImage();
            }
            case \u500d\u901f: {
                return Image_Icon.stt_icon_quick.getImage();
            }
            case \u7b49\u901f: {
                return Image_Icon.stt_icon_quick0.getImage();
            }
        }
        return null;
    }

    public static int getRestTurn() {
        return flag_turn_count_second ? TurnSystemController.getMaxTurn() - turn_count : -1;
    }

    public static boolean getSlowSwitch() {
        return slow_switch;
    }

    public static String getStepName() {
        if (step == null) {
            return "null";
        }
        return step.name();
    }

    public static boolean isAbleToMoveAdditionally(Base_Enemy e) {
        if (e.flag_3rd_move) {
            return false;
        }
        Player player = Player.me;
        switch (phase) {
            case \u7b49\u901f: {
                if (e.flag_2nd_move) {
                    if (e.conditionCheck(CONDITION.\u4e09\u500d\u901f)) {
                        e.flag_3rd_move = true;
                        return true;
                    }
                    return false;
                }
                if ((e.conditionCheck(CONDITION.\u500d\u901f) || e.conditionCheck(CONDITION.\u4e09\u500d\u901f)) && !player.conditionCheck(CONDITION.\u500d\u901f) && !player.conditionCheck(CONDITION.\u4e09\u500d\u901f)) {
                    e.flag_2nd_move = true;
                    return true;
                }
                return false;
            }
            case \u500d\u901f: {
                if (e.conditionCheck(CONDITION.\u4e09\u500d\u901f) && !player.conditionCheck(CONDITION.\u4e09\u500d\u901f)) {
                    e.flag_3rd_move = true;
                    return true;
                }
                return false;
            }
            case \u4e09\u500d\u901f: {
                return false;
            }
        }
        return false;
    }

    public static boolean isBoss(Base_Enemy e) {
        return boss != null && TurnSystemController.boss.creature == e;
    }

    private static boolean isEnemyAnimatigCompletelyEnded() {
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            if (enemy.isAnimeComletelyEnded()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEnemyAnimatigEnded() {
        return MapList.isEnemyAnimatigEnded();
    }

    public static boolean isEnemyTurn() {
        return step != null;
    }

    public static boolean isTurnOver() {
        return turn_count > TurnSystemController.getMaxTurn();
    }

    private static boolean isXndWarning(int x) {
        if (x == 1) {
            return turn_count >= TurnSystemController.get1stWarning();
        }
        if (x == 2) {
            return turn_count >= TurnSystemController.get2ndWarning();
        }
        if (x == 3) {
            return turn_count >= TurnSystemController.getFinalWarning();
        }
        return false;
    }

    private static boolean moveOrActionLoop() {
        int non_actioned_count = 0;
        if (MapList.getListEnemy().size() == 0) {
            for (Base_Enemy em : MapList.getListEnemy()) {
                if (!em.enemy_actioned) continue;
                em.flagMoveAnimeating();
            }
            return true;
        }
        for (Base_Enemy enemy : MapList.getListEnemy()) {
            if (enemy.enemy_actioned) continue;
            ++non_actioned_count;
        }
        if (non_actioned_count == 0) {
            for (Base_Enemy em : MapList.getListEnemy()) {
                if (!em.enemy_actioned) continue;
                em.flagMoveAnimeating();
            }
            return true;
        }
        if (non_actioned_count == non_actioned_count_hold) {
            TurnSystemController.enemyMoveWaitAll(true);
        }
        non_actioned_count_hold = non_actioned_count;
        if (TaskOnMapObject.isWaitMoveTaskEmpty()) {
            for (Base_Enemy enemy : MapList.getListEnemy()) {
                if (enemy.enemy_actioned) continue;
                enemy.action();
            }
        } else {
            for (Base_Enemy enemy : TaskOnMapObject.getWaitMoveTask()) {
                if (enemy.enemy_actioned) continue;
                enemy.action();
            }
        }
        if (!TaskOnMapObject.isMoveTaskEmpty()) {
            TaskOnMapObject.clearWaitMoveTask();
            for (Base_Enemy em : MapList.getListEnemy()) {
                if (!em.enemy_actioned) continue;
                em.flagMoveAnimeating();
            }
            return false;
        }
        all_moved_and_start_to_wait = true;
        for (Base_Enemy em : MapList.getListEnemy()) {
            if (!em.enemy_actioned) continue;
            em.flagMoveAnimeating();
        }
        return false;
    }

    private static boolean nextPhase() {
        switch (phase) {
            case \u7b49\u901f: {
                if (TurnSystemController.quickPlayer()) {
                    phase = Phase.\u500d\u901f;
                    return false;
                }
                if (!TurnSystemController.quickEnemy()) break;
                phase = Phase.\u500d\u901f;
                return true;
            }
            case \u500d\u901f: {
                if (TurnSystemController.quickPlayer()) {
                    phase = Phase.\u4e09\u500d\u901f;
                    return false;
                }
                if (TurnSystemController.quickEnemy()) {
                    phase = Phase.\u4e09\u500d\u901f;
                    return true;
                }
                phase = Phase.\u7b49\u901f;
                break;
            }
            case \u4e09\u500d\u901f: {
                phase = Phase.\u7b49\u901f;
            }
        }
        return false;
    }

    private static boolean quickEnemy() {
        switch (phase) {
            case \u7b49\u901f: {
                for (Base_Enemy em : MapList.getListEnemy()) {
                    if (!em.getConditionList().contains((Object)CONDITION.\u500d\u901f) && !em.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f) || em.flag_2nd_move) continue;
                    return true;
                }
            }
            case \u500d\u901f: {
                for (Base_Enemy em : MapList.getListEnemy()) {
                    if (!em.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f) || em.flag_3rd_move) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private static boolean quickPlayer() {
        switch (phase) {
            case \u7b49\u901f: {
                if (Player.me.getConditionList().contains((Object)CONDITION.\u500d\u901f) || Player.me.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f)) {
                    return true;
                }
            }
            case \u500d\u901f: {
                if (!Player.me.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f)) break;
                return true;
            }
        }
        return false;
    }

    public static void removeTimeStop() {
        if (time_stop) {
            time_stop_count = -1;
            Message.set("\u305d\u3057\u3066\u6642\u306f\u52d5\u304d\u51fa\u3059@");
            Message.setTask_AfterReleaseDemandToPushEnter(new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    time_stop_count = 0;
                    time_stop = false;
                    MainThread.switchWB(false);
                }
            });
        }
    }

    public static void setBoss(BossMap.BOSS boss) {
        TurnSystemController.boss = boss;
        if (boss != null) {
            MapList.addEnemy(boss.creature);
        }
    }

    public static void setPlayerConditionSleep() {
        player_condition_sleep = 5;
    }

    public static void setTimeStop(int count) {
        SE.TIME_STOP.play();
        MainThread.switchWB(true);
        time_stop = true;
        time_stop_count = count;
        time_stop_count2 = 0;
        TurnSystemController.setTurnFinish();
    }

    private static void settingEnemyActioned() {
        Base_Enemy[] es = new Base_Enemy[MapList.getListEnemy().size()];
        int i = 0;
        while (i < es.length) {
            es[i] = MapList.getListEnemy().get(i);
            ++i;
        }
        switch (phase) {
            case \u7b49\u901f: {
                CONDITION.conditionRemove();
                slow_switch = TurnSystemController.slowSwitch();
                Base_Enemy[] base_EnemyArray = es;
                int n = es.length;
                int n2 = 0;
                while (n2 < n) {
                    Base_Enemy enemy = base_EnemyArray[n2];
                    enemy.flag_3rd_move = false;
                    enemy.flag_2nd_move = false;
                    enemy.massCheck();
                    if (enemy.getConditionList().contains((Object)CONDITION.\u920d\u8db3) && slow_switch) {
                        enemy.enemy_actioned = true;
                    } else {
                        enemy.startTurn();
                        enemy.enemy_actioned = false;
                        enemy.quick_one_attack = false;
                        CONDITION.conditionOneEnemyContinue(enemy);
                    }
                    ++n2;
                }
                break;
            }
            case \u500d\u901f: {
                Base_Enemy[] base_EnemyArray = es;
                int n = es.length;
                int n3 = 0;
                while (n3 < n) {
                    Base_Enemy enemy = base_EnemyArray[n3];
                    if (!(CONDITION.conditionEffect(enemy) || !enemy.getConditionList().contains((Object)CONDITION.\u500d\u901f) && !enemy.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f) || enemy.quick_one_attack || enemy.flag_2nd_move)) {
                        enemy.enemy_actioned = false;
                        enemy.startTurn();
                    }
                    ++n3;
                }
                break;
            }
            case \u4e09\u500d\u901f: {
                Base_Enemy[] base_EnemyArray = es;
                int n = es.length;
                int n4 = 0;
                while (n4 < n) {
                    Base_Enemy enemy = base_EnemyArray[n4];
                    if (!CONDITION.conditionEffect(enemy) && enemy.getConditionList().contains((Object)CONDITION.\u4e09\u500d\u901f) && !enemy.quick_one_attack && !enemy.flag_3rd_move) {
                        enemy.enemy_actioned = false;
                        enemy.startTurn();
                    }
                    ++n4;
                }
                break;
            }
        }
    }

    public static void setTurnFinish() {
        step = null;
        phase = Phase.\u7b49\u901f;
    }

    private static boolean slowPlayer() {
        return slow_switch && Player.me.getConditionList().contains((Object)CONDITION.\u920d\u8db3);
    }

    private static boolean slowSwitch() {
        if (!slow_switch) {
            if (Player.me.getConditionList().contains((Object)CONDITION.\u920d\u8db3)) {
                return true;
            }
            for (Base_Enemy enemy : MapList.getListEnemy()) {
                if (!enemy.getConditionList().contains((Object)CONDITION.\u920d\u8db3)) continue;
                return true;
            }
        }
        return false;
    }

    private static void stairCheck() {
        if (!PresentField.get().isRandomField()) {
            return;
        }
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (!(a instanceof Stairs)) continue;
            return;
        }
        for (Base_Enemy e : MapList.getListEnemy()) {
            if (!(e instanceof \u4e8c\u30c3\u5ca9\u30de\u30df\u30be\u30a6) || !((\u4e8c\u30c3\u5ca9\u30de\u30df\u30be\u30a6)e).hasStair()) continue;
            return;
        }
        MapList.addArtifact(new Stairs(MassCreater.getStairsIP()));
        Message.set("\u3069\u3053\u304b\u306b\u968e\u6bb5\u304c\u73fe\u308c\u305f\u3088\u3046\u3060");
    }

    private static void stepAction() {
        if (TurnSystemController.moveOrActionLoop()) {
            step = all_moved_and_start_to_wait ? EnemyTurnStep.\u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061 : EnemyTurnStep.\u6575\u79fb\u52d5\u5f85\u3061;
            all_moved_and_start_to_wait = true;
            return;
        }
        if (!TaskOnMapObject.isMoveTaskEmpty()) {
            TaskOnMapObject.workMove();
        }
        step = EnemyTurnStep.\u6575\u79fb\u52d5\u5f85\u3061;
    }

    private static void stepEnd() {
        Message.setConcatFlag(false);
        MassCreater.stepEnd();
        for (Base_Enemy em : MapList.getListEnemy()) {
            Nap.TurnCheck(false, em);
            if (phase == Phase.\u7b49\u901f) {
                CONDITION.\u90aa\u6cd5(em);
            }
            if (CONDITION.enemyDontMove(em)) continue;
            if (MassCreater.getMass((Point)em.getMassPoint()).ROAD) {
                em.playerChecked();
                if (em.player_is_in_sight) {
                    em.setPlayerBackPoint(Player.me.getMassPoint().getLocation());
                } else if (!em.rootIsAround()) {
                    em.setPlayerBackPoint(Mass.nullpo.null_point);
                }
            }
            if (!em.getPlayerIsInSight() || Player.me.getConditionList().contains((Object)CONDITION.\u3084\u308a\u3059\u3054\u3057) || Player.me.getConditionList().contains((Object)CONDITION.\u900f\u660e) || CONDITION.enemyDontMove(em) || em.getConditionList().contains((Object)CONDITION.\u6df7\u4e71)) continue;
            if (!(em.getConditionList().contains((Object)CONDITION.\u4eee\u7720) && em.getConditionList().contains((Object)CONDITION.\u7279\u6b8a\u4eee\u7720) && em.getConditionList().contains((Object)CONDITION.\u9ebb\u75fa))) {
                em.direction = em.converDirection(Player.me.getMassPoint());
            }
            em.playerChecked();
        }
        while (MapList.checkSpecialRoom(Player.me.getMassPoint())) {
        }
        if (TurnSystemController.nextPhase()) {
            flag_while_end = true;
            TurnSystemController.stepStart();
            return;
        }
        EnemyTable.makeEnemyTurn();
        if (TurnSystemController.slowPlayer()) {
            CONDITION.conditionPlayerContinue();
            flag_while_end = true;
            TurnSystemController.stepStart();
            return;
        }
        if (phase == Phase.\u7b49\u901f) {
            CONDITION.conditionPlayerContinue();
        }
        TurnSystemController.stairCheck();
        TurnSystemController.bossCheck();
        TurnSystemController.endPlayer();
        MassCreater.turnCount();
        TurnSystemController.endEnemy();
        step = null;
        if (TaskOnMapObject.isFlagSkipPlayerTurn()) {
            \u9234\u4ed9\u30fb\u512a\u66c7\u83ef\u9662\u30fb\u30a4\u30ca\u30d0.effect();
            TurnSystemController.callMeToStartEnemyTurn();
            TaskOnMapObject.setFlagSkipPlayerTurn(false);
        } else {
            TaskOnMapObject.workStairs();
            Message.setTurnStartFlagOn();
            if (Scene_Action.getMe().is_I_Dushing()) {
                I_Dush.work();
            }
        }
        TurnSystemController.turnCount();
        while (MapList.checkSpecialRoom(Player.me.getMassPoint())) {
        }
    }

    private static void stepStart() {
        if (time_stop && TurnSystemController.timeCount()) {
            step = null;
            return;
        }
        MapList.checkWater();
        EnchantSpecial.turnStepEffect();
        all_moved_and_start_to_wait = false;
        TurnSystemController.settingEnemyActioned();
        TurnSystemController.enemyMoveWaitAll(false);
        step = EnemyTurnStep.\u6575\u79fb\u52d5;
    }

    public static boolean timeCount() {
        SE.SYSTEM_CURSOR.play();
        Message.set(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(++time_stop_count2), "\u79d2\u7d4c\u904e\uff01");
        if (--time_stop_count <= 0) {
            TurnSystemController.removeTimeStop();
            return false;
        }
        if (time_stop_count2 == 5) {
            Message.set("\u3075\u306f\u306f\u3001\u307e\u3060\u307e\u3060\u6b62\u3081\u3066\u3044\u3089\u308c\u308b\u305e\uff01");
        }
        return true;
    }

    private static void turnCount() {
        if (!PresentField.get().isHaraheru()) {
            return;
        }
        turn_count += 10;
        if (!TurnSystemController.isXndWarning(1) && EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u5bd2)) {
            turn_count = TurnSystemController.get1stWarning();
        }
        if (TurnSystemController.isXndWarning(1) && !TurnSystemController.isXndWarning(2)) {
            if (!flag_turn_count_first) {
                flag_turn_count_first = true;
                Player.me.setCondition(CONDITION.\u900f\u8996, 0);
                Message.set("\u30c0\u30f3\u30b8\u30e7\u30f3\u304c\u51b7\u3048\u3066\u6d45\u3044\u6c34\u8def\u304c\u51cd\u3063\u305f");
                MassCreater.frozenWater(true);
                View_Sider.setInformation("\u305d\u308d\u305d\u308d\u6b21\u306e\u968e\u3078\u5411\u304b\u304a\u3046");
                SE.ICE.play();
                FrameShaker.doneSoftly();
                FrameShaker.setShake_time(1000);
            }
            return;
        }
        if (TurnSystemController.isXndWarning(2) && !TurnSystemController.isXndWarning(3) && !flag_turn_count_second) {
            turn_count = TurnSystemController.get2ndWarning();
            flag_turn_count_second = true;
            Player.me.setCondition(CONDITION.\u900f\u8996, 0);
            View_Sider.setInformation("\u65e9\u304f\u6b21\u306e\u968e\u306b\u884c\u304b\u306a\u3044\u3068\u2026\uff01");
            SE.ICE.play();
            MainMap.addEffect(new CirnoIceEffect(), true);
            MassCreater.frozenWater(true);
            MapInSelect.damageIcy_toAllEnemies(null, null, Player.me.getLV() / 3);
            Message.set(Color.red, "\u3060\u3093\u3060\u3093\u697d\u3057\u304f\u306a\u3063\u3066\u304d\u305f\uff01");
            FrameShaker.doneNormaly();
            FrameShaker.setShake_time(1000);
            return;
        }
        if (TurnSystemController.isTurnOver() && !flag_turn_count_max) {
            Player.me.flag_game_over_TurnOver = true;
            Player.me.death(null, "\u697d\u3057\u304f\u306a\u3063\u3066\u5192\u967a\u306e\u76ee\u7684\u3092\u5fd8\u308c\u305f");
            if (MapList.getFlagSheef()) {
                Medal.\u6ce5\u68d2\u3057\u3066\u3044\u305f\u3089\u5192\u967a\u306e\u76ee\u7684\u3092\u5fd8\u308c\u305f.addCount();
            }
            flag_turn_count_max = true;
            return;
        }
    }

    public static void turnCountReset() {
        turn_count = 0;
        flag_turn_count_first = false;
        flag_turn_count_second = false;
        flag_turn_count_max = false;
    }

    public static void turnSkip() {
        turn_count = TurnSystemController.get1stWarning() - 1;
    }

    public static void upDate() {
        TurnSystemController.upDate_body();
    }

    public static void upDate_body() {
        if (player_condition_sleep > 0) {
            --player_condition_sleep;
        }
        while (!Message.isDemandToWaitPushingAnyKey()) {
            Player.me.updateStatus();
            if (step == null) {
                CONDITION.conditionEffect(Player.me);
                if (MainSystem.isKeyAccept()) {
                    TaskOnMapObject.finishDamaging();
                }
                return;
            }
            if (MainSystem.isDemandForWaitExist()) {
                return;
            }
            switch (step) {
                case \u4e3b\u4eba\u516c\u5f85\u3061: {
                    if (!DangeonScene.DANGEON.isPresentScene()) {
                        return;
                    }
                    if (Message.isDemandToWaitAnySystem()) {
                        return;
                    }
                    if (Player.me.isAnimating_withoutMoving()) {
                        return;
                    }
                    if (!TurnSystemController.isEnemyAnimatigEnded()) {
                        return;
                    }
                    if (TaskOnMapObject.isTaskTask()) {
                        return;
                    }
                    Message.setConcatFlag(false);
                    TaskOnMapObject.taskSpellUsed();
                    TurnSystemController.stepStart();
                    break;
                }
                case \u6575\u79fb\u52d5: {
                    TurnSystemController.stepAction();
                    break;
                }
                case \u6575\u653b\u6483: {
                    if (Player.me.isAnimating()) {
                        return;
                    }
                    if (!TurnSystemController.enemyAttack()) break;
                    return;
                }
                case \u6575\u79fb\u52d5\u5f85\u3061: {
                    if (all_moved_and_start_to_wait) {
                        if (TurnSystemController.isEnemyAnimatigEnded()) {
                            if (TaskOnMapObject.isPlayerMoveOnArtifact()) {
                                step = EnemyTurnStep.\u8db3\u5143\u30c1\u30a7\u30c3\u30af;
                                return;
                            }
                            step = EnemyTurnStep.\u6575\u7f60\u767a\u52d5;
                            TaskOnMapObject.finishDamaging();
                            break;
                        }
                        return;
                    }
                    step = EnemyTurnStep.\u6575\u79fb\u52d5;
                    break;
                }
                case \u6575\u653b\u6483\u5f85\u6a5f: {
                    if (Player.me.isAnimating()) {
                        return;
                    }
                    if (!Player.me.isAnimeComletelyEnded()) {
                        return;
                    }
                    if (TurnSystemController.isEnemyAnimatigEnded() && TurnSystemController.isEnemyAnimatigCompletelyEnded()) {
                        step = all_moved_and_start_to_wait ? EnemyTurnStep.\u6575\u7f60\u767a\u52d5 : EnemyTurnStep.\u6575\u79fb\u52d5;
                        TaskOnMapObject.finishDamaging();
                        break;
                    }
                    return;
                }
                case \u6575\u7f60\u767a\u52d5: {
                    for (Base_Enemy em : MapList.getListEnemy()) {
                        if (!em.flag_move) continue;
                        em.flag_move = false;
                        Base_Trap a = MapList.getTrap(em.getMassPoint());
                        if (a == null) continue;
                        a.walkOnActionByEnemy(em);
                    }
                    step = EnemyTurnStep.\u6575\u653b\u6483;
                    break;
                }
                case \u8db3\u5143\u30c1\u30a7\u30c3\u30af: {
                    if (Player.me.isAnimating()) {
                        return;
                    }
                    boolean flag = TaskOnMapObject.artifactOnAction();
                    step = flag ? EnemyTurnStep.\u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061 : EnemyTurnStep.\u7f60\u767a\u52d5\u5f85\u3061;
                    return;
                }
                case \u7f60\u767a\u52d5\u5f85\u3061: {
                    if (Player.me.isAnimating()) {
                        return;
                    }
                    if (TaskOnMapObject.task_trap.isDemandWaiting()) {
                        return;
                    }
                    if (!Player.me.isAnimeComletelyEnded()) {
                        return;
                    }
                    if (TaskOnMapObject.task_trap instanceof \u843d\u3068\u3057\u7a74\u306e\u7f60) {
                        step = EnemyTurnStep.\u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061;
                        break;
                    }
                    step = EnemyTurnStep.\u6575\u7f60\u767a\u52d5;
                    break;
                }
                case \u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061: {
                    if (Player.me.isAnimating()) {
                        return;
                    }
                    if (!TurnSystemController.isEnemyAnimatigEnded()) {
                        return;
                    }
                    if (player_condition_sleep > 0) {
                        return;
                    }
                    TurnSystemController.stepEnd();
                }
            }
        }
        return;
    }

    private static enum EnemyTurnStep {
        \u4e3b\u4eba\u516c\u5f85\u3061,
        \u6575\u79fb\u52d5,
        \u6575\u79fb\u52d5\u5f85\u3061,
        \u8db3\u5143\u30c1\u30a7\u30c3\u30af,
        \u6575\u653b\u6483,
        \u6575\u653b\u6483\u5f85\u6a5f,
        \u5168\u30a2\u30cb\u30e1\u7d42\u4e86\u5f85\u3061,
        \u7f60\u767a\u52d5\u5f85\u3061,
        \u6575\u7f60\u767a\u52d5;

    }

    private static enum Phase {
        \u7b49\u901f,
        \u500d\u901f,
        \u4e09\u500d\u901f;

    }
}

