/*
 * Decompiled with CFR 0.152.
 */
package dangeon.controller;

import dangeon.controller.MainSystem;
import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.menu.first.adventure.medal.Medal;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.device.Stairs;
import dangeon.model.object.artifact.item.arrow.\u5927\u7832\u306e\u5f3e;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u98df;
import dangeon.model.object.artifact.item.pot.Base_Pot;
import dangeon.model.object.artifact.item.pot.Base_Pot_Selective;
import dangeon.model.object.artifact.item.staff.MagicBullet;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.\u59eb\u6d77\u68e0\u306f\u305f\u3066;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import dangeon.view.anime.MissEffect;
import dangeon.view.detail.MainMap;
import java.awt.Point;
import java.util.ArrayList;
import main.res.SE;
import main.util.DIRECTION;

public class ThrowingItem {
    private final int PLAYER_MISS = 15;
    private final int ENEMY_MISS = 20;
    private int first_sleep = 3;
    public final Base_Artifact A;
    public final Base_Creature C;
    public boolean ENTO;
    public boolean DIGG;
    public final HowToThrow HOW;
    private static ThrowingItem me;
    private boolean flag_reflect = false;
    public boolean flag_continue_throwing = false;
    private boolean flag_ento_launch = false;
    private static int THROW_MAX;

    public static boolean launch(Base_Artifact a, boolean ento) {
        return ThrowingItem.launch(a, ento, 10);
    }

    public static boolean launch(Base_Artifact a, boolean ento, int throw_max) {
        Point back;
        int x = a.getDirection().X;
        int y = a.getDirection().Y;
        THROW_MAX = ento ? Math.max(40, 30) : throw_max;
        boolean out = false;
        Point mass_point = a.getMassPoint();
        int i = 0;
        while (i < THROW_MAX) {
            Base_Creature c;
            Base_Artifact A;
            mass_point.translate(x, y);
            if (MassCreater.getMass((Point)mass_point).X < 0) {
                mass_point.translate(-x, -y);
                out = true;
            } else if (a.isHitToItem() && (A = MapList.getArtifact(mass_point)) != null && (!(A instanceof Base_Device) || A instanceof Stairs) || (c = MapList.getCreature(mass_point)) != null && (!c.isSkillActive() || !c.isThroughItem(a)) || !ento && !MassCreater.getMass((Point)mass_point).WALKABLE && !a.isNeglectiveForWall()) break;
            ++i;
        }
        if (i > 0 && \u59eb\u6d77\u68e0\u306f\u305f\u3066.isShotSpoit(back = a.getDirection().getReverse().getFrontPoint(a.getMassPoint().getLocation()), a)) {
            a.getMassPoint().setLocation(back);
            a.setFateToBeDeleted();
        }
        a.setMoveAnimating(true);
        return out;
    }

    private ThrowingItem(Base_Artifact a, Base_Creature c) {
        this(a, c, false, HowToThrow.PARABOLA_NAKUNARANAI);
        this.first_sleep = 0;
    }

    public ThrowingItem(Base_Artifact a, Base_Creature c, boolean ento) {
        this(a, c, ento, HowToThrow.NORMAL);
    }

    public ThrowingItem(Base_Artifact a, Base_Creature c, boolean ento, HowToThrow how) {
        this.A = a;
        this.C = c;
        this.ENTO = ento;
        this.HOW = how;
        me = this;
        if (how == HowToThrow.NORMAL || how == HowToThrow.SLOW) {
            this.A.initScreenPoint();
        }
    }

    private void bounce(Point _p) {
        Point p = this.getBounceLocation(_p);
        if (p == null) {
            this.fall(_p);
        } else {
            this.flag_reflect = true;
            SE.TIME_STOP.play();
            _p.translate(this.A.getDirection().X, this.A.getDirection().Y);
            this.A.direction = DIRECTION.getDirection(_p, p);
            this.A.getMassPoint().setLocation(p);
            this.A.setMassPoint_ParabolaJumpAttack(p);
            ThrowingItem th = this.HOW == HowToThrow.NORMAL ? new ThrowingItem(this.A, this.C) : new ThrowingItem(this.A, this.C, false, HowToThrow.PARABOLA);
            this.first_sleep = 0;
            TaskOnMapObject.setThrow(th);
            th.flag_reflect = true;
            this.A.upDate();
            this.A.upDate();
            this.flag_continue_throwing = true;
        }
    }

    private void doFinalCalculation() {
        this.flag_continue_throwing = false;
        this.A.upDate(this.HOW.SPEED * 2);
        Base_Creature object = MapList.getCreature(this.A.getMassPoint());
        if (this.reflectCheck(object)) {
            this.reflect();
        } else {
            if (this.HOW == HowToThrow.MAGIC) {
                this.doMagic();
            } else {
                this.doNormal();
            }
            if (!this.flag_continue_throwing) {
                TaskOnMapObject.setThrow(null);
                me = null;
            }
        }
    }

    private void doMagic() {
        if (MassCreater.getMass((Point)this.A.getMassPoint()).WALKABLE || this.A.isNeglectiveForWall()) {
            Base_Creature object = MapList.getCreature(this.A.getMassPoint());
            this.doMagic(object);
        } else if (this.A instanceof MagicBullet && ((MagicBullet)this.A).STAFF.hitWall(this)) {
            Base_Creature object = MapList.getCreature(this.A.getMassPoint());
            this.doMagic(object);
        }
    }

    private void doMagic(Base_Creature object) {
        if (object != null) {
            this.A.itemHitCheck(false, this.C, object);
            this.entoCheck();
        } else if (this.A.isHitToItem()) {
            this.A.staticCheck();
            Base_Artifact a = MapList.getArtifact(this.A.getMassPoint());
            if (a != null) {
                this.A.itemHitCheck(false, this.C, a);
                this.entoCheck();
            }
        }
    }

    private void doNormal() {
        Point p = this.A.getMassPoint();
        if (MapList.getCreature(p) != null) {
            this.reachAtCreature(!this.ENTO);
            this.entoCheck();
        } else if (!MassCreater.getMass((Point)p).WALKABLE) {
            if (!this.ENTO) {
                if (this.A instanceof \u5927\u7832\u306e\u5f3e) {
                    ((\u5927\u7832\u306e\u5f3e)this.A).explode(p, this.C);
                    return;
                }
                p.translate(-this.A.getDirection().X, -this.A.getDirection().Y);
                if (!this.podBreak()) {
                    if (this.C.equals(Player.me) && !this.flag_reflect && EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u5f3e)) {
                        this.bounce(p);
                    } else {
                        this.fall(p);
                    }
                }
            } else {
                if (this.A instanceof Base_Pot_Selective && ((Base_Pot_Selective)this.A).isMax()) {
                    Medal.\u4e2d\u8eab\u304c\u8a70\u307e\u3063\u305f\u74f6\u3092\u9060\u6295\u3057\u305f.addCount();
                }
                Message.set(this.A.getColoredName().concat("\u306f"), "\u6d88\u3048\u3066\u3057\u307e\u3063\u305f\uff65\uff65\uff65");
            }
        } else if (!this.ENTO) {
            if (this.A instanceof \u5927\u7832\u306e\u5f3e) {
                ((\u5927\u7832\u306e\u5f3e)this.A).explode(p, this.C);
                return;
            }
            this.fall(p);
        } else {
            Message.set(this.A.getColoredName().concat("\u306f"), "\u6d88\u3048\u3066\u3057\u307e\u3063\u305f\uff65\uff65\uff65");
        }
    }

    private void entoCheck() {
        if (this.ENTO) {
            if (!this.isAnimationExist()) {
                ThrowingItem.launch(this.A, this.ENTO);
                this.flag_ento_launch = false;
            } else {
                this.flag_ento_launch = true;
            }
            this.flag_continue_throwing = true;
            return;
        }
    }

    private void fall(Point p) {
        Mass m;
        if (this.HOW == HowToThrow.NORMAL || this.HOW == HowToThrow.PARABOLA_NAKUNARANAI) {
            ItemFall.itemFall_TrapCheck(p, this.A);
        }
        if (this.A.getClass().equals(Stairs.class) && ((m = MassCreater.getMass(p)).isHoly() || m.isShop())) {
            Medal.\u968e\u6bb5\u3092\u6756\u3067\u79fb\u52d5\u3055\u305b\u3066\u6577\u5730\u5185\u306b\u5165\u308c\u305f.addCount();
        }
    }

    private Point getBounceLocation(Point p) {
        ArrayList<Point> old = new ArrayList<Point>();
        ArrayList<Point> now = new ArrayList<Point>();
        now.add(p.getLocation());
        int length = 3;
        int i = 0;
        while (i < length) {
            Point _p = this.getBouncePoint(now, old);
            if (_p != null) {
                return _p;
            }
            ++i;
        }
        return null;
    }

    private Point getBouncePoint(ArrayList<Point> now, ArrayList<Point> old) {
        for (Point p : now) {
            Base_Creature c = MapList.getCreature(p);
            if (c != null && !c.equals(Player.me)) {
                return p;
            }
            old.add(p);
        }
        ArrayList<Point> next = new ArrayList<Point>();
        for (Point p : now) {
            if (!MassCreater.getMass((Point)p).WALKABLE) continue;
            DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                Point point = new Point(p.x + d.X, p.y + d.Y);
                if (!old.contains(point)) {
                    next.add(point);
                }
                ++n2;
            }
        }
        now.clear();
        for (Point p : next) {
            now.add(p);
        }
        return null;
    }

    private boolean isAnimationExist() {
        return MainSystem.isDemandForWaitExist();
    }

    public boolean isFirstSleeping() {
        return this.first_sleep > 0;
    }

    public boolean isReflected() {
        return this.flag_reflect;
    }

    private int isThrowingMiss(Base_Creature target) {
        if (target instanceof Player && EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.DEF, ENCHANT_SIMBOL.\u8eab\u8eb1\u3057)) {
            return 100;
        }
        if (this.C instanceof Player) {
            if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ATK, ENCHANT_SIMBOL.\u9060\u6295)) {
                return 0;
            }
            if (EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.ATK, ENCHANT_SIMBOL.\u5fc5\u4e2d)) {
                return 0;
            }
            return 15;
        }
        return 20;
    }

    private boolean podBreak() {
        if (this.A instanceof Base_Pot) {
            return ((Base_Pot)this.A).broken();
        }
        return false;
    }

    private void reachAtCreature(boolean fall) {
        if (this.A instanceof Base_Device) {
            ItemFall.itemFall(this.A);
            return;
        }
        Point p = this.A.getMassPoint();
        Base_Creature object = MapList.getCreature(this.A.getMassPoint());
        if (!this.ENTO && object instanceof Player && \u5370\u98df.effect(this)) {
            Message.set(object.getColoredName(), "\u306f", this.A.getColoredName(), "\u3092\u98df\u3079\u3066\u6e80\u8179\u5ea6\u304c10\u56de\u5fa9\u3057\u305f");
            return;
        }
        if (this.A instanceof \u5927\u7832\u306e\u5f3e) {
            ((\u5927\u7832\u306e\u5f3e)this.A).explode(p, this.C);
            return;
        }
        if (this.HOW == HowToThrow.BREAK && object.isThroughItem(this.A)) {
            return;
        }
        if (new R().is(this.isThrowingMiss(object))) {
            MainMap.addEffect(new MissEffect(object, true));
            if (this.C instanceof Player) {
                Message.set(this.A.getName(), "\u306f\u907f\u3051\u3089\u308c\u305f");
            } else if (object instanceof Player) {
                Message.set(this.A.getName(), "\u3092\u907f\u3051\u305f");
            } else {
                Message.set(this.A.getName(), "\u306f\u5f53\u305f\u3089\u306a\u304b\u3063\u305f");
            }
            if (fall) {
                this.fall(p);
            }
        } else if (this.A.itemHitCheck(!fall, this.C, object) && fall) {
            if (this.A.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) {
                this.A.getListComposition().remove((Object)ENCHANT_SIMBOL.\u91d1);
                Message.set(this.A.getColoredName(), "\u306e\u96db\u306e\u52a0\u8b77\u304c\u5265\u304c\u308c\u305f");
                this.fall(p);
            } else if (this.A.isNoWasteWithThrowing()) {
                this.fall(p);
            } else {
                this.podBreak();
            }
        }
    }

    private void reflect() {
        this.flag_reflect = true;
        this.A.direction = this.A.direction.getReverse();
        if (this.HOW == HowToThrow.PARABOLA || this.HOW == HowToThrow.PARABOLA_NAKUNARANAI) {
            if (this.C != null) {
                this.A.setMassPoint_ParabolaJumpAttack(this.C.getMassPoint());
            } else if (THROW_MAX == 0) {
                THROW_MAX = 10;
            }
        }
        ThrowingItem.launch(this.A, this.ENTO, THROW_MAX);
        this.flag_continue_throwing = true;
    }

    private boolean reflectCheck(Base_Creature object) {
        if (object == null) {
            return false;
        }
        if (this.flag_reflect) {
            return false;
        }
        return object.isSkillActive() && object.reflection(this);
    }

    public void setReflected(boolean b) {
        this.flag_reflect = b;
    }

    public void upDate() {
        if (this.flag_ento_launch) {
            if (!this.isAnimationExist()) {
                ThrowingItem.launch(this.A, this.ENTO);
                this.flag_ento_launch = false;
            }
            TaskOnMapObject.work_task();
            return;
        }
        if (this.first_sleep > 0 && --this.first_sleep > 0) {
            return;
        }
        if (this.A.isAnimating()) {
            if (this.HOW.SPEED != 0) {
                this.A.upDate(this.HOW.SPEED * 2);
            } else {
                this.A.upDate();
            }
        } else if (this.A.isFateToBeDeleted()) {
            this.A.upDate(this.HOW.SPEED * 2);
            TaskOnMapObject.setThrow(null);
        } else {
            this.doFinalCalculation();
        }
    }

    public static enum HowToThrow {
        NORMAL(20),
        SLOW(10),
        MAGIC(20),
        BREAK(20),
        PARABOLA(0),
        PARABOLA_NAKUNARANAI(0);

        private final int SPEED;

        private HowToThrow(int speed) {
            this.SPEED = speed;
        }
    }
}

