/*
 * Decompiled with CFR 0.152.
 */
package title.objects;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import main.util.BeautifulView;
import main.util.FileReadSupporter;

public abstract class Base_Title_Object {
    public BufferedImage IM;
    public final Point2D NO = null;
    public final Point2D CENTER = new Point2D.Double(0.5, 0.5);
    public final Point2D LEFT_BOTTOM = new Point(0, 1);
    public final Point2D RIGHT_BOTTOM = new Point(1, 1);
    private int first_wait_frame = 3;
    public double theta;
    public boolean flag_setted;
    public int first_frame = 0;
    public final int FIRST_FRAME = 30;
    private boolean flag_body;
    public int count_360 = 0;

    public Base_Title_Object() {
        this.flag_body = true;
        this.IM = null;
    }

    public Base_Title_Object(String file_name) {
        this(file_name, false);
    }

    public Base_Title_Object(String file_name, boolean flag_start) {
        if (file_name.contains(".dat")) {
            file_name = file_name.replaceFirst("\\.dat", "");
        }
        this.IM = FileReadSupporter.readImage("title/".concat(file_name), "png");
        this.flag_setted = flag_start;
    }

    public void draw(Graphics2D g) {
        if (this.first_wait_frame > 0 && !this.flag_body) {
            return;
        }
        int w = this.w();
        int h = this.h();
        int dx = 0;
        int dy = 0;
        AffineTransform firts_at = g.getTransform();
        if (this.rotate() != this.NO) {
            Point2D p = this.rotate();
            dx = (int)Math.round((double)w * p.getX());
            dy = (int)Math.round((double)h * p.getY());
            AffineTransform at = new AffineTransform(firts_at);
            if (this.isConnetedBody()) {
                at.translate(this.x() + dx, this.y() + dy - this.shakeBody());
            } else {
                at.translate(this.x() + dx, this.y() + dy);
            }
            at.rotate(this.theta);
            this.drawIM(g, at, dx, dy, w, h);
        } else {
            AffineTransform at = new AffineTransform(firts_at);
            at.translate(this.x(), this.y());
            this.drawIM(g, at, dx, dy, w, h);
        }
        g.setTransform(firts_at);
    }

    private void drawIM(Graphics2D g, AffineTransform at, int dx, int dy, int w, int h) {
        g.setTransform(at);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(this.getAlpha()));
        g.drawImage(this.IM, -dx, -dy, w, h, null);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
    }

    protected float getAlpha() {
        return 1.0f;
    }

    protected int h() {
        return (int)Math.round((double)this.IM.getHeight() * this.rate());
    }

    protected boolean isConnetedBody() {
        return false;
    }

    public double rate() {
        return 0.175;
    }

    public abstract Point2D rotate();

    protected void setted() {
    }

    protected final int shakeBody() {
        return -((int)(Math.sin(Math.PI * 2 * (double)this.count_360 / 40.0) * 15.0 * Math.pow(0.9, this.count_360 / 20)));
    }

    public final void upDate() {
        if (this.first_wait_frame > 0) {
            --this.first_wait_frame;
            if (!this.flag_body) {
                return;
            }
        } else {
            ++this.count_360;
            if (this.count_360 >= 360) {
                this.count_360 = 0;
            }
        }
        if (this.flag_setted) {
            this.upDate_AfterSetted();
        } else {
            this.upDate_First();
        }
    }

    protected void upDate_AfterSetted() {
    }

    protected final void upDate_First() {
        this.upDate_First_Indiv();
        if (++this.first_frame == 30) {
            this.flag_setted = true;
            this.setted();
        }
    }

    protected void upDate_First_Indiv() {
    }

    protected int w() {
        return (int)Math.round((double)this.IM.getWidth() * this.rate());
    }

    public abstract int x();

    public abstract int y();
}

