/*
 * Decompiled with CFR 0.152.
 */
package main.util;

import dangeon.model.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import javax.swing.JOptionPane;
import main.Second_Firster;

public class Show {
    private static void set(boolean b) {
        Second_Firster.ME.setEnabled(b);
        Second_Firster.ME.setVisible(b);
    }

    public static int showConfirmDialog(String message) {
        Show.set(false);
        int i = JOptionPane.showConfirmDialog(Second_Firster.ME, message, "Confirm", 2, 2);
        Show.set(true);
        return i;
    }

    public static void showCriticalErrorMessageDialog(Exception e) {
        Show.writeErrorText(e);
        Show.showCriticalErrorMessageDialog("Error", e.toString());
    }

    public static void showCriticalErrorMessageDialog(Exception e, String title) {
        Show.writeErrorText(e);
        Show.showCriticalErrorMessageDialog(title, e.toString());
    }

    public static void showCriticalErrorMessageDialog(String message) {
        Show.showWarningMessageDialog(message);
        Show.writeErrorText(new Exception(message));
        System.exit(0);
    }

    public static void showCriticalErrorMessageDialog(String ... message) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = message;
        int n = message.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            sb.append("\n");
            ++n2;
        }
        Show.showCriticalErrorMessageDialog(sb.toString());
        System.exit(0);
    }

    public static void showErrorMessageDialog(Exception e) {
        Show.writeErrorText(e);
        if (Show.showConfirmDialog(e.toString().concat("\n\n\u4e86\u89e3 => \u7d9a\u884c")) != 0) {
            System.exit(0);
        }
    }

    public static void showErrorMessageDialog(String message) {
        Show.writeErrorText(new Exception(message));
        if (Show.showConfirmDialog(message.concat("\n\n\u4e86\u89e3 => \u7d9a\u884c")) != 0) {
            System.exit(0);
        }
    }

    public static void showInformationMessageDialog(String message) {
        System.out.println(message);
        Show.set(false);
        JOptionPane.showMessageDialog(Second_Firster.ME, message, "Information...", 1);
        Show.set(true);
    }

    public static void showInformationMessageDialog(String message, String title) {
        Show.set(false);
        JOptionPane.showMessageDialog(Second_Firster.ME, message, title, 1);
        Show.set(true);
    }

    public static void showNotOpenErrorMessageDialog(String filename) {
        try {
            Show.showErrorMessageDialog("\u30d5\u30a1\u30a4\u30eb".concat(filename).concat("\u304c\u958b\u3051\u307e\u305b\u3093\u00a5n\u524a\u9664\u3055\u308c\u305f\u304b\u7de8\u96c6\u4e2d\u3067\u306a\u3044\u304b\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044"));
        }
        catch (NullPointerException e) {
            Show.showErrorMessageDialog("\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u6307\u793a\u3067\u3059\u304c\u3001\u305d\u3082\u305d\u3082\u30d5\u30a1\u30a4\u30eb\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093(null)\u00a5n\u30d7\u30ed\u30b0\u30e9\u30e0\u4e0a\u306e\u30d0\u30b0\u306e\u53ef\u80fd\u6027\u304c\u9ad8\u3044\u3067\u3059");
        }
    }

    public static void showWarningMessageDialog(String message) {
        Show.showWarningMessageDialog(message, "Warning...");
    }

    public static void showWarningMessageDialog(String message, String title) {
        Show.set(false);
        JOptionPane.showMessageDialog(Second_Firster.ME, message, title, 2);
        Show.set(true);
    }

    public static void writeErrorText(Error e) {
        e.printStackTrace();
        if (Config.isTest()) {
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            File file = new File("error.txt");
            FileWriter filewriter = new FileWriter(file, true);
            filewriter.write("\u3010");
            filewriter.write(new Date().toString());
            filewriter.write("\u3011");
            filewriter.write("\r\n");
            filewriter.write(stringWriter.toString());
            filewriter.write("\r\n");
            filewriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeErrorText(Exception e) {
        e.printStackTrace();
        if (Config.isTest()) {
            return;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            File file = new File("error.txt");
            FileWriter filewriter = new FileWriter(file, true);
            filewriter.write("\u3010");
            filewriter.write(new Date().toString());
            filewriter.write("\u3011");
            filewriter.write("\r\n");
            filewriter.write(stringWriter.toString());
            filewriter.write("\r\n");
            filewriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

