/*
 * Decompiled with CFR 0.152.
 */
package main.util;

import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import main.util.Show;

public enum DIRECTION {
    UP_LEFT(7, 5, -1, -1),
    UP(8, 6, 0, -1),
    UP_RIGHT(9, 7, 1, -1),
    RIGHT(6, 0, 1, 0),
    DOWN_RIGHT(3, 1, 1, 1),
    DOWN(2, 2, 0, 1),
    DOWN_LEFT(1, 3, -1, 1),
    LEFT(4, 4, -1, 0),
    NEUTRAL(5, null, 0, 0);

    public final Integer ROTATE;
    public final int NUM;
    public final int X;
    public final int Y;
    private final DIRECTION[] NEIBORING3 = new DIRECTION[3];
    private final DIRECTION[] NEIBORING5 = new DIRECTION[5];

    public static DIRECTION backDirection(DIRECTION dir) {
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (-dir.X == d.X && -dir.Y == d.Y) {
                return d;
            }
            ++n2;
        }
        return dir;
    }

    public static DIRECTION[] get8Direction() {
        DIRECTION[] direction = new DIRECTION[8];
        int i = 0;
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION dir = dIRECTIONArray[n2];
            if (dir.NUM != 5) {
                direction[i] = dir;
                ++i;
            }
            ++n2;
        }
        return direction;
    }

    public static DIRECTION getDirection(Base_Creature c1, Base_Creature c2) {
        return DIRECTION.getDirection(c1.getMassPoint(), c2.getMassPoint());
    }

    public static DIRECTION getDirection(int x, int y) {
        if (x > 0) {
            x = 1;
        } else if (x < 0) {
            x = -1;
        }
        if (y > 0) {
            y = 1;
        } else if (y < 0) {
            y = -1;
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (d.X == x && d.Y == y) {
                return d;
            }
            ++n2;
        }
        return null;
    }

    public static DIRECTION getDirection(Point p1, Point p2) {
        int x = p2.x - p1.x;
        int y = p2.y - p1.y;
        return DIRECTION.getDirection(x, y);
    }

    public static DIRECTION getDirectionFromRotate(int rotate) {
        if (rotate < 0) {
            rotate += 8;
        }
        if (rotate > 7) {
            rotate -= 8;
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (d != NEUTRAL && d.ROTATE == rotate) {
                return d;
            }
            ++n2;
        }
        return NEUTRAL;
    }

    public static DIRECTION getDirectionToPlayer(Base_Creature c) {
        return DIRECTION.getDirection(c, Player.me);
    }

    public static DIRECTION getFromNUM(int num) {
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (d.NUM == num) {
                return d;
            }
            ++n2;
        }
        return NEUTRAL;
    }

    public static DIRECTION getRandom8Direction() {
        int ran = new R().nextInt(8) + 1;
        if (ran >= 5) {
            ++ran;
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (d.NUM == ran) {
                return d;
            }
            ++n2;
        }
        Show.showCriticalErrorMessageDialog("Neutral\u65b9\u5411\u304c\u9078\u3070\u308c\u3066\u3057\u307e\u3044\u307e\u3057\u305f\u3002\n@DIRECTION.getRandom8Direction()");
        return NEUTRAL;
    }

    public static DIRECTION getSum(DIRECTION ... directions) {
        int x = 0;
        int y = 0;
        DIRECTION[] dIRECTIONArray = directions;
        int n = directions.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION direction = dIRECTIONArray[n2];
            x += direction.X;
            y += direction.Y;
            ++n2;
        }
        return DIRECTION.getDirection(x, y);
    }

    public static boolean isBias(DIRECTION direction) {
        return direction.isBias();
    }

    public static List<DIRECTION> neiberDirection(DIRECTION dir) {
        ArrayList<DIRECTION> list = new ArrayList<DIRECTION>();
        switch (dir) {
            case UP: {
                list.add(UP);
                list.add(UP_LEFT);
                list.add(UP_RIGHT);
                list.add(LEFT);
                list.add(RIGHT);
                break;
            }
            case DOWN: {
                list.add(DOWN);
                list.add(DOWN_RIGHT);
                list.add(DOWN_LEFT);
                list.add(LEFT);
                list.add(RIGHT);
                break;
            }
            case LEFT: {
                list.add(LEFT);
                list.add(UP_LEFT);
                list.add(DOWN_LEFT);
                list.add(UP);
                list.add(DOWN);
                break;
            }
            case RIGHT: {
                list.add(RIGHT);
                list.add(UP_RIGHT);
                list.add(DOWN_RIGHT);
                list.add(UP);
                list.add(DOWN);
                break;
            }
            case UP_LEFT: {
                list.add(UP_LEFT);
                list.add(LEFT);
                list.add(UP);
                list.add(UP_RIGHT);
                list.add(DOWN_LEFT);
                break;
            }
            case UP_RIGHT: {
                list.add(UP_RIGHT);
                list.add(RIGHT);
                list.add(UP);
                list.add(UP_LEFT);
                list.add(DOWN_RIGHT);
                break;
            }
            case DOWN_LEFT: {
                list.add(DOWN_LEFT);
                list.add(DOWN);
                list.add(LEFT);
                list.add(UP_LEFT);
                list.add(DOWN_RIGHT);
                break;
            }
            case DOWN_RIGHT: {
                list.add(DOWN_RIGHT);
                list.add(RIGHT);
                list.add(DOWN);
                list.add(UP_RIGHT);
                list.add(DOWN_LEFT);
            }
        }
        return list;
    }

    public static DIRECTION[] values_exceptNeatral() {
        DIRECTION[] d = new DIRECTION[8];
        int i = 0;
        while (i < 8) {
            d[i] = DIRECTION.getDirectionFromRotate(i);
            ++i;
        }
        return d;
    }

    public static DIRECTION[] values_onlyBasic4() {
        DIRECTION[] d = new DIRECTION[4];
        int i = 0;
        while (i < 8) {
            d[i / 2] = DIRECTION.getDirectionFromRotate(i);
            i += 2;
        }
        return d;
    }

    public static DIRECTION[] values_onlyNANAME4() {
        DIRECTION[] d = new DIRECTION[4];
        int i = 0;
        while (i < 8) {
            d[i / 2] = DIRECTION.getDirectionFromRotate(i + 1);
            i += 2;
        }
        return d;
    }

    private DIRECTION(int num, Integer rotate, int x, int y) {
        this.NUM = num;
        this.ROTATE = rotate;
        this.X = x;
        this.Y = y;
    }

    public DIRECTION getDeNeiboringDirection() {
        return this.getNeiboringDirection(-1);
    }

    public Point getFrontPoint(Point p) {
        p.translate(this.X, this.Y);
        return p;
    }

    public int getIndexFrom0ExceptNeautral() {
        int i = this.NUM;
        if (i == 5) {
            return -1;
        }
        if (i > 5) {
            return i - 2;
        }
        return i - 1;
    }

    public DIRECTION getNeiboringDirection() {
        return this.getNeiboringDirection(1);
    }

    public DIRECTION getNeiboringDirection(int delt) {
        return DIRECTION.getDirectionFromRotate(this.ROTATE + delt);
    }

    public DIRECTION[] getNeiboringDirections3() {
        if (this.NEIBORING3[0] != null) {
            return this.NEIBORING3;
        }
        int i = 0;
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            int dif = Math.abs(this.ROTATE - d.ROTATE);
            if (dif <= 1 || dif >= 7) {
                this.NEIBORING3[i] = d;
                ++i;
            }
            ++n2;
        }
        return this.NEIBORING3;
    }

    public DIRECTION[] getNeiboringDirections5() {
        if (this.NEIBORING5[0] != null) {
            return this.NEIBORING5;
        }
        int i = 0;
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            int dif = Math.abs(this.ROTATE - d.ROTATE);
            if (dif <= 2 || dif >= 6) {
                this.NEIBORING5[i] = d;
                ++i;
            }
            ++n2;
        }
        return this.NEIBORING5;
    }

    public DIRECTION[] getNeiboringDirections8() {
        DIRECTION[] ds = new DIRECTION[8];
        int i = 0;
        while (i < ds.length) {
            ds[i] = DIRECTION.getDirectionFromRotate(this.ROTATE + i);
            ++i;
        }
        return ds;
    }

    public DIRECTION[] getNeiboringDirections8_Head() {
        DIRECTION[] ds = new DIRECTION[8];
        ds[0] = this;
        ds[7] = this.getReverse();
        int i = 1;
        while (i < 7) {
            int delt = (i + 1) / 2;
            if (i % 2 == 0) {
                delt *= -1;
            }
            ds[i] = this.getNeiboringDirection(delt);
            ++i;
        }
        return ds;
    }

    public DIRECTION getReverse() {
        DIRECTION[] dIRECTIONArray = DIRECTION.values();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            if (d.X == -this.X && d.Y == -this.Y) {
                return d;
            }
            ++n2;
        }
        return this;
    }

    public int getRotate() {
        if (this.ROTATE == null) {
            return 5;
        }
        int r = this.ROTATE - 5;
        if (r < 0) {
            r += 8;
        }
        return r;
    }

    public boolean isBias() {
        return this.X != 0 && this.Y != 0;
    }
}

