/*
 * Decompiled with CFR 0.152.
 */
package main.util;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.Base_Map;
import dangeon.view.constant.BGMFONT;
import dangeon.view.constant.NormalFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import main.res.SE;
import main.util.BeautifulView;

public class BlackOut {
    public final Task TASK;
    public final Task END_TASK;
    public final String TITLE;
    public String TITLE2 = null;
    public int time = 0;
    public final int LENGTH = 50;
    public final int HALF = 25;
    private static final ArrayList<BlackOut> LIST = new ArrayList();
    private static boolean no_se = false;

    private static synchronized void add(BlackOut b) {
        LIST.add(b);
    }

    public static synchronized boolean isEmpty() {
        return LIST.isEmpty();
    }

    public static void setNoMoveSE() {
        no_se = true;
    }

    public static synchronized void staticDraw(Graphics2D g) {
        Iterator<BlackOut> i = LIST.iterator();
        while (i.hasNext()) {
            BlackOut type = i.next();
            if (!type.draw(g)) continue;
            i.remove();
        }
    }

    public BlackOut(final Base_Map bm) {
        this(bm, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                new MassCreater(bm, null, true).createMap();
            }
        });
    }

    public BlackOut(Base_Map bm, Task task_at_mid) {
        this(bm.getTitle(), task_at_mid);
        if (bm.RANDOM_LENGTH > 0) {
            this.TITLE2 = String.valueOf(MapList.getFloor()).concat("\uff26");
        }
    }

    public BlackOut(String title, String title2, Task task_at_mid) {
        this.playSE();
        this.TITLE = title;
        this.TITLE2 = title2;
        this.TASK = task_at_mid;
        this.END_TASK = null;
        BlackOut.add(this);
    }

    public BlackOut(String title, Task task_at_mid) {
        this.playSE();
        this.TITLE = title;
        this.TASK = task_at_mid;
        this.END_TASK = null;
        BlackOut.add(this);
    }

    public BlackOut(Task middle_task) {
        this("", middle_task);
    }

    public BlackOut(Task end_task, Task task_at_mid) {
        this.TITLE2 = "";
        this.TITLE = "";
        this.TASK = task_at_mid;
        this.END_TASK = end_task;
        BlackOut.add(this);
    }

    public boolean draw(Graphics2D g) {
        Float f = new Float(Math.sin(Math.PI * (double)this.time / 50.0));
        if (f.floatValue() >= 1.0f) {
            f = Float.valueOf(1.0f);
        }
        BeautifulView.setAlphaOnImg(g, f);
        Font font = g.getFont();
        if (PresentField.get() != null && PresentField.isRandomField() && this.TITLE2 != null) {
            g.setFont(BGMFONT.FONT);
        } else {
            g.setFont(NormalFont.NORMALFONT);
        }
        this.drawFloor(g);
        if (this.time == 25) {
            if (TaskOnMapObject.isTaskTask()) {
                return false;
            }
            if (this.TASK != null) {
                this.TASK.work();
            }
        }
        g.setFont(font);
        if (this.time >= 50) {
            if (this.END_TASK != null) {
                this.END_TASK.work();
            }
            return true;
        }
        ++this.time;
        return false;
    }

    private void drawFloor(Graphics2D g) {
        g.setColor(Color.BLACK);
        int del = 30;
        g.fillRect(-del, -del, 400 + del * 2, 340 + del * 2);
        g.setColor(Color.WHITE);
        int w = g.getFontMetrics().stringWidth(this.TITLE);
        g.drawString(this.TITLE, (400 - w) / 2, 120);
        if (this.TITLE2 != null) {
            g.drawString(this.TITLE2, 200, 170);
        }
    }

    private void playSE() {
        if (no_se) {
            SE.SYSTEM_STAIR_STEP.play();
        }
        no_se = false;
    }
}

