/*
 * Decompiled with CFR 0.152.
 */
package dungeon_creater.second_ver;

import dangeon.model.config.table.EnemyDetail;
import dangeon.model.object.artifact.ArtifactData;
import dungeon_creater.second_ver.DungeonLevelControl;
import dungeon_creater.second_ver.SetObject;
import dungeon_creater.second_ver.SubBaseCreature;
import dungeon_creater.second_ver.TableMainFrame;
import dungeon_creater.second_ver.TableScene;
import dungeon_creater.second_ver.item_table.ItemTableGraphics;
import dungeon_creater.second_ver.item_table.SubItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.util.Show;

public class FileControl {
    static File FILE;
    static FileFilter csv_filter;
    static JFileChooser csv_chooser;
    static JFileChooser chooser;
    public static HashMap<Integer, ArrayList<SubBaseCreature>> map;
    public static SubItem item_table;

    static {
        csv_filter = new FileNameExtensionFilter("CSV\u30d5\u30a1\u30a4\u30eb", "csv");
        csv_chooser = FileControl.addFilter(new JFileChooser("./"));
        chooser = new JFileChooser("./");
        map = new HashMap();
        item_table = new SubItem();
    }

    static JFileChooser addFilter(JFileChooser _chooser) {
        _chooser.addChoosableFileFilter(csv_filter);
        return _chooser;
    }

    public static String getFileName() {
        if (FILE == null) {
            FileControl.readALLTable(new File("./res/table/\u30c1\u30eb\u30ce\u306e\u65c5.csv"));
        }
        return FILE.getName();
    }

    private static StringBuffer getStringWriteEnemyTable(BufferedReader bf) {
        boolean Y = false;
        StringBuffer sb = new StringBuffer();
        String category = "";
        boolean flag_enemy = false;
        boolean flag_item = false;
        int count = 0;
        try {
            String str;
            while ((str = bf.readLine()) != null) {
                if ((str = str.trim()).startsWith("ITEM")) {
                    flag_enemy = false;
                    flag_item = true;
                    sb.append(str.trim());
                    sb.append("\n");
                    continue;
                }
                if (str.startsWith("TRAP")) {
                    flag_item = false;
                    sb.append(str.trim());
                    sb.append("\n");
                    continue;
                }
                if (str.startsWith("ENEMY")) {
                    flag_enemy = true;
                    sb.append(str.trim());
                    sb.append("\n");
                    continue;
                }
                if (flag_item) {
                    if (str.startsWith("category")) {
                        String[] _s = str.split("\\.");
                        category = _s[1];
                        sb.append(str.trim());
                        sb.append("\n");
                        continue;
                    }
                    if (category.isEmpty()) continue;
                    ArtifactData[] artifactDataArray = ArtifactData.values();
                    int n = artifactDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ArtifactData ad = artifactDataArray[n2];
                        if (category.matches(ad.getCategory())) {
                            String[] stringArray = ad.items;
                            int n3 = ad.items.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String _str = stringArray[n4];
                                if (ItemTableGraphics.ME.isOn(_str)) {
                                    sb.append(_str);
                                    sb.append("\t");
                                    sb.append(ItemTableGraphics.ME.getRank(_str));
                                    sb.append("\n");
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    category = "";
                    continue;
                }
                if (!flag_enemy) {
                    sb.append(str.trim());
                    sb.append("\n");
                    continue;
                }
                if (++count > DungeonLevelControl.getDungeonMaxLevel()) continue;
                sb.append(count);
                sb.append("F");
                for (SubBaseCreature sbc : map.get(count)) {
                    sb.append("\t");
                    sb.append(sbc.C.getClass().getSimpleName());
                    sb.append(",");
                    sb.append(sbc.C.getLV());
                    sb.append(",");
                    sb.append(sbc.parcent);
                }
                sb.append("\n");
            }
            bf.close();
        }
        catch (FileNotFoundException e) {
            Show.showCriticalErrorMessageDialog("EnemyTable\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093@FileReader-EnemyTable");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb;
    }

    private static void itemTable(String str) {
        if (str.startsWith("category")) {
            return;
        }
        String[] item_sp = str.split("\t");
        item_table.add(new SubItem(item_sp[0], item_sp[1]));
    }

    public static void openAllFiles() {
    }

    public static void openFiles() {
        int select = csv_chooser.showOpenDialog(TableMainFrame.MAIN.main_panel);
        if (select == 0) {
            FileControl.readALLTable(csv_chooser.getSelectedFile());
            ItemTableGraphics.ME.setDungeon();
        }
    }

    private static void readALLTable(File file) {
        FILE = file;
        try {
            FileControl.readTable(new BufferedReader(new FileReader(file)));
            SetObject.setEnemyListDungeonLevel();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void readTable(BufferedReader bf) {
        map.clear();
        item_table.clear();
        boolean item = false;
        int Y = 0;
        try {
            String str;
            while ((str = bf.readLine()) != null) {
                ArrayList<SubBaseCreature> list = new ArrayList<SubBaseCreature>();
                if (str.startsWith("ITEM")) {
                    item = true;
                    continue;
                }
                if (str.startsWith("TRAP")) break;
                if (str.startsWith("ENEMY")) continue;
                if ((str = str.trim()).isEmpty()) break;
                if (item) {
                    FileControl.itemTable(str);
                    continue;
                }
                list.clear();
                ++Y;
                String[] floor = str.split("F\t");
                String[] strAry = floor[1].split("\t");
                int i = 0;
                while (i < strAry.length) {
                    String[] detail = strAry[i].split(",");
                    String enemy_name = detail[0];
                    int level = Integer.parseInt(detail[1]);
                    int parcent = Integer.parseInt(detail[2]);
                    list.add(new SubBaseCreature(new EnemyDetail(level, parcent, enemy_name).getBaseCreature(), parcent));
                    ++i;
                }
                map.put(Y, list);
            }
            DungeonLevelControl.setDungeonMaxLevel(Y);
            bf.close();
        }
        catch (FileNotFoundException e) {
            Show.showCriticalErrorMessageDialog("EnemyTable\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093@FileReader-EnemyTable");
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveFiles() {
        int select = csv_chooser.showSaveDialog(TableMainFrame.MAIN.main_panel);
        if (select == 0) {
            FILE = csv_chooser.getSelectedFile();
            switch (TableScene.CURRENT) {
                case ENEMY_TABLE: {
                    FileControl.writeEnemyTable();
                    break;
                }
                case ITEM_TABLE: {
                    FileControl.writeItemTable();
                }
            }
        }
    }

    public static void setMap(int level, ArrayList<SubBaseCreature> _list) {
        map.remove(level);
        map.put(level, _list);
    }

    public static void writeEnemyTable() {
        try {
            StringBuffer sb = FileControl.getStringWriteEnemyTable(new BufferedReader(new FileReader(FILE)));
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(FILE)));
            pw.print(sb.toString());
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeItemTable() {
        try {
            StringBuffer sb = FileControl.getStringWriteEnemyTable(new BufferedReader(new FileReader(FILE)));
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(FILE)));
            pw.print(sb.toString());
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

