/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.util;

import dangeon.view.constant.NormalFont;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import main.util.BeautifulView;

public class Window {
    public static final int string_y = NormalFont.ASCENT + 10;
    public static final int string_x = 10;
    public static final int string_w = NormalFont.WIDTH2 + 10;
    public static final int string_h = NormalFont.HEIGHT + 10;
    private static final int arc = 15;
    public static final Color[] WINDOW_COLOR = new Color[]{new Color(0, 0, 204), new Color(0, 0, 102)};

    public static void draw(Graphics2D g, int X, int Y, int W, int H) {
        Window.drawME(g, X, Y, W, H);
    }

    private static void drawME(Graphics2D g, int X, int Y, int W, int H) {
        g.setPaint(new GradientPaint(0.0f, Y, WINDOW_COLOR[0], 0.0f, Y + H, WINDOW_COLOR[1]));
        g.fillRoundRect(X, Y, W, H, 15, 15);
        g.setColor(new Color(0, 0, 0, 0));
        g.drawRoundRect(X, Y, W, H, 15, 15);
        int hosei = 4;
        g.drawRoundRect(X + hosei, Y + hosei, W - hosei * 2, H - hosei * 2, 15 - hosei, 15 - hosei);
        g.setColor(Color.WHITE);
        g.setStroke(new BasicStroke(3.0f));
        hosei = 2;
        g.drawRoundRect(X + hosei, Y + hosei, W - hosei * 2, H - hosei * 2, 15 - hosei, 15 - hosei);
        g.setStroke(new BasicStroke());
    }

    public static BufferedImage get(int W, int H) {
        BufferedImage bi = new BufferedImage(W, H, 3);
        Graphics2D g = bi.createGraphics();
        BeautifulView.setAntiAliasing(g, true);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(0.8f));
        Window.drawME(g, 0, 0, W, H);
        g.dispose();
        return bi;
    }

    public static int getNarrowStringY(int index) {
        return 10 + (NormalFont.HEIGHT + NormalFont.DECENT) * (index + 1) - NormalFont.DECENT;
    }

    public static int getNarrowWindowH(int length) {
        return 20 + (NormalFont.HEIGHT + NormalFont.DECENT) * length;
    }

    public static int getNarrowWindowH_SmallFont(int length) {
        return 10 + (NormalFont.SMALL_HEIGHT + NormalFont.SMALL_DECENT) * length;
    }

    public static int getSpaceWindowH(int length) {
        return 10 + (10 + NormalFont.HEIGHT) * length;
    }

    public static int getSpaceWindowW(int length) {
        return 10 + (10 + NormalFont.WIDTH2) * length;
    }

    public static int getStringX(int index) {
        return 10 + string_w * index;
    }

    public static int getStringY(int index) {
        return string_y + string_h * index;
    }
}

