/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.listener.KeyAccepter;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.PresentField;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.enchantSpecial.Composition;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.EnchantArrow;
import dangeon.model.object.creature.player.Player;
import dangeon.view.constant.BGMFONT;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.View_Sider_Info;
import dangeon.view.util.StringFilter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import main.Listener;
import main.Second_Firster;
import main.util.BeautifulView;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class View_Sider {
    private static int story = Config.getStory();
    private static int KW;
    private static int KH;
    private static BufferedImage KEY_EXPLAIN;
    private static int TW;
    private static int TH;
    private static BufferedImage TASK_EXPLAIN;
    private static String info;
    private static int information_time;

    static {
        View_Sider.setImage();
        information_time = 0;
    }

    public static void draw(Graphics2D g) {
        if (KeyAccepter.isDirecting() || Scene_Action.getMe().isMap()) {
            return;
        }
        if (!Message.isDemandToWaitAnySystem()) {
            View_Sider.drawFooter(g);
        }
        View_Sider_Info.draw(g);
    }

    private static void drawEnchant(Graphics2D g, int y, int w, int w2, int w3) {
        Base_Artifact sc;
        Enchant[] enc = new Enchant[]{Enchant.ATK, Enchant.DEF};
        int i = 0;
        while (i < enc.length) {
            Enchant en = enc[i];
            StringBuilder sb = new StringBuilder();
            sc = en.getEnchant();
            if (sc == null) {
                sb.append(en.getColor());
                sb.append("(");
                sb.append(en.toString());
                sb.append("\u306a\u3057)");
            } else {
                if (sc.isCurse()) {
                    sb.append(Base_Item.CL_CURSED);
                } else {
                    sb.append(en.getColor());
                }
                String str = sc.getName();
                if (str.startsWith("\u6a59")) {
                    str = "\u3061\u3047\u3093";
                } else if (str.startsWith("\u53e4\u660e\u5730")) {
                    str = str.substring(3);
                }
                sb.append(str.substring(0, 3));
                sb.append(StringFilter.NUMBERS);
                int forge = sc.getForgeValue();
                if (forge > 9) {
                    sb.append("+");
                    sb.append(sc.getForgeValue());
                } else if (forge > 0) {
                    sb.append("+");
                    sb.append(" ");
                    sb.append(sc.getForgeValue());
                } else if (forge < -9) {
                    sb.append(forge);
                } else if (forge < 0) {
                    sb.append(forge);
                } else {
                    sb.append(Color.GRAY);
                    sb.append("\u00b10");
                }
                sb.append(Color.WHITE);
                sb.append(Composition.compositionSimply(sc));
            }
            StringFilter.drawString_plain(g, sb.toString(), w * i + 2, y);
            ++i;
        }
        enc = Enchant.getANYS();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < enc.length) {
            Enchant en = enc[i2];
            sc = en.getEnchant();
            if (sc == null) {
                sb.append(en.getColor());
                sb.append(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(i2 + 1));
            } else if (!sc.isStaticCheked()) {
                sb.append(en.getColor());
                sb.append("\uff1f");
            } else if (sc.sim == null) {
                sb.append("\u25a1");
            } else {
                sb.append(sc.sim.getName(true));
            }
            ++i2;
        }
        StringFilter.drawString_plain(g, sb.toString(), 400 - w2 - w3, y);
        sb = new StringBuilder();
        sb.append(Color.WHITE);
        if (EnchantArrow.getArrow() == null) {
            sb.append("(\u5c04\u6483\u306a\u3057)");
        } else {
            sb.append(EnchantArrow.getArrow().name());
        }
        StringFilter.drawString_plain(g, sb.toString(), 400 - w3 + 2, y);
    }

    private static void drawEnchants(Graphics2D g, int y, int h) {
        if (Config.isKey_ex() && Message.ME.isEmpty()) {
            g.setColor(new Color(0, 0, 0, 125));
            g.fillRect(0, y, 400, h * 2);
        }
        int w2 = 22;
        int w3 = 54;
        int w = (400 - w2 - w3) / 2;
        g.setColor(new Color(250, 0, 0, 200));
        g.fillRect(0, 340 - h, w, h);
        g.setColor(new Color(250, 150, 0, 200));
        g.fillRect(w, 340 - h, w, h);
        g.setColor(new Color(0, 250, 250, 200));
        g.fillRect(400 - w3 - w2, 340 - h, w2, h);
        g.setColor(new Color(0, 250, 0, 200));
        g.fillRect(400 - w3, 340 - h, w3, h);
        g.setColor(Color.WHITE);
        View_Sider.drawEnchant(g, 339, w, w2, w3);
    }

    private static void drawFooter(Graphics2D g) {
        if (!Scene_Action.getMe().isCurrentScene()) {
            return;
        }
        Message.ME.isEmpty();
        if (Scene_Action.getMe().isDirecting()) {
            BeautifulView.setAlphaOnImg(g, Float.valueOf(0.3f));
        }
        Font font = g.getFont();
        g.setFont(NormalFont.NORMALFONT.deriveFont(10.0f));
        int h = 11;
        int y = 340 - h * 3;
        View_Sider.drawEnchants(g, y, h);
        if (Config.isKey_ex() && Message.ME.isEmpty()) {
            View_Sider.drawKey(g, y - 1);
        }
        if (Config.isLapON() && PresentField.isRandomField()) {
            View_Sider.drawTimer(g, y, h);
        }
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        g.setFont(font);
    }

    private static void drawKey(Graphics2D g, int y) {
        Listener.ACTION[] actions = new Listener.ACTION[]{Listener.ACTION.ENTER, Listener.ACTION.MENU, Listener.ACTION.FIRE, Listener.ACTION.IDASH, Listener.ACTION.MAP, Listener.ACTION.TURN, Listener.ACTION.BIAS, Listener.ACTION.MOVE};
        Listener.ACTION[] actions2 = new Listener.ACTION[]{Listener.ACTION.REST, Listener.ACTION.ITEM, Listener.ACTION.GATHER, Listener.ACTION.SPEC, Listener.ACTION.SYMBOL, Listener.ACTION.RECORD, Listener.ACTION.BIAS, Listener.ACTION.DASH};
        boolean[] color = new boolean[actions.length];
        boolean flag_x = Scene_Action.getMe().isDushKeyPushing();
        String[] ex = new String[actions.length];
        int i = 0;
        while (i < actions.length) {
            Listener.ACTION a = actions[i];
            StringBuilder sb = new StringBuilder();
            if (a == Listener.ACTION.MOVE) {
                String s;
                switch (Scene_Action.getMe().getDirection()) {
                    case DOWN: {
                        s = "\u2193";
                        break;
                    }
                    case DOWN_LEFT: {
                        s = "_ ";
                        break;
                    }
                    case DOWN_RIGHT: {
                        s = " _";
                        break;
                    }
                    case LEFT: {
                        s = "\u2190";
                        break;
                    }
                    case RIGHT: {
                        s = "\u2192";
                        break;
                    }
                    case UP: {
                        s = "\u2191";
                        break;
                    }
                    case UP_LEFT: {
                        s = "^ ";
                        break;
                    }
                    case UP_RIGHT: {
                        s = " ^";
                        break;
                    }
                    default: {
                        s = "\u30fb";
                    }
                }
                sb.append(s);
                sb.append(":");
                a = flag_x ? actions2[i] : actions[i];
                sb.append(a.SHORT_EX);
                color[i] = Scene_Action.getMe().KH.isDirecting();
            } else {
                String key = null;
                for (int keys : Listener.getKey().keySet()) {
                    if (a != Listener.getKey().get(keys)) continue;
                    String text = KeyEvent.getKeyText(keys);
                    if (keys == 10 || keys == 27) continue;
                    text = text.length() > 2 ? text.substring(0, 2) : \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u82f1\u5b57(text);
                    key = text;
                    break;
                }
                if (key == null && a == Listener.ACTION.ENTER) {
                    key = "En";
                }
                sb.append(key);
                a = flag_x ? actions2[i] : actions[i];
                sb.append(":");
                if (a == Listener.ACTION.SPEC) {
                    if (PresentField.get().isEnemyEnchantDungeon()) {
                        sb.append("\u6575\u88c5\u5099");
                    } else {
                        sb.append(a.SHORT_EX);
                    }
                } else {
                    sb.append(a.SHORT_EX);
                }
                color[i] = View_Sider.is(actions[i]);
            }
            ex[i] = sb.toString();
            ++i;
        }
        int cols = 4;
        int rows = 2;
        int X_DELT = 85;
        int X = 84;
        int h = g.getFontMetrics().getHeight();
        int index = 0;
        while (index < ex.length) {
            int j = index % 2;
            String name = ex[index];
            int x = 84 + 85 * (index / 2);
            int _y_ = y + h * (j + 1);
            View_Sider.drawKeyContent(g, name, x, _y_, h, flag_x, color[index]);
            ++index;
        }
        String key = null;
        for (int keys : Listener.getKey().keySet()) {
            if (Listener.ACTION.CANCEL != Listener.getKey().get(keys)) continue;
            String text = KeyEvent.getKeyText(keys);
            if (keys == 27) continue;
            text = text.length() > 2 ? text.substring(0, 2) : \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u82f1\u5b57(text);
            key = text;
            break;
        }
        if (key == null) {
            key = "Es";
        }
        View_Sider.drawKeyContent(g, key.concat(":\u7d44\u307f\u5408\u308f\u305b"), 2, y + h, h, flag_x, View_Sider.is(Listener.ACTION.CANCEL));
    }

    private static void drawKeyContent(Graphics2D g, String name, int x, int y, int h, boolean flag_x, boolean b) {
        Color c = !flag_x && !b ? Color.LIGHT_GRAY : (b ? Color.YELLOW : Color.MAGENTA);
        StringFilter.drawString(g, c.toString().concat(name), x, y);
    }

    private static void drawTimer(Graphics2D g, int y, int height) {
        StringBuilder sb = new StringBuilder();
        long t = Player.me.getPlayingMilliTime();
        boolean h = false;
        if ((t /= 1000L) > 3600L) {
            sb.append(Color.ORANGE);
            sb.append(t / 3600L);
            t -= t / 3600L * 3600L;
            sb.append("h");
            h = true;
        }
        sb.append(Color.RED);
        if (h || t > 60L) {
            if (h && t / 60L < 10L) {
                sb.append("0");
            }
            sb.append(t / 60L);
            t -= t / 60L * 60L;
            sb.append("m");
        }
        sb.append(Color.YELLOW);
        if (t < 10L) {
            sb.append("0");
        }
        sb.append(t);
        sb.append("s");
        sb.append(Color.lightGray);
        t = Player.me.getPlayingMilliTime();
        t -= t / 1000L * 1000L;
        if (t < 10L) {
            sb.append("00");
        } else if (t < 100L) {
            sb.append("0");
        }
        sb.append(t);
        View_Sider.drawKeyContent(g, sb.toString(), 2, y + height * 2, height, true, View_Sider.is(Listener.ACTION.CANCEL));
    }

    private static String[] getExplain() {
        StringBuilder sb = new StringBuilder();
        if (View_Sider.getStory() >= 10) {
            sb.append("\uff5eKeyTips\uff5e,");
            if (View_Sider.getStory() >= 70) {
                sb.append("\uff3a\uff1a\u6c7a\u5b9a\uff08\u653b\u6483\uff0f\u8a71\u3057\u304b\u3051\u308b\uff09,");
            } else {
                sb.append("\uff3a\uff1a\u6c7a\u5b9a\uff08\u8a71\u3057\u304b\u3051\u308b\uff09,");
            }
        } else {
            return null;
        }
        if (View_Sider.getStory() >= 20) {
            sb.append("\uff38\uff1a\u62bc\u3057\u3063\u3071\u3067\u30c0\u30c3\u30b7\u30e5,");
        }
        if (View_Sider.getStory() >= 40) {
            sb.append("\uff36\uff1a\u30e1\u30cb\u30e5\u30fc\u3092\u958b\u304f,");
        }
        if (View_Sider.getStory() >= 50) {
            sb.append("\uff23\uff1a\u30df\u30cb\u30de\u30c3\u30d7\u8868\u793a,");
        }
        if (View_Sider.getStory() >= 80) {
            sb.append("Shift\uff0fSpace\uff1a\u65b9\u5411\u6307\u5b9a,");
        }
        if (View_Sider.getStory() >= 100) {
            sb.append("Ctrl\uff1a\u659c\u3081\u5236\u9650,");
        }
        if (View_Sider.getStory() >= 110) {
            sb.append("\uff26\uff1a\u5c04\u6483,");
        }
        if (View_Sider.getStory() >= 150) {
            sb.append("\u203b\uff38\u4e2d\u306b\uff3a\u3067\u30bf\u30fc\u30f3\u9001\u308a");
        }
        return sb.toString().split(",");
    }

    private static int getStory() {
        return Config.getStory();
    }

    private static String getTask() {
        return null;
    }

    private static boolean is(Listener.ACTION a) {
        return Scene_Action.getMe().KH.isContraining(a);
    }

    private static void setImage() {
        View_Sider.setTaskImage();
        String[] ex = View_Sider.getExplain();
        if (ex == null) {
            KH = 1;
            KW = 1;
            KEY_EXPLAIN = new BufferedImage(KW, KH, 3);
            return;
        }
        int width = 0;
        Font font = NormalFont.NORMALFONT.deriveFont(13.0f);
        FontMetrics fo = Second_Firster.ME.getFontMetrics(font);
        String[] stringArray = ex;
        int n = ex.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            width = Math.max(width, fo.stringWidth(s));
            ++n2;
        }
        int height = (BGMFONT.HEIGHT + BGMFONT.DECENT) * ex.length + BGMFONT.DECENT;
        KEY_EXPLAIN = new BufferedImage(width * 2, height * 2, 3);
        Graphics2D g = KEY_EXPLAIN.createGraphics();
        g.setFont(font);
        BeautifulView.setAntiAliasing(g, true);
        g.scale(2.0, 2.0);
        int i = 0;
        while (i < ex.length) {
            String str = ex[i];
            g.drawString(str, 0, BGMFONT.HEIGHT * (i + 1));
            ++i;
        }
        KW = width;
        KH = height;
        story = Config.getStory();
    }

    public static void setInformation(String ... msg) {
        View_Sider_Info.setInformation(msg);
    }

    private static void setTaskImage() {
        boolean flag;
        boolean bl = flag = information_time == 0;
        if (flag) {
            info = View_Sider.getTask();
        }
        if (info == null) {
            TH = 1;
            TW = 1;
            TASK_EXPLAIN = new BufferedImage(TW, TH, 3);
            return;
        }
        String head = flag ? "\uff5eNextTask\uff5e@" : "@";
        String[] ex = head.concat(info).split("@");
        int width = 0;
        Font font = NormalFont.NORMALFONT.deriveFont(13.0f);
        FontMetrics fo = Second_Firster.ME.getFontMetrics(font);
        String[] stringArray = ex;
        int n = ex.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            width = Math.max(width, fo.stringWidth(s));
            ++n2;
        }
        int height = (BGMFONT.HEIGHT + BGMFONT.DECENT) * ex.length + BGMFONT.DECENT;
        TASK_EXPLAIN = new BufferedImage(width * 2, height * 2, 3);
        Graphics2D g = TASK_EXPLAIN.createGraphics();
        g.setFont(font);
        BeautifulView.setAntiAliasing(g, true);
        g.scale(2.0, 2.0);
        fo = g.getFontMetrics();
        int i = 0;
        while (i < ex.length) {
            String str = ex[i];
            StringFilter.drawString(g, str, width - fo.stringWidth(StringFilter.getPlainString(str)), BGMFONT.HEIGHT * (i + 1));
            ++i;
        }
        TW = width;
        TH = height;
    }
}

