/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.listener.menu.Base_MenuItem;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.Item;
import dangeon.view.detail.View_Cursor;
import dangeon.view.util.StringFilter;
import dangeon.view.util.Window;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class View_Select_Item {
    public static final int W = Item.W;
    public static final int H = Item.H;
    public static final int SCREEN_X;
    public static final int SCREEN_Y;
    public static final int margine = 1;
    private static final Image ITEM_WINDOW;
    private static final Image EXPLANATION_WINDOW;
    private static final int Y_HOSEI = 8;
    private static final int MINI_EXPLANATION_MAX_LENGTH = 4;

    static {
        ITEM_WINDOW = Item.ITEM_WINDOW;
        EXPLANATION_WINDOW = Item.MINI_EXPLANATION_WINDOW;
        SCREEN_X = 25;
        SCREEN_Y = 30;
    }

    public static void draw(Graphics2D g) {
        View_Select_Item.drawItemWindow(g);
        View_Select_Item.drawItems(g);
        View_Select_Item.drawExplain(g);
        View_Select_Item.drawTitle(g);
    }

    private static void drawBelongingItemName(Graphics2D g, int index, int y, int h) {
        Base_Artifact a = Base_MenuItem.getNow().get(index);
        if (a == null) {
            return;
        }
        int x = SCREEN_X + 10;
        g.drawImage(a.getImage(), x - h / 2, y - h * 3 / 2, h * 2, h * 2, null);
        StringFilter.drawString(g, a.getColoredName(false), x + h, y);
        if (Base_MenuItem.getNow().get(index).isEnchantedNow()) {
            g.drawString("E", x - 2, y - 2);
        }
    }

    private static void drawExplain(Graphics2D g) {
        View_Select_Item.drawExplanation(g, SCREEN_X, SCREEN_Y + H + 1);
    }

    private static void drawExplanation(Graphics2D g, int X, int Y) {
        if (Base_MenuItem.getNow().IS_EMPTY) {
            return;
        }
        Base_Artifact a = Base_MenuItem.getNow().get();
        if (a == null) {
            return;
        }
        String[] arr = a.firstPageExplain();
        g.drawImage(EXPLANATION_WINDOW, X, Y, null);
        g.setFont(g.getFont().deriveFont(14.0f));
        int times = arr.length;
        if (arr.length > 4) {
            times = 4;
        }
        int x = X + 10;
        int i = 0;
        while (i < times) {
            int y = Y + 5 + (NormalFont.SMALL_HEIGHT + 1) * (i + 1) - 1;
            StringFilter.drawString(g, arr[i], x, y);
            ++i;
        }
        g.setFont(NormalFont.NORMALFONT);
    }

    private static void drawItem(Graphics2D g, int i, int j) {
        int y = SCREEN_Y + Window.getNarrowStringY(j);
        View_Select_Item.drawBelongingItemName(g, i, y, NormalFont.HEIGHT);
    }

    private static void drawItems(Graphics2D g) {
        if (Base_MenuItem.getNow().IS_EMPTY) {
            int x = SCREEN_X + 10;
            int h = NormalFont.HEIGHT;
            int y = SCREEN_Y + Window.getNarrowStringY(0);
            StringFilter.drawString(g, "\u2015\u5019\u88dc\u304c\u306a\u3044\u2015", x + h, y);
            return;
        }
        int i = Base_MenuItem.getNow().getPage() * 10;
        int j = 0;
        while (i < Base_MenuItem.getNow().getSize() && j < 10) {
            View_Select_Item.drawItem(g, i, j);
            ++i;
            ++j;
        }
        int x = SCREEN_X + 10;
        int y = SCREEN_Y + 10 + (NormalFont.HEIGHT + NormalFont.DECENT) * (Base_MenuItem.getNow().getY() + 1) - NormalFont.DECENT;
        View_Cursor.draw(g, x, y, true);
    }

    private static void drawItemWindow(Graphics2D g) {
        int x = SCREEN_X + W / 2 - NormalFont.WIDTH2 / 2;
        g.drawImage(ITEM_WINDOW, SCREEN_X, SCREEN_Y, null);
        int page = Base_MenuItem.getNow().getPage() + 1;
        String s = \u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(page);
        int m = 4;
        if (page > 9) {
            m += g.getFontMetrics().stringWidth(s.substring(1));
        }
        g.drawString(s, x - 10 - 1 - m, SCREEN_Y + H);
        g.drawString("\uff0f", x, SCREEN_Y + H);
        g.drawString(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(Base_MenuItem.getNow().getMaxPage()), x + 10 + 1, SCREEN_Y + H);
    }

    private static void drawTitle(Graphics2D g) {
        BufferedImage im = Base_MenuItem.getNow().TITLE_IMAGE;
        if (im == null) {
            return;
        }
        int x = SCREEN_X;
        int y = SCREEN_Y - im.getHeight() * 2 / 3;
        g.drawImage((Image)im, x, y, null);
        g.drawString(Base_MenuItem.getNow().TITLE, x + 10, y + 5 + NormalFont.HEIGHT - 2);
    }
}

