/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.MainSystem;
import dangeon.controller.TaskOnMapObject;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.Config;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.map.StairScene;
import dangeon.model.object.Base_MapObject;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.device.Base_Device;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.arrow.Arrow;
import dangeon.model.object.artifact.item.bullet.Base_Bullet;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u7f60\u5e2b;
import dangeon.model.object.artifact.trap.Base_Trap;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.enemy.\u308f\u304b\u3055\u304e\u59eb;
import dangeon.model.object.creature.enemy.\u6d29\u77e2\u8acf\u8a2a\u5b50;
import dangeon.model.object.creature.enemy.\u98a8\u898b\u5e7d\u9999;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.Stand;
import dangeon.util.MergeSort;
import dangeon.util.ObjectPoint;
import dangeon.view.anime.Base_Anime;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.MiniMap;
import dangeon.view.detail.name.MainMap_Name;
import dangeon.view.util.StringFilter;
import dangeon.view.util.WithinOutofScreen;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import main.res.CHARA_IMAGE;
import main.res.Image_Effect;
import main.res.Image_MapTip;
import main.thread.MainThread;
import main.util.BeautifulView;
import main.util.DIRECTION;
import main.util.EX_DIRECTION;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class MainMap {
    private static final List<Base_Anime> list_effect = new ArrayList<Base_Anime>();
    private static ArrayList<Base_Creature> animating_creature_list = new ArrayList();
    public static final HashMap<EX_DIRECTION, Integer> wall_map = new HashMap();
    public static Color[] shadow;
    private static double grid_time;
    private static BufferedImage base_image;
    private static final Area SCREEN;

    static {
        wall_map.put(EX_DIRECTION.UP_LEFT, 0);
        wall_map.put(EX_DIRECTION.LEFT, 1);
        wall_map.put(EX_DIRECTION.DOWN_LEFT, 2);
        wall_map.put(EX_DIRECTION.UP, 3);
        wall_map.put(EX_DIRECTION.NEUTRAL, 4);
        wall_map.put(EX_DIRECTION.DOWN, 5);
        wall_map.put(EX_DIRECTION.UP_RIGHT, 6);
        wall_map.put(EX_DIRECTION.RIGHT, 7);
        wall_map.put(EX_DIRECTION.DOWN_RIGHT, 8);
        wall_map.put(EX_DIRECTION.ELSE, 9);
        shadow = new Color[]{new Color(0, 0, 0), new Color(100, 0, 100), new Color(100, 100, 0), new Color(100, 0, 0)};
        grid_time = 0.0;
        SCREEN = new Area(new Rectangle2D.Double(-50.0, -50.0, 500.0, 440.0));
    }

    public static synchronized void addEffect(Base_Anime e) {
        list_effect.add(e);
    }

    public static synchronized void addEffect(Base_Anime e, boolean b) {
        if (b) {
            MainSystem.addDemandForWaitUntilRemoved(e, list_effect);
        }
        MainMap.addEffect(e);
    }

    public static void draw(Graphics2D g) {
        MainMap.drawMap(g);
        MainMap.drawGrid(g);
        MainMap.drawMapObject(g);
        MainMap.drawAnimatingCreature(g);
        MainMap.drawSpot(g);
        MainMap.drawEffect(g);
    }

    private static void drawAnimatingCreature(Graphics2D g) {
        Iterator<Base_Creature> iterator = animating_creature_list.iterator();
        while (iterator.hasNext()) {
            Base_Creature c = iterator.next();
            if (c.getAnimation() == null) {
                iterator.remove();
                continue;
            }
            Base_Anime anime = c.getAnimation();
            boolean animating = c.getAnimation().drawAnime(g);
            if (anime != c.getAnimation() || animating) continue;
            c.finshAnimation();
            iterator.remove();
        }
    }

    private static void drawArtifacts(Graphics2D g, boolean jumping) {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>(MapList.getListArtifact().size());
        for (Base_Artifact a : MapList.getListArtifact()) {
            if (jumping != a.isJumping() || !MassCreater.getMass((Point)a.getMassPoint()).WALKABLE) continue;
            list.add(a);
        }
        ArrayList<Base_Artifact> order = jumping ? MergeSort.creatureY(list) : list;
        for (Base_Artifact a : order) {
            if (jumping != a.isJumping()) continue;
            Mass m = MassCreater.getMass(a.getMassPoint());
            if (!MainMap.isVisible(a)) continue;
            Point p = ObjectPoint.getScreenPointRelPlayer(a);
            int y = p.y;
            boolean flag = false;
            if (!jumping && m.WATER) {
                flag = true;
            }
            int size = 18;
            if (!flag && !Config.isNoShadow() && a.getShadow() > 0) {
                int awa = a.jumped_away_y;
                if (a.isJumping()) {
                    size += awa / 3;
                }
                MainMap.drawShadow(g, size, p.x, y + 6 - awa, a.getShadow());
            }
            if (flag) {
                BeautifulView.setAlphaOnImg(g, Float.valueOf(0.3f));
            }
            g.drawImage(a.getImage(), p.x, y, null);
            if (!flag) continue;
            BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        }
    }

    private static void drawCreatures(Graphics2D g, boolean name) {
        ArrayList<Base_Creature> list = new ArrayList<Base_Creature>();
        ArrayList<Base_Creature> jumping_list = new ArrayList<Base_Creature>();
        for (Base_Enemy e : MapList.getListEnemy()) {
            list.add(e);
        }
        if (!name) {
            list.add(Player.me);
        }
        MainMap.ignoreCreature(list, jumping_list);
        List<Base_Creature> order = MergeSort.creatureY(list);
        if (name) {
            for (Base_Creature c : order) {
                MainMap_Name.drawName(c);
            }
            for (Base_Creature c : jumping_list) {
                MainMap_Name.drawName(c);
            }
            MainMap_Name.drawName(g);
        } else {
            for (Base_Creature c : order) {
                MainMap.drawCreatureShadow(g, c);
            }
            for (Base_Creature c : jumping_list) {
                MainMap.drawCreatureShadow(g, c);
            }
            for (Base_Creature c : order) {
                c.drawCreature(g);
            }
            if (Player.me.isStandExist()) {
                ListIterator<Stand> li = Player.me.getListIterator();
                while (li.hasNext()) {
                    Stand s = li.next();
                    Point p = ObjectPoint.getScreenPointRelPlayer(s.SCREEN_X, s.SCREEN_Y);
                    int x = p.x;
                    int y = p.y;
                    if (s.E.getSize() == 100) {
                        g.drawImage(s.getImage(g), x + s.getFootX(), y + s.getFootY(), null);
                        continue;
                    }
                    int size = s.E.getSize();
                    Image bi = s.getImage(g);
                    int w = bi.getWidth(null) * size / 100;
                    int h = bi.getHeight(null) * size / 100;
                    g.drawImage(bi, x + s.getFootX(), y + s.getFootY(), w, h, null);
                }
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
            }
            for (Base_Creature c : jumping_list) {
                c.drawCreature(g);
            }
        }
    }

    private static void drawCreatureShadow(Graphics2D g, Base_Creature c) {
        Point p = ObjectPoint.getScreenPointRelPlayer(c);
        int x = p.x;
        int y = p.y + 2;
        int size = c.getShadowSize();
        if (c.isJumping() && c.jumped_away_y < 0) {
            size += c.jumped_away_y / 15;
        }
        if (MassCreater.getMass((Point)c.getMassPoint()).WATER && !c.isFlying()) {
            if (c.isBoating()) {
                if (!(c instanceof \u6d29\u77e2\u8acf\u8a2a\u5b50) && !(c instanceof \u98a8\u898b\u5e7d\u9999)) {
                    Image im = CHARA_IMAGE.\u8239.getWalkImage(0, c.getDirection(), 1.0f);
                    int width = im.getWidth(null);
                    int height = im.getHeight(null);
                    g.drawImage(im, x + 25 - width / 2, y - height / 2 + 30, null);
                    return;
                }
            } else if (c instanceof \u308f\u304b\u3055\u304e\u59eb) {
                return;
            }
        } else if (c == Player.me) {
            if (Player.me.isDying() || StairScene.isTasksEmpty()) {
                BeautifulView.setAlphaOnImg(g, Float.valueOf(Player.me.getDyingAlpha()));
                MainMap.drawShadow(g, size, x, y, c.getShadowY() + c.jumped_away_y, c);
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
                return;
            }
            if (Player.me.isFalling()) {
                return;
            }
        }
        if (MassCreater.getMass((Point)c.getMassPoint()).WALKABLE) {
            MainMap.drawShadow(g, size, x, y, c.getShadowY() + c.jumped_away_y, c);
        }
    }

    private static synchronized void drawEffect(Graphics2D g) {
        Iterator<Base_Anime> iterator = list_effect.iterator();
        while (iterator.hasNext()) {
            Base_Anime e = iterator.next();
            if (e.drawAnime(g)) continue;
            iterator.remove();
        }
    }

    private static void drawGrid(Graphics2D g) {
        Point p = Player.me.getPureScreenPoint().getLocation();
        Point _P = Player.me.getMassPoint();
        p.translate(-_P.x * 50, -_P.y * 50);
        if (!Config.isMass_OFF()) {
            MainMap.drawGrid_Mass(g, p, _P);
        }
        if (!Player.me.isAnimating()) {
            MainMap.drawGrid_DIRECTION(g, p, _P);
        }
    }

    private static void drawGrid_DIRECTION(Graphics2D g, Point p, Point _P) {
        ArrayList<DIRECTION> ds = new ArrayList<DIRECTION>(5);
        if (Scene_Action.getMe().isDirecting() || Scene_Action.getMe().isBiasButtonPushing()) {
            if (Config.isMass_OFF()) {
                MainMap.drawGrid_Mass(g, p, _P);
            }
            grid_time += 0.4;
            if (Scene_Action.getMe().isDirecting()) {
                ds.add(Player.me.getDirection());
            }
            if (Scene_Action.getMe().isBiasButtonPushing()) {
                DIRECTION[] dIRECTIONArray = DIRECTION.values_onlyNANAME4();
                int n = dIRECTIONArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DIRECTION d = dIRECTIONArray[n2];
                    ds.add(d);
                    ++n2;
                }
            }
        } else {
            grid_time = 0.0;
        }
        for (DIRECTION d : ds) {
            Point point = Player.me.getMassPoint().getLocation();
            ArrayList<Base_Creature> list = new ArrayList<Base_Creature>(4);
            int i = 0;
            while (i < 4) {
                point.translate(d.X, d.Y);
                Base_Creature c = MapList.getCreature(point);
                if (c != null) {
                    list.add(c);
                }
                ++i;
            }
            MainMap.ignoreCreature(list, null);
            point = Player.me.getMassPoint().getLocation();
            i = 0;
            while (i < 5) {
                int _x = (point.x - _P.x + 4) * 50 - 25 - p.x;
                int _y = (point.y - _P.y + 3) * 50 - p.y;
                int size = 49;
                int alpha = (int)Math.floor(Math.cos(grid_time) * 100.0) + 150;
                boolean flag_enemy = false;
                for (Base_Creature c : list) {
                    if (!c.getMassPoint().equals(point)) continue;
                    flag_enemy = true;
                    break;
                }
                if (flag_enemy) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(new Color(255, 255, 255, alpha));
                }
                g.drawRect(_x, _y, size, size);
                point.translate(d.X, d.Y);
                ++i;
            }
        }
    }

    private static void drawGrid_Mass(Graphics2D g, Point p, Point _P) {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 7) {
                int size;
                int _y;
                int _x;
                int x = _P.x + i - 4;
                int y = _P.y + j - 3;
                Mass m = MassCreater.getMass(x, y);
                if (m.WALKABLE) {
                    _x = (x - _P.x + 4) * 50 - 25 - p.x;
                    _y = (y - _P.y + 3) * 50 - p.y;
                    size = 49;
                    m.drawGrid(g, _x, _y, size);
                }
                if (MapList.isArtifact(x, y)) {
                    _x = (x - _P.x + 4) * 50 - 25 - p.x + 3;
                    _y = (y - _P.y + 3) * 50 - p.y + 3;
                    size = 43;
                    Base_Artifact a = MapList.getArtiface(x, y);
                    if (MainMap.isVisible(a)) {
                        if (a instanceof Base_Item) {
                            Color c = a.isPunishment() ? MiniMap.C_GOLDSTAIR : (((Base_Item)a).isPickCheked() ? MiniMap.C_ARTIFACT_CHECKED : MiniMap.C_ARTIFACT);
                            if (MassCreater.getMass((Point)a.getMassPoint()).WATER) {
                                c = c.darker();
                            }
                            g.setColor(c);
                            g.drawOval(_x, _y, size, size);
                        } else if (a instanceof Base_Trap) {
                            g.setColor(MiniMap.C_TRAP);
                            g.drawLine(_x, _y, _x + size, _y + size);
                            g.drawLine(_x + size, _y, _x, _y + size);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private static void drawGrid_old(Graphics2D g) {
        int alpha;
        if (Scene_Action.getMe().isDirecting()) {
            g.setColor(new Color(0, 0, 0));
            int i = 0;
            while (i < 9) {
                int x = 50 * i - 25;
                g.drawLine(x, 0, x, 340);
                ++i;
            }
            int j = 0;
            while (j < 7) {
                int y = 50 * j;
                g.drawLine(0, y, 400, y);
                ++j;
            }
        }
        if (Scene_Action.getMe().isDirecting() || Scene_Action.getMe().isBiasButtonPushing()) {
            alpha = (int)Math.floor((Math.cos(grid_time += 0.3) + 1.0) * 90.0) + 50;
            Color col = new Color(200, 200, 255, alpha);
            Color col_red = new Color(255, 0, 0, alpha);
            int x = Player.me.getMassPoint().x;
            int y = Player.me.getMassPoint().y;
            if (Scene_Action.getMe().isBiasButtonPushing()) {
                g.setColor(col);
                int i = 0;
                while (i < 9) {
                    int j = 0;
                    while (j < 7) {
                        if (i == j + 1 || 8 - i == j + 1) {
                            boolean flag;
                            boolean bl = flag = !MainMap.isOutofPlayerSight(MapList.getEnemy(x + i - 4, y + j - 3));
                            if (flag) {
                                g.setColor(col_red);
                            }
                            g.drawRect(50 * i - 25, 50 * j, 50, 50);
                            if (flag) {
                                g.setColor(col);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                alpha += 20;
                g.setColor(col);
                DIRECTION d = Player.me.getDirection();
                int i = 0;
                while (i < 5) {
                    boolean flag;
                    boolean bl = flag = !MainMap.isOutofPlayerSight(MapList.getEnemy(x + i * d.X, y + i * d.Y));
                    if (flag) {
                        g.setColor(col_red);
                    }
                    g.drawRect(50 * (4 + i * d.X) - 25, 50 * (3 + i * d.Y), 50, 50);
                    if (flag) {
                        g.setColor(col);
                    }
                    ++i;
                }
            }
        } else if (Scene_Action.getMe().isBiasButtonPushing()) {
            alpha = (int)(Math.floor(Math.cos(grid_time += 0.01) + 1.0) * 100.0);
            g.setColor(new Color(0, 0, 0, alpha));
            int i = 0;
            while (i < 9) {
                int j = 0;
                while (j < 7) {
                    g.drawRect(50 * (4 + i) - 25, 50 * (3 + j), 50, 50);
                    ++j;
                }
                ++i;
            }
        } else {
            grid_time = 0.0;
        }
    }

    private static void drawMap(Graphics2D g) {
        int out = 0;
        int x = Player.me.getPureScreenPoint().x + (1 + out) * 50 - 25;
        int y = Player.me.getPureScreenPoint().y + (0 + out) * 50;
        g.drawImage((Image)base_image.getSubimage(x, y, 400, 340), 0, 0, null);
        MainMap.drawMap_Waters(g);
    }

    private static void drawMap_Waters(Graphics2D g) {
        Font font = g.getFont();
        g.setFont(font.deriveFont(50.0f));
        Mass[][] massArray = MassCreater.getMass();
        int n = massArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mass[] ms;
            Mass[] massArray2 = ms = massArray[n2];
            int n3 = ms.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean flag_B;
                Mass m = massArray2[n4];
                boolean flag_A = m.WATER_LEEF;
                boolean bl = flag_B = m.isWarning() && !m.isTrapChecked();
                if ((flag_A || flag_B) && !WithinOutofScreen.isOutside(m.X, m.Y, 50, 50) && !MainMap.isOutofPlayerSight(m.getPoint())) {
                    Point p = ObjectPoint.getDangeonScreenPoint(m.getPoint());
                    p = ObjectPoint.getScreenPointRelPlayer(p);
                    if (m.isWarning() && flag_B) {
                        int delt;
                        int s = 50;
                        int a = (int)(75.0 * Math.sin((double)(MainThread.getFrame() * 4) * Math.PI / 36.0)) + 100;
                        if (m.isWarningLarge(false)) {
                            g.setColor(new Color(255, 255, 0, a));
                            if (m.isWarningLarge(true)) {
                                g.drawString("\uff01", p.x, p.y + 43);
                            } else {
                                g.drawRect(p.x, p.y, s, s);
                                delt = s / 4;
                                g.drawRect(p.x + delt, p.y + delt, s - delt * 2, s - delt * 2);
                            }
                        } else if (m.isWarningSmall(false)) {
                            g.setColor(new Color(255, 0, 0, a));
                            if (m.isWarningSmall(true)) {
                                g.drawString("\uff01", p.x, p.y + 43);
                            } else {
                                g.drawRect(p.x, p.y, s, s);
                                delt = s / 4;
                                g.drawRect(p.x + delt, p.y + delt, s - delt * 2, s - delt * 2);
                            }
                        }
                    }
                    if (flag_A) {
                        g.drawImage((Image)(m.FLOWER ? Image_Effect.hasu_.BI[1] : Image_Effect.ha_.BI[0]), p.x, p.y, null);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        g.setFont(font);
    }

    private static void drawMapObject(Graphics2D g) {
        MainMap.drawArtifacts(g, false);
        MainMap.drawCreatures(g, false);
        MainMap.drawArtifacts(g, true);
        if (Scene_Action.getMe().isNamePushing()) {
            MainMap.drawCreatures(g, true);
        } else {
            MainMap_Name.set(false);
        }
        MainMap.drawThrowing(g);
    }

    private static void drawName(Graphics2D g, Base_Creature c) {
        Point p = ObjectPoint.getScreenPointRelPlayer(c);
        int x = p.x;
        int y = p.y;
        if (c.isJumping()) {
            y += c.getJumpDY();
        }
        int size = 14;
        g.setFont(NormalFont.NORMALFONT.deriveFont((float)size));
        if (c instanceof Base_Enemy && !(c instanceof Base_NPC)) {
            g.setColor(Color.WHITE);
            String lv = c.getLV() == 4 ? "ANOTHER" : "Lv".concat(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(c.getLV()));
            StringFilter.drawEdgedString_plain(g, lv, x, y + c.getFootY() + 50 - (size + 1) / 3);
        }
        g.setColor(Color.WHITE);
        StringFilter.drawEdgedString(g, c.getColoredName(), x, y + c.getFootY() + 50 + size + 1 - (size + 1) / 3);
        g.setFont(NormalFont.NORMALFONT);
    }

    private static void drawShadow(Graphics2D g, int width, int x, int y, int y_dif) {
        MainMap.drawShadow(g, width, x, y, y_dif, false);
    }

    public static void drawShadow(Graphics2D g, int width, int x, int y, int y_dif, Base_Creature c) {
        if (c.isBeatedAway()) {
            return;
        }
        if (!c.conditionCheck(CONDITION.\u90aa\u6cd5) || MainThread.getFrame() / 3 % 2 != 0) {
            if (c.getPowerUp() == 1) {
                Color color = new Color(255, 0, 0);
                color = MainThread.getFrame() / 6 % 2 == 0 ? new Color(150, 0, 0) : new Color(255, 0, 0);
                MainMap.drawShadow(g, width, x, y, y_dif, false, color);
                return;
            }
            if (c.getPowerUp() > 1) {
                Color color = new Color(255, 0, 0);
                color = MainThread.getFrame() / 6 % 2 == 0 ? new Color(0, 0, 150) : new Color(0, 0, 255);
                MainMap.drawShadow(g, width, x, y, y_dif, false, color);
                return;
            }
            MainMap.drawShadow(g, width, x, y, y_dif, false, shadow[0]);
            return;
        }
        int index = 1;
        MainMap.drawShadow(g, width, x, y, y_dif, false, shadow[index]);
    }

    public static void drawShadow(Graphics2D g, int width, int x, int y, int y_dif, boolean flat) {
        if (width <= 0) {
            return;
        }
        MainMap.drawShadow(g, width, x, y, y_dif, flat, shadow[0]);
    }

    public static void drawShadow(Graphics2D g, int width, int x, int y, int y_dif, boolean flat, Color c) {
        int height = flat ? width : width / 2;
        g.setColor(c);
        g.fillOval(x + 25 - width / 2, y - height / 2 + 30 - y_dif, width, height);
    }

    private static void drawSpot(Graphics2D g) {
        if (!MassCreater.isSpotValid()) {
            return;
        }
        Area mask = (Area)SCREEN.clone();
        if (MassCreater.isPlayerInRoom()) {
            InitialPlacement.Room r = MassCreater.getPlayerRoom();
            r.LIGHT.x = (2 - (Player.me.getMassPoint().x - r.X)) * 50 + 50 - 12 + ObjectPoint.getDifferenceBetweenMass_Screen((Base_MapObject)Player.me).x;
            r.LIGHT.y = (2 - (Player.me.getMassPoint().y - r.Y)) * 50 + 25 - 12 + ObjectPoint.getDifferenceBetweenMass_Screen((Base_MapObject)Player.me).y;
            mask.subtract(new Area(r.LIGHT));
        }
        int radius = 50;
        Ellipse2D.Double spot = new Ellipse2D.Double(200 - radius, 170 - radius, radius * 2, radius * 2);
        mask.subtract(new Area(spot));
        g.setColor(new Color(0, 0, 0, 100));
        g.fill(mask);
    }

    private static void drawThrowing(Graphics2D g) {
        if (!TaskOnMapObject.isThrowTaskEmpty()) {
            if (TaskOnMapObject.getThrow().isFirstSleeping()) {
                return;
            }
            Base_Artifact a = TaskOnMapObject.getThrow().A;
            Point p = ObjectPoint.getScreenPointRelPlayer(a);
            Image im = a.getImage(a.direction);
            int x = p.x - (im.getWidth(null) - 50) / 2;
            int y = p.y - (im.getHeight(null) - 50) / 2;
            if (!Config.isNoShadow() && a.getShadow() > 0) {
                int size = 12;
                int awa = a.jumped_away_y;
                if (a.isJumping()) {
                    size += awa / 3;
                }
                MainMap.drawShadow(g, size, p.x, y + 5, a.getShadow());
            }
            if (a instanceof Base_Bullet || a instanceof Arrow) {
                g.drawImage(im, x, y - 10, null);
            } else {
                int w = im.getWidth(null);
                int h = im.getHeight(null);
                double theta = MainThread.getFrame();
                AffineTransform firts_at = g.getTransform();
                AffineTransform at = new AffineTransform(firts_at);
                at.translate(x + w / 2, y - 10 + h / 2);
                at.rotate(Math.PI * theta / 4.0);
                g.setTransform(at);
                g.drawImage(im, -w / 2, -h / 2, null);
                g.setTransform(firts_at);
            }
        }
    }

    public static void drawWall(Graphics2D g, Image[] wall_img, int draw_x, int draw_y) {
        int count = 0;
        int k = 0;
        while (k < 2) {
            int l = 0;
            while (l < 2) {
                g.drawImage(wall_img[count], draw_x + 25 * k, draw_y + 25 * l, null);
                ++count;
                ++l;
            }
            ++k;
        }
    }

    private static Image[] getDirectionWall(Image_MapTip map_tip, Mass mass) {
        Image[] wall_img = new Image[4];
        int count = 0;
        int k = 0;
        while (k < 2) {
            int l = 0;
            while (l < 2) {
                wall_img[count] = map_tip.getWall(10 * count + wall_map.get(mass.getWallDIRECION(count)));
                ++count;
                ++l;
            }
            ++k;
        }
        return wall_img;
    }

    public static Image[] getPlainWall(Image_MapTip map_tip) {
        Image[] wall_img = new Image[4];
        int k = 0;
        while (k < wall_img.length) {
            wall_img[k] = map_tip.getWall(10 * k + wall_map.get(EX_DIRECTION.NEUTRAL));
            ++k;
        }
        return wall_img;
    }

    private static void ignoreCreature(List<Base_Creature> list, List<Base_Creature> jumping_list) {
        Iterator<Base_Creature> i = list.iterator();
        while (i.hasNext()) {
            Base_Creature c = i.next();
            Point p = ObjectPoint.getScreenPointRelPlayer(c);
            int x = p.x;
            int y = p.y;
            if (!(!c.conditionCheck(CONDITION.\u900f\u660e) || c.isBeatedAway() || c instanceof Player || Player.me.conditionCheck(CONDITION.\u76ee\u85ac) || EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u8b58))) {
                c.skipDrawFrame();
                i.remove();
                continue;
            }
            if (c.isJumping()) {
                if (jumping_list != null) {
                    jumping_list.add(c);
                }
                i.remove();
                continue;
            }
            if (WithinOutofScreen.isOutside(x, y, c.getImage().getWidth(null), c.getImage().getHeight(null))) {
                i.remove();
                c.skipDrawFrame();
                continue;
            }
            if (!MainMap.isOutofPlayerSight(c) || c.getAnimation() != null) continue;
            i.remove();
            c.skipDrawFrame();
        }
    }

    public static boolean isOutofPlayerSight(Base_Creature c) {
        if (c == null) {
            return true;
        }
        return MainMap.isOutofPlayerSight(c.getMassPoint());
    }

    public static boolean isOutofPlayerSight(Point p) {
        return MassCreater.isSpotValid() && !EnchantSpecial.toushi() && !Player.me.conditionCheck(CONDITION.\u86cd) && !MassCreater.isThePointInThePlayerSight(p, 1);
    }

    private static boolean isVisible(Base_Artifact a) {
        if (a.isHidden()) {
            return false;
        }
        Mass m = MassCreater.getMass(a.getMassPoint());
        if (WithinOutofScreen.isOutside(a)) {
            return false;
        }
        if (a.isAnimating()) {
            return true;
        }
        if (MassCreater.isSpotValid() && !m.isVisible()) {
            return false;
        }
        if (!a.isVisible()) {
            if (!(a instanceof Base_Device)) {
                if (!Player.me.conditionCheck(CONDITION.\u76ee\u85ac) && !\u5370\u7f60\u5e2b.effect() || EnchantSpecial.enchantSimbolAllCheck(EnchantSpecial.CASE.RING, ENCHANT_SIMBOL.\u63a2\u77e5)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static void requestForUpdate() {
        MainMap.setBase();
        MiniMap.reset();
    }

    public static void setAnimation(Base_Creature c) {
        animating_creature_list.add(c);
    }

    private static void setBase() {
        Mass mass;
        int draw_y;
        int draw_x;
        int y;
        int out_hr = 4;
        int out_vt = 3;
        int w = (40 + out_hr * 2) * 50;
        int h = (30 + out_vt * 2) * 50;
        base_image = new BufferedImage(w, h, 5);
        Graphics2D g = base_image.createGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, w, h);
        Image[] wall_img = new Image[4];
        Image_MapTip map_tip = PresentField.get().getMapTip();
        int x = 0;
        while (x < 40 + out_hr * 2) {
            y = 0;
            while (y < 30 + out_vt * 2) {
                block13: {
                    draw_x = 50 * x;
                    draw_y = 50 * y;
                    if (x < out_hr || x >= 40 + out_hr || y < out_vt || y >= 40 + out_vt) {
                        wall_img = MainMap.getPlainWall(map_tip);
                    } else {
                        try {
                            mass = MassCreater.getMass()[x - out_hr][y - out_vt];
                            if (mass.WALKABLE) {
                                g.drawImage(mass.HAP ? map_tip.getHap() : map_tip.getFloor(), draw_x, draw_y, null);
                                break block13;
                            }
                            wall_img = MainMap.getDirectionWall(map_tip, mass);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            wall_img = MainMap.getPlainWall(map_tip);
                        }
                    }
                    MainMap.drawWall(g, wall_img, draw_x, draw_y);
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < 40) {
            y = 0;
            while (y < 30) {
                block14: {
                    draw_x = 50 * (x + out_hr);
                    draw_y = 50 * (y + out_vt);
                    try {
                        mass = MassCreater.getMass()[x][y];
                        if (mass.isWater_or_WaterLeef()) {
                            map_tip = Image_MapTip.water;
                        } else {
                            if (!mass.WATER_FROZEN) break block14;
                            map_tip = Image_MapTip.water_ice;
                        }
                        wall_img = MainMap.getDirectionWall(map_tip, mass);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        wall_img = MainMap.getPlainWall(map_tip);
                    }
                    MainMap.drawWall(g, wall_img, draw_x, draw_y);
                }
                ++y;
            }
            ++x;
        }
        g.dispose();
    }
}

