/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.detail;

import dangeon.controller.DangeonScene;
import dangeon.controller.listener.menu.ENCHANT;
import dangeon.controller.listener.menu.Gousei;
import dangeon.controller.listener.menu.ITEM;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.Base_Item;
import dangeon.model.object.artifact.item.spellcard.SpellCard;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.view.constant.NormalFont;
import dangeon.view.detail.Menu_First;
import dangeon.view.detail.View_Cursor;
import dangeon.view.detail.View_Select_String;
import dangeon.view.util.StringFilter;
import dangeon.view.util.Window;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import main.util.BeautifulView;
import main.util.\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc;

public class Item {
    public static final int W;
    public static final int H;
    public static final int H_foot;
    public static final int H_command;
    public static final int W_enchant_select;
    public static final int W_enchant_item;
    public static final int W_wide;
    public static final int W_commands;
    public static final int margine = 1;
    public static final Image ENCHANT_SELECT_WINDOW;
    public static final Image COMMANDS_WINDOW;
    public static final Image ITEM_WINDOW;
    public static final Image ITEM_WINDOW_FOOT;
    public static final Image MINI_EXPLANATION_WINDOW;
    public static final int MINI_EXPLANATION_MAX_LENGTH = 4;

    static {
        MINI_EXPLANATION_WINDOW = Menu_First.STATUS_WINDOW;
        W_commands = NormalFont.WIDTH2 + 20;
        H_command = Window.getNarrowWindowH(ITEM.ITEM_COMMAND.LENGTH);
        COMMANDS_WINDOW = Window.get(W_commands, H_command);
        W_enchant_select = NormalFont.WIDTH2 * 2 + 20;
        W_enchant_item = 350 - W_enchant_select;
        W = W_wide = 350;
        H = Window.getNarrowWindowH(10);
        H_foot = Window.getNarrowWindowH(1);
        ITEM_WINDOW = Window.get(W, H);
        ENCHANT_SELECT_WINDOW = Window.get(W, Window.getNarrowWindowH(Enchant.LENGTH));
        ITEM_WINDOW_FOOT = Window.get(W, H_foot);
    }

    public static void draw(Graphics2D g) {
        Item.drawItemWindow(g);
        if (DangeonScene.GOUSEI.isPresentScene()) {
            Item.drawGOUSEI(g);
        }
        Item.drawItems(g);
        Item.drawExplain(g);
        if (ITEM.flag_command_phase) {
            Item.drawCommands(g);
        }
        if (ITEM.flag_explanation_phase) {
            Item.drawExplain_on_phase(g);
        } else if (DangeonScene.ENCHANT.isPresentScene()) {
            Item.drawENCHANT(g);
        } else if (ITEM.flag_naming_phase) {
            Item.fillBlack(g);
            View_Select_String.draw(g);
        }
    }

    private static void drawBelongingItemName(Graphics2D g, int index, int y) {
        Base_Artifact a = Belongings.get(index);
        int x = 35;
        Item.drawItemName(g, x, y, a.getImage(), a.getColoredName(false));
        if (Belongings.get(index).isEnchantedNow()) {
            Enchant[] enchantArray = Enchant.values();
            int n = enchantArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enchant enc = enchantArray[n2];
                if (enc.isEquals(a)) {
                    Item.drawItemEnchanted(g, x, y, enc.getColor());
                    break;
                }
                ++n2;
            }
        }
        if (a.isCurse()) {
            if (a instanceof SpellCard && !a.isPerfectCheked()) {
                return;
            }
            Item.drawItemSholder(g, x, y, Color.PINK, "\u546a");
        }
    }

    private static void drawCommands(Graphics2D g) {
        int x = 25 + W - W_commands;
        int y = 25;
        g.drawImage(COMMANDS_WINDOW, x, y, null);
        int i = 0;
        while (i < ITEM.ITEM_COMMAND.LENGTH) {
            ITEM.ITEM_COMMAND command = ITEM.ITEM_COMMAND.get(i);
            g.setColor(command.getColor());
            g.drawString(command.toString(), x + 10, y + 10 + (NormalFont.HEIGHT + 1) * (i + 1) - 1);
            ++i;
        }
        int _x = x + 10;
        int _y = y + 10 + (NormalFont.HEIGHT + 1) * (ITEM.command_y + 1) - 1;
        View_Cursor.draw(g, _x, _y, !DangeonScene.ENCHANT.isPresentScene());
    }

    private static void drawENCHANT(Graphics2D g) {
        Item.fillBlack(g);
        int x = 25;
        int y = 25 + H_command - 20;
        g.drawImage(ENCHANT_SELECT_WINDOW, x, y, null);
        int __y = y + ENCHANT_SELECT_WINDOW.getHeight(null) + 1;
        g.drawImage((Image)Window.get(W, Window.getNarrowWindowH_SmallFont(2)), x, __y, null);
        x += 10;
        int i = 0;
        while (i < Enchant.LENGTH) {
            Enchant command = Enchant.get(i);
            g.setColor(command.getColorWithForbitten());
            int del = Window.getNarrowStringY(i);
            if (command.isEnchant()) {
                Base_Item item = (Base_Item)command.getEnchant();
                if (ENCHANT.isSelectedArtifactEqualEnchant(command)) {
                    BeautifulView.setAlphaOnImg(g, Float.valueOf(0.5f));
                }
                Item.drawItemName(g, x, y + del, item.getImage(), item.getName(new StringBuilder()).toString());
                BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("(");
                sb.append((Object)command);
                sb.append(")");
                g.drawString(sb.toString(), x, y + del);
            }
            ++i;
        }
        g.setColor(Color.WHITE);
        g.setFont(NormalFont.NORMALFONT.deriveFont(14.0f));
        ArrayList<String> list = new ArrayList<String>();
        StringFilter.setList(list, W - 20, true, ENCHANT.getEXP());
        int j = 0;
        while (j < list.size()) {
            StringFilter.drawString(g, list.get(j), x, __y + NormalFont.SMALL_HEIGHT + (NormalFont.SMALL_HEIGHT + NormalFont.SMALL_LEADING) * j + 5);
            ++j;
        }
        g.setFont(NormalFont.NORMALFONT);
        View_Cursor.draw(g, x, y + Window.getNarrowStringY(ENCHANT.getY()), true);
    }

    private static void drawExplain(Graphics2D g) {
        boolean foot = ITEM.isFoot();
        if (!foot && Belongings.getSize() == 0) {
            return;
        }
        Item.drawExplanation(g, 25, foot ? 25 + H_foot + 1 : 25 + H + 1, true);
    }

    private static void drawExplain_on_phase(Graphics2D g) {
        Item.fillBlack(g);
        g.setColor(Color.WHITE);
        int h = Window.getNarrowWindowH(1);
        Window.draw(g, 25, 25, W, h);
        Item.drawBelongingItemName(g, ITEM.getIndex(), 35 + NormalFont.HEIGHT);
        Item.drawExplanation(g, 25, 25 + h + 1, false);
    }

    private static void drawExplanation(Graphics2D g, int X, int Y, boolean mini) {
        String[] arr;
        Base_Artifact a = Belongings.get(ITEM.getIndex());
        if (a == null) {
            return;
        }
        if (mini) {
            arr = a.firstPageExplain();
            g.drawImage(MINI_EXPLANATION_WINDOW, X, Y, null);
        } else {
            arr = a.secondPageExplain().toArray(new String[0]);
            int h = Window.getNarrowWindowH_SmallFont(arr.length);
            Window.draw(g, X, Y, W, h);
        }
        g.setFont(g.getFont().deriveFont(14.0f));
        int times = arr.length;
        if (mini && arr.length > 4) {
            times = 4;
        }
        int x = X + 10;
        int i = 0;
        while (i < times) {
            int y = Y + 5 + (NormalFont.SMALL_HEIGHT + 1) * (i + 1) - 1;
            StringFilter.drawString(g, arr[i], x, y);
            ++i;
        }
        g.setFont(NormalFont.NORMALFONT);
    }

    private static void drawGOUSEI(Graphics2D g) {
        FontMetrics fo = g.getFontMetrics();
        int h = 20 + fo.getHeight();
        int w = 20 + fo.stringWidth("\u5408\u6210");
        int x = 25 + W - w / 2;
        int y = 25 - h / 2;
        Window.draw(g, x, y, w, h);
        g.drawString("\u5408\u6210", x + 10, y + 10 + fo.getAscent());
        if (Gousei.getSelected_first() > 0) {
            g.setColor(Color.CYAN);
            int _y = 35 + (NormalFont.HEIGHT + 1) * Gousei.getSelected_first();
            int _h = NormalFont.HEIGHT;
            g.fillRect(25, _y, W, _h);
        }
    }

    private static void drawItem(Graphics2D g, int i, int j) {
        int y = 25 + Window.getNarrowStringY(j);
        Item.drawBelongingItemName(g, i, y);
    }

    static void drawItemEnchanted(Graphics2D g, int x, int y, Color c) {
        g.setColor(c);
        Font font = g.getFont();
        g.setFont(font.deriveFont(10.0f));
        StringFilter.drawEdgedString_plain(g, "E", x - 2, y - 2);
        g.setFont(font);
        g.setColor(Color.WHITE);
    }

    public static void drawItemName(Graphics2D g, int x, int y, Image i, String name) {
        int _x = x - i.getWidth(null) / 2 + NormalFont.HEIGHT / 2;
        int _y = y - i.getHeight(null) / 2 - NormalFont.HEIGHT / 2 + 2;
        g.drawImage(i, _x, _y, null);
        StringFilter.drawString(g, name, x + 20, y);
    }

    private static void drawItems(Graphics2D g) {
        if (ITEM.isFoot()) {
            Item.drawItem(g, -1, 0);
            int x = 35;
            int y = 35 + NormalFont.HEIGHT;
            View_Cursor.draw(g, x, y, !ITEM.flag_command_phase);
            return;
        }
        int i = ITEM.x * 10;
        int j = 0;
        while (i < Belongings.getSize() && j < 10) {
            Item.drawItem(g, i, j);
            ++i;
            ++j;
        }
        int x = 35;
        int y = 35 + (NormalFont.HEIGHT + NormalFont.DECENT) * (ITEM.y + 1) - NormalFont.DECENT;
        View_Cursor.draw(g, x, y, !ITEM.flag_command_phase);
    }

    static void drawItemSholder(Graphics2D g, int x, int y, Color c, String s) {
        g.setColor(c);
        Font font = g.getFont();
        g.setFont(font.deriveFont(10.0f));
        StringFilter.drawEdgedString_plain(g, s, x + 20 - g.getFontMetrics().stringWidth(s), y - 5);
        g.setFont(font);
        g.setColor(Color.WHITE);
    }

    private static void drawItemWindow(Graphics2D g) {
        if (ITEM.isFoot()) {
            g.drawImage(ITEM_WINDOW_FOOT, 25, 25, null);
            return;
        }
        int x = 25 + W / 2 - NormalFont.WIDTH2 / 2;
        g.drawImage(ITEM_WINDOW, 25, 25, null);
        g.drawString(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(ITEM.getPage()), x - 10 - 1, 25 + H);
        g.drawString("\uff0f", x, 25 + H);
        g.drawString(\u534a\u89d2\u5168\u89d2\u30b3\u30f3\u30d0\u30fc\u30bf\u30fc.\u534a\u89d2To\u5168\u89d2\u6570\u5b57(ITEM.getMaxPage()), x + 10 + 1, 25 + H);
    }

    private static void fillBlack(Graphics2D g) {
        g.setColor(new Color(0, 0, 0, 136));
        g.fillRect(0, 0, 400, 340);
    }
}

