/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.anime;

import dangeon.model.object.creature.Base_Creature;
import dangeon.util.ObjectPoint;
import dangeon.view.anime.HitEffect;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import main.constant.FR;
import main.res.SE;
import main.util.BeautifulView;

public class MissEffect
extends HitEffect {
    public MissEffect(Base_Creature c, boolean graze_miss) {
        super(c, graze_miss ? "GRAZE" : "MISS");
    }

    @Override
    protected void addFrameImage() {
    }

    @Override
    public boolean draw(Graphics2D g) {
        Point p = ObjectPoint.getScreenPointRelPlayer(this.SCREEN_POINT);
        p.translate(0, -20);
        float rate = new Float(Math.cos((double)this.time / 1000.0)).floatValue() / 2.0f;
        BeautifulView.setAlphaOnImg(g, Float.valueOf(rate));
        g.drawImage(this.DAMAGE, p.x + this.DELT.x, p.y + this.DELT.y, this.WIDTH, this.HEIGHT, null);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        return this.upDatePopNumber();
    }

    @Override
    protected void SE(int damage) {
        SE.MISS.play();
    }

    @Override
    protected void setColor(Graphics2D g, Base_Creature c, int height) {
        Color COLOR1 = Color.CYAN;
        Color COLOR2 = Color.BLUE;
        g.setPaint(new GradientPaint(0.0f, 0.0f, COLOR1, 0.0f, height, COLOR2));
    }

    @Override
    protected boolean upDatePopNumber() {
        this.time += FR.THREAD_SLEEP;
        if (this.time > 1000) {
            return false;
        }
        double converter = (3000.0 - (double)this.time) / 3000.0;
        double v_x = (double)this.FIRST_VELOCITY.x * converter / 10.0;
        double v_y = (double)this.FIRST_VELOCITY.y * converter / 20.0;
        Point velocity = new Point((int)v_x, (int)v_y);
        double t = (double)this.time / 1000.0;
        double delt_x = (double)velocity.x * t;
        double delt_y = (double)velocity.y * t;
        this.DELT.move((int)delt_x + this.CENTERING, (int)delt_y + this.MIDDLING);
        return true;
    }
}

