/*
 * Decompiled with CFR 0.152.
 */
package dangeon.view.anime;

import dangeon.controller.task.Task;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import dangeon.util.ObjectPoint;
import dangeon.view.anime.Base_Anime;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import main.res.SE;
import main.util.BeautifulView;

public class MasterSpark
extends Base_Anime {
    private int width = 0;
    private int height = 0;
    private final double THETA;
    private boolean flag = false;
    private final int HEAD_WIDTH;
    private final BufferedImage BODY;
    private final BufferedImage FOOT_HEAD;
    private Point START_POINT;

    public MasterSpark(Base_Creature c) {
        this(c, null);
    }

    public MasterSpark(Base_Creature c, Task task) {
        super(c, task);
        String base = "anime/";
        this.BODY = this.loadImage(base.concat("\u30de\u30b9\u30d1wid-b.png"));
        this.FOOT_HEAD = this.loadImage(base.concat("\u30de\u30b9\u30d1wid-a.png"));
        this.THETA = 0.7853981633974483 * (double)this.C.direction.ROTATE.intValue();
        this.HEAD_WIDTH = this.FOOT_HEAD.getWidth();
    }

    @Override
    public boolean draw(Graphics2D g) {
        if (!this.flag) {
            if (!Player.me.isAnimeComletelyEnded()) {
                return true;
            }
            this.flag = true;
            SE.MASTERSPARK.play();
            this.START_POINT = this.getStartPoint();
        }
        AffineTransform firts_at = g.getTransform();
        AffineTransform at = new AffineTransform(firts_at);
        Point p = this.START_POINT.getLocation();
        at.translate(p.x, p.y);
        at.rotate(this.THETA);
        BeautifulView.setAlphaOnImg(g, new Float((double)this.height / 50.0));
        g.setTransform(at);
        g.translate(42.0, 0.0);
        boolean animating = this.drawRight(g);
        g.setTransform(firts_at);
        g.setColor(new Color(240, 240, 255, 50));
        g.fillRect(0, 0, 400, 340);
        BeautifulView.setAlphaOnImg(g, Float.valueOf(1.0f));
        return animating;
    }

    private boolean drawRight(Graphics2D g) {
        if (this.width > 400) {
            this.height -= 5;
            if (this.height <= 0) {
                return false;
            }
        } else if (this.height < 50) {
            this.height += 20;
            if (this.height > 50) {
                this.height = 50;
            }
        }
        int y = -this.height / 2;
        g.drawImage(this.FOOT_HEAD, 0, y, this.HEAD_WIDTH, this.height, null);
        g.drawImage(this.BODY, this.HEAD_WIDTH, y, this.width, this.height, null);
        g.drawImage(this.FOOT_HEAD, this.HEAD_WIDTH * 2 + this.width, y, -this.HEAD_WIDTH, this.height, null);
        this.width += 50;
        return true;
    }

    private Point getStartPoint() {
        Point p;
        if (ObjectPoint.getLengthBetweenPlayer(this.C.getMassPoint()) > 4) {
            int x = Player.me.getMassPoint().x;
            int y = Player.me.getMassPoint().y;
            p = ObjectPoint.getScreenPointRelPlayer(ObjectPoint.getDangeonScreenPoint(x += 6 * -this.C.direction.X, y += 6 * -this.C.direction.Y));
        } else {
            p = ObjectPoint.getScreenPointRelPlayer(this.C);
        }
        p.translate(25, 11);
        return p;
    }
}

