/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player.strage;

import dangeon.model.config.Config;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import main.util.Show;

public abstract class Base_Strage
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final HashMap<Integer, Base_Artifact> LIST_ITEM;
    protected Base_Strage me;
    protected final int ROW;
    protected final int COL;
    public final int SIZE;

    public Base_Strage(int row, int col) {
        this.ROW = row;
        this.COL = col;
        this.SIZE = this.ROW * this.COL;
        this.LIST_ITEM = new HashMap(this.SIZE);
        this.clear();
    }

    public void add(Base_Artifact a, int row, int col) {
        Enchant.forceToRemove(a);
        this.LIST_ITEM.put(this.getIndex(row, col), a);
    }

    public synchronized void add_sort(Base_Artifact a) {
        this.addLast(a);
        this.sort();
    }

    public void addLast(Base_Artifact a) {
        Enchant.forceToRemove(a);
        int i = 0;
        while (i < this.SIZE) {
            if (this.LIST_ITEM.get(i) == null) {
                this.LIST_ITEM.put(i, a);
                return;
            }
            ++i;
        }
        Show.showErrorMessageDialog("Error@Base_Strage.addLast");
    }

    public void clear() {
        int i = 0;
        while (i < this.SIZE) {
            this.LIST_ITEM.put(i, null);
            ++i;
        }
    }

    public boolean contrains(Base_Artifact a) {
        return this.LIST_ITEM.containsValue(a);
    }

    public Base_Artifact get(int i) {
        return this.LIST_ITEM.get(i);
    }

    public Base_Artifact get(int row, int col) {
        return this.LIST_ITEM.get(this.getIndex(row, col));
    }

    public int getEmptyNumber() {
        int num = 0;
        int i = 0;
        while (i < this.SIZE) {
            if (this.LIST_ITEM.get(i) == null) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    public int getFilledNumber() {
        return this.SIZE - this.getEmptyNumber();
    }

    protected int getIndex(int row, int col) {
        int coord = row * this.COL + col;
        if (coord >= this.SIZE) {
            Show.showCriticalErrorMessageDialog("Error@Base_Strage.getIndex");
        }
        return coord;
    }

    public ArrayList<Base_Artifact> getList() {
        ArrayList<Base_Artifact> list = new ArrayList<Base_Artifact>(this.SIZE);
        for (Base_Artifact a : this.LIST_ITEM.values()) {
            if (a == null) continue;
            list.add(a);
        }
        return list;
    }

    public String getSaveURL() {
        StringBuilder sb = new StringBuilder();
        sb.append("save/");
        sb.append(Config.getSaveIndex());
        sb.append("/base_strage.save");
        return sb.toString();
    }

    public boolean isMax() {
        return !this.LIST_ITEM.containsValue(null);
    }

    public Object load() {
        String url = this.getSaveURL();
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(url));
            Object obj = ois.readObject();
            ois.close();
            return obj;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void remove(Base_Artifact a) {
        int i = 0;
        while (i < this.SIZE) {
            if (a.equals(this.LIST_ITEM.get(i))) {
                this.LIST_ITEM.put(i, null);
                break;
            }
            ++i;
        }
        while (i < this.SIZE - 1) {
            this.LIST_ITEM.put(i, this.LIST_ITEM.get(i + 1));
            ++i;
        }
        this.LIST_ITEM.put(this.SIZE - 1, null);
    }

    public void save() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.getSaveURL()));
            oos.writeObject(this);
            oos.close();
        }
        catch (Exception e) {
            Show.showCriticalErrorMessageDialog(e);
        }
    }

    public void sort() {
        Base_Artifact a;
        ArrayList<Base_Artifact> items = new ArrayList<Base_Artifact>(this.SIZE);
        int i = 0;
        while (i < this.SIZE) {
            a = this.LIST_ITEM.get(i);
            if (a != null) {
                items.add(a);
            }
            ++i;
        }
        items = Belongings.sort(items);
        System.out.println(items);
        this.clear();
        i = 0;
        while (i < items.size()) {
            a = (Base_Artifact)items.get(i);
            this.LIST_ITEM.put(i, a);
            ++i;
        }
    }
}

