/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.player.save;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.config.Config;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.map.PresentField;
import dangeon.model.map.field.Base_Map;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.check.Checker;
import dangeon.model.object.artifact.item.check.Checker_ClassName;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.EnchantArrow;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.WriteAbortedException;
import java.util.List;
import main.res.BGM;
import main.util.BlackOut;
import main.util.Show;
import title.Title;

public class SaveLoad
implements Serializable {
    private static final long serialVersionUID = 2L;
    public final Player PLAYER;
    public final List<Base_Artifact> ITEMS;
    public final Base_Artifact[] ENCHANT_ARTIFACT;
    public final Integer ENCHANT_ARROW;
    public final Base_Map BASE_MAP;
    public final MapList MAP_LIST;
    public final MassCreater MASS_CREATER;
    public final String HACK_NAME;
    public final Checker_ClassName<Checker> CHECKER;
    public final boolean ITEM_TEMP;
    private static long time = -1L;

    public static void delete() {
        SaveLoad.delete(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(boolean temp) {
        File file = new File(SaveLoad.getSaveURL(temp));
        try {
            int max = 99;
            int min = 1;
            int i = max;
            if (temp) {
                file.delete();
                new File(SaveLoad.getSaveURL(temp)).createNewFile();
            } else {
                while (true) {
                    if (i < min) {
                        file.renameTo(new File(SaveLoad.getRenameString(temp, min)));
                        new File(SaveLoad.getSaveURL(temp)).createNewFile();
                        break;
                    }
                    File f = new File(SaveLoad.getRenameString(temp, i));
                    if (f.exists()) {
                        if (i == max) {
                            f.delete();
                        } else {
                            f.renameTo(new File(SaveLoad.getRenameString(temp, i + 1)));
                        }
                    }
                    --i;
                }
            }
            Config.release();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getRenameString(boolean temp, int i) {
        return SaveLoad.getSaveURL(temp).concat("__temp__" + i + "__");
    }

    public static SaveLoad getSaveLoad(boolean temp) {
        String url = SaveLoad.getSaveURL(temp);
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(url));
            SaveLoad s = (SaveLoad)ois.readObject();
            ois.close();
            return s;
        }
        catch (EOFException s) {
        }
        catch (FileNotFoundException s) {
        }
        catch (InvalidClassException e) {
            Message.set("\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u304c\u73fe\u5728\u306e\u5f62\u5f0f\u3068\u4e00\u81f4\u3057\u306a\u304b\u3063\u305f\u306e\u3067\u65b0\u3057\u304f\u5192\u967a\u3092\u958b\u59cb\u3057\u307e\u3057\u305f@");
        }
        catch (WriteAbortedException e) {
            Message.set("\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u304c\u73fe\u5728\u306e\u5f62\u5f0f\u3068\u4e00\u81f4\u3057\u306a\u304b\u3063\u305f\u306e\u3067\u65b0\u3057\u304f\u5192\u967a\u3092\u958b\u59cb\u3057\u307e\u3057\u305f@");
        }
        catch (Exception e) {
            Show.writeErrorText(e);
            Message.set("\u30bb\u30fc\u30d6\u30c7\u30fc\u30bf\u304c\u4f55\u304b\u3057\u3089\u306e\u539f\u56e0\u3067\u8aad\u307f\u8fbc\u3081\u306a\u304b\u3063\u305f\u306e\u3067\u65b0\u3057\u304f\u5192\u967a\u3092\u958b\u59cb\u3057\u307e\u3057\u305f@");
            Message.set("\u304a\u624b\u6570\u3067\u3059\u304c\u516c\u5f0f\u63b2\u793a\u677f\u306b\u3001\u73fe\u5728\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u3068\u66f8\u304d\u51fa\u3055\u308c\u305ferror.txt\u306e\u5185\u5bb9\u3092\u9001\u3063\u3066\u3044\u305f\u3060\u3051\u308b\u3068\u52a9\u304b\u308a\u307e\u3059@");
        }
        return null;
    }

    private static String getSaveURL(boolean temp) {
        StringBuilder sb = new StringBuilder();
        sb.append("save/");
        sb.append(Config.getSaveIndex());
        sb.append("/");
        if (temp) {
            sb.append("temp");
        } else {
            sb.append(Config.getSaveIndex());
        }
        sb.append(".save");
        return sb.toString();
    }

    public static void initTime() {
        time = System.nanoTime();
    }

    public static boolean staticLoad() {
        return SaveLoad.staticLoad(false);
    }

    private static boolean staticLoad(boolean temp) {
        SaveLoad s = SaveLoad.getSaveLoad(temp);
        if (s == null) {
            return false;
        }
        s.load();
        return true;
    }

    public static List<Base_Artifact> staticLoad_SaisenBox() {
        SaveLoad s = SaveLoad.getSaveLoad(true);
        if (s == null) {
            return null;
        }
        SaveLoad.delete(true);
        return s.ITEMS;
    }

    public static boolean staticTempLoad() {
        return SaveLoad.staticLoad(true);
    }

    public static void time_save() {
        if (time != -1L) {
            Config.save((System.nanoTime() - time) / 1000000000L);
        }
        time = System.nanoTime();
    }

    public SaveLoad() {
        this.ITEM_TEMP = true;
        this.PLAYER = null;
        this.HACK_NAME = null;
        this.ITEMS = Belongings.getListItems();
        this.ENCHANT_ARTIFACT = null;
        this.ENCHANT_ARROW = null;
        this.BASE_MAP = null;
        this.MAP_LIST = null;
        this.MASS_CREATER = null;
        this.CHECKER = null;
    }

    public SaveLoad(MassCreater MC) {
        this.ITEM_TEMP = false;
        this.PLAYER = Player.me;
        this.HACK_NAME = MassCreater.getHackName();
        this.ITEMS = Belongings.getListItems();
        this.ENCHANT_ARTIFACT = Enchant.savePresentEnchant();
        this.ENCHANT_ARROW = EnchantArrow.saveArrowEnchant();
        this.BASE_MAP = PresentField.get();
        this.MAP_LIST = new MapList(MapList.ME);
        this.MASS_CREATER = MC;
        this.CHECKER = Checker.saveHash();
    }

    private void load() {
        if (this.ITEM_TEMP) {
            Belongings.allRemove();
            Belongings.setListItems(this.ITEMS);
        } else {
            this.loadRegularly();
        }
    }

    private void loadRegularly() {
        Player.load(this.PLAYER);
        this.PLAYER.endDamaging();
        MassCreater.setHackName(this.HACK_NAME);
        Checker.load(this.CHECKER);
        Belongings.setListItems(this.ITEMS);
        Enchant.loadPresentEnchant(this.ENCHANT_ARTIFACT);
        EnchantArrow.loadArrowEnchant(this.ENCHANT_ARROW);
        PresentField.setPresentField(this.BASE_MAP);
        if (this.BASE_MAP.isDungeon()) {
            this.MASS_CREATER.createItemTable();
        } else {
            this.MASS_CREATER.createItemTableNoDungeon();
        }
        MapList.load(this.MAP_LIST);
        if (this.MASS_CREATER.MOVE_BY_STEP && this.BASE_MAP.isDungeon()) {
            MapList.nextFloor();
        }
        new BlackOut(this.BASE_MAP, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                SaveLoad.delete();
                Scene_Action.getMe().setNextScene(Scene_Action.getMe());
                R.setFix(Config.getRandomSeed());
                MassCreater.load(SaveLoad.this.MASS_CREATER);
                if (!BGM.isSpecialBGMplaying()) {
                    System.out.println((Object)BGM.get());
                    BGM bgm = SaveLoad.this.BASE_MAP.getBGM();
                    if (bgm != null) {
                        bgm.play();
                    }
                } else {
                    System.out.println((Object)BGM.get());
                }
            }
        });
    }

    private void save(boolean temp) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(SaveLoad.getSaveURL(temp)));
            oos.writeObject(this);
            oos.close();
            SaveLoad.time_save();
        }
        catch (Exception e) {
            Show.showCriticalErrorMessageDialog(e);
        }
    }

    public void saveContinue() {
        this.save(false);
    }

    public void saveEnd() {
        this.save(false);
        BGM.waitUntilFadeOut_Thread();
        if (this.BASE_MAP.isDungeon()) {
            Message.set("\u30bb\u30fc\u30d6\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002$\u6b21\u306e\u968e\u5c64\u304b\u3089\u59cb\u307e\u308a\u307e\u3059\u3002@");
        } else {
            Message.set("\u30bb\u30fc\u30d6\u306b\u6210\u529f\u3057\u307e\u3057\u305f\u3002$\u30a2\u30a4\u30c6\u30e0\u3092\u6301\u3063\u305f\u307e\u307e\u59cb\u307e\u308a\u307e\u3059\u3002@");
        }
        Message.setTask_AfterReleaseDemandToPushEnter(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                new BlackOut("", new Task(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void work() {
                        Scene_Action.getMe().setNextScene(new Title(Scene_Action.getMe().KH));
                    }
                });
            }
        });
    }

    public void saveItemsFirst() {
        this.save(true);
    }
}

