/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.npc;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.message.ConvEvent;
import dangeon.latest.scene.action.message.Conversation;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.config.table.ItemTable;
import dangeon.model.map.InitialPlacement;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.staff.\u4e00\u6642\u3057\u306e\u304e\u306e\u6756;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Player;
import dangeon.model.object.creature.player.strage.SAISEN_Strage;
import dangeon.util.R;
import dangeon.view.detail.MiniMap;
import java.awt.Image;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import main.res.Image_LargeCharacter;
import main.res.Image_Object;

public class \u8cfd\u92ad\u7bb1
extends Base_NPC {
    private static final long serialVersionUID = 1L;
    public final SAISEN_Strage STRAGE;
    private final Base_Artifact[] PUNISHMENTS;
    private final InitialPlacement.Room ROOM;

    protected \u8cfd\u92ad\u7bb1(Point p, String name, List<Base_Artifact> list) {
        super(p, name, false);
        this.ROOM = null;
        int size = list.size();
        int row = 10;
        int cols = (size + row - 1) / row;
        this.STRAGE = new SAISEN_Strage(this, cols);
        Iterator<Base_Artifact> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.STRAGE.addLast(iterator.next());
        }
        this.PUNISHMENTS = new Base_Artifact[0];
        this.IM = null;
    }

    public \u8cfd\u92ad\u7bb1(InitialPlacement.Room r) {
        super(new Point(r.X + r.W / 2, r.Y + r.H / 2), "\u535a\u970a\u8cfd\u92ad\u7bb1", false);
        this.ROOM = r;
        this.STRAGE = new SAISEN_Strage(this);
        int ran = 6 + (int)Math.floor(new R().nextDouble() * 5.0);
        this.PUNISHMENTS = new Base_Artifact[ran];
        int i = 0;
        while (i < ran) {
            this.PUNISHMENTS[i] = ItemTable.itemReturn(this.mass_point, null);
            this.PUNISHMENTS[i].setPunishment(true);
            this.STRAGE.addLast(this.PUNISHMENTS[i]);
            ++i;
        }
        this.IM = null;
    }

    public \u8cfd\u92ad\u7bb1(InitialPlacement.Room r, List<Base_Artifact> list) {
        super(new Point(r.X + r.W / 2, r.Y + r.H / 2), "\u8cfd\u92ad\u7bb1", false);
        this.ROOM = r;
        this.STRAGE = new SAISEN_Strage(this);
        this.PUNISHMENTS = new Base_Artifact[list.size()];
        int i = 0;
        while (i < this.PUNISHMENTS.length) {
            this.PUNISHMENTS[i] = list.get(i);
            this.PUNISHMENTS[i].setPunishment(true);
            this.STRAGE.addLast(this.PUNISHMENTS[i]);
            ++i;
        }
        this.IM = null;
    }

    @Override
    protected void enemyBreakAction() {
        int i = 0;
        while (i < this.STRAGE.SIZE) {
            ItemFall.itemFall(this.getMassPoint(), this.STRAGE.get(i));
            ++i;
        }
        this.STRAGE.clear();
        if (!MassCreater.getMass(Player.me.getMassPoint()).isHoly()) {
            new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                    \u8cfd\u92ad\u7bb1.this.punish();
                }
            }.work_appointment();
        }
    }

    private int getBlackCount() {
        if (Player.me.saisen == null) {
            return 0;
        }
        HashMap<Base_Artifact, Boolean> map = new HashMap<Base_Artifact, Boolean>(this.PUNISHMENTS.length);
        Base_Artifact[] base_ArtifactArray = this.PUNISHMENTS;
        int n = this.PUNISHMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            Base_Artifact a = base_ArtifactArray[n2];
            map.put(a, this.STRAGE.contrains(a));
            ++n2;
        }
        base_ArtifactArray = MassCreater.getMass();
        n = base_ArtifactArray.length;
        n2 = 0;
        while (n2 < n) {
            Base_Artifact m2;
            Base_Artifact base_Artifact = m2 = base_ArtifactArray[n2];
            int n3 = ((Base_Artifact)base_Artifact).length;
            int n4 = 0;
            while (n4 < n3) {
                Base_Artifact a;
                Base_Artifact m = base_Artifact[n4];
                if (((Mass)((Object)m)).isHoly() && (a = MapList.getArtiface(((Mass)((Object)m)).X, ((Mass)((Object)m)).Y)) != null) {
                    Base_Artifact[] base_ArtifactArray2 = this.PUNISHMENTS;
                    int n5 = this.PUNISHMENTS.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Base_Artifact pu = base_ArtifactArray2[n6];
                        if (a.equals(pu)) {
                            map.put(a, true);
                            break;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        int count = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            boolean b = (Boolean)iterator.next();
            if (b) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Image getImage() {
        return Image_Object.\u8cfd\u92ad\u7bb1.getImage();
    }

    @Override
    public int getShadowSize100() {
        return 44;
    }

    @Override
    public int getShadowY() {
        return 8;
    }

    public void goOut() {
        if (this.isWhite()) {
            Message.set("\u6577\u5730\u306e\u5916\u306b\u51fa\u305f");
        } else {
            this.punish();
        }
    }

    public boolean isGray() {
        return this.getBlackCount() == 1;
    }

    public boolean isWhite() {
        return this.getBlackCount() <= 1;
    }

    private void judgement() {
        MapList.judgement();
        this.release();
    }

    @Override
    public void message() {
        new ConvEvent(new String[]{"\u304a\u8cfd\u92ad\u7bb1\u3060$\uff11\u3064\u3060\u3051\u6577\u5730\u306e\u5916\u306b\u6301\u3061\u51fa\u305b\u308b\u305e"}){

            @Override
            protected Book getContent1() {
                return new Book("\u53d6\u308a\u51fa\u3059"){

                    @Override
                    protected void work() {
                        (this).\u8cfd\u92ad\u7bb1.this.STRAGE.takeIt();
                    }
                };
            }

            @Override
            protected Book getContent2() {
                return new Book("\u898b\u308b"){

                    @Override
                    protected void work() {
                        (this).\u8cfd\u92ad\u7bb1.this.STRAGE.justWatch();
                    }
                };
            }

            @Override
            protected Book getContent3() {
                return new Book("\u3084\u3081\u308b"){

                    @Override
                    protected void work() {
                    }
                };
            }

            @Override
            protected Book getContent4() {
                return new Book("\u8aac\u660e"){

                    @Override
                    protected void work() {
                        Image_LargeCharacter imlc = Image_LargeCharacter.\u535a\u9e97\u970a\u5922;
                        new Conversation(imlc, "\u203b\u305f\u304f\u3055\u3093\u30a2\u30a4\u30c6\u30e0\u3092\u53d6\u308a\u51fa\u3057\u3061\u3083\u3063\u305f\u3089\u5e8a\u306b\u7f6e\u3044\u3066\u3082\u3044\u3044\u308f");
                        new Conversation(imlc, "\u203b\uff12\u3064\u4ee5\u4e0a\u306e\u304a\u4f9b\u3048\u7269\u3092\u6577\u5730\u306e\u5916\u306b\u51fa\u3059\u3068\u30fb\u30fb\u30fb\u3000\u3046\u3075\u3075");
                        new Conversation(imlc, "\u203b\u58ca\u3055\u306a\u3051\u308c\u3070\u8cfd\u92ad\u7bb1\u81ea\u4f53\u3092\u6577\u5730\u306e\u5916\u306b\u51fa\u3057\u3066\u3082\u3044\u3044\u308f");
                    }
                };
            }
        };
    }

    public boolean punish() {
        if (MassCreater.getMass(Player.me.getMassPoint()).isHoly() || this.isWhite()) {
            return true;
        }
        this.judgement();
        return false;
    }

    public void release() {
        Base_Artifact[] base_ArtifactArray = this.PUNISHMENTS;
        int n = this.PUNISHMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            Base_Artifact a = base_ArtifactArray[n2];
            a.setPunishment(false);
            ++n2;
        }
        this.ROOM.setHoly(false);
        MiniMap.reset();
    }

    @Override
    protected boolean resistCondition(CONDITION c) {
        return true;
    }

    @Override
    public boolean staffHitEffect(Base_Artifact a) {
        if (a instanceof \u4e00\u6642\u3057\u306e\u304e\u306e\u6756) {
            Message.set("\u4e0d\u601d\u8b70\u306a\u3061\u304b\u3089\u304c\u306f\u305f\u3089\u3044\u3066\u7121\u52b9\u5316\u3055\u308c\u305f");
            return false;
        }
        return true;
    }
}

