/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.npc.dungeonNpc;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.task.Task;
import dangeon.latest.scene.action.menu.Book;
import dangeon.latest.scene.action.message.ConvEvent;
import dangeon.latest.scene.action.message.Conversation;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.field.random.Base_Map_Random;
import dangeon.model.object.creature.npc.Base_NPC;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Player;
import java.awt.Point;
import main.res.CHARA_IMAGE;
import main.res.Image_LargeCharacter;
import main.res.SE;
import main.util.BlackOut;

public abstract class Base_DungeonNPC
extends Base_NPC {
    private static final long serialVersionUID = 1L;
    protected final String ASK;
    protected final Base_Map_Random MAP;

    public Base_DungeonNPC(Point p, String name, CHARA_IMAGE c, String ask, Base_Map_Random map) {
        this(p, name, c, ask, ask, map);
    }

    public Base_DungeonNPC(Point p, String name, CHARA_IMAGE c, String ask, String ask2, Base_Map_Random map) {
        super(p, name, c, false);
        this.ASK = map.getStoryManager_ClearFlag().hasFinished() ? ask2 : ask;
        this.MAP = map;
    }

    protected void ask() {
        new Conversation(this.IMLC, this.ASK, new ConvEvent(){

            @Override
            protected String getCancel() {
                return Base_DungeonNPC.this.getMsg_cancel();
            }

            @Override
            protected String[] getExn() {
                return Base_DungeonNPC.this.MAP.getExn();
            }

            @Override
            protected Book getYes() {
                return new Book(){

                    @Override
                    protected void work() {
                        if ((this).Base_DungeonNPC.this.MAP.ITEM_MAX != null && Belongings.getSize() > (this).Base_DungeonNPC.this.MAP.ITEM_MAX) {
                            Message.set(Base_DungeonNPC.this.getMsg_overItems());
                        } else {
                            Base_DungeonNPC.this.intoDungeon();
                        }
                    }
                };
            }
        });
    }

    private boolean firstCheck() {
        return !this.MAP.getStoryManager_FirstFlag().hasFinished();
    }

    private void firstMessage() {
        this.sayFirst();
    }

    protected String getMsg_cancel() {
        return null;
    }

    protected String[] getMsg_overItems() {
        return new String[]{"\u30a2\u30a4\u30c6\u30e0\u3092\u6301\u3061\u3059\u304e\u3060\u3088"};
    }

    protected SE getSE() {
        return SE.YUKARI_SPELL;
    }

    protected void intoDungeon() {
        if (this.getSE() != null) {
            this.getSE().play();
        }
        this.preCreaterFirstMap();
        this.MAP.createFirstMap();
    }

    @Override
    public void message() {
        if (this.firstCheck()) {
            this.firstMessage();
        } else {
            this.ask();
        }
    }

    protected void preCreaterFirstMap() {
    }

    protected void say(boolean end, String ... msg) {
        ConvEvent cne = new ConvEvent(){

            @Override
            public void workAfterPush() {
                new BlackOut(new Task(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void work() {
                        Player.flag_clear = true;
                        SE.FANFARE2.play();
                        Base_DungeonNPC.this.setTalks(Image_LargeCharacter.ANY);
                        Base_DungeonNPC.this.talks(new String[]{(this).Base_DungeonNPC.this.MAP.getClassName(), "\u306b\u6311\u6226\u3067\u304d\u308b\u3088\u3046\u306b\u306a\u3063\u305f\uff01"});
                        Base_DungeonNPC.this.sayBrief();
                    }
                }, new Task(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void work() {
                        (this).Base_DungeonNPC.this.MAP.getStoryManager_FirstFlag().saveThisFinished();
                        TaskOnMapObject.reCreateNewMap();
                    }
                });
            }
        };
        new Conversation(this.IMLC, cne, msg);
    }

    protected abstract void sayBrief();

    protected abstract void sayFirst();
}

