/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.Scene_Action;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.view.anime.DoronEffect;
import dangeon.view.anime.EvilField;
import dangeon.view.detail.MainMap;
import java.awt.Image;
import java.awt.Point;
import main.res.SE;
import main.util.DIRECTION;

public class \u9b45\u9b54
extends Base_Enemy {
    private static final long serialVersionUID = 1L;

    public \u9b45\u9b54(Point p, int Lv) {
        super(p, Lv);
    }

    @Override
    public void action() {
        super.action();
    }

    private boolean attackCheck() {
        if (!this.player_is_in_sight) {
            return false;
        }
        int length = 2;
        Point p = Player.me.getMassPoint().getLocation();
        Point e = this.getMassPoint().getLocation();
        int i = -length;
        while (i <= length) {
            int j = -length;
            while (j <= length) {
                if (p.x == e.x + i && p.y == e.y + j) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean check() {
        return this.attackCheck() || this.warpCheck();
    }

    private boolean effect() {
        if (this.warpCheck()) {
            if (this.roomInWarp()) {
                this.warp(false);
            } else {
                this.warp(true);
                Message.set(this.getColoredName(), "\u304c\u73fe\u308c\u305f");
                Scene_Action.getMe().set_I_Dushing_request_arrow_key(true);
            }
        } else {
            this.startAttack(this.getAttackTask(this, Player.me), Player.me.getMassPoint());
            Message.set(this.getColoredName(), "\u306f\u7834\u58ca\u306e\u9b54\u6cd5\u3092\u5531\u3048\u305f");
        }
        return true;
    }

    private Point[] get8Points() {
        Point[] array = new Point[8];
        DIRECTION[] ds = Player.me.getDirection().getNeiboringDirections8();
        int i = 0;
        while (i < ds.length) {
            DIRECTION direction = ds[i];
            array[i] = this.getMass(direction);
            ++i;
        }
        return array;
    }

    @Override
    public Image getATKImage(int LV, DIRECTION attacking_direction, int attack_No) {
        return super.getATKImage(LV, attacking_direction, attack_No);
    }

    @Override
    protected Point getAttackPoint() {
        return this.screen_point;
    }

    private Point getMass(DIRECTION direction) {
        Point p = Player.me.getMassPoint().getLocation();
        direction = direction.getDeNeiboringDirection();
        direction.getFrontPoint(p);
        direction.getFrontPoint(p);
        if (direction.isBias()) {
            direction.getNeiboringDirection().getNeiboringDirection().getNeiboringDirection().getFrontPoint(p);
        } else {
            direction.getNeiboringDirection().getNeiboringDirection().getFrontPoint(p);
        }
        return p;
    }

    private void odoroke(final Point p, boolean jump) {
        if (jump) {
            SE.KOGASA_SPELL.play();
            MainMap.addEffect(new DoronEffect(p, new Task(){
                private static final long serialVersionUID = 1L;

                @Override
                public void work() {
                }

                @Override
                protected void work(int frame) {
                    if (frame == 4) {
                        \u9b45\u9b54.this.setMassPoint(p);
                        \u9b45\u9b54.this.direction = DIRECTION.getDirection(p, Player.me.getMassPoint());
                    }
                }
            }, true), true);
        } else {
            SE.WARP_INSTANT.play();
            this.setMassPoint_WalkLike(p, 3);
            this.direction = DIRECTION.getDirection(p, Player.me.getMassPoint());
        }
    }

    private boolean parcent() {
        if (this.player_is_in_sight && MassCreater.getMass((Point)Player.me.getMassPoint()).ROOM && MassCreater.getMass((Point)this.getMassPoint()).ROOM) {
            return true;
        }
        return this.isSpecialParcent();
    }

    private boolean roomInWarp() {
        if (this.player_is_in_sight && MassCreater.getMass((Point)Player.me.getMassPoint()).ROOM && MassCreater.getMass((Point)this.getMassPoint()).ROOM) {
            this.warp(false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean specialAttack() {
        this.effect();
        return true;
    }

    @Override
    protected boolean specialCheck() {
        if (this.parcent() && this.warpCheck()) {
            return true;
        }
        return this.isSpecialParcent() && this.attackCheck();
    }

    @Override
    public void startAttack(Task t) {
        this.startAttack(t, this.direction.getFrontPoint(this.mass_point.getLocation()));
    }

    private void startAttack(Task t, Point p) {
        SE.ATTACK_HEAVY.play();
        MainMap.addEffect(new EvilField(p.getLocation()));
        super.startAttack(t);
    }

    @Override
    protected void upDate_NormalAttack() {
        super.upDate_NormalAttack();
    }

    private void warp(boolean jump) {
        Point[] pointArray = this.get8Points();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (MassCreater.getMass(p).isWalkable() && MapList.getCreature(p) == null) {
                this.odoroke(p, jump);
                return;
            }
            ++n2;
        }
    }

    private boolean warpCheck() {
        if (this.attack_possible()) {
            return false;
        }
        if (!MassCreater.getMass((Point)Player.me.getMassPoint()).ROOM) {
            return false;
        }
        boolean flag = false;
        Point[] pointArray = this.get8Points();
        int n = pointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            if (MassCreater.getMass(p).isWalkable()) {
                Base_Creature c = MapList.getCreature(p);
                if (c == this) {
                    return false;
                }
                if (c == null) {
                    flag = true;
                }
            }
            ++n2;
        }
        return flag;
    }
}

