/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.MapList;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.grass.\u6bd2\u8349;
import dangeon.model.object.artifact.item.grass.\u6df7\u4e71\u8349;
import dangeon.model.object.artifact.item.grass.\u7761\u7720\u8349;
import dangeon.model.object.artifact.item.grass.\u80c3\u62e1\u5f35\u306e\u7a2e;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import java.awt.Image;
import java.awt.Point;
import main.util.DIRECTION;

public class \u516b\u610f\u6c38\u7433
extends Base_Enemy {
    private static final long serialVersionUID = 1L;
    private boolean flag_throwing = false;

    public \u516b\u610f\u6c38\u7433(Point p, int Lv) {
        super(p, Lv);
    }

    private boolean check() {
        if (!this.player_is_in_sight) {
            return false;
        }
        Point player_point = Player.me.getMassPoint();
        if (this.getMassPoint().x == player_point.x) {
            this.direction = this.getMassPoint().y > player_point.y ? DIRECTION.UP : DIRECTION.DOWN;
        } else if (this.getMassPoint().y == player_point.y) {
            this.direction = this.getMassPoint().x > player_point.x ? DIRECTION.LEFT : DIRECTION.RIGHT;
        } else if (Math.abs(this.getMassPoint().x - player_point.x) == Math.abs(this.getMassPoint().y - player_point.y)) {
            this.direction = this.getMassPoint().x > player_point.x ? (this.getMassPoint().y > player_point.y ? DIRECTION.UP_LEFT : DIRECTION.DOWN_LEFT) : (this.getMassPoint().y > player_point.y ? DIRECTION.UP_RIGHT : DIRECTION.DOWN_RIGHT);
        } else {
            return false;
        }
        return true;
    }

    public boolean effect() {
        final Base_Artifact a = this.itemSelect();
        final \u516b\u610f\u6c38\u7433 c = this;
        this.flag_throwing = true;
        this.startAttack(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                a.check();
                Message.set(\u516b\u610f\u6c38\u7433.this.getColoredName(), "\u306f", a.getColoredName(), "\u3092\u6295\u3052\u305f");
                a.itemThrow(c);
            }
        });
        return true;
    }

    @Override
    public boolean enchantEnemySpecialAction() {
        Base_Artifact a = this.itemSelect();
        a.itemThrow(Player.me);
        return true;
    }

    @Override
    public Image getATKImage(int LV, DIRECTION attacking_direction, int attack_No) {
        if (this.flag_throwing) {
            return this.IM.getSPImage(LV, attacking_direction, attack_No);
        }
        return this.IM.getATKImage(LV, attacking_direction, attack_No);
    }

    @Override
    protected Base_Artifact getDropItem() {
        return this.itemSelect();
    }

    @Override
    public boolean isResistantToGrassWave() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370);
    }

    private Base_Artifact itemSelect() {
        Base_Creature aimed_creature;
        if (this.LV == 1) {
            return new \u6bd2\u8349(this.getMassPoint());
        }
        if (this.LV == 2) {
            if (Player.me.getConditionList().contains((Object)CONDITION.\u6df7\u4e71)) {
                return new \u6bd2\u8349(this.getMassPoint());
            }
            return new \u6df7\u4e71\u8349(this.getMassPoint());
        }
        if (this.LV == 4 && (aimed_creature = MapInSelect.getListStraightHitCreature(this.direction, this.getMassPoint(), 10).get(0)) != null) {
            DIRECTION[] dIRECTIONArray = DIRECTION.values();
            int n = dIRECTIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                DIRECTION d = dIRECTIONArray[n2];
                Base_Creature surrounded_creature = MapList.getCreature(d.getFrontPoint(aimed_creature.getMassPoint().getLocation()));
                if (!(surrounded_creature == null || surrounded_creature instanceof Player || surrounded_creature.isPlayerSide() || d != DIRECTION.NEUTRAL && surrounded_creature.isResistantToGrassWave())) {
                    return new \u80c3\u62e1\u5f35\u306e\u7a2e(this.mass_point);
                }
                ++n2;
            }
        }
        if (Player.me.getConditionList().contains((Object)CONDITION.\u7761\u7720)) {
            if (Player.me.getConditionList().contains((Object)CONDITION.\u6df7\u4e71)) {
                return new \u6bd2\u8349(this.getMassPoint());
            }
            return new \u6df7\u4e71\u8349(this.getMassPoint());
        }
        return new \u7761\u7720\u8349(this.getMassPoint());
    }

    private boolean railgun() {
        if (!this.player_is_in_sight) {
            return false;
        }
        this.effect();
        return true;
    }

    protected boolean specialAction() {
        return this.railgun();
    }

    @Override
    protected boolean specialAttack() {
        return this.special_ok && this.railgun();
    }

    @Override
    protected boolean specialCheck() {
        if (!this.check()) {
            return false;
        }
        return this.isSpecialParcent();
    }

    @Override
    public void upDate() {
        if (this.flag_throwing) {
            super.upDate_NormalAttack();
            this.flag_throwing = this.normal_attack_phase != null;
        } else {
            super.upDate();
        }
    }
}

