/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.controller.task.Task;
import dangeon.latest.scene.action.message.Message;
import dangeon.model.map.MapList;
import dangeon.model.map.Mass;
import dangeon.model.map.MassCreater;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import dangeon.util.MapInSelect;
import java.awt.Point;
import main.res.SE;
import main.util.DIRECTION;

public class \u30ec\u30df\u30ea\u30a2
extends Base_Enemy {
    private static final long serialVersionUID = 1L;
    private boolean flag_shoot = false;

    public \u30ec\u30df\u30ea\u30a2(Point p, int Lv) {
        super(p, Lv);
    }

    private boolean check() {
        if (this.LV < 4 && !this.player_is_in_sight) {
            return false;
        }
        if (this.playerIsInNeiver()) {
            return false;
        }
        if (this.LV == 4) {
            Point p = this.getMassPoint().getLocation();
            DIRECTION dir = this.getDirection();
            do {
                p.translate(dir.X, dir.Y);
                Base_Creature c = MapList.getCreature(p);
                if (c == null) continue;
                if (c.equals(Player.me)) {
                    this.flag_shoot = true;
                    return true;
                }
                return false;
            } while (!MassCreater.getMass(p).equals(Mass.nullpo));
            return false;
        }
        DIRECTION[] dIRECTIONArray = DIRECTION.values_exceptNeatral();
        int n = dIRECTIONArray.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION dir = dIRECTIONArray[n2];
            if (MapInSelect.getStraightMoveCheck(dir, this.getMassPoint(), 0) instanceof Player) {
                this.flag_shoot = true;
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void drain(int dam) {
        int min = 10;
        if (dam < min) {
            return;
        }
        dam = this.LV == 2 || this.LV == 1 ? (int)Math.round((double)dam / 4.0) : (int)Math.round((double)dam / 2.0);
        if (dam < min) {
            dam = min;
        }
        this.heal(this, dam);
    }

    private void effect(DIRECTION dir) {
        SE.WARP_INSTANT.play();
        Message.set(this.getColoredName().concat("\u306f\u7a81\u6483\u3057\u3066\u304d\u305f"));
        this.setMassPoint_WalkLike(new Point(Player.me.getMassPoint().x - dir.X, Player.me.getMassPoint().y - dir.Y), 2, new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                \u30ec\u30df\u30ea\u30a2.this.attack();
                \u30ec\u30df\u30ea\u30a2.this.upDate();
            }
        });
    }

    @Override
    public boolean enchantEnemySpecialAction() {
        DIRECTION d = Player.me.getDirection();
        Point p = Player.me.getMassPoint().getLocation();
        Base_Creature e = MapInSelect.getStraightMoveCheck(d, p, 0);
        System.out.println(e);
        if (e == null) {
            return false;
        }
        Point _p = e.getMassPoint().getLocation();
        Point f_p = new Point(_p.x - d.X, _p.y - d.Y);
        SE.WARP_INSTANT.play();
        Task ta = new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Player.me.normalAttack();
            }
        };
        Player.me.attack_point = f_p;
        Player.me.setMassPoint_WalkLike(f_p, 10, ta);
        return true;
    }

    @Override
    protected boolean specialAttack() {
        if (this.flag_shoot && this.check()) {
            this.direction = this.converDirection(Player.me.getMassPoint());
            this.effect(this.direction);
            return true;
        }
        this.attack();
        return true;
    }

    @Override
    protected boolean specialCheck() {
        this.flag_shoot = false;
        if (this.isSpecialParcent() && this.check()) {
            return true;
        }
        return this.LV > 1 && this.attack_possible();
    }
}

