/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.creature.enemy;

import dangeon.latest.scene.action.message.Message;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Player;
import java.awt.Image;
import java.awt.Point;
import main.res.SE;
import main.thread.MainThread;
import main.util.DIRECTION;

public class \u308f\u304b\u3055\u304e\u59eb
extends Base_Enemy {
    private static final long serialVersionUID = 1L;
    private boolean flag_in_water;

    public \u308f\u304b\u3055\u304e\u59eb(Point p, int Lv) {
        super(p, Lv);
    }

    private boolean check(Point p) {
        if (MapList.getEnemy(p) != null) {
            return false;
        }
        if (this.LV >= 2 && MassCreater.getMass((Point)p).WATER) {
            return true;
        }
        return this.LV >= 3 && MassCreater.getMass((Point)p).WALKABLE && MapList.isTrapOrWaterPermitted(p);
    }

    @Override
    public boolean counterAttackEnemy() {
        return super.counterAttackEnemy();
    }

    private void effect() {
        DIRECTION[] ds = new DIRECTION[8];
        int i = 0;
        while (i < ds.length) {
            ds[i] = Player.me.getDirection().getNeiboringDirection((i + 1) / 2 * (i % 2 == 0 ? -1 : 1));
            ++i;
        }
        DIRECTION[] dIRECTIONArray = ds;
        int n = ds.length;
        int n2 = 0;
        while (n2 < n) {
            DIRECTION d = dIRECTIONArray[n2];
            Point p = Player.me.getMassPoint().getLocation();
            p.translate(d.X, d.Y);
            if (this.check(p)) {
                SE.ATTACK_WATER.play();
                this.setMassPoint(p);
                boolean flag = false;
                if (!MassCreater.getMass((Point)p).WATER) {
                    flag = true;
                    MassCreater.getMass(p).setWater(true);
                }
                if (this.LV == 4) {
                    DIRECTION[] dIRECTIONArray2 = DIRECTION.values_exceptNeatral();
                    int n3 = dIRECTIONArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DIRECTION direction = dIRECTIONArray2[n4];
                        p = Player.me.getMassPoint().getLocation();
                        p.translate(direction.X, direction.Y);
                        if (MapList.isTrapOrWaterPermitted(p)) {
                            flag = true;
                            MassCreater.getMass(p).setWater(true);
                        }
                        ++n4;
                    }
                }
                if (!flag) {
                    Message.set(this.getColoredName(), "\u306f\u6c34\u5834\u3078\u98db\u3073\u79fb\u3063\u305f");
                } else {
                    Message.set(this.getColoredName(), "\u306f\u6c34\u5834\u3092\u4f5c\u3063\u3066\u98db\u3073\u79fb\u3063\u305f");
                    MassCreater.retakeMassSet();
                }
                this.flag_in_water = true;
                return;
            }
            ++n2;
        }
        if (this.LV >= 3) {
            Message.set(this.getColoredName(), "\u306f\u69d8\u5b50\u3092\u898b\u3066\u3044\u308b");
        }
    }

    @Override
    public boolean enchantEnemySpecialAction() {
        return true;
    }

    @Override
    public void enemyMovePossible() {
    }

    @Override
    public int getFootDeltY() {
        if (this.flag_in_water) {
            return 22;
        }
        return 10;
    }

    @Override
    public Image getImage() {
        if (this.flag_in_water) {
            int koma = MainThread.getFrame() / (int)(12.0f / this.getMoveAnimationSpeed()) % 2;
            return this.IM.getSPImage(this.LV, this.direction, koma);
        }
        return super.getImage();
    }

    @Override
    public int getShadowSize100() {
        return 0;
    }

    @Override
    public boolean isInValidOnAttack() {
        return this.flag_in_water;
    }

    @Override
    protected boolean isSkillActiveAnytimeButSealed() {
        return true;
    }

    @Override
    public boolean isThroughItem(Base_Artifact a) {
        return this.flag_in_water;
    }

    @Override
    public boolean isWatering() {
        return !this.conditionCheck(CONDITION.\u5c01\u5370);
    }

    @Override
    public boolean itemHitEffect(Base_Artifact a, boolean ento) {
        boolean flag = super.itemHitEffect(a, ento);
        this.flag_in_water = this.getHP() > 0;
        return flag;
    }

    @Override
    public void normalAttack(boolean p_or_e) {
        this.flag_in_water = false;
        super.normalAttack(p_or_e);
    }

    public void resetFlagInWater(boolean b) {
        this.flag_in_water = b;
    }

    @Override
    protected boolean specialAttack() {
        this.effect();
        return true;
    }

    @Override
    protected boolean specialCheck() {
        if (this.attack_possible()) {
            return false;
        }
        if (MassCreater.isPlayerInTheSameRoom(this.getMassPoint())) {
            return true;
        }
        this.flag_in_water = true;
        return false;
    }

    @Override
    public boolean staffHitEffect(Base_Artifact a) {
        boolean flag = super.staffHitEffect(a);
        this.flag_in_water = this.getHP() > 0;
        return flag;
    }
}

