/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.trap;

import dangeon.controller.TaskOnMapObject;
import dangeon.controller.TurnSystemController;
import dangeon.controller.task.Task;
import dangeon.latest.scene.Base_View;
import dangeon.latest.scene.action.message.Message;
import dangeon.latest.scene.action.message.MessageLock;
import dangeon.latest.system.KeyHolder;
import dangeon.model.condition.CONDITION;
import dangeon.model.map.ItemFall;
import dangeon.model.map.MapList;
import dangeon.model.map.MassCreater;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.enchantSpecial.ENCHANT_SIMBOL;
import dangeon.model.object.artifact.item.enchantSpecial.EnchantSpecial;
import dangeon.model.object.artifact.item.enchantSpecial.simbolEffect.\u5370\u7f60\u5e2b;
import dangeon.model.object.artifact.trap.\u843d\u3068\u3057\u7a74\u306e\u7f60;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.enemy.Base_Enemy;
import dangeon.model.object.creature.player.Belongings;
import dangeon.model.object.creature.player.Enchant;
import dangeon.model.object.creature.player.Player;
import dangeon.util.R;
import java.awt.Point;
import main.constant.FR;
import main.res.SE;

public abstract class Base_Trap
extends Base_Artifact {
    private static final long serialVersionUID = 1L;
    private boolean jap = false;
    protected int durability;
    public static final int trap_list_value = 14;
    protected boolean flag_broken = false;
    private int demand_wait_min_frame;
    protected boolean flag_demand_waiting = false;

    protected Base_Trap(Point p, String name, int parcentage, int durability) {
        super(p, name, 0, Base_Artifact.ITEM_CASE.TRAP, false);
        this.durability = durability;
        this.visible = MassCreater.getMass(p).isTrapChecked();
    }

    protected Base_Artifact action(Base_Artifact a) {
        return a;
    }

    protected abstract void action(Base_Creature var1);

    private void breakingCheck() {
        int ran2 = new R().nextInt(100);
        if (ran2 < this.durability) {
            if (this.getListComposition().contains((Object)ENCHANT_SIMBOL.\u91d1)) {
                this.getListComposition().remove((Object)ENCHANT_SIMBOL.\u91d1);
                Message.set(this.getColoredName(), "\u306e\u795e\u306e\u52a0\u8b77\u304c\u5265\u304c\u308c\u305f@");
            } else {
                this.flag_broken = true;
                Message.set(this.getColoredName().concat("\u306f\u58ca\u308c\u305f"));
                TaskOnMapObject.addTrapRemoveTask(this);
            }
        }
    }

    @Override
    public void check() {
    }

    protected int enchantAttack(boolean normal, Base_Creature c, int damage) {
        return 0;
    }

    @Override
    protected int enchantDefence(boolean normal, Base_Creature c, int damage) {
        return damage;
    }

    @Override
    protected String[] getExplan() {
        return new String[]{"\u8e0f\u3080\u3068\u69d8\u3005\u306a\u52b9\u679c\u304c\u767a\u751f\u3059\u308b\u305e", "\u666e\u6bb5\u306f\u76ee\u306b\u898b\u3048\u306a\u3044\u305e"};
    }

    @Override
    protected String getSecondExplain_ByCategory() {
        return "\u8e0f\u3080\u3068\u4f55\u304b\u3057\u3089\u52b9\u679c\u304c\u767a\u751f\u3059\u308b\u3002\u8e0f\u3080\u307e\u3067\u5730\u9762\u306b\u96a0\u308c\u3066\u3044\u3066\u898b\u3048\u306a\u3044\u304c\u7f60\u304c\u3042\u308b\u5834\u6240\u3067\u7d20\u632f\u308a\u3092\u3059\u308b\u3053\u3068\u3067\u767a\u898b\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u308b\u3002\u306a\u304a\u4f55\u56de\u304b\u8e0f\u3080\u3068\u58ca\u308c\u3066\u3057\u307e\u3046\u3002";
    }

    @Override
    public boolean isAbleToCurse() {
        return false;
    }

    public boolean isAbleToWork() {
        return MapList.getArtiface_exceptME(this.getMassPoint(), this) == null;
    }

    private void isActive() {
        int ran = new R().nextInt(100) + 1;
        int active = \u5370\u7f60\u5e2b.effect() ? 0 : (this.jap ? 200 : (this.visible || Player.me.conditionCheck(CONDITION.\u76ee\u85ac) ? (EnchantSpecial.enchantSimbolAllCheck(ENCHANT_SIMBOL.\u622f) ? 0 : 70) : 90));
        if (ran <= active) {
            this.trapEffect();
        } else {
            Message.set("\u3057\u304b\u3057\u7f60\u306f\u767a\u52d5\u3057\u306a\u304b\u3063\u305f\u3002");
            Message.setConcatFlag(false);
            this.flag_demand_waiting = false;
        }
    }

    @Override
    public boolean isDemandWaiting() {
        if (this.demand_wait_min_frame > 0) {
            this.demand_wait_min_frame -= FR.THREAD_SLEEP;
            return true;
        }
        return this.flag_demand_waiting;
    }

    @Override
    public boolean isMobile() {
        return false;
    }

    @Override
    public int itemEnchantPower(Base_Artifact.STATUS status) {
        return 0;
    }

    public void itemHit() {
    }

    @Override
    public void itemHit(final Base_Creature c, Base_Creature c2) {
        final Base_Trap ME = this;
        new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Message.set(ME.getColoredName(), "\u304c\u53cd\u5fdc\u3057\u305f");
                Base_Trap.this.trapEffect(c);
                if (!Base_Trap.this.flag_broken) {
                    ItemFall.itemFall(ME);
                }
            }
        }.work_appointment();
    }

    @Override
    public boolean itemUse() {
        return false;
    }

    @Override
    public void itemUseThis() {
        this.trapEffect();
        TurnSystemController.callMeToStartEnemyTurn();
    }

    @Override
    public void itemUseThis_fromMenu(KeyHolder KH, Base_View view) {
        super.itemUseThis_fromMenu(KH, view);
        if (Belongings.get(-1) != this) {
            if (this.isEnchantedNow()) {
                Enchant.forceToRemove(this);
            }
            Belongings.remove(this);
        }
    }

    protected void setDemandReleaseTask() {
        Message.setTask_AfterReleaseDemandToPushEnter(new Task(){
            private static final long serialVersionUID = 1L;

            @Override
            public void work() {
                Base_Trap.this.flag_demand_waiting = false;
            }
        });
    }

    public Base_Trap setJapanese() {
        this.jap = true;
        this.durability = 0;
        return this;
    }

    public void trapEffect() {
        this.trapEffect(Player.me);
    }

    public Base_Artifact trapEffect(Base_Artifact a) {
        this.visible = true;
        SE.SYSTEM_TRAP_ON.play();
        Base_Artifact A = this.action(a);
        if (A != null) {
            MapList.removeArtifact(a);
            ItemFall.itemFall(A);
        }
        this.breakingCheck();
        return a;
    }

    public void trapEffect(Base_Creature c) {
        this.visible = true;
        this.action(c);
        this.breakingCheck();
        Message.setConcatFlag(false);
    }

    @Override
    public boolean walkOnAction() {
        if (\u5370\u7f60\u5e2b.effect()) {
            Message.set(this.getColoredName(), "\u306e\u4e0a\u306b\u4e57\u3063\u305f");
            return false;
        }
        if (Player.me.isFlying()) {
            return false;
        }
        this.flag_demand_waiting = true;
        this.demand_wait_min_frame = 500;
        SE.SYSTEM_TRAP_ON.play();
        Message.setConcatFlag(false);
        if (\u5370\u7f60\u5e2b.effect() || this.visible || Player.me.conditionCheck(CONDITION.\u76ee\u85ac)) {
            this.visible = true;
            Message.set(this.getColoredName(), "\u3092\u8e0f\u3093\u3060\u3002");
            this.isActive();
        } else {
            new MessageLock(new String[]{this.getColoredName(), "\u3092\u8e0f\u3093\u3060\u3002"}){

                @Override
                public void second() {
                    Base_Trap.this.isActive();
                }
            };
            this.visible = true;
        }
        return this instanceof \u843d\u3068\u3057\u7a74\u306e\u7f60;
    }

    @Override
    public boolean walkOnAction(boolean b) {
        if (\u5370\u7f60\u5e2b.effect()) {
            Message.set(this.getColoredName(), "\u306e\u4e0a\u306b\u4e57\u3063\u305f");
            return false;
        }
        return this.walkOnAction();
    }

    public void walkOnActionByEnemy(Base_Enemy em) {
        if (!\u5370\u7f60\u5e2b.effect()) {
            return;
        }
        if (em.isFlying()) {
            return;
        }
        this.flag_demand_waiting = true;
        this.demand_wait_min_frame = 500;
        SE.SYSTEM_TRAP_ON.play();
        Message.setConcatFlag(false);
        Message.set(em.getName(), "\u306f", this.getColoredName(), "\u3092\u8e0f\u3093\u3060\u3002");
        this.action(em);
        this.breakingCheck();
        Message.setConcatFlag(false);
    }
}

