/*
 * Decompiled with CFR 0.152.
 */
package dangeon.model.object.artifact.item.staff;

import dangeon.controller.ThrowingItem;
import dangeon.model.object.artifact.Base_Artifact;
import dangeon.model.object.artifact.item.bullet.Base_Bullet;
import dangeon.model.object.artifact.item.staff.Staff;
import dangeon.model.object.creature.Base_Creature;
import dangeon.model.object.creature.player.Player;
import main.res.BulletImage;
import main.res.SE;

public class MagicBullet
extends Base_Bullet {
    private static final long serialVersionUID = 1L;
    public final Staff STAFF;
    private final Base_Creature CREATURE;

    protected MagicBullet(Staff s) {
        this(s, Player.me);
    }

    protected MagicBullet(Staff s, Base_Creature c) {
        super(c, "\u9b54\u6cd5\u5f3e");
        this.STAFF = s;
        this.CREATURE = c;
    }

    @Override
    public BulletImage getBulletImage() {
        return BulletImage.MagicBullet;
    }

    @Override
    public int getShadow() {
        return 0;
    }

    @Override
    public boolean isHitToItem() {
        return this.STAFF.isMagicHitToItem();
    }

    @Override
    public boolean isNeglectiveForWall() {
        return this.STAFF.isNeglectiveForWall_Magic();
    }

    @Override
    public void itemHit(Base_Creature c, Base_Creature c2) {
        this.STAFF.direction = this.direction;
        this.STAFF.effectHitCheck(c, this.CREATURE);
    }

    @Override
    public void itemHitCheck(boolean ento, Base_Creature c, Base_Artifact a) {
        this.STAFF.itemHitCheck(ento, c, a);
    }

    @Override
    public void itemThrow(Base_Creature c) {
        this.itemThrow(c, ThrowingItem.HowToThrow.MAGIC);
    }

    @Override
    public void itemThrow(Base_Creature c, ThrowingItem.HowToThrow how) {
        SE.SYSTEM_MAGIC.play();
        if (c instanceof Player) {
            Player.me.setThrowing(this, Player.me.getDirection());
        }
        super.itemThrow(c, how, Math.max(40, 30));
    }
}

